/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.common;

import java.util.Arrays;

public enum ReportEndpoint {
    LANDING_PAGES("landing-pages"),
    STANDARD_PAGES("standard-pages"),
    BLOG_POSTS("blog-posts"),
    LISTING_PAGES("listing-pages"),
    KNOWLEDGE_ARTICLES("knowledge-articles"),
    TOTALS("totals"),
    SESSIONS("sessions"),
    SOURCES("sources"),
    GEOLOCATION("geolocation"),
    UTM_CAMPAIGNS("utm-campaigns"),
    UTM_CONTENTS("utm-contents"),
    UTM_MEDIUMS("utm-mediums"),
    UTM_SOURCES("utm-sources"),
    UTM_TERMS("utm-terms"),
    EVENT_COMPLETIONS("event-completions"),
    FORMS("forms"),
    PAGES("pages"),
    SOCIAL_ASSISTS("social-assists");

    private String stringValue;

    private ReportEndpoint(String stringValue) {
        this.stringValue = stringValue;
    }

    public static ReportEndpoint fromString(String value) {
        return Arrays.stream(ReportEndpoint.values()).filter(type -> type.stringValue.equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("'%s' is invalid ObjectType.", value)));
    }

    public String getStringValue() {
        return this.stringValue;
    }
}

