/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.common;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.hubspot.common.BaseHubspotConfig;
import io.cdap.plugin.hubspot.common.ConfigValidator;
import io.cdap.plugin.hubspot.common.ObjectType;
import io.cdap.plugin.hubspot.common.ReportEndpoint;
import io.cdap.plugin.hubspot.common.ReportType;
import io.cdap.plugin.hubspot.common.TimePeriod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class SourceHubspotConfig
extends BaseHubspotConfig {
    public static final String TIME_PERIOD = "timePeriod";
    public static final String REPORT_TYPE = "reportType";
    public static final String REPORT_CONTENT = "reportContent";
    public static final String REPORT_CATEGORY = "reportCategory";
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String FILTERS = "filters";
    public static final String REPORT_OBJECT = "reportObject";
    @Name(value="filters")
    @Description(value="Keyword to filter the analytics report data to include only the specified breakdowns.")
    @Macro
    @Nullable
    public String filters;
    @Name(value="startDate")
    @Description(value="Start date for the analytics report data. YYYYMMDD format.")
    @Macro
    @Nullable
    public String startDate;
    @Name(value="endDate")
    @Description(value="End date for the analytics report data. YYYYMMDD format.")
    @Macro
    @Nullable
    public String endDate;
    @Name(value="reportType")
    @Description(value="Analytics report target to get data for.")
    @Macro
    @Nullable
    public String reportType;
    @Name(value="reportContent")
    @Description(value="Analytics report type of content that you want to get data for.")
    @Macro
    @Nullable
    public String reportContent;
    @Name(value="reportCategory")
    @Description(value="Analytics report category used to break down the analytics data.")
    @Macro
    @Nullable
    public String reportCategory;
    @Name(value="reportObject")
    @Description(value="Analytics report type of object that you want the analytics data for.")
    @Macro
    @Nullable
    public String reportObject;
    @Name(value="timePeriod")
    @Description(value="Time period used to group the data.")
    @Macro
    @Nullable
    public String timePeriod;

    public SourceHubspotConfig(String referenceName) {
        super(referenceName);
    }

    public SourceHubspotConfig(String referenceName, String apiServerUrl, String objectType, String authToken, String filters, String startDate, String endDate, String reportType, String reportContent, String reportCategory, String reportObject, String timePeriod) {
        super(referenceName, apiServerUrl, objectType, authToken);
        this.filters = filters;
        this.startDate = startDate;
        this.endDate = endDate;
        this.reportType = reportType;
        this.reportContent = reportContent;
        this.reportCategory = reportCategory;
        this.reportObject = reportObject;
        this.timePeriod = timePeriod;
    }

    public void validate(FailureCollector failureCollector) {
        ConfigValidator.validateObjectType(this, failureCollector);
        if (!this.containsMacro("objectType") && this.getObjectType().equals((Object)ObjectType.ANALYTICS)) {
            ConfigValidator.validateReportType(this, failureCollector);
            ConfigValidator.validateTimePeriod(this, failureCollector);
            ConfigValidator.validateFilters(this, failureCollector);
            ConfigValidator.validateDateRange(this, failureCollector);
        }
        ConfigValidator.validateAuthorization(this, failureCollector);
    }

    public Schema getSchema() {
        HashSet<Schema.Field> schemaFields = new HashSet<Schema.Field>();
        schemaFields.add(Schema.Field.of((String)"objectType", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING))));
        schemaFields.add(Schema.Field.of((String)"object", (Schema)Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING))));
        return Schema.recordOf((String)"etlSchemaBody", schemaFields);
    }

    @Nullable
    public ReportEndpoint getReportEndpoint() {
        switch (this.getReportType()) {
            case REPORT_CATEGORY: {
                return this.getReportEndpoint(this.reportCategory);
            }
            case REPORT_OBJECT: {
                return this.getReportEndpoint(this.reportObject);
            }
            case REPORT_CONTENT: {
                return this.getReportEndpoint(this.reportContent);
            }
        }
        throw new IllegalArgumentException(String.format("'%s' is invalid ObjectType.", this.reportType));
    }

    @Nullable
    public ReportEndpoint getReportEndpoint(String reportCategory) {
        return ReportEndpoint.fromString(reportCategory);
    }

    @Nullable
    public ReportType getReportType() {
        return ReportType.fromString(this.reportType);
    }

    @Nullable
    public TimePeriod getTimePeriod() {
        return TimePeriod.fromString(this.timePeriod);
    }

    @Nullable
    public List<String> getFilters() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.filters != null && !this.filters.isEmpty()) {
            list.addAll(Arrays.asList(this.filters.split(",")));
        }
        return list;
    }
}

