/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.sink.batch;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.batch.Output;
import io.cdap.cdap.api.data.batch.OutputFormatProvider;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.dataset.lib.KeyValue;
import io.cdap.cdap.etl.api.Emitter;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.batch.BatchSink;
import io.cdap.cdap.etl.api.batch.BatchSinkContext;
import io.cdap.plugin.hubspot.sink.batch.HubspotOutputFormatProvider;
import io.cdap.plugin.hubspot.sink.batch.SinkHubspotConfig;
import org.apache.hadoop.io.NullWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type="batchsink")
@Name(value="Hubspot")
@Description(value="Sink plugin to  put data to HubSpot CRM.")
public class HubspotBatchSink
extends BatchSink<StructuredRecord, NullWritable, String> {
    private static final Logger LOG = LoggerFactory.getLogger(HubspotBatchSink.class);
    private SinkHubspotConfig config;
    public static final String NAME = "Hubspot";

    public HubspotBatchSink(SinkHubspotConfig config) {
        this.config = config;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        super.configurePipeline(pipelineConfigurer);
        FailureCollector collector = pipelineConfigurer.getStageConfigurer().getFailureCollector();
        this.config.validate(collector);
    }

    public void prepareRun(BatchSinkContext context) {
        FailureCollector collector = context.getFailureCollector();
        this.config.validate(collector);
        collector.getOrThrowException();
        context.addOutput(Output.of((String)this.config.referenceName, (OutputFormatProvider)new HubspotOutputFormatProvider(this.config)));
    }

    public void transform(StructuredRecord input, Emitter<KeyValue<NullWritable, String>> emitter) throws Exception {
        emitter.emit((Object)new KeyValue(null, input.get(this.config.objectField)));
    }
}

