/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.sink.batch;

import io.cdap.plugin.hubspot.sink.batch.HubspotOutputFormatProvider;
import io.cdap.plugin.hubspot.sink.batch.HubspotSinkHelper;
import io.cdap.plugin.hubspot.sink.batch.SinkHubspotConfig;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class HubspotRecordWriter
extends RecordWriter<NullWritable, String> {
    private HubspotSinkHelper hubspotSinkHelper;
    private final SinkHubspotConfig sinkHubspotConfig;

    public HubspotRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        Configuration conf = taskAttemptContext.getConfiguration();
        String configJson = conf.get("cdap.Hubspot.sink.config");
        this.sinkHubspotConfig = (SinkHubspotConfig)((Object)HubspotOutputFormatProvider.GSON.fromJson(configJson, SinkHubspotConfig.class));
    }

    public void write(NullWritable nullWritable, String input) throws IOException {
        this.hubspotSinkHelper = new HubspotSinkHelper();
        try {
            this.hubspotSinkHelper.executeHTTPService(input, this.sinkHubspotConfig);
        }
        catch (Exception e) {
            throw new RuntimeException("Submit record to Hubspot failed with:", e);
        }
    }

    public void close(TaskAttemptContext taskAttemptContext) {
    }
}

