/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.sink.batch;

import io.cdap.plugin.hubspot.sink.batch.SinkHubspotConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.http.client.utils.URIBuilder;
import org.awaitility.Awaitility;
import org.awaitility.Duration;
import org.awaitility.core.ConditionTimeoutException;
import org.awaitility.pollinterval.IterativePollInterval;
import org.awaitility.pollinterval.PollInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubspotSinkHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HubspotSinkHelper.class);
    public static final int MAX_RETRY_DURATION = 10;

    public void executeHTTPService(String input, SinkHubspotConfig config) throws Exception {
        HttpService httpService = new HttpService(input, config);
        try {
            Awaitility.await().with().pollInterval((PollInterval)IterativePollInterval.iterative(duration -> duration.multiply(2L)).startDuration(Duration.ONE_SECOND)).pollDelay(0L, TimeUnit.MILLISECONDS).timeout(10L, TimeUnit.SECONDS).until(httpService::postInput);
        }
        catch (ConditionTimeoutException ex) {
            throw httpService.getException();
        }
    }

    @Nullable
    public String getSinkEndpoint(SinkHubspotConfig sinkHubspotConfig) {
        String apiServerUrl = sinkHubspotConfig.getApiServerUrl();
        switch (sinkHubspotConfig.getObjectType()) {
            case CONTACT_LISTS: {
                return String.format("%s/contacts/v1/lists", apiServerUrl);
            }
            case CONTACTS: {
                return String.format("%s/contacts/v1/contact", apiServerUrl);
            }
            case COMPANIES: {
                return String.format("%s/companies/v2/companies", apiServerUrl);
            }
            case DEALS: {
                return String.format("%s/deals/v1/deal", apiServerUrl);
            }
            case DEAL_PIPELINES: {
                return String.format("%s/crm-pipelines/v1/pipelines/deals", apiServerUrl);
            }
            case MARKETING_EMAIL: {
                return String.format("%s/marketing-emails/v1/emails", apiServerUrl);
            }
            case PRODUCTS: {
                return String.format("%s/crm-objects/v1/objects/products", apiServerUrl);
            }
            case TICKETS: {
                return String.format("%s/crm-objects/v1/objects/tickets", apiServerUrl);
            }
        }
        return null;
    }

    private class HttpService {
        private Exception exception = null;
        private String input;
        private SinkHubspotConfig config;

        private HttpService(String input, SinkHubspotConfig config) {
            this.input = input;
            this.config = config;
        }

        public Exception getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean postInput() {
            this.exception = null;
            HttpURLConnection conn = null;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", String.format("Bearer %s", this.config.authToken));
            headers.put("Content-Type", "application/json");
            try {
                int responseCode;
                URIBuilder b = new URIBuilder(HubspotSinkHelper.this.getSinkEndpoint(this.config));
                URL url = new URL(b.build().toString());
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                for (Map.Entry entry : headers.entrySet()) {
                    conn.addRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
                if (this.input.length() > 0) {
                    conn.setDoOutput(true);
                    Throwable throwable = null;
                    try (OutputStream outputStream = conn.getOutputStream();){
                        outputStream.write(this.input.getBytes());
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
                if ((responseCode = conn.getResponseCode()) >= 300) {
                    String output;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                    StringBuilder sb = new StringBuilder();
                    while ((output = bufferedReader.readLine()) != null) {
                        sb.append(output);
                    }
                    this.exception = new IllegalStateException(String.format("Received error response. Response code: %s %s", responseCode, sb.toString()));
                    boolean bl = false;
                    return bl;
                }
            }
            catch (MalformedURLException | ProtocolException e) {
                throw new IllegalStateException("Error opening url connection. Reason: " + e.getMessage(), e);
            }
            catch (Exception e) {
                LOG.warn("Error making {} request to url {}", (Object)this.config.getObjectType(), (Object)HubspotSinkHelper.this.getSinkEndpoint(this.config));
                this.exception = e;
                boolean bl = false;
                return bl;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            return true;
        }
    }
}

