/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.source.batch;

import com.google.gson.JsonElement;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.batch.Input;
import io.cdap.cdap.api.data.batch.InputFormatProvider;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.dataset.lib.KeyValue;
import io.cdap.cdap.etl.api.Emitter;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.batch.BatchContext;
import io.cdap.cdap.etl.api.batch.BatchSource;
import io.cdap.cdap.etl.api.batch.BatchSourceContext;
import io.cdap.plugin.common.IdUtils;
import io.cdap.plugin.common.LineageRecorder;
import io.cdap.plugin.hubspot.common.HubspotHelper;
import io.cdap.plugin.hubspot.common.SourceHubspotConfig;
import io.cdap.plugin.hubspot.source.batch.HubspotInputFormatProvider;
import java.util.stream.Collectors;
import org.apache.hadoop.io.NullWritable;

@Plugin(type="batchsource")
@Name(value="Hubspot")
@Description(value="Plugin reads Hubspot objects in batch")
public class HubspotBatchSource
extends BatchSource<NullWritable, JsonElement, StructuredRecord> {
    private final SourceHubspotConfig config;
    public static final String NAME = "Hubspot";

    public HubspotBatchSource(SourceHubspotConfig config) {
        this.config = config;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        this.validateConfiguration(pipelineConfigurer.getStageConfigurer().getFailureCollector());
        pipelineConfigurer.getStageConfigurer().setOutputSchema(this.config.getSchema());
    }

    public void prepareRun(BatchSourceContext context) throws Exception {
        this.validateConfiguration(context.getFailureCollector());
        LineageRecorder lineageRecorder = new LineageRecorder((BatchContext)context, this.config.referenceName);
        lineageRecorder.createExternalDataset(this.config.getSchema());
        lineageRecorder.recordRead("Reads", "Reading Hubspot objects", this.config.getSchema().getFields().stream().map(Schema.Field::getName).collect(Collectors.toList()));
        context.setInput(Input.of((String)NAME, (InputFormatProvider)new HubspotInputFormatProvider(this.config)));
    }

    public void transform(KeyValue<NullWritable, JsonElement> input, Emitter<StructuredRecord> emitter) {
        emitter.emit((Object)HubspotHelper.transform(((JsonElement)input.getValue()).toString(), this.config));
    }

    private void validateConfiguration(FailureCollector failureCollector) {
        IdUtils.validateReferenceName((String)this.config.referenceName, (FailureCollector)failureCollector);
        this.config.validate(failureCollector);
        failureCollector.getOrThrowException();
    }
}

