/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.source.batch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.cdap.plugin.hubspot.common.HubspotPagesIterator;
import io.cdap.plugin.hubspot.common.SourceHubspotConfig;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class HubspotRecordReader
extends RecordReader<NullWritable, JsonElement> {
    protected static final Gson GSON = new GsonBuilder().create();
    private JsonElement currentObject;
    private HubspotPagesIterator hubspotPagesIterator;

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        Configuration conf = taskAttemptContext.getConfiguration();
        String configJson = conf.get("cdap.hubspot.config");
        SourceHubspotConfig sourceHubspotConfig = (SourceHubspotConfig)((Object)GSON.fromJson(configJson, SourceHubspotConfig.class));
        this.hubspotPagesIterator = new HubspotPagesIterator(sourceHubspotConfig);
    }

    public boolean nextKeyValue() {
        if (!this.hubspotPagesIterator.hasNext()) {
            return false;
        }
        this.currentObject = this.hubspotPagesIterator.next();
        return true;
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public JsonElement getCurrentValue() throws IOException, InterruptedException {
        return this.currentObject;
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void close() throws IOException {
    }
}

