/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.source.streaming;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.cdap.plugin.hubspot.common.HubspotHelper;
import io.cdap.plugin.hubspot.common.HubspotPage;
import io.cdap.plugin.hubspot.common.HubspotPagesIterator;
import io.cdap.plugin.hubspot.source.streaming.HubspotStreamingSourceConfig;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.sparkreceiver.HasOffset;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.receiver.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubspotReceiver
extends Receiver<String>
implements HasOffset {
    private static final Logger LOG = LoggerFactory.getLogger(HubspotReceiver.class);
    private static final String RECEIVER_THREAD_NAME = "hubspot_api_listener";
    private final HubspotStreamingSourceConfig config;
    private String startOffset = null;
    private Long endOffset = Long.MAX_VALUE;

    HubspotReceiver(HubspotStreamingSourceConfig config) throws IOException {
        super(StorageLevel.MEMORY_AND_DISK_2());
        this.config = config;
    }

    public void setStartOffset(Long startOffset) {
        if (startOffset != null) {
            this.startOffset = String.valueOf(startOffset);
        }
    }

    public HubspotStreamingSourceConfig getConfig() {
        return this.config;
    }

    public void onStart() {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("hubspot_api_listener-%d").build();
        Executors.newSingleThreadExecutor(namedThreadFactory).submit(this::receive);
    }

    public void onStop() {
    }

    public Long getEndOffset() {
        return this.endOffset;
    }

    private void receive() {
        try {
            HubspotPagesIterator hubspotPagesIterator = new HubspotPagesIterator(this.config, this.startOffset);
            while (!this.isStopped()) {
                this.endOffset = Long.parseLong(hubspotPagesIterator.getCurrentPage().getOffset());
                if (hubspotPagesIterator.hasNext()) {
                    if (this.isStopped()) continue;
                    this.store(hubspotPagesIterator.next().toString());
                    continue;
                }
                Integer minutesToSleep = this.config.getPullFrequency().getMinutesValue();
                LOG.debug(String.format("Waiting for '%d' minutes to pull.", minutesToSleep));
                Thread.sleep(TimeUnit.MINUTES.toMillis(minutesToSleep.intValue()));
                HubspotPage currentPage = new HubspotHelper().getHubspotPage(this.config, hubspotPagesIterator.getCurrentPageOffset());
                int iteratorPosition = hubspotPagesIterator.getIteratorPosition();
                hubspotPagesIterator = new HubspotPagesIterator(this.config, currentPage, hubspotPagesIterator.getCurrentPageOffset());
                hubspotPagesIterator.setIteratorPosition(iteratorPosition);
            }
        }
        catch (Exception e) {
            String errorMessage = "Exception while receiving messages from hubspot";
            LOG.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }
}

