/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.source.streaming;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.streaming.StreamingContext;
import io.cdap.cdap.etl.api.streaming.StreamingSource;
import io.cdap.plugin.hubspot.source.streaming.HubspotStreamingSourceConfig;
import io.cdap.plugin.hubspot.source.streaming.HubspotStreamingUtil;
import java.io.IOException;
import org.apache.spark.streaming.api.java.JavaDStream;

@Plugin(type="streamingsource")
@Name(value="Hubspot")
@Description(value="Streams data updates from Hubspot")
public class HubspotStreamingSource
extends StreamingSource<StructuredRecord> {
    static final String NAME = "Hubspot";
    static final String DESCRIPTION = "Streams data updates from Hubspot";
    private HubspotStreamingSourceConfig config;

    public HubspotStreamingSource(HubspotStreamingSourceConfig config) {
        this.config = config;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        FailureCollector collector = pipelineConfigurer.getStageConfigurer().getFailureCollector();
        this.config.validate(collector);
        collector.getOrThrowException();
        pipelineConfigurer.getStageConfigurer().setOutputSchema(this.config.getSchema());
    }

    public JavaDStream<StructuredRecord> getStream(StreamingContext streamingContext) throws IOException {
        FailureCollector collector = streamingContext.getFailureCollector();
        this.config.validate(collector);
        collector.getOrThrowException();
        return HubspotStreamingUtil.getStream(this.config, streamingContext);
    }
}

