/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.hubspot.source.streaming;

import java.util.Arrays;

public enum PullFrequency {
    MINUTES_15("15 min", 15),
    MINUTES_30("30 min", 30),
    HOUR_1("1 hour", 60),
    HOUR_4("4 hour", 240),
    HOUR_8("8 hour", 480);

    private final String name;
    private final Integer minutesValue;

    private PullFrequency(String name, Integer minutesValue) {
        this.name = name;
        this.minutesValue = minutesValue;
    }

    public String getName() {
        return this.name;
    }

    public Integer getMinutesValue() {
        return this.minutesValue;
    }

    public static PullFrequency fromValue(String name) {
        return Arrays.stream(PullFrequency.values()).filter(pullFrequency -> pullFrequency.getName().equals(name)).findAny().orElseThrow(() -> new RuntimeException(String.format("Unexpected pull frequency value '%s'.", name)));
    }
}

