/*
 * Decompiled with CFR 0.152.
 */
package com.alecstrong.cocoapods.gradle.plugin;

import com.alecstrong.cocoapods.gradle.plugin.CocoapodsCompileTask;
import com.alecstrong.cocoapods.gradle.plugin.CompatibilityKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.tasks.KotlinNativeLink;
import org.jetbrains.kotlin.konan.target.Architecture;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0007J\b\u0010 \u001a\u00020\u001bH\u0007J\b\u0010!\u001a\u00020\"H\u0002R*\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0000@@X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000b0\n@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00128\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\u00128\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/alecstrong/cocoapods/gradle/plugin/CocoapodsCompileTask;", "Lorg/gradle/api/DefaultTask;", "()V", "value", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "buildType", "getBuildType$gradle_plugin", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "setBuildType$gradle_plugin", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;)V", "", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinNativeLink;", "compilations", "getCompilations$gradle_plugin", "()Ljava/util/Collection;", "setCompilations$gradle_plugin", "(Ljava/util/Collection;)V", "inputs", "Lorg/gradle/api/file/FileCollection;", "getInputs", "()Lorg/gradle/api/file/FileCollection;", "setInputs", "(Lorg/gradle/api/file/FileCollection;)V", "outputDirectories", "getOutputDirectories", "setOutputDirectories", "compileFatBinary", "", "binaryPath", "", "bundleName", "compileFatDsym", "compileFatFramework", "hasDsyms", "", "gradle-plugin"})
public class CocoapodsCompileTask
extends DefaultTask {
    @InputFiles
    @NotNull
    public FileCollection inputs;
    @Input
    @Nullable
    private NativeBuildType buildType;
    @OutputDirectories
    @NotNull
    public FileCollection outputDirectories;
    @NotNull
    private Collection<? extends KotlinNativeLink> compilations = CollectionsKt.emptyList();

    @NotNull
    public final FileCollection getInputs() {
        FileCollection fileCollection = this.inputs;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputs");
        }
        return fileCollection;
    }

    public final void setInputs(@NotNull FileCollection fileCollection) {
        Intrinsics.checkParameterIsNotNull((Object)fileCollection, (String)"<set-?>");
        this.inputs = fileCollection;
    }

    @Nullable
    public final NativeBuildType getBuildType$gradle_plugin() {
        return this.buildType;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBuildType$gradle_plugin(@Nullable NativeBuildType value) {
        void $receiver$iv;
        Object[] objectArray = new String[1];
        StringBuilder stringBuilder = new StringBuilder();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
        StringBuilder stringBuilder2 = stringBuilder.append(file.getPath()).append('/');
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        objectArray[0] = stringBuilder2.append(project2.getName()).append(".framework").toString();
        List outputs = CollectionsKt.mutableListOf((Object[])objectArray);
        if (this.hasDsyms()) {
            StringBuilder stringBuilder3 = new StringBuilder();
            Project project3 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            File file2 = project3.getBuildDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.buildDir");
            StringBuilder stringBuilder4 = stringBuilder3.append(file2.getPath()).append('/');
            Project project4 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
            outputs.add(stringBuilder4.append(project4.getName()).append(".framework.dSYM").toString());
        }
        Collection collection = outputs;
        Project project5 = this.getProject();
        CocoapodsCompileTask cocoapodsCompileTask = this;
        void v11 = $receiver$iv;
        if (v11 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v11;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        ConfigurableFileCollection configurableFileCollection = project5.files((Object[])Arrays.copyOf(stringArray2, stringArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files(*outputs.toTypedArray())");
        cocoapodsCompileTask.outputDirectories = (FileCollection)configurableFileCollection;
        this.buildType = value;
    }

    @NotNull
    public final FileCollection getOutputDirectories() {
        FileCollection fileCollection = this.outputDirectories;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDirectories");
        }
        return fileCollection;
    }

    public final void setOutputDirectories(@NotNull FileCollection fileCollection) {
        Intrinsics.checkParameterIsNotNull((Object)fileCollection, (String)"<set-?>");
        this.outputDirectories = fileCollection;
    }

    @NotNull
    public final Collection<KotlinNativeLink> getCompilations$gradle_plugin() {
        return this.compilations;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCompilations$gradle_plugin(@NotNull Collection<? extends KotlinNativeLink> value) {
        Collection<File> collection;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Iterable iterable = value;
        Project project = this.getProject();
        CocoapodsCompileTask cocoapodsCompileTask = this;
        void var3_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KotlinNativeLink kotlinNativeLink = (KotlinNativeLink)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            File file = it.getBinary().getOutputFile();
            collection.add(file);
        }
        collection = (List)destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)collection;
        File[] fileArray = thisCollection$iv.toArray(new File[0]);
        if (fileArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Collection<File> collection2 = collection = fileArray;
        ConfigurableFileCollection configurableFileCollection = project.files((Object[])Arrays.copyOf(collection2, ((Collection<E>)collection2).length));
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files(*value.map\u2026putFile }.toTypedArray())");
        cocoapodsCompileTask.inputs = (FileCollection)configurableFileCollection;
        this.compilations = value;
    }

    @TaskAction
    public final void compileFatFramework() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        StringBuilder stringBuilder = new StringBuilder();
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        this.compileFatBinary(string, stringBuilder.append(project2.getName()).append(".framework").toString());
    }

    @TaskAction
    public final void compileFatDsym() {
        if (this.hasDsyms()) {
            StringBuilder stringBuilder = new StringBuilder().append("Contents/Resources/DWARF/");
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            String string = stringBuilder.append(project.getName()).toString();
            StringBuilder stringBuilder2 = new StringBuilder();
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            this.compileFatBinary(string, stringBuilder2.append(project2.getName()).append(".framework.dSYM").toString());
        }
    }

    private final boolean hasDsyms() {
        boolean bl;
        block3: {
            Iterable $receiver$iv = this.compilations;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KotlinNativeLink it = (KotlinNativeLink)element$iv;
                    boolean bl2 = false;
                    if (it.getBinary().getDebuggable() || it.getBinary().getFreeCompilerArgs().contains("-g")) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void compileFatBinary(String binaryPath, String bundleName) {
        WorkResult copyResult2;
        void deviceParentDir;
        this.getLogger().debug("Creating fat binary for " + binaryPath + ' ' + bundleName);
        StringBuilder stringBuilder = new StringBuilder();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
        String finalContainerPath = stringBuilder.append(file.getPath()).append('/').append(bundleName).toString();
        String finalOutputPath = finalContainerPath + '/' + binaryPath;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        this.getProject().exec((Action)new Action<ExecSpec>(this, finalOutputPath, (Ref.ObjectRef)deviceParentDir, bundleName, binaryPath){
            final /* synthetic */ CocoapodsCompileTask this$0;
            final /* synthetic */ String $finalOutputPath;
            final /* synthetic */ Ref.ObjectRef $deviceParentDir;
            final /* synthetic */ String $bundleName;
            final /* synthetic */ String $binaryPath;

            public final void execute(ExecSpec exec) {
                new File(this.$finalOutputPath).getParentFile().mkdirs();
                List args = CollectionsKt.mutableListOf((Object[])new String[]{"-create"});
                Iterable $receiver$iv = this.this$0.getCompilations$gradle_plugin();
                for (T element$iv : $receiver$iv) {
                    KotlinNativeLink compilation = (KotlinNativeLink)element$iv;
                    boolean bl = false;
                    Object object = compilation.getOutputFile().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"compilation.outputFile.get()");
                    File file = ((File)object).getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"compilation.outputFile.get().parentFile");
                    String output = file.getAbsolutePath();
                    KonanTarget target = compilation.getBinary().getTarget().getKonanTarget();
                    if (target.getArchitecture() == Architecture.ARM64) {
                        this.$deviceParentDir.element = output;
                    }
                    this.this$0.getLogger().debug("Lipo'ing for arch " + target.getArchitecture() + " with path " + output + '/' + this.$bundleName + '/' + this.$binaryPath);
                    args.addAll(CollectionsKt.listOf((Object[])new String[]{"-arch", CompatibilityKt.architecture(target), output + '/' + this.$bundleName + '/' + this.$binaryPath}));
                }
                args.addAll(CollectionsKt.listOf((Object[])new String[]{"-output", this.$finalOutputPath}));
                ExecSpec execSpec = exec;
                Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"exec");
                execSpec.setExecutable("lipo");
                exec.setArgs(args);
            }
            {
                this.this$0 = cocoapodsCompileTask;
                this.$finalOutputPath = string;
                this.$deviceParentDir = objectRef;
                this.$bundleName = string2;
                this.$binaryPath = string3;
            }
        }).rethrowFailure().assertNormalExitValue();
        if ((String)deviceParentDir.element == null) {
            throw (Throwable)new IllegalStateException("You need to have a compilation target for X64");
        }
        String initialContainer = (String)deviceParentDir.element + '/' + bundleName;
        WorkResult workResult = copyResult2 = this.getProject().copy((Action)new Action<CopySpec>(initialContainer, binaryPath, finalContainerPath){
            final /* synthetic */ String $initialContainer;
            final /* synthetic */ String $binaryPath;
            final /* synthetic */ String $finalContainerPath;

            public final void execute(CopySpec copy) {
                copy.from((Object)this.$initialContainer, (Action)new Action<CopySpec>(this){
                    final /* synthetic */ compileFatBinary.copyResult.1 this$0;

                    public final void execute(CopySpec from) {
                        from.exclude(new String[]{this.this$0.$binaryPath});
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                copy.into((Object)this.$finalContainerPath);
            }
            {
                this.$initialContainer = string;
                this.$binaryPath = string2;
                this.$finalContainerPath = string3;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)workResult, (String)"copyResult");
        if (!workResult.getDidWork()) {
            throw (Throwable)new IllegalStateException("Failed to copy framework.");
        }
        String plistPath = finalContainerPath + "/Info.plist";
        if (new File(plistPath).exists()) {
            ExecResult execResult = this.getProject().exec((Action)new Action<ExecSpec>(plistPath){
                final /* synthetic */ String $plistPath;

                public final void execute(ExecSpec exec) {
                    ExecSpec execSpec = exec;
                    Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"exec");
                    execSpec.setExecutable("/usr/libexec/PlistBuddy");
                    exec.setArgs(CollectionsKt.listOf((Object[])new String[]{"-c", "Delete :UIRequiredDeviceCapabilities", this.$plistPath}));
                }
                {
                    this.$plistPath = string;
                }
            }).rethrowFailure().assertNormalExitValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)execResult, (String)"project.exec { exec ->\n \u2026).assertNormalExitValue()");
            execResult.getExitValue();
            this.getProject().exec((Action)new Action<ExecSpec>(plistPath){
                final /* synthetic */ String $plistPath;

                public final void execute(ExecSpec exec) {
                    ExecSpec execSpec = exec;
                    Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"exec");
                    execSpec.setExecutable("/usr/libexec/PlistBuddy");
                    exec.setArgs(CollectionsKt.listOf((Object[])new String[]{"-c", "Delete :CFBundleSupportedPlatforms:0", this.$plistPath}));
                }
                {
                    this.$plistPath = string;
                }
            }).rethrowFailure().assertNormalExitValue();
            this.getProject().exec((Action)new Action<ExecSpec>(plistPath){
                final /* synthetic */ String $plistPath;

                public final void execute(ExecSpec exec) {
                    ExecSpec execSpec = exec;
                    Intrinsics.checkExpressionValueIsNotNull((Object)execSpec, (String)"exec");
                    execSpec.setExecutable("/usr/libexec/PlistBuddy");
                    exec.setArgs(CollectionsKt.listOf((Object[])new String[]{"-c", "Add :CFBundleSupportedPlatforms:0 string iPhoneOS", this.$plistPath}));
                }
                {
                    this.$plistPath = string;
                }
            }).rethrowFailure().assertNormalExitValue();
        }
    }
}

