/* The following code was generated by JFlex 1.7.0-1 tweaked for IntelliJ platform */

package com.alecstrong.sqlite.psi.core.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;

import static com.intellij.psi.TokenType.BAD_CHARACTER;
import static com.intellij.psi.TokenType.WHITE_SPACE;
import static com.alecstrong.sqlite.psi.core.psi.SqliteTypes.*;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0-1
 * from the specification file <tt>/Users/astrong/Development/sqlite/sqlite-psi/core/src/main/grammars/SqliteLexer.flex</tt>
 */
public class SqliteLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   * Chosen bits are [7, 7, 7]
   * Total runtime size is 1928 bytes
   */
  public static int ZZ_CMAP(int ch) {
    return ZZ_CMAP_A[(ZZ_CMAP_Y[ZZ_CMAP_Z[ch>>14]|((ch>>7)&0x7f)]<<7)|(ch&0x7f)];
  }

  /* The ZZ_CMAP_Z table has 68 entries */
  static final char ZZ_CMAP_Z[] = zzUnpackCMap(
    "\1\0\103\200");

  /* The ZZ_CMAP_Y table has 256 entries */
  static final char ZZ_CMAP_Y[] = zzUnpackCMap(
    "\1\0\1\1\53\2\1\3\22\2\1\4\37\2\1\3\237\2");

  /* The ZZ_CMAP_A table has 640 entries */
  static final char ZZ_CMAP_A[] = zzUnpackCMap(
    "\11\0\1\3\1\2\3\1\22\0\1\3\1\24\1\13\2\0\1\25\1\26\1\12\1\16\1\17\1\6\1\21"+
    "\1\20\1\4\1\10\1\5\12\7\1\0\1\14\1\23\1\15\1\22\2\0\1\34\1\47\1\45\1\53\1"+
    "\30\1\60\1\50\1\46\1\35\1\62\1\54\1\33\1\52\1\36\1\51\1\32\1\37\1\41\1\55"+
    "\1\43\1\40\1\56\1\57\1\31\1\42\1\44\1\11\1\0\1\11\1\0\1\61\33\11\1\0\1\27"+
    "\10\0\1\1\32\0\1\3\337\0\1\3\177\0\13\3\35\0\2\1\5\0\1\3\57\0\1\3\40\0");

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10"+
    "\1\1\2\2\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\2\1\21\1\22\1\23\1\24\26\1"+
    "\1\25\1\0\1\7\1\0\1\26\1\0\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\20\1\1\37"+
    "\1\1\1\40\2\1\1\41\1\42\2\1\1\43\13\1"+
    "\1\44\7\1\1\45\2\1\1\46\1\1\1\47\1\50"+
    "\20\1\1\0\5\1\1\51\7\1\1\52\2\1\1\53"+
    "\4\1\1\54\1\55\13\1\1\56\16\1\1\57\36\1"+
    "\1\60\1\1\1\61\11\1\1\62\1\1\1\0\4\1"+
    "\1\63\1\64\1\1\1\65\2\1\1\66\1\1\1\67"+
    "\12\1\1\70\7\1\1\71\21\1\1\72\3\1\1\73"+
    "\1\74\1\75\16\1\1\76\7\1\1\77\4\1\1\100"+
    "\4\1\1\101\1\1\1\102\1\103\1\1\1\104\1\105"+
    "\1\1\1\106\1\107\7\1\1\110\1\111\4\1\1\112"+
    "\1\113\1\1\1\114\1\1\1\115\7\1\1\116\2\1"+
    "\1\117\1\120\10\1\1\121\1\1\1\122\1\1\1\123"+
    "\5\1\1\124\1\125\7\1\1\126\1\1\1\127\1\130"+
    "\1\131\1\1\1\132\14\1\1\133\2\1\1\134\1\135"+
    "\1\1\1\136\1\137\3\1\1\140\1\141\3\1\1\142"+
    "\1\1\1\143\1\1\1\144\2\1\1\145\1\146\3\1"+
    "\1\147\1\1\1\150\10\1\1\151\1\1\1\152\2\1"+
    "\1\153\1\154\1\1\1\155\1\156\1\157\1\160\4\1"+
    "\1\161\1\1\1\162\1\163\3\1\1\164\1\1\1\165"+
    "\1\166\3\1\1\167\1\170\1\1\1\171\1\172\1\173"+
    "\1\174\1\175\6\1\1\176\1\177\1\1\1\200\2\1"+
    "\1\201\2\1\1\202\3\1\1\203\1\204\1\205\6\1"+
    "\1\206\1\1\1\207\4\1\1\210\1\211\1\1\1\212"+
    "\1\213\1\1\1\214\1\1\1\215\1\216\1\217\1\220"+
    "\1\1\1\221\5\1\1\222\1\1\1\223\3\1\1\224"+
    "\1\225\1\1\1\226\3\1\1\227\1\230\1\231\4\1"+
    "\1\232";

  private static int [] zzUnpackAction() {
    int [] result = new int[551];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\63\0\146\0\231\0\314\0\63\0\377\0\63"+
    "\0\u0132\0\u0165\0\u0198\0\63\0\u01cb\0\63\0\63\0\63"+
    "\0\63\0\u01fe\0\u0231\0\u0264\0\63\0\63\0\u0297\0\u02ca"+
    "\0\u02fd\0\u0330\0\u0363\0\u0396\0\u03c9\0\u03fc\0\u042f\0\u0462"+
    "\0\u0495\0\u04c8\0\u04fb\0\u052e\0\u0561\0\u0594\0\u05c7\0\u05fa"+
    "\0\u062d\0\u0660\0\u0693\0\u06c6\0\u06f9\0\u072c\0\u075f\0\u0792"+
    "\0\u07c5\0\u0165\0\63\0\u0198\0\63\0\63\0\63\0\63"+
    "\0\63\0\63\0\63\0\63\0\u07f8\0\u082b\0\u085e\0\u0891"+
    "\0\u08c4\0\u08f7\0\u092a\0\u095d\0\u0990\0\u09c3\0\u09f6\0\u0a29"+
    "\0\u0a5c\0\u0a8f\0\u0ac2\0\u0af5\0\u0b28\0\u0b5b\0\u0b8e\0\u0bc1"+
    "\0\u0bf4\0\u0c27\0\u0132\0\u0c5a\0\u0c8d\0\u0cc0\0\u0cf3\0\u0d26"+
    "\0\u0d59\0\u0d8c\0\u0dbf\0\u0df2\0\u0e25\0\u0e58\0\u0e8b\0\u0ebe"+
    "\0\u0ef1\0\u0132\0\u0f24\0\u0f57\0\u0f8a\0\u0fbd\0\u0ff0\0\u1023"+
    "\0\u1056\0\u0132\0\u1089\0\u10bc\0\u0132\0\u10ef\0\u1122\0\u1155"+
    "\0\u1188\0\u11bb\0\u11ee\0\u1221\0\u1254\0\u1287\0\u12ba\0\u12ed"+
    "\0\u1320\0\u1353\0\u1386\0\u13b9\0\u13ec\0\u141f\0\u1452\0\u1485"+
    "\0\u14b8\0\u14eb\0\u151e\0\u1551\0\u1584\0\u15b7\0\u0132\0\u15ea"+
    "\0\u161d\0\u1650\0\u1683\0\u16b6\0\u16e9\0\u171c\0\u0132\0\u174f"+
    "\0\u1782\0\u0132\0\u17b5\0\u17e8\0\u181b\0\u184e\0\u0132\0\u0132"+
    "\0\u1881\0\u18b4\0\u18e7\0\u191a\0\u194d\0\u1980\0\u19b3\0\u19e6"+
    "\0\u1a19\0\u1a4c\0\u1a7f\0\u1ab2\0\u1ae5\0\u1b18\0\u1b4b\0\u1b7e"+
    "\0\u1bb1\0\u1be4\0\u1c17\0\u1c4a\0\u1c7d\0\u1cb0\0\u1ce3\0\u1d16"+
    "\0\u1d49\0\u1d7c\0\u1daf\0\u1de2\0\u1e15\0\u1e48\0\u1e7b\0\u1eae"+
    "\0\u1ee1\0\u1f14\0\u1f47\0\u1f7a\0\u1fad\0\u1fe0\0\u2013\0\u2046"+
    "\0\u2079\0\u20ac\0\u20df\0\u2112\0\u2145\0\u2178\0\u21ab\0\u21de"+
    "\0\u2211\0\u2244\0\u2277\0\u22aa\0\u22dd\0\u2310\0\u2343\0\u2376"+
    "\0\u23a9\0\u0132\0\u23dc\0\u0132\0\u240f\0\u2442\0\u2475\0\u24a8"+
    "\0\u24db\0\u250e\0\u2541\0\u2574\0\u25a7\0\u25da\0\u260d\0\u2640"+
    "\0\u2673\0\u26a6\0\u26d9\0\u270c\0\u0132\0\u0132\0\u273f\0\u0132"+
    "\0\u2772\0\u27a5\0\u0132\0\u27d8\0\u0132\0\u280b\0\u283e\0\u2871"+
    "\0\u28a4\0\u28d7\0\u290a\0\u293d\0\u2970\0\u29a3\0\u29d6\0\u0132"+
    "\0\u2a09\0\u2a3c\0\u2a6f\0\u2aa2\0\u2ad5\0\u2b08\0\u2b3b\0\u0132"+
    "\0\u2b6e\0\u2ba1\0\u2bd4\0\u2c07\0\u2c3a\0\u2c6d\0\u2ca0\0\u2cd3"+
    "\0\u2d06\0\u2d39\0\u2d6c\0\u2d9f\0\u2dd2\0\u2e05\0\u2e38\0\u2e6b"+
    "\0\u2e9e\0\u2ed1\0\u2f04\0\u2f37\0\u2f6a\0\u0132\0\u0132\0\u0132"+
    "\0\u2f9d\0\u2fd0\0\u3003\0\u3036\0\u3069\0\u309c\0\u30cf\0\u3102"+
    "\0\u3135\0\u3168\0\u319b\0\u31ce\0\u3201\0\u3234\0\u0132\0\u3267"+
    "\0\u329a\0\u32cd\0\u3300\0\u3333\0\u3366\0\u3399\0\u0132\0\u33cc"+
    "\0\u33ff\0\u3432\0\u3465\0\u0132\0\u3498\0\u34cb\0\u34fe\0\u3531"+
    "\0\u0132\0\u3564\0\u3597\0\u0132\0\u35ca\0\u0132\0\u0132\0\u35fd"+
    "\0\u0132\0\u14b8\0\u3630\0\u3663\0\u3696\0\u36c9\0\u36fc\0\u372f"+
    "\0\u3762\0\u0132\0\u0132\0\u3795\0\u37c8\0\u37fb\0\u382e\0\u0132"+
    "\0\u0132\0\u3861\0\u0132\0\u3894\0\u38c7\0\u38fa\0\u392d\0\u3960"+
    "\0\u3993\0\u39c6\0\u39f9\0\u3a2c\0\u0132\0\u3a5f\0\u3a92\0\u0132"+
    "\0\u0132\0\u3ac5\0\u3af8\0\u3b2b\0\u3b5e\0\u3b91\0\u3bc4\0\u3bf7"+
    "\0\u3c2a\0\u0132\0\u3c5d\0\u0132\0\u3c90\0\u0132\0\u3cc3\0\u3cf6"+
    "\0\u3d29\0\u3d5c\0\u3d8f\0\u0132\0\u0132\0\u3dc2\0\u3df5\0\u3e28"+
    "\0\u3e5b\0\u3e8e\0\u3ec1\0\u3ef4\0\u0132\0\u3f27\0\u0132\0\u0132"+
    "\0\u0132\0\u3f5a\0\u0132\0\u3f8d\0\u3fc0\0\u3ff3\0\u4026\0\u4059"+
    "\0\u408c\0\u40bf\0\u40f2\0\u4125\0\u4158\0\u418b\0\u41be\0\u0132"+
    "\0\u41f1\0\u4224\0\u0132\0\u0132\0\u4257\0\u0132\0\u0132\0\u428a"+
    "\0\u42bd\0\u42f0\0\u0132\0\u0132\0\u4323\0\u4356\0\u4389\0\u0132"+
    "\0\u43bc\0\u0132\0\u43ef\0\u0132\0\u4422\0\u4455\0\u0132\0\u0132"+
    "\0\u4488\0\u44bb\0\u44ee\0\u0132\0\u4521\0\u0132\0\u4554\0\u4587"+
    "\0\u45ba\0\u45ed\0\u4620\0\u4653\0\u4686\0\u46b9\0\u0132\0\u46ec"+
    "\0\u0132\0\u471f\0\u4752\0\u0132\0\u0132\0\u4785\0\u0132\0\u0132"+
    "\0\u0132\0\u0132\0\u47b8\0\u47eb\0\u481e\0\u4851\0\u0132\0\u4884"+
    "\0\u0132\0\u0132\0\u48b7\0\u48ea\0\u491d\0\u0132\0\u4950\0\u0132"+
    "\0\u0132\0\u4983\0\u49b6\0\u49e9\0\u0132\0\u0132\0\u4a1c\0\u0132"+
    "\0\u0132\0\u0132\0\u0132\0\u0132\0\u4a4f\0\u4a82\0\u4ab5\0\u4ae8"+
    "\0\u4b1b\0\u4b4e\0\u0132\0\u0132\0\u4b81\0\u0132\0\u4bb4\0\u4be7"+
    "\0\u0132\0\u4c1a\0\u4c4d\0\u0132\0\u4c80\0\u4cb3\0\u4ce6\0\u0132"+
    "\0\u0132\0\u0132\0\u4d19\0\u4d4c\0\u4d7f\0\u4db2\0\u4de5\0\u4e18"+
    "\0\u0132\0\u4e4b\0\u0132\0\u4e7e\0\u4eb1\0\u4ee4\0\u4f17\0\u0132"+
    "\0\u0132\0\u4f4a\0\u0132\0\u0132\0\u4f7d\0\u0132\0\u4fb0\0\u0132"+
    "\0\u0132\0\u0132\0\u0132\0\u4fe3\0\u0132\0\u5016\0\u5049\0\u507c"+
    "\0\u50af\0\u50e2\0\u0132\0\u5115\0\u0132\0\u5148\0\u517b\0\u51ae"+
    "\0\u0132\0\u0132\0\u51e1\0\u0132\0\u5214\0\u5247\0\u527a\0\u52ad"+
    "\0\u0132\0\u0132\0\u52e0\0\u5313\0\u5346\0\u5379\0\u0132";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[551];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\3\3\1\4\1\5\1\6\1\7\1\10\1\11"+
    "\1\12\1\13\1\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\11"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
    "\1\11\1\41\1\11\1\42\1\43\1\44\1\45\1\46"+
    "\1\47\1\50\1\51\1\52\1\53\1\54\1\55\1\11"+
    "\1\56\64\0\3\3\63\0\1\57\64\0\1\60\63\0"+
    "\1\7\1\61\1\11\16\0\33\11\7\0\1\11\1\0"+
    "\1\11\16\0\33\11\12\62\1\63\50\62\13\64\1\63"+
    "\47\64\15\0\1\65\62\0\1\66\4\0\1\67\55\0"+
    "\1\70\4\0\1\71\1\72\54\0\1\73\74\0\1\74"+
    "\42\0\1\11\1\0\1\11\16\0\1\11\1\75\1\11"+
    "\1\76\1\77\1\11\1\100\16\11\1\101\5\11\7\0"+
    "\1\11\1\0\1\11\16\0\3\11\1\102\5\11\1\103"+
    "\21\11\7\0\1\11\1\0\1\11\16\0\1\104\4\11"+
    "\1\105\25\11\7\0\1\11\1\0\1\11\16\0\3\11"+
    "\1\106\2\11\1\107\1\11\1\110\2\11\1\111\1\11"+
    "\1\112\1\11\1\113\3\11\1\114\1\11\1\115\2\11"+
    "\1\116\2\11\7\0\1\11\1\0\1\11\16\0\6\11"+
    "\1\117\11\11\1\120\1\11\1\121\2\11\1\122\2\11"+
    "\1\123\2\11\7\0\1\11\1\0\1\11\16\0\4\11"+
    "\1\124\3\11\1\125\10\11\1\126\11\11\7\0\1\11"+
    "\1\0\1\11\16\0\10\11\1\127\22\11\7\0\1\11"+
    "\1\0\1\11\16\0\2\11\1\130\3\11\1\131\16\11"+
    "\1\132\5\11\7\0\1\11\1\0\1\11\16\0\1\133"+
    "\3\11\1\134\14\11\1\135\11\11\7\0\1\11\1\0"+
    "\1\11\16\0\1\136\3\11\1\137\4\11\1\140\4\11"+
    "\1\141\2\11\1\142\11\11\7\0\1\11\1\0\1\11"+
    "\16\0\4\11\1\143\3\11\1\144\1\145\4\11\1\146"+
    "\2\11\1\147\11\11\7\0\1\11\1\0\1\11\16\0"+
    "\4\11\1\150\26\11\7\0\1\11\1\0\1\11\16\0"+
    "\1\151\11\11\1\152\20\11\7\0\1\11\1\0\1\11"+
    "\16\0\3\11\1\153\5\11\1\154\21\11\7\0\1\11"+
    "\1\0\1\11\16\0\6\11\1\155\1\11\1\156\1\157"+
    "\16\11\1\160\2\11\7\0\1\11\1\0\1\11\16\0"+
    "\4\11\1\161\26\11\7\0\1\11\1\0\1\11\16\0"+
    "\1\162\3\11\1\163\1\164\3\11\1\165\21\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\166\32\11\7\0\1\11"+
    "\1\0\1\11\16\0\1\167\3\11\1\170\26\11\7\0"+
    "\1\11\1\0\1\11\16\0\4\11\1\171\1\172\25\11"+
    "\7\0\1\11\1\0\1\11\16\0\5\11\1\173\10\11"+
    "\1\174\14\11\7\0\1\11\1\0\1\11\16\0\4\11"+
    "\1\175\4\11\1\176\7\11\1\177\11\11\7\0\1\11"+
    "\1\0\1\11\16\0\21\11\1\200\11\11\1\57\2\0"+
    "\60\57\6\0\1\201\63\0\1\61\62\0\1\11\1\0"+
    "\1\11\16\0\2\11\1\202\2\11\1\203\7\11\1\204"+
    "\15\11\7\0\1\11\1\0\1\11\16\0\25\11\1\205"+
    "\5\11\7\0\1\11\1\0\1\11\16\0\15\11\1\206"+
    "\15\11\7\0\1\11\1\0\1\11\16\0\23\11\1\207"+
    "\7\11\7\0\1\11\1\0\1\11\16\0\15\11\1\210"+
    "\15\11\7\0\1\11\1\0\1\11\16\0\4\11\1\211"+
    "\26\11\7\0\1\11\1\0\1\11\16\0\4\11\1\212"+
    "\1\213\25\11\7\0\1\11\1\0\1\11\16\0\30\11"+
    "\1\214\2\11\7\0\1\11\1\0\1\11\16\0\22\11"+
    "\1\215\1\11\1\216\6\11\7\0\1\11\1\0\1\11"+
    "\16\0\3\11\1\217\7\11\1\220\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\4\11\1\221\16\11\1\222\7\11"+
    "\7\0\1\11\1\0\1\11\16\0\13\11\1\223\17\11"+
    "\7\0\1\11\1\0\1\11\16\0\13\11\1\224\17\11"+
    "\7\0\1\11\1\0\1\11\16\0\13\11\1\225\17\11"+
    "\7\0\1\11\1\0\1\11\16\0\21\11\1\226\11\11"+
    "\7\0\1\11\1\0\1\11\16\0\23\11\1\227\7\11"+
    "\7\0\1\11\1\0\1\11\16\0\15\11\1\230\15\11"+
    "\7\0\1\11\1\0\1\11\16\0\13\11\1\231\17\11"+
    "\7\0\1\11\1\0\1\11\16\0\5\11\1\232\1\233"+
    "\4\11\1\234\7\11\1\235\1\11\1\236\5\11\7\0"+
    "\1\11\1\0\1\11\16\0\6\11\1\237\24\11\7\0"+
    "\1\11\1\0\1\11\16\0\22\11\1\240\10\11\7\0"+
    "\1\11\1\0\1\11\16\0\6\11\1\241\24\11\7\0"+
    "\1\11\1\0\1\11\16\0\13\11\1\242\17\11\7\0"+
    "\1\11\1\0\1\11\16\0\3\11\1\243\27\11\7\0"+
    "\1\11\1\0\1\11\16\0\13\11\1\244\17\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\245\32\11\7\0\1\11"+
    "\1\0\1\11\16\0\23\11\1\246\7\11\7\0\1\11"+
    "\1\0\1\11\16\0\5\11\1\247\25\11\7\0\1\11"+
    "\1\0\1\11\16\0\5\11\1\250\25\11\7\0\1\11"+
    "\1\0\1\11\16\0\2\11\1\251\1\252\1\11\1\253"+
    "\1\254\6\11\1\255\2\11\1\256\4\11\1\257\2\11"+
    "\1\260\2\11\7\0\1\11\1\0\1\11\16\0\5\11"+
    "\1\261\25\11\7\0\1\11\1\0\1\11\16\0\3\11"+
    "\1\262\23\11\1\263\3\11\7\0\1\11\1\0\1\11"+
    "\16\0\22\11\1\264\10\11\7\0\1\11\1\0\1\11"+
    "\16\0\17\11\1\265\13\11\7\0\1\11\1\0\1\11"+
    "\16\0\4\11\1\266\1\267\25\11\7\0\1\11\1\0"+
    "\1\11\16\0\1\270\32\11\7\0\1\11\1\0\1\11"+
    "\16\0\25\11\1\271\5\11\7\0\1\11\1\0\1\11"+
    "\16\0\11\11\1\272\21\11\7\0\1\11\1\0\1\11"+
    "\16\0\1\273\20\11\1\274\11\11\7\0\1\11\1\0"+
    "\1\11\16\0\1\275\32\11\7\0\1\11\1\0\1\11"+
    "\16\0\3\11\1\276\2\11\1\277\13\11\1\300\10\11"+
    "\7\0\1\11\1\0\1\11\16\0\26\11\1\301\4\11"+
    "\7\0\1\11\1\0\1\11\16\0\13\11\1\302\4\11"+
    "\1\303\7\11\1\304\2\11\7\0\1\11\1\0\1\11"+
    "\16\0\21\11\1\305\11\11\7\0\1\11\1\0\1\11"+
    "\16\0\21\11\1\306\11\11\7\0\1\11\1\0\1\11"+
    "\16\0\13\11\1\307\17\11\7\0\1\11\1\0\1\11"+
    "\16\0\23\11\1\310\7\11\7\0\1\11\1\0\1\11"+
    "\16\0\30\11\1\311\2\11\7\0\1\11\1\0\1\11"+
    "\16\0\13\11\1\312\17\11\7\0\1\11\1\0\1\11"+
    "\16\0\3\11\1\313\7\11\1\314\11\11\1\315\2\11"+
    "\1\316\2\11\7\0\1\11\1\0\1\11\16\0\13\11"+
    "\1\317\17\11\7\0\1\11\1\0\1\11\16\0\25\11"+
    "\1\320\5\11\7\0\1\11\1\0\1\11\16\0\21\11"+
    "\1\321\11\11\7\0\1\11\1\0\1\11\16\0\12\11"+
    "\1\322\20\11\7\0\1\11\1\0\1\11\16\0\3\11"+
    "\1\323\7\11\1\324\17\11\7\0\1\11\1\0\1\11"+
    "\16\0\26\11\1\325\4\11\7\0\1\11\1\0\1\11"+
    "\16\0\3\11\1\326\11\11\1\327\15\11\7\0\1\11"+
    "\1\0\1\11\16\0\1\330\10\11\1\331\21\11\7\0"+
    "\1\11\1\0\1\11\16\0\13\11\1\332\17\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\333\32\11\7\0\1\11"+
    "\1\0\1\11\16\0\5\11\1\334\25\11\7\0\1\11"+
    "\1\0\1\11\16\0\21\11\1\335\11\11\7\0\1\11"+
    "\1\0\1\11\16\0\11\11\1\336\21\11\7\0\1\11"+
    "\1\0\1\11\16\0\5\11\1\337\25\11\1\201\1\0"+
    "\4\201\1\340\54\201\7\0\1\11\1\0\1\11\16\0"+
    "\3\11\1\341\27\11\7\0\1\11\1\0\1\11\16\0"+
    "\25\11\1\342\5\11\7\0\1\11\1\0\1\11\16\0"+
    "\1\343\2\11\1\344\27\11\7\0\1\11\1\0\1\11"+
    "\16\0\1\345\32\11\7\0\1\11\1\0\1\11\16\0"+
    "\16\11\1\346\14\11\7\0\1\11\1\0\1\11\16\0"+
    "\4\11\1\347\26\11\7\0\1\11\1\0\1\11\16\0"+
    "\6\11\1\350\24\11\7\0\1\11\1\0\1\11\16\0"+
    "\20\11\1\351\12\11\7\0\1\11\1\0\1\11\16\0"+
    "\22\11\1\352\10\11\7\0\1\11\1\0\1\11\16\0"+
    "\13\11\1\353\17\11\7\0\1\11\1\0\1\11\16\0"+
    "\5\11\1\354\25\11\7\0\1\11\1\0\1\11\16\0"+
    "\1\355\32\11\7\0\1\11\1\0\1\11\16\0\1\356"+
    "\32\11\7\0\1\11\1\0\1\11\16\0\3\11\1\357"+
    "\27\11\7\0\1\11\1\0\1\11\16\0\21\11\1\360"+
    "\11\11\7\0\1\11\1\0\1\11\16\0\4\11\1\361"+
    "\26\11\7\0\1\11\1\0\1\11\16\0\5\11\1\362"+
    "\25\11\7\0\1\11\1\0\1\11\16\0\11\11\1\363"+
    "\21\11\7\0\1\11\1\0\1\11\16\0\1\364\32\11"+
    "\7\0\1\11\1\0\1\11\16\0\13\11\1\365\17\11"+
    "\7\0\1\11\1\0\1\11\16\0\1\366\32\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\367\20\11\1\370\11\11"+
    "\7\0\1\11\1\0\1\11\16\0\1\371\32\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\372\12\11\1\373\17\11"+
    "\7\0\1\11\1\0\1\11\16\0\21\11\1\374\11\11"+
    "\7\0\1\11\1\0\1\11\16\0\1\375\32\11\7\0"+
    "\1\11\1\0\1\11\16\0\10\11\1\376\22\11\7\0"+
    "\1\11\1\0\1\11\16\0\10\11\1\377\22\11\7\0"+
    "\1\11\1\0\1\11\16\0\3\11\1\u0100\27\11\7\0"+
    "\1\11\1\0\1\11\16\0\6\11\1\u0101\24\11\7\0"+
    "\1\11\1\0\1\11\16\0\11\11\1\u0102\21\11\7\0"+
    "\1\11\1\0\1\11\16\0\4\11\1\u0103\26\11\7\0"+
    "\1\11\1\0\1\11\16\0\7\11\1\u0104\11\11\1\u0105"+
    "\11\11\7\0\1\11\1\0\1\11\16\0\6\11\1\u0106"+
    "\24\11\7\0\1\11\1\0\1\11\16\0\3\11\1\u0107"+
    "\27\11\7\0\1\11\1\0\1\11\16\0\1\u0108\32\11"+
    "\7\0\1\11\1\0\1\11\16\0\6\11\1\u0109\24\11"+
    "\7\0\1\11\1\0\1\11\16\0\4\11\1\u010a\26\11"+
    "\7\0\1\11\1\0\1\11\16\0\10\11\1\u010b\22\11"+
    "\7\0\1\11\1\0\1\11\16\0\1\u010c\32\11\7\0"+
    "\1\11\1\0\1\11\16\0\13\11\1\u010d\17\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\u010e\32\11\7\0\1\11"+
    "\1\0\1\11\16\0\25\11\1\u010f\5\11\7\0\1\11"+
    "\1\0\1\11\16\0\3\11\1\u0110\27\11\7\0\1\11"+
    "\1\0\1\11\16\0\5\11\1\u0111\25\11\7\0\1\11"+
    "\1\0\1\11\16\0\2\11\1\u0112\30\11\7\0\1\11"+
    "\1\0\1\11\16\0\3\11\1\u0113\27\11\7\0\1\11"+
    "\1\0\1\11\16\0\6\11\1\u0114\24\11\7\0\1\11"+
    "\1\0\1\11\16\0\20\11\1\u0115\12\11\7\0\1\11"+
    "\1\0\1\11\16\0\6\11\1\u0116\24\11\7\0\1\11"+
    "\1\0\1\11\16\0\1\u0117\12\11\1\u0118\1\11\1\u0119"+
    "\15\11\7\0\1\11\1\0\1\11\16\0\11\11\1\u011a"+
    "\21\11\7\0\1\11\1\0\1\11\16\0\4\11\1\u011b"+
    "\26\11\7\0\1\11\1\0\1\11\16\0\25\11\1\u011c"+
    "\5\11\7\0\1\11\1\0\1\11\16\0\15\11\1\u011d"+
    "\15\11\7\0\1\11\1\0\1\11\16\0\3\11\1\u011e"+
    "\4\11\1\u011f\22\11\7\0\1\11\1\0\1\11\16\0"+
    "\25\11\1\u0120\2\11\1\u0121\2\11\7\0\1\11\1\0"+
    "\1\11\16\0\22\11\1\u0122\10\11\7\0\1\11\1\0"+
    "\1\11\16\0\5\11\1\u0123\25\11\7\0\1\11\1\0"+
    "\1\11\16\0\27\11\1\u0124\3\11\7\0\1\11\1\0"+
    "\1\11\16\0\5\11\1\u0125\25\11\7\0\1\11\1\0"+
    "\1\11\16\0\21\11\1\u0126\11\11\7\0\1\11\1\0"+
    "\1\11\16\0\17\11\1\u0127\13\11\7\0\1\11\1\0"+
    "\1\11\16\0\10\11\1\u0128\22\11\7\0\1\11\1\0"+
    "\1\11\16\0\1\u0129\32\11\7\0\1\11\1\0\1\11"+
    "\16\0\1\u012a\32\11\7\0\1\11\1\0\1\11\16\0"+
    "\25\11\1\u012b\5\11\7\0\1\11\1\0\1\11\16\0"+
    "\15\11\1\u012c\15\11\7\0\1\11\1\0\1\11\16\0"+
    "\1\u012d\32\11\7\0\1\11\1\0\1\11\16\0\4\11"+
    "\1\u012e\26\11\7\0\1\11\1\0\1\11\16\0\15\11"+
    "\1\u012f\15\11\7\0\1\11\1\0\1\11\16\0\1\u0130"+
    "\3\11\1\u0131\26\11\7\0\1\11\1\0\1\11\16\0"+
    "\4\11\1\u0132\26\11\7\0\1\11\1\0\1\11\16\0"+
    "\13\11\1\u0133\17\11\7\0\1\11\1\0\1\11\16\0"+
    "\2\11\1\u0134\30\11\7\0\1\11\1\0\1\11\16\0"+
    "\1\u0135\32\11\7\0\1\11\1\0\1\11\16\0\1\u0136"+
    "\32\11\7\0\1\11\1\0\1\11\16\0\10\11\1\u0137"+
    "\22\11\7\0\1\11\1\0\1\11\16\0\10\11\1\u0138"+
    "\22\11\7\0\1\11\1\0\1\11\16\0\27\11\1\u0139"+
    "\3\11\7\0\1\11\1\0\1\11\16\0\13\11\1\u013a"+
    "\17\11\7\0\1\11\1\0\1\11\16\0\16\11\1\u013b"+
    "\14\11\7\0\1\11\1\0\1\11\16\0\6\11\1\u013c"+
    "\2\11\1\u013d\21\11\7\0\1\11\1\0\1\11\16\0"+
    "\3\11\1\u013e\27\11\7\0\1\11\1\0\1\11\16\0"+
    "\22\11\1\u013f\10\11\7\0\1\11\1\0\1\11\16\0"+
    "\1\u0140\32\11\7\0\1\11\1\0\1\11\16\0\6\11"+
    "\1\u0141\24\11\1\201\1\0\3\201\1\u0142\1\340\54\201"+
    "\7\0\1\11\1\0\1\11\16\0\4\11\1\u0143\26\11"+
    "\7\0\1\11\1\0\1\11\16\0\13\11\1\u0144\17\11"+
    "\7\0\1\11\1\0\1\11\16\0\2\11\1\u0145\30\11"+
    "\7\0\1\11\1\0\1\11\16\0\10\11\1\u0146\22\11"+
    "\7\0\1\11\1\0\1\11\16\0\2\11\1\u0147\30\11"+
    "\7\0\1\11\1\0\1\11\16\0\22\11\1\u0148\10\11"+
    "\7\0\1\11\1\0\1\11\16\0\4\11\1\u0149\26\11"+
    "\7\0\1\11\1\0\1\11\16\0\13\11\1\u014a\17\11"+
    "\7\0\1\11\1\0\1\11\16\0\11\11\1\u014b\21\11"+
    "\7\0\1\11\1\0\1\11\16\0\12\11\1\u014c\20\11"+
    "\7\0\1\11\1\0\1\11\16\0\5\11\1\u014d\25\11"+
    "\7\0\1\11\1\0\1\11\16\0\15\11\1\u014e\15\11"+
    "\7\0\1\11\1\0\1\11\16\0\21\11\1\u014f\11\11"+
    "\7\0\1\11\1\0\1\11\16\0\13\11\1\u0150\17\11"+
    "\7\0\1\11\1\0\1\11\16\0\11\11\1\u0151\21\11"+
    "\7\0\1\11\1\0\1\11\16\0\5\11\1\u0152\25\11"+
    "\7\0\1\11\1\0\1\11\16\0\11\11\1\u0153\21\11"+
    "\7\0\1\11\1\0\1\11\16\0\11\11\1\u0154\21\11"+
    "\7\0\1\11\1\0\1\11\16\0\1\11\1\u0155\31\11"+
    "\7\0\1\11\1\0\1\11\16\0\11\11\1\u0156\21\11"+
    "\7\0\1\11\1\0\1\11\16\0\1\u0157\32\11\7\0"+
    "\1\11\1\0\1\11\16\0\11\11\1\u0158\21\11\7\0"+
    "\1\11\1\0\1\11\16\0\23\11\1\u0159\7\11\7\0"+
    "\1\11\1\0\1\11\16\0\3\11\1\u015a\27\11\7\0"+
    "\1\11\1\0\1\11\16\0\11\11\1\u015b\21\11\7\0"+
    "\1\11\1\0\1\11\16\0\10\11\1\u015c\22\11\7\0"+
    "\1\11\1\0\1\11\16\0\12\11\1\u015d\20\11\7\0"+
    "\1\11\1\0\1\11\16\0\13\11\1\u015e\17\11\7\0"+
    "\1\11\1\0\1\11\16\0\10\11\1\u015f\22\11\7\0"+
    "\1\11\1\0\1\11\16\0\6\11\1\u0160\24\11\7\0"+
    "\1\11\1\0\1\11\16\0\20\11\1\u0161\12\11\7\0"+
    "\1\11\1\0\1\11\16\0\4\11\1\u0162\26\11\7\0"+
    "\1\11\1\0\1\11\16\0\4\11\1\u0163\26\11\7\0"+
    "\1\11\1\0\1\11\16\0\23\11\1\u0164\7\11\7\0"+
    "\1\11\1\0\1\11\16\0\22\11\1\u0165\10\11\7\0"+
    "\1\11\1\0\1\11\16\0\11\11\1\u0166\21\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\11\1\u0167\31\11\7\0"+
    "\1\11\1\0\1\11\16\0\11\11\1\u0168\21\11\7\0"+
    "\1\11\1\0\1\11\16\0\11\11\1\u0169\21\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\u016a\32\11\7\0\1\11"+
    "\1\0\1\11\16\0\17\11\1\u016b\13\11\7\0\1\11"+
    "\1\0\1\11\16\0\23\11\1\u016c\7\11\7\0\1\11"+
    "\1\0\1\11\16\0\21\11\1\u016d\11\11\7\0\1\11"+
    "\1\0\1\11\16\0\1\u016e\32\11\7\0\1\11\1\0"+
    "\1\11\16\0\25\11\1\u016f\5\11\7\0\1\11\1\0"+
    "\1\11\16\0\20\11\1\u0170\12\11\7\0\1\11\1\0"+
    "\1\11\16\0\4\11\1\u0171\26\11\7\0\1\11\1\0"+
    "\1\11\16\0\1\u0172\32\11\7\0\1\11\1\0\1\11"+
    "\16\0\13\11\1\u0173\17\11\7\0\1\11\1\0\1\11"+
    "\16\0\25\11\1\u0174\5\11\7\0\1\11\1\0\1\11"+
    "\16\0\24\11\1\u0175\6\11\7\0\1\11\1\0\1\11"+
    "\16\0\4\11\1\u0176\26\11\7\0\1\11\1\0\1\11"+
    "\16\0\22\11\1\u0177\10\11\7\0\1\11\1\0\1\11"+
    "\16\0\13\11\1\u0178\17\11\7\0\1\11\1\0\1\11"+
    "\16\0\3\11\1\u0179\27\11\7\0\1\11\1\0\1\11"+
    "\16\0\5\11\1\u017a\25\11\7\0\1\11\1\0\1\11"+
    "\16\0\6\11\1\u017b\24\11\7\0\1\11\1\0\1\11"+
    "\16\0\1\u017c\32\11\7\0\1\11\1\0\1\11\16\0"+
    "\6\11\1\u017d\24\11\7\0\1\11\1\0\1\11\16\0"+
    "\11\11\1\u017e\21\11\7\0\1\11\1\0\1\11\16\0"+
    "\2\11\1\u017f\30\11\7\0\1\11\1\0\1\11\16\0"+
    "\11\11\1\u0180\21\11\7\0\1\11\1\0\1\11\16\0"+
    "\11\11\1\u0181\21\11\7\0\1\11\1\0\1\11\16\0"+
    "\1\u0182\32\11\7\0\1\11\1\0\1\11\16\0\16\11"+
    "\1\u0183\14\11\7\0\1\11\1\0\1\11\16\0\13\11"+
    "\1\u0184\17\11\7\0\1\11\1\0\1\11\16\0\15\11"+
    "\1\u0185\15\11\7\0\1\11\1\0\1\11\16\0\11\11"+
    "\1\u0186\21\11\7\0\1\11\1\0\1\11\16\0\10\11"+
    "\1\u0187\22\11\7\0\1\11\1\0\1\11\16\0\17\11"+
    "\1\u0188\13\11\7\0\1\11\1\0\1\11\16\0\5\11"+
    "\1\u0189\25\11\7\0\1\11\1\0\1\11\16\0\15\11"+
    "\1\u018a\15\11\7\0\1\11\1\0\1\11\16\0\2\11"+
    "\1\u018b\30\11\7\0\1\11\1\0\1\11\16\0\1\u018c"+
    "\32\11\7\0\1\11\1\0\1\11\16\0\10\11\1\u018d"+
    "\22\11\7\0\1\11\1\0\1\11\16\0\10\11\1\u018e"+
    "\22\11\7\0\1\11\1\0\1\11\16\0\21\11\1\u018f"+
    "\11\11\7\0\1\11\1\0\1\11\16\0\1\u0190\32\11"+
    "\7\0\1\11\1\0\1\11\16\0\5\11\1\u0191\25\11"+
    "\7\0\1\11\1\0\1\11\16\0\5\11\1\u0192\25\11"+
    "\7\0\1\11\1\0\1\11\16\0\25\11\1\u0193\5\11"+
    "\7\0\1\11\1\0\1\11\16\0\13\11\1\u0194\17\11"+
    "\7\0\1\11\1\0\1\11\16\0\25\11\1\u0195\5\11"+
    "\7\0\1\11\1\0\1\11\16\0\1\u0196\32\11\7\0"+
    "\1\11\1\0\1\11\16\0\4\11\1\u0197\26\11\7\0"+
    "\1\11\1\0\1\11\16\0\11\11\1\u0198\21\11\7\0"+
    "\1\11\1\0\1\11\16\0\14\11\1\u0199\16\11\7\0"+
    "\1\11\1\0\1\11\16\0\6\11\1\u019a\24\11\7\0"+
    "\1\11\1\0\1\11\16\0\16\11\1\u019b\14\11\7\0"+
    "\1\11\1\0\1\11\16\0\6\11\1\u019c\24\11\7\0"+
    "\1\11\1\0\1\11\16\0\4\11\1\u019d\26\11\7\0"+
    "\1\11\1\0\1\11\16\0\25\11\1\u019e\5\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\u019f\32\11\7\0\1\11"+
    "\1\0\1\11\16\0\13\11\1\u01a0\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\4\11\1\u01a1\26\11\7\0\1\11"+
    "\1\0\1\11\16\0\1\u01a2\32\11\7\0\1\11\1\0"+
    "\1\11\16\0\5\11\1\u01a3\25\11\7\0\1\11\1\0"+
    "\1\11\16\0\3\11\1\u01a4\27\11\7\0\1\11\1\0"+
    "\1\11\16\0\4\11\1\u01a5\26\11\7\0\1\11\1\0"+
    "\1\11\16\0\3\11\1\u01a6\27\11\7\0\1\11\1\0"+
    "\1\11\16\0\1\u01a7\32\11\7\0\1\11\1\0\1\11"+
    "\16\0\1\u01a8\32\11\7\0\1\11\1\0\1\11\16\0"+
    "\15\11\1\u01a9\15\11\7\0\1\11\1\0\1\11\16\0"+
    "\25\11\1\u01aa\5\11\7\0\1\11\1\0\1\11\16\0"+
    "\1\u01ab\32\11\7\0\1\11\1\0\1\11\16\0\1\u01ac"+
    "\32\11\7\0\1\11\1\0\1\11\16\0\25\11\1\u01ad"+
    "\5\11\7\0\1\11\1\0\1\11\16\0\2\11\1\u01ae"+
    "\30\11\7\0\1\11\1\0\1\11\16\0\5\11\1\u01af"+
    "\25\11\7\0\1\11\1\0\1\11\16\0\1\u01b0\32\11"+
    "\7\0\1\11\1\0\1\11\16\0\4\11\1\u01b1\26\11"+
    "\7\0\1\11\1\0\1\11\16\0\11\11\1\u01b2\21\11"+
    "\7\0\1\11\1\0\1\11\16\0\4\11\1\u01b3\26\11"+
    "\7\0\1\11\1\0\1\11\16\0\1\u01b4\32\11\7\0"+
    "\1\11\1\0\1\11\16\0\23\11\1\u01b5\7\11\7\0"+
    "\1\11\1\0\1\11\16\0\6\11\1\u01b6\24\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\u01b7\32\11\7\0\1\11"+
    "\1\0\1\11\16\0\13\11\1\u01b8\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\6\11\1\u01b9\24\11\7\0\1\11"+
    "\1\0\1\11\16\0\11\11\1\u01ba\21\11\7\0\1\11"+
    "\1\0\1\11\16\0\5\11\1\u01bb\25\11\7\0\1\11"+
    "\1\0\1\11\16\0\13\11\1\u01bc\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\20\11\1\u01bd\12\11\7\0\1\11"+
    "\1\0\1\11\16\0\1\u01be\32\11\7\0\1\11\1\0"+
    "\1\11\16\0\1\u01bf\32\11\7\0\1\11\1\0\1\11"+
    "\16\0\13\11\1\u01c0\17\11\7\0\1\11\1\0\1\11"+
    "\16\0\1\u01c1\32\11\7\0\1\11\1\0\1\11\16\0"+
    "\16\11\1\u01c2\14\11\7\0\1\11\1\0\1\11\16\0"+
    "\11\11\1\u01c3\21\11\7\0\1\11\1\0\1\11\16\0"+
    "\3\11\1\u01c4\27\11\7\0\1\11\1\0\1\11\16\0"+
    "\4\11\1\u01c5\26\11\7\0\1\11\1\0\1\11\16\0"+
    "\6\11\1\u01c6\24\11\7\0\1\11\1\0\1\11\16\0"+
    "\13\11\1\u01c7\17\11\7\0\1\11\1\0\1\11\16\0"+
    "\21\11\1\u01c8\11\11\7\0\1\11\1\0\1\11\16\0"+
    "\25\11\1\u01c9\5\11\7\0\1\11\1\0\1\11\16\0"+
    "\22\11\1\u01ca\10\11\7\0\1\11\1\0\1\11\16\0"+
    "\4\11\1\u01cb\26\11\7\0\1\11\1\0\1\11\16\0"+
    "\10\11\1\u01cc\22\11\7\0\1\11\1\0\1\11\16\0"+
    "\20\11\1\u01cd\12\11\7\0\1\11\1\0\1\11\16\0"+
    "\6\11\1\u01ce\24\11\7\0\1\11\1\0\1\11\16\0"+
    "\5\11\1\u01cf\25\11\7\0\1\11\1\0\1\11\16\0"+
    "\12\11\1\u01d0\20\11\7\0\1\11\1\0\1\11\16\0"+
    "\1\u01d1\32\11\7\0\1\11\1\0\1\11\16\0\15\11"+
    "\1\u01d2\15\11\7\0\1\11\1\0\1\11\16\0\3\11"+
    "\1\u01d3\27\11\7\0\1\11\1\0\1\11\16\0\1\u01d4"+
    "\32\11\7\0\1\11\1\0\1\11\16\0\23\11\1\u01d5"+
    "\7\11\7\0\1\11\1\0\1\11\16\0\23\11\1\u01d6"+
    "\7\11\7\0\1\11\1\0\1\11\16\0\4\11\1\u01d7"+
    "\26\11\7\0\1\11\1\0\1\11\16\0\3\11\1\u01d8"+
    "\27\11\7\0\1\11\1\0\1\11\16\0\3\11\1\u01d9"+
    "\27\11\7\0\1\11\1\0\1\11\16\0\1\u01da\32\11"+
    "\7\0\1\11\1\0\1\11\16\0\1\u01db\32\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\11\1\u01dc\31\11\7\0"+
    "\1\11\1\0\1\11\16\0\5\11\1\u01dd\25\11\7\0"+
    "\1\11\1\0\1\11\16\0\15\11\1\u01de\15\11\7\0"+
    "\1\11\1\0\1\11\16\0\6\11\1\u01df\24\11\7\0"+
    "\1\11\1\0\1\11\16\0\15\11\1\u01e0\15\11\7\0"+
    "\1\11\1\0\1\11\16\0\4\11\1\u01e1\26\11\7\0"+
    "\1\11\1\0\1\11\16\0\15\11\1\u01e2\15\11\7\0"+
    "\1\11\1\0\1\11\16\0\11\11\1\u01e3\21\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\u01e4\32\11\7\0\1\11"+
    "\1\0\1\11\16\0\13\11\1\u01e5\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\1\u01e6\32\11\7\0\1\11\1\0"+
    "\1\11\16\0\4\11\1\u01e7\26\11\7\0\1\11\1\0"+
    "\1\11\16\0\15\11\1\u01e8\15\11\7\0\1\11\1\0"+
    "\1\11\16\0\6\11\1\u01e9\24\11\7\0\1\11\1\0"+
    "\1\11\16\0\1\u01ea\3\11\1\u01eb\26\11\7\0\1\11"+
    "\1\0\1\11\16\0\13\11\1\u01ec\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\25\11\1\u01ed\5\11\7\0\1\11"+
    "\1\0\1\11\16\0\15\11\1\u01ee\15\11\7\0\1\11"+
    "\1\0\1\11\16\0\5\11\1\u01ef\25\11\7\0\1\11"+
    "\1\0\1\11\16\0\3\11\1\u01f0\27\11\7\0\1\11"+
    "\1\0\1\11\16\0\13\11\1\u01f1\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\6\11\1\u01f2\24\11\7\0\1\11"+
    "\1\0\1\11\16\0\26\11\1\u01f3\4\11\7\0\1\11"+
    "\1\0\1\11\16\0\11\11\1\u01f4\21\11\7\0\1\11"+
    "\1\0\1\11\16\0\3\11\1\u01f5\27\11\7\0\1\11"+
    "\1\0\1\11\16\0\15\11\1\u01f6\15\11\7\0\1\11"+
    "\1\0\1\11\16\0\13\11\1\u01f7\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\26\11\1\u01f8\4\11\7\0\1\11"+
    "\1\0\1\11\16\0\13\11\1\u01f9\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\15\11\1\u01fa\15\11\7\0\1\11"+
    "\1\0\1\11\16\0\24\11\1\u01fb\6\11\7\0\1\11"+
    "\1\0\1\11\16\0\11\11\1\u01fc\21\11\7\0\1\11"+
    "\1\0\1\11\16\0\13\11\1\u01fd\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\31\11\1\u01fe\1\11\7\0\1\11"+
    "\1\0\1\11\16\0\5\11\1\u01ff\25\11\7\0\1\11"+
    "\1\0\1\11\16\0\13\11\1\u0200\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\23\11\1\u0201\7\11\7\0\1\11"+
    "\1\0\1\11\16\0\17\11\1\u0202\13\11\7\0\1\11"+
    "\1\0\1\11\16\0\1\u0203\32\11\7\0\1\11\1\0"+
    "\1\11\16\0\13\11\1\u0204\17\11\7\0\1\11\1\0"+
    "\1\11\16\0\6\11\1\u0205\24\11\7\0\1\11\1\0"+
    "\1\11\16\0\1\u0206\32\11\7\0\1\11\1\0\1\11"+
    "\16\0\1\u0207\32\11\7\0\1\11\1\0\1\11\16\0"+
    "\12\11\1\u0208\20\11\7\0\1\11\1\0\1\11\16\0"+
    "\13\11\1\u0209\17\11\7\0\1\11\1\0\1\11\16\0"+
    "\1\u020a\32\11\7\0\1\11\1\0\1\11\16\0\1\u020b"+
    "\32\11\7\0\1\11\1\0\1\11\16\0\1\u020c\32\11"+
    "\7\0\1\11\1\0\1\11\16\0\12\11\1\u020d\20\11"+
    "\7\0\1\11\1\0\1\11\16\0\5\11\1\u020e\25\11"+
    "\7\0\1\11\1\0\1\11\16\0\13\11\1\u020f\7\11"+
    "\1\u0210\7\11\7\0\1\11\1\0\1\11\16\0\6\11"+
    "\1\u0211\24\11\7\0\1\11\1\0\1\11\16\0\3\11"+
    "\1\u0212\27\11\7\0\1\11\1\0\1\11\16\0\13\11"+
    "\1\u0213\17\11\7\0\1\11\1\0\1\11\16\0\22\11"+
    "\1\u0214\10\11\7\0\1\11\1\0\1\11\16\0\25\11"+
    "\1\u0215\5\11\7\0\1\11\1\0\1\11\16\0\21\11"+
    "\1\u0216\11\11\7\0\1\11\1\0\1\11\16\0\5\11"+
    "\1\u0217\25\11\7\0\1\11\1\0\1\11\16\0\4\11"+
    "\1\u0218\26\11\7\0\1\11\1\0\1\11\16\0\13\11"+
    "\1\u0219\17\11\7\0\1\11\1\0\1\11\16\0\1\u021a"+
    "\32\11\7\0\1\11\1\0\1\11\16\0\1\u021b\32\11"+
    "\7\0\1\11\1\0\1\11\16\0\6\11\1\u021c\24\11"+
    "\7\0\1\11\1\0\1\11\16\0\22\11\1\u021d\10\11"+
    "\7\0\1\11\1\0\1\11\16\0\13\11\1\u021e\17\11"+
    "\7\0\1\11\1\0\1\11\16\0\6\11\1\u021f\24\11"+
    "\7\0\1\11\1\0\1\11\16\0\1\u0220\32\11\7\0"+
    "\1\11\1\0\1\11\16\0\1\u0221\32\11\7\0\1\11"+
    "\1\0\1\11\16\0\13\11\1\u0222\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\25\11\1\u0223\5\11\7\0\1\11"+
    "\1\0\1\11\16\0\13\11\1\u0224\17\11\7\0\1\11"+
    "\1\0\1\11\16\0\4\11\1\u0225\26\11\7\0\1\11"+
    "\1\0\1\11\16\0\22\11\1\u0226\10\11\7\0\1\11"+
    "\1\0\1\11\16\0\2\11\1\u0227\30\11";

  private static int [] zzUnpackTrans() {
    int [] result = new int[21420];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\1\1\11\3\1\1\11\1\1\1\11\3\1\1\11"+
    "\1\1\4\11\3\1\2\11\31\1\1\0\1\1\1\0"+
    "\1\11\1\0\10\11\104\1\1\0\136\1\1\0\u0147\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[551];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  public SqliteLexer() {
    this((java.io.Reader)null);
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public SqliteLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    int size = 0;
    for (int i = 0, length = packed.length(); i < length; i += 2) {
      size += packed.charAt(i);
    }
    char[] map = new char[size];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < packed.length()) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + ZZ_CMAP(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return ID;
            } 
            // fall through
          case 155: break;
          case 2: 
            { return BAD_CHARACTER;
            } 
            // fall through
          case 156: break;
          case 3: 
            { return WHITE_SPACE;
            } 
            // fall through
          case 157: break;
          case 4: 
            { return MINUS;
            } 
            // fall through
          case 158: break;
          case 5: 
            { return DIVIDE;
            } 
            // fall through
          case 159: break;
          case 6: 
            { return MULTIPLY;
            } 
            // fall through
          case 160: break;
          case 7: 
            { return DIGIT;
            } 
            // fall through
          case 161: break;
          case 8: 
            { return DOT;
            } 
            // fall through
          case 162: break;
          case 9: 
            { return SEMI;
            } 
            // fall through
          case 163: break;
          case 10: 
            { return EQ;
            } 
            // fall through
          case 164: break;
          case 11: 
            { return LP;
            } 
            // fall through
          case 165: break;
          case 12: 
            { return RP;
            } 
            // fall through
          case 166: break;
          case 13: 
            { return COMMA;
            } 
            // fall through
          case 167: break;
          case 14: 
            { return PLUS;
            } 
            // fall through
          case 168: break;
          case 15: 
            { return GT;
            } 
            // fall through
          case 169: break;
          case 16: 
            { return LT;
            } 
            // fall through
          case 170: break;
          case 17: 
            { return MOD;
            } 
            // fall through
          case 171: break;
          case 18: 
            { return BITWISE_AND;
            } 
            // fall through
          case 172: break;
          case 19: 
            { return BITWISE_OR;
            } 
            // fall through
          case 173: break;
          case 20: 
            { return E;
            } 
            // fall through
          case 174: break;
          case 21: 
            { return COMMENT;
            } 
            // fall through
          case 175: break;
          case 22: 
            { return STRING;
            } 
            // fall through
          case 176: break;
          case 23: 
            { return EQ2;
            } 
            // fall through
          case 177: break;
          case 24: 
            { return GTE;
            } 
            // fall through
          case 178: break;
          case 25: 
            { return SHIFT_RIGHT;
            } 
            // fall through
          case 179: break;
          case 26: 
            { return LTE;
            } 
            // fall through
          case 180: break;
          case 27: 
            { return NEQ2;
            } 
            // fall through
          case 181: break;
          case 28: 
            { return SHIFT_LEFT;
            } 
            // fall through
          case 182: break;
          case 29: 
            { return NEQ;
            } 
            // fall through
          case 183: break;
          case 30: 
            { return CONCAT;
            } 
            // fall through
          case 184: break;
          case 31: 
            { return AS;
            } 
            // fall through
          case 185: break;
          case 32: 
            { return IN;
            } 
            // fall through
          case 186: break;
          case 33: 
            { return IS;
            } 
            // fall through
          case 187: break;
          case 34: 
            { return IF;
            } 
            // fall through
          case 188: break;
          case 35: 
            { return NO;
            } 
            // fall through
          case 189: break;
          case 36: 
            { return TO;
            } 
            // fall through
          case 190: break;
          case 37: 
            { return BY;
            } 
            // fall through
          case 191: break;
          case 38: 
            { return ON;
            } 
            // fall through
          case 192: break;
          case 39: 
            { return OR;
            } 
            // fall through
          case 193: break;
          case 40: 
            { return OF;
            } 
            // fall through
          case 194: break;
          case 41: 
            { return END;
            } 
            // fall through
          case 195: break;
          case 42: 
            { return ALL;
            } 
            // fall through
          case 196: break;
          case 43: 
            { return AND;
            } 
            // fall through
          case 197: break;
          case 44: 
            { return ADD;
            } 
            // fall through
          case 198: break;
          case 45: 
            { return ASC;
            } 
            // fall through
          case 199: break;
          case 46: 
            { return NOT;
            } 
            // fall through
          case 200: break;
          case 47: 
            { return ROW;
            } 
            // fall through
          case 201: break;
          case 48: 
            { return KEY;
            } 
            // fall through
          case 202: break;
          case 49: 
            { return SET;
            } 
            // fall through
          case 203: break;
          case 50: 
            { return FOR;
            } 
            // fall through
          case 204: break;
          case 51: 
            { return ELSE;
            } 
            // fall through
          case 205: break;
          case 52: 
            { return EACH;
            } 
            // fall through
          case 206: break;
          case 53: 
            { return PLAN;
            } 
            // fall through
          case 207: break;
          case 54: 
            { return LEFT;
            } 
            // fall through
          case 208: break;
          case 55: 
            { return LIKE;
            } 
            // fall through
          case 209: break;
          case 56: 
            { return INTO;
            } 
            // fall through
          case 210: break;
          case 57: 
            { return NULL;
            } 
            // fall through
          case 211: break;
          case 58: 
            { return TEMP;
            } 
            // fall through
          case 212: break;
          case 59: 
            { return THEN;
            } 
            // fall through
          case 213: break;
          case 60: 
            { return CASE;
            } 
            // fall through
          case 214: break;
          case 61: 
            { return CAST;
            } 
            // fall through
          case 215: break;
          case 62: 
            { return GLOB;
            } 
            // fall through
          case 216: break;
          case 63: 
            { return DESC;
            } 
            // fall through
          case 217: break;
          case 64: 
            { return DROP;
            } 
            // fall through
          case 218: break;
          case 65: 
            { return VIEW;
            } 
            // fall through
          case 219: break;
          case 66: 
            { return WITH;
            } 
            // fall through
          case 220: break;
          case 67: 
            { return WHEN;
            } 
            // fall through
          case 221: break;
          case 68: 
            { return FAIL;
            } 
            // fall through
          case 222: break;
          case 69: 
            { return FROM;
            } 
            // fall through
          case 223: break;
          case 70: 
            { return JOIN;
            } 
            // fall through
          case 224: break;
          case 71: 
            { return JAVADOC;
            } 
            // fall through
          case 225: break;
          case 72: 
            { return LIMIT;
            } 
            // fall through
          case 226: break;
          case 73: 
            { return ALTER;
            } 
            // fall through
          case 227: break;
          case 74: 
            { return ABORT;
            } 
            // fall through
          case 228: break;
          case 75: 
            { return AFTER;
            } 
            // fall through
          case 229: break;
          case 76: 
            { return INNER;
            } 
            // fall through
          case 230: break;
          case 77: 
            { return INDEX;
            } 
            // fall through
          case 231: break;
          case 78: 
            { return QUERY;
            } 
            // fall through
          case 232: break;
          case 79: 
            { return UNION;
            } 
            // fall through
          case 233: break;
          case 80: 
            { return USING;
            } 
            // fall through
          case 234: break;
          case 81: 
            { return RAISE;
            } 
            // fall through
          case 235: break;
          case 82: 
            { return ROWID;
            } 
            // fall through
          case 236: break;
          case 83: 
            { return TABLE;
            } 
            // fall through
          case 237: break;
          case 84: 
            { return CROSS;
            } 
            // fall through
          case 238: break;
          case 85: 
            { return CHECK;
            } 
            // fall through
          case 239: break;
          case 86: 
            { return BEGIN;
            } 
            // fall through
          case 240: break;
          case 87: 
            { return GROUP;
            } 
            // fall through
          case 241: break;
          case 88: 
            { return OUTER;
            } 
            // fall through
          case 242: break;
          case 89: 
            { return ORDER;
            } 
            // fall through
          case 243: break;
          case 90: 
            { return MATCH;
            } 
            // fall through
          case 244: break;
          case 91: 
            { return WHERE;
            } 
            // fall through
          case 245: break;
          case 92: 
            { return EXISTS;
            } 
            // fall through
          case 246: break;
          case 93: 
            { return EXCEPT;
            } 
            // fall through
          case 247: break;
          case 94: 
            { return ESCAPE;
            } 
            // fall through
          case 248: break;
          case 95: 
            { return PRAGMA;
            } 
            // fall through
          case 249: break;
          case 96: 
            { return ATTACH;
            } 
            // fall through
          case 250: break;
          case 97: 
            { return ACTION;
            } 
            // fall through
          case 251: break;
          case 98: 
            { return INSERT;
            } 
            // fall through
          case 252: break;
          case 99: 
            { return IGNORE;
            } 
            // fall through
          case 253: break;
          case 100: 
            { return ISNULL;
            } 
            // fall through
          case 254: break;
          case 101: 
            { return UPDATE;
            } 
            // fall through
          case 255: break;
          case 102: 
            { return UNIQUE;
            } 
            // fall through
          case 256: break;
          case 103: 
            { return RENAME;
            } 
            // fall through
          case 257: break;
          case 104: 
            { return REGEXP;
            } 
            // fall through
          case 258: break;
          case 105: 
            { return CREATE;
            } 
            // fall through
          case 259: break;
          case 106: 
            { return COLUMN;
            } 
            // fall through
          case 260: break;
          case 107: 
            { return COMMIT;
            } 
            // fall through
          case 261: break;
          case 108: 
            { return HAVING;
            } 
            // fall through
          case 262: break;
          case 109: 
            { return BEFORE;
            } 
            // fall through
          case 263: break;
          case 110: 
            { return OFFSET;
            } 
            // fall through
          case 264: break;
          case 111: 
            { return DELETE;
            } 
            // fall through
          case 265: break;
          case 112: 
            { return DETACH;
            } 
            // fall through
          case 266: break;
          case 113: 
            { return SELECT;
            } 
            // fall through
          case 267: break;
          case 114: 
            { return VALUES;
            } 
            // fall through
          case 268: break;
          case 115: 
            { return VACUUM;
            } 
            // fall through
          case 269: break;
          case 116: 
            { return EXPLAIN;
            } 
            // fall through
          case 270: break;
          case 117: 
            { return PRIMARY;
            } 
            // fall through
          case 271: break;
          case 118: 
            { return ANALYZE;
            } 
            // fall through
          case 272: break;
          case 119: 
            { return INDEXED;
            } 
            // fall through
          case 273: break;
          case 120: 
            { return INSTEAD;
            } 
            // fall through
          case 274: break;
          case 121: 
            { return NATURAL;
            } 
            // fall through
          case 275: break;
          case 122: 
            { return NOTNULL;
            } 
            // fall through
          case 276: break;
          case 123: 
            { return REPLACE;
            } 
            // fall through
          case 277: break;
          case 124: 
            { return RELEASE;
            } 
            // fall through
          case 278: break;
          case 125: 
            { return REINDEX;
            } 
            // fall through
          case 279: break;
          case 126: 
            { return TRIGGER;
            } 
            // fall through
          case 280: break;
          case 127: 
            { return CASCADE;
            } 
            // fall through
          case 281: break;
          case 128: 
            { return COLLATE;
            } 
            // fall through
          case 282: break;
          case 129: 
            { return BETWEEN;
            } 
            // fall through
          case 283: break;
          case 130: 
            { return DEFAULT;
            } 
            // fall through
          case 284: break;
          case 131: 
            { return VIRTUAL;
            } 
            // fall through
          case 285: break;
          case 132: 
            { return WITHOUT;
            } 
            // fall through
          case 286: break;
          case 133: 
            { return FOREIGN;
            } 
            // fall through
          case 287: break;
          case 134: 
            { return RESTRICT;
            } 
            // fall through
          case 288: break;
          case 135: 
            { return ROLLBACK;
            } 
            // fall through
          case 289: break;
          case 136: 
            { return CONFLICT;
            } 
            // fall through
          case 290: break;
          case 137: 
            { return DEFERRED;
            } 
            // fall through
          case 291: break;
          case 138: 
            { return DATABASE;
            } 
            // fall through
          case 292: break;
          case 139: 
            { return DISTINCT;
            } 
            // fall through
          case 293: break;
          case 140: 
            { return EXCLUSIVE;
            } 
            // fall through
          case 294: break;
          case 141: 
            { return INITIALLY;
            } 
            // fall through
          case 295: break;
          case 142: 
            { return INTERSECT;
            } 
            // fall through
          case 296: break;
          case 143: 
            { return IMMEDIATE;
            } 
            // fall through
          case 297: break;
          case 144: 
            { return RECURSIVE;
            } 
            // fall through
          case 298: break;
          case 145: 
            { return TEMPORARY;
            } 
            // fall through
          case 299: break;
          case 146: 
            { return SAVEPOINT;
            } 
            // fall through
          case 300: break;
          case 147: 
            { return REFERENCES;
            } 
            // fall through
          case 301: break;
          case 148: 
            { return CONSTRAINT;
            } 
            // fall through
          case 302: break;
          case 149: 
            { return DEFERRABLE;
            } 
            // fall through
          case 303: break;
          case 150: 
            { return TRANSACTION;
            } 
            // fall through
          case 304: break;
          case 151: 
            { return CURRENT_TIME;
            } 
            // fall through
          case 305: break;
          case 152: 
            { return CURRENT_DATE;
            } 
            // fall through
          case 306: break;
          case 153: 
            { return AUTOINCREMENT;
            } 
            // fall through
          case 307: break;
          case 154: 
            { return CURRENT_TIMESTAMP;
            } 
            // fall through
          case 308: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
