package com.alecstrong.sqlite.psi.core

import com.alecstrong.sqlite.psi.core.psi.SqliteTypes
import com.intellij.lang.ASTNode
import com.intellij.lang.PsiBuilder
import com.intellij.lang.parser.GeneratedParserUtilBase
import com.intellij.psi.PsiElement
import kotlin.Boolean
import kotlin.Int

open class CustomSqliteParser {
    open fun createElement(node: ASTNode): PsiElement = SqliteTypes.Factory.createElement(node)

    open fun sqlStmtList(
            builder: PsiBuilder,
            level: Int,
            sql_stmt_list: GeneratedParserUtilBase.Parser
    ): Boolean = sql_stmt_list.parse(builder, level)

    open fun statement(
            builder: PsiBuilder,
            level: Int,
            statement: GeneratedParserUtilBase.Parser
    ): Boolean = statement.parse(builder, level)

    open fun sqlStmt(
            builder: PsiBuilder,
            level: Int,
            sql_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = sql_stmt.parse(builder, level)

    open fun alterTableStmt(
            builder: PsiBuilder,
            level: Int,
            alter_table_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = alter_table_stmt.parse(builder, level)

    open fun analyzeStmt(
            builder: PsiBuilder,
            level: Int,
            analyze_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = analyze_stmt.parse(builder, level)

    open fun attachStmt(
            builder: PsiBuilder,
            level: Int,
            attach_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = attach_stmt.parse(builder, level)

    open fun beginStmt(
            builder: PsiBuilder,
            level: Int,
            begin_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = begin_stmt.parse(builder, level)

    open fun commitStmt(
            builder: PsiBuilder,
            level: Int,
            commit_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = commit_stmt.parse(builder, level)

    open fun rollbackStmt(
            builder: PsiBuilder,
            level: Int,
            rollback_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = rollback_stmt.parse(builder, level)

    open fun savepointStmt(
            builder: PsiBuilder,
            level: Int,
            savepoint_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = savepoint_stmt.parse(builder, level)

    open fun releaseStmt(
            builder: PsiBuilder,
            level: Int,
            release_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = release_stmt.parse(builder, level)

    open fun createIndexStmt(
            builder: PsiBuilder,
            level: Int,
            create_index_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = create_index_stmt.parse(builder, level)

    open fun indexedColumn(
            builder: PsiBuilder,
            level: Int,
            indexed_column: GeneratedParserUtilBase.Parser
    ): Boolean = indexed_column.parse(builder, level)

    open fun createTableStmt(
            builder: PsiBuilder,
            level: Int,
            create_table_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = create_table_stmt.parse(builder, level)

    open fun columnDef(
            builder: PsiBuilder,
            level: Int,
            column_def: GeneratedParserUtilBase.Parser
    ): Boolean = column_def.parse(builder, level)

    open fun typeName(
            builder: PsiBuilder,
            level: Int,
            type_name: GeneratedParserUtilBase.Parser
    ): Boolean = type_name.parse(builder, level)

    open fun columnConstraint(
            builder: PsiBuilder,
            level: Int,
            column_constraint: GeneratedParserUtilBase.Parser
    ): Boolean = column_constraint.parse(builder, level)

    open fun signedNumber(
            builder: PsiBuilder,
            level: Int,
            signed_number: GeneratedParserUtilBase.Parser
    ): Boolean = signed_number.parse(builder, level)

    open fun tableConstraint(
            builder: PsiBuilder,
            level: Int,
            table_constraint: GeneratedParserUtilBase.Parser
    ): Boolean = table_constraint.parse(builder, level)

    open fun foreignKeyClause(
            builder: PsiBuilder,
            level: Int,
            foreign_key_clause: GeneratedParserUtilBase.Parser
    ): Boolean = foreign_key_clause.parse(builder, level)

    open fun conflictClause(
            builder: PsiBuilder,
            level: Int,
            conflict_clause: GeneratedParserUtilBase.Parser
    ): Boolean = conflict_clause.parse(builder, level)

    open fun createTriggerStmt(
            builder: PsiBuilder,
            level: Int,
            create_trigger_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = create_trigger_stmt.parse(builder, level)

    open fun createViewStmt(
            builder: PsiBuilder,
            level: Int,
            create_view_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = create_view_stmt.parse(builder, level)

    open fun createVirtualTableStmt(
            builder: PsiBuilder,
            level: Int,
            create_virtual_table_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = create_virtual_table_stmt.parse(builder, level)

    open fun withClause(
            builder: PsiBuilder,
            level: Int,
            with_clause: GeneratedParserUtilBase.Parser
    ): Boolean = with_clause.parse(builder, level)

    open fun cteTableName(
            builder: PsiBuilder,
            level: Int,
            cte_table_name: GeneratedParserUtilBase.Parser
    ): Boolean = cte_table_name.parse(builder, level)

    open fun deleteStmt(
            builder: PsiBuilder,
            level: Int,
            delete_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = delete_stmt.parse(builder, level)

    open fun deleteStmtLimited(
            builder: PsiBuilder,
            level: Int,
            delete_stmt_limited: GeneratedParserUtilBase.Parser
    ): Boolean = delete_stmt_limited.parse(builder, level)

    open fun detachStmt(
            builder: PsiBuilder,
            level: Int,
            detach_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = detach_stmt.parse(builder, level)

    open fun dropIndexStmt(
            builder: PsiBuilder,
            level: Int,
            drop_index_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = drop_index_stmt.parse(builder, level)

    open fun dropTableStmt(
            builder: PsiBuilder,
            level: Int,
            drop_table_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = drop_table_stmt.parse(builder, level)

    open fun dropTriggerStmt(
            builder: PsiBuilder,
            level: Int,
            drop_trigger_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = drop_trigger_stmt.parse(builder, level)

    open fun dropViewStmt(
            builder: PsiBuilder,
            level: Int,
            drop_view_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = drop_view_stmt.parse(builder, level)

    open fun literalExpr(
            builder: PsiBuilder,
            level: Int,
            literal_expr: GeneratedParserUtilBase.Parser
    ): Boolean = literal_expr.parse(builder, level)

    open fun bindExpr(
            builder: PsiBuilder,
            level: Int,
            bind_expr: GeneratedParserUtilBase.Parser
    ): Boolean = bind_expr.parse(builder, level)

    open fun columnExpr(
            builder: PsiBuilder,
            level: Int,
            column_expr: GeneratedParserUtilBase.Parser
    ): Boolean = column_expr.parse(builder, level)

    open fun unaryExpr(
            builder: PsiBuilder,
            level: Int,
            unary_expr: GeneratedParserUtilBase.Parser
    ): Boolean = unary_expr.parse(builder, level)

    open fun binaryPipeExpr(
            builder: PsiBuilder,
            level: Int,
            binary_pipe_expr: GeneratedParserUtilBase.Parser
    ): Boolean = binary_pipe_expr.parse(builder, level)

    open fun binaryMultExpr(
            builder: PsiBuilder,
            level: Int,
            binary_mult_expr: GeneratedParserUtilBase.Parser
    ): Boolean = binary_mult_expr.parse(builder, level)

    open fun binaryAddExpr(
            builder: PsiBuilder,
            level: Int,
            binary_add_expr: GeneratedParserUtilBase.Parser
    ): Boolean = binary_add_expr.parse(builder, level)

    open fun binaryBitwiseExpr(
            builder: PsiBuilder,
            level: Int,
            binary_bitwise_expr: GeneratedParserUtilBase.Parser
    ): Boolean = binary_bitwise_expr.parse(builder, level)

    open fun binaryBooleanExpr(
            builder: PsiBuilder,
            level: Int,
            binary_boolean_expr: GeneratedParserUtilBase.Parser
    ): Boolean = binary_boolean_expr.parse(builder, level)

    open fun binaryEqualityExpr(
            builder: PsiBuilder,
            level: Int,
            binary_equality_expr: GeneratedParserUtilBase.Parser
    ): Boolean = binary_equality_expr.parse(builder, level)

    open fun binaryAndExpr(
            builder: PsiBuilder,
            level: Int,
            binary_and_expr: GeneratedParserUtilBase.Parser
    ): Boolean = binary_and_expr.parse(builder, level)

    open fun binaryOrExpr(
            builder: PsiBuilder,
            level: Int,
            binary_or_expr: GeneratedParserUtilBase.Parser
    ): Boolean = binary_or_expr.parse(builder, level)

    open fun functionExpr(
            builder: PsiBuilder,
            level: Int,
            function_expr: GeneratedParserUtilBase.Parser
    ): Boolean = function_expr.parse(builder, level)

    open fun parenExpr(
            builder: PsiBuilder,
            level: Int,
            paren_expr: GeneratedParserUtilBase.Parser
    ): Boolean = paren_expr.parse(builder, level)

    open fun castExpr(
            builder: PsiBuilder,
            level: Int,
            cast_expr: GeneratedParserUtilBase.Parser
    ): Boolean = cast_expr.parse(builder, level)

    open fun collateExpr(
            builder: PsiBuilder,
            level: Int,
            collate_expr: GeneratedParserUtilBase.Parser
    ): Boolean = collate_expr.parse(builder, level)

    open fun binaryLikeExpr(
            builder: PsiBuilder,
            level: Int,
            binary_like_expr: GeneratedParserUtilBase.Parser
    ): Boolean = binary_like_expr.parse(builder, level)

    open fun nullExpr(
            builder: PsiBuilder,
            level: Int,
            null_expr: GeneratedParserUtilBase.Parser
    ): Boolean = null_expr.parse(builder, level)

    open fun isExpr(
            builder: PsiBuilder,
            level: Int,
            is_expr: GeneratedParserUtilBase.Parser
    ): Boolean = is_expr.parse(builder, level)

    open fun betweenExpr(
            builder: PsiBuilder,
            level: Int,
            between_expr: GeneratedParserUtilBase.Parser
    ): Boolean = between_expr.parse(builder, level)

    open fun inExpr(
            builder: PsiBuilder,
            level: Int,
            in_expr: GeneratedParserUtilBase.Parser
    ): Boolean = in_expr.parse(builder, level)

    open fun existsExpr(
            builder: PsiBuilder,
            level: Int,
            exists_expr: GeneratedParserUtilBase.Parser
    ): Boolean = exists_expr.parse(builder, level)

    open fun caseExpr(
            builder: PsiBuilder,
            level: Int,
            case_expr: GeneratedParserUtilBase.Parser
    ): Boolean = case_expr.parse(builder, level)

    open fun raiseExpr(
            builder: PsiBuilder,
            level: Int,
            raise_expr: GeneratedParserUtilBase.Parser
    ): Boolean = raise_expr.parse(builder, level)

    open fun raiseFunction(
            builder: PsiBuilder,
            level: Int,
            raise_function: GeneratedParserUtilBase.Parser
    ): Boolean = raise_function.parse(builder, level)

    open fun literalValue(
            builder: PsiBuilder,
            level: Int,
            literal_value: GeneratedParserUtilBase.Parser
    ): Boolean = literal_value.parse(builder, level)

    open fun numericLiteral(
            builder: PsiBuilder,
            level: Int,
            numeric_literal: GeneratedParserUtilBase.Parser
    ): Boolean = numeric_literal.parse(builder, level)

    open fun insertStmt(
            builder: PsiBuilder,
            level: Int,
            insert_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = insert_stmt.parse(builder, level)

    open fun pragmaStmt(
            builder: PsiBuilder,
            level: Int,
            pragma_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = pragma_stmt.parse(builder, level)

    open fun pragmaValue(
            builder: PsiBuilder,
            level: Int,
            pragma_value: GeneratedParserUtilBase.Parser
    ): Boolean = pragma_value.parse(builder, level)

    open fun reindexStmt(
            builder: PsiBuilder,
            level: Int,
            reindex_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = reindex_stmt.parse(builder, level)

    open fun compoundSelectStmt(
            builder: PsiBuilder,
            level: Int,
            compound_select_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = compound_select_stmt.parse(builder, level)

    open fun limitingTerm(
            builder: PsiBuilder,
            level: Int,
            limiting_term: GeneratedParserUtilBase.Parser
    ): Boolean = limiting_term.parse(builder, level)

    open fun selectStmt(
            builder: PsiBuilder,
            level: Int,
            select_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = select_stmt.parse(builder, level)

    open fun valuesExpression(
            builder: PsiBuilder,
            level: Int,
            values_expression: GeneratedParserUtilBase.Parser
    ): Boolean = values_expression.parse(builder, level)

    open fun joinClause(
            builder: PsiBuilder,
            level: Int,
            join_clause: GeneratedParserUtilBase.Parser
    ): Boolean = join_clause.parse(builder, level)

    open fun tableOrSubquery(
            builder: PsiBuilder,
            level: Int,
            table_or_subquery: GeneratedParserUtilBase.Parser
    ): Boolean = table_or_subquery.parse(builder, level)

    open fun resultColumn(
            builder: PsiBuilder,
            level: Int,
            result_column: GeneratedParserUtilBase.Parser
    ): Boolean = result_column.parse(builder, level)

    open fun joinOperator(
            builder: PsiBuilder,
            level: Int,
            join_operator: GeneratedParserUtilBase.Parser
    ): Boolean = join_operator.parse(builder, level)

    open fun joinConstraint(
            builder: PsiBuilder,
            level: Int,
            join_constraint: GeneratedParserUtilBase.Parser
    ): Boolean = join_constraint.parse(builder, level)

    open fun orderingTerm(
            builder: PsiBuilder,
            level: Int,
            ordering_term: GeneratedParserUtilBase.Parser
    ): Boolean = ordering_term.parse(builder, level)

    open fun compoundOperator(
            builder: PsiBuilder,
            level: Int,
            compound_operator: GeneratedParserUtilBase.Parser
    ): Boolean = compound_operator.parse(builder, level)

    open fun updateStmt(
            builder: PsiBuilder,
            level: Int,
            update_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = update_stmt.parse(builder, level)

    open fun updateStmtLimited(
            builder: PsiBuilder,
            level: Int,
            update_stmt_limited: GeneratedParserUtilBase.Parser
    ): Boolean = update_stmt_limited.parse(builder, level)

    open fun setterExpression(
            builder: PsiBuilder,
            level: Int,
            setter_expression: GeneratedParserUtilBase.Parser
    ): Boolean = setter_expression.parse(builder, level)

    open fun qualifiedTableName(
            builder: PsiBuilder,
            level: Int,
            qualified_table_name: GeneratedParserUtilBase.Parser
    ): Boolean = qualified_table_name.parse(builder, level)

    open fun vacuumStmt(
            builder: PsiBuilder,
            level: Int,
            vacuum_stmt: GeneratedParserUtilBase.Parser
    ): Boolean = vacuum_stmt.parse(builder, level)

    open fun tableName(
            builder: PsiBuilder,
            level: Int,
            table_name: GeneratedParserUtilBase.Parser
    ): Boolean = table_name.parse(builder, level)

    open fun databaseName(
            builder: PsiBuilder,
            level: Int,
            database_name: GeneratedParserUtilBase.Parser
    ): Boolean = database_name.parse(builder, level)

    open fun indexName(
            builder: PsiBuilder,
            level: Int,
            index_name: GeneratedParserUtilBase.Parser
    ): Boolean = index_name.parse(builder, level)

    open fun columnName(
            builder: PsiBuilder,
            level: Int,
            column_name: GeneratedParserUtilBase.Parser
    ): Boolean = column_name.parse(builder, level)

    open fun columnAlias(
            builder: PsiBuilder,
            level: Int,
            column_alias: GeneratedParserUtilBase.Parser
    ): Boolean = column_alias.parse(builder, level)

    open fun tableAlias(
            builder: PsiBuilder,
            level: Int,
            table_alias: GeneratedParserUtilBase.Parser
    ): Boolean = table_alias.parse(builder, level)

    open fun foreignTable(
            builder: PsiBuilder,
            level: Int,
            foreign_table: GeneratedParserUtilBase.Parser
    ): Boolean = foreign_table.parse(builder, level)

    open fun identifier(
            builder: PsiBuilder,
            level: Int,
            identifier: GeneratedParserUtilBase.Parser
    ): Boolean = identifier.parse(builder, level)

    open fun pragmaName(
            builder: PsiBuilder,
            level: Int,
            pragma_name: GeneratedParserUtilBase.Parser
    ): Boolean = pragma_name.parse(builder, level)

    open fun functionName(
            builder: PsiBuilder,
            level: Int,
            function_name: GeneratedParserUtilBase.Parser
    ): Boolean = function_name.parse(builder, level)

    open fun stringLiteral(
            builder: PsiBuilder,
            level: Int,
            string_literal: GeneratedParserUtilBase.Parser
    ): Boolean = string_literal.parse(builder, level)

    open fun tableOrIndexName(
            builder: PsiBuilder,
            level: Int,
            table_or_index_name: GeneratedParserUtilBase.Parser
    ): Boolean = table_or_index_name.parse(builder, level)

    open fun newTableName(
            builder: PsiBuilder,
            level: Int,
            new_table_name: GeneratedParserUtilBase.Parser
    ): Boolean = new_table_name.parse(builder, level)

    open fun savepointName(
            builder: PsiBuilder,
            level: Int,
            savepoint_name: GeneratedParserUtilBase.Parser
    ): Boolean = savepoint_name.parse(builder, level)

    open fun triggerName(
            builder: PsiBuilder,
            level: Int,
            trigger_name: GeneratedParserUtilBase.Parser
    ): Boolean = trigger_name.parse(builder, level)

    open fun blobLiteral(
            builder: PsiBuilder,
            level: Int,
            blob_literal: GeneratedParserUtilBase.Parser
    ): Boolean = blob_literal.parse(builder, level)

    open fun collationName(
            builder: PsiBuilder,
            level: Int,
            collation_name: GeneratedParserUtilBase.Parser
    ): Boolean = collation_name.parse(builder, level)

    open fun errorMessage(
            builder: PsiBuilder,
            level: Int,
            error_message: GeneratedParserUtilBase.Parser
    ): Boolean = error_message.parse(builder, level)

    open fun viewName(
            builder: PsiBuilder,
            level: Int,
            view_name: GeneratedParserUtilBase.Parser
    ): Boolean = view_name.parse(builder, level)

    open fun moduleName(
            builder: PsiBuilder,
            level: Int,
            module_name: GeneratedParserUtilBase.Parser
    ): Boolean = module_name.parse(builder, level)

    open fun bindParameter(
            builder: PsiBuilder,
            level: Int,
            bind_parameter: GeneratedParserUtilBase.Parser
    ): Boolean = bind_parameter.parse(builder, level)
}
