package com.alecstrong.sqlite.psi.core

import com.intellij.lang.PsiBuilder
import kotlin.Boolean
import kotlin.Int
import kotlin.jvm.JvmStatic

internal object SqliteParserUtil : ModuleParserUtil() {
    internal var customSqliteParser: CustomSqliteParser = CustomSqliteParser()

    @JvmStatic
    fun sqlStmtListExt(
            builder: PsiBuilder,
            level: Int,
            sql_stmt_list: Parser
    ): Boolean = customSqliteParser.sqlStmtList(builder, level, sql_stmt_list)

    @JvmStatic
    fun statementExt(
            builder: PsiBuilder,
            level: Int,
            statement: Parser
    ): Boolean = customSqliteParser.statement(builder, level, statement)

    @JvmStatic
    fun sqlStmtExt(
            builder: PsiBuilder,
            level: Int,
            sql_stmt: Parser
    ): Boolean = customSqliteParser.sqlStmt(builder, level, sql_stmt)

    @JvmStatic
    fun alterTableStmtExt(
            builder: PsiBuilder,
            level: Int,
            alter_table_stmt: Parser
    ): Boolean = customSqliteParser.alterTableStmt(builder, level, alter_table_stmt)

    @JvmStatic
    fun analyzeStmtExt(
            builder: PsiBuilder,
            level: Int,
            analyze_stmt: Parser
    ): Boolean = customSqliteParser.analyzeStmt(builder, level, analyze_stmt)

    @JvmStatic
    fun attachStmtExt(
            builder: PsiBuilder,
            level: Int,
            attach_stmt: Parser
    ): Boolean = customSqliteParser.attachStmt(builder, level, attach_stmt)

    @JvmStatic
    fun beginStmtExt(
            builder: PsiBuilder,
            level: Int,
            begin_stmt: Parser
    ): Boolean = customSqliteParser.beginStmt(builder, level, begin_stmt)

    @JvmStatic
    fun commitStmtExt(
            builder: PsiBuilder,
            level: Int,
            commit_stmt: Parser
    ): Boolean = customSqliteParser.commitStmt(builder, level, commit_stmt)

    @JvmStatic
    fun rollbackStmtExt(
            builder: PsiBuilder,
            level: Int,
            rollback_stmt: Parser
    ): Boolean = customSqliteParser.rollbackStmt(builder, level, rollback_stmt)

    @JvmStatic
    fun savepointStmtExt(
            builder: PsiBuilder,
            level: Int,
            savepoint_stmt: Parser
    ): Boolean = customSqliteParser.savepointStmt(builder, level, savepoint_stmt)

    @JvmStatic
    fun releaseStmtExt(
            builder: PsiBuilder,
            level: Int,
            release_stmt: Parser
    ): Boolean = customSqliteParser.releaseStmt(builder, level, release_stmt)

    @JvmStatic
    fun createIndexStmtExt(
            builder: PsiBuilder,
            level: Int,
            create_index_stmt: Parser
    ): Boolean = customSqliteParser.createIndexStmt(builder, level, create_index_stmt)

    @JvmStatic
    fun indexedColumnExt(
            builder: PsiBuilder,
            level: Int,
            indexed_column: Parser
    ): Boolean = customSqliteParser.indexedColumn(builder, level, indexed_column)

    @JvmStatic
    fun createTableStmtExt(
            builder: PsiBuilder,
            level: Int,
            create_table_stmt: Parser
    ): Boolean = customSqliteParser.createTableStmt(builder, level, create_table_stmt)

    @JvmStatic
    fun columnDefExt(
            builder: PsiBuilder,
            level: Int,
            column_def: Parser
    ): Boolean = customSqliteParser.columnDef(builder, level, column_def)

    @JvmStatic
    fun typeNameExt(
            builder: PsiBuilder,
            level: Int,
            type_name: Parser
    ): Boolean = customSqliteParser.typeName(builder, level, type_name)

    @JvmStatic
    fun columnConstraintExt(
            builder: PsiBuilder,
            level: Int,
            column_constraint: Parser
    ): Boolean = customSqliteParser.columnConstraint(builder, level, column_constraint)

    @JvmStatic
    fun signedNumberExt(
            builder: PsiBuilder,
            level: Int,
            signed_number: Parser
    ): Boolean = customSqliteParser.signedNumber(builder, level, signed_number)

    @JvmStatic
    fun tableConstraintExt(
            builder: PsiBuilder,
            level: Int,
            table_constraint: Parser
    ): Boolean = customSqliteParser.tableConstraint(builder, level, table_constraint)

    @JvmStatic
    fun foreignKeyClauseExt(
            builder: PsiBuilder,
            level: Int,
            foreign_key_clause: Parser
    ): Boolean = customSqliteParser.foreignKeyClause(builder, level, foreign_key_clause)

    @JvmStatic
    fun conflictClauseExt(
            builder: PsiBuilder,
            level: Int,
            conflict_clause: Parser
    ): Boolean = customSqliteParser.conflictClause(builder, level, conflict_clause)

    @JvmStatic
    fun createTriggerStmtExt(
            builder: PsiBuilder,
            level: Int,
            create_trigger_stmt: Parser
    ): Boolean = customSqliteParser.createTriggerStmt(builder, level, create_trigger_stmt)

    @JvmStatic
    fun createViewStmtExt(
            builder: PsiBuilder,
            level: Int,
            create_view_stmt: Parser
    ): Boolean = customSqliteParser.createViewStmt(builder, level, create_view_stmt)

    @JvmStatic
    fun createVirtualTableStmtExt(
            builder: PsiBuilder,
            level: Int,
            create_virtual_table_stmt: Parser
    ): Boolean = customSqliteParser.createVirtualTableStmt(builder, level, create_virtual_table_stmt)

    @JvmStatic
    fun withClauseExt(
            builder: PsiBuilder,
            level: Int,
            with_clause: Parser
    ): Boolean = customSqliteParser.withClause(builder, level, with_clause)

    @JvmStatic
    fun cteTableNameExt(
            builder: PsiBuilder,
            level: Int,
            cte_table_name: Parser
    ): Boolean = customSqliteParser.cteTableName(builder, level, cte_table_name)

    @JvmStatic
    fun deleteStmtExt(
            builder: PsiBuilder,
            level: Int,
            delete_stmt: Parser
    ): Boolean = customSqliteParser.deleteStmt(builder, level, delete_stmt)

    @JvmStatic
    fun deleteStmtLimitedExt(
            builder: PsiBuilder,
            level: Int,
            delete_stmt_limited: Parser
    ): Boolean = customSqliteParser.deleteStmtLimited(builder, level, delete_stmt_limited)

    @JvmStatic
    fun detachStmtExt(
            builder: PsiBuilder,
            level: Int,
            detach_stmt: Parser
    ): Boolean = customSqliteParser.detachStmt(builder, level, detach_stmt)

    @JvmStatic
    fun dropIndexStmtExt(
            builder: PsiBuilder,
            level: Int,
            drop_index_stmt: Parser
    ): Boolean = customSqliteParser.dropIndexStmt(builder, level, drop_index_stmt)

    @JvmStatic
    fun dropTableStmtExt(
            builder: PsiBuilder,
            level: Int,
            drop_table_stmt: Parser
    ): Boolean = customSqliteParser.dropTableStmt(builder, level, drop_table_stmt)

    @JvmStatic
    fun dropTriggerStmtExt(
            builder: PsiBuilder,
            level: Int,
            drop_trigger_stmt: Parser
    ): Boolean = customSqliteParser.dropTriggerStmt(builder, level, drop_trigger_stmt)

    @JvmStatic
    fun dropViewStmtExt(
            builder: PsiBuilder,
            level: Int,
            drop_view_stmt: Parser
    ): Boolean = customSqliteParser.dropViewStmt(builder, level, drop_view_stmt)

    @JvmStatic
    fun literalExprExt(
            builder: PsiBuilder,
            level: Int,
            literal_expr: Parser
    ): Boolean = customSqliteParser.literalExpr(builder, level, literal_expr)

    @JvmStatic
    fun bindExprExt(
            builder: PsiBuilder,
            level: Int,
            bind_expr: Parser
    ): Boolean = customSqliteParser.bindExpr(builder, level, bind_expr)

    @JvmStatic
    fun columnExprExt(
            builder: PsiBuilder,
            level: Int,
            column_expr: Parser
    ): Boolean = customSqliteParser.columnExpr(builder, level, column_expr)

    @JvmStatic
    fun unaryExprExt(
            builder: PsiBuilder,
            level: Int,
            unary_expr: Parser
    ): Boolean = customSqliteParser.unaryExpr(builder, level, unary_expr)

    @JvmStatic
    fun binaryPipeExprExt(
            builder: PsiBuilder,
            level: Int,
            binary_pipe_expr: Parser
    ): Boolean = customSqliteParser.binaryPipeExpr(builder, level, binary_pipe_expr)

    @JvmStatic
    fun binaryMultExprExt(
            builder: PsiBuilder,
            level: Int,
            binary_mult_expr: Parser
    ): Boolean = customSqliteParser.binaryMultExpr(builder, level, binary_mult_expr)

    @JvmStatic
    fun binaryAddExprExt(
            builder: PsiBuilder,
            level: Int,
            binary_add_expr: Parser
    ): Boolean = customSqliteParser.binaryAddExpr(builder, level, binary_add_expr)

    @JvmStatic
    fun binaryBitwiseExprExt(
            builder: PsiBuilder,
            level: Int,
            binary_bitwise_expr: Parser
    ): Boolean = customSqliteParser.binaryBitwiseExpr(builder, level, binary_bitwise_expr)

    @JvmStatic
    fun binaryBooleanExprExt(
            builder: PsiBuilder,
            level: Int,
            binary_boolean_expr: Parser
    ): Boolean = customSqliteParser.binaryBooleanExpr(builder, level, binary_boolean_expr)

    @JvmStatic
    fun binaryEqualityExprExt(
            builder: PsiBuilder,
            level: Int,
            binary_equality_expr: Parser
    ): Boolean = customSqliteParser.binaryEqualityExpr(builder, level, binary_equality_expr)

    @JvmStatic
    fun binaryAndExprExt(
            builder: PsiBuilder,
            level: Int,
            binary_and_expr: Parser
    ): Boolean = customSqliteParser.binaryAndExpr(builder, level, binary_and_expr)

    @JvmStatic
    fun binaryOrExprExt(
            builder: PsiBuilder,
            level: Int,
            binary_or_expr: Parser
    ): Boolean = customSqliteParser.binaryOrExpr(builder, level, binary_or_expr)

    @JvmStatic
    fun functionExprExt(
            builder: PsiBuilder,
            level: Int,
            function_expr: Parser
    ): Boolean = customSqliteParser.functionExpr(builder, level, function_expr)

    @JvmStatic
    fun parenExprExt(
            builder: PsiBuilder,
            level: Int,
            paren_expr: Parser
    ): Boolean = customSqliteParser.parenExpr(builder, level, paren_expr)

    @JvmStatic
    fun castExprExt(
            builder: PsiBuilder,
            level: Int,
            cast_expr: Parser
    ): Boolean = customSqliteParser.castExpr(builder, level, cast_expr)

    @JvmStatic
    fun collateExprExt(
            builder: PsiBuilder,
            level: Int,
            collate_expr: Parser
    ): Boolean = customSqliteParser.collateExpr(builder, level, collate_expr)

    @JvmStatic
    fun binaryLikeExprExt(
            builder: PsiBuilder,
            level: Int,
            binary_like_expr: Parser
    ): Boolean = customSqliteParser.binaryLikeExpr(builder, level, binary_like_expr)

    @JvmStatic
    fun nullExprExt(
            builder: PsiBuilder,
            level: Int,
            null_expr: Parser
    ): Boolean = customSqliteParser.nullExpr(builder, level, null_expr)

    @JvmStatic
    fun isExprExt(
            builder: PsiBuilder,
            level: Int,
            is_expr: Parser
    ): Boolean = customSqliteParser.isExpr(builder, level, is_expr)

    @JvmStatic
    fun betweenExprExt(
            builder: PsiBuilder,
            level: Int,
            between_expr: Parser
    ): Boolean = customSqliteParser.betweenExpr(builder, level, between_expr)

    @JvmStatic
    fun inExprExt(
            builder: PsiBuilder,
            level: Int,
            in_expr: Parser
    ): Boolean = customSqliteParser.inExpr(builder, level, in_expr)

    @JvmStatic
    fun existsExprExt(
            builder: PsiBuilder,
            level: Int,
            exists_expr: Parser
    ): Boolean = customSqliteParser.existsExpr(builder, level, exists_expr)

    @JvmStatic
    fun caseExprExt(
            builder: PsiBuilder,
            level: Int,
            case_expr: Parser
    ): Boolean = customSqliteParser.caseExpr(builder, level, case_expr)

    @JvmStatic
    fun raiseExprExt(
            builder: PsiBuilder,
            level: Int,
            raise_expr: Parser
    ): Boolean = customSqliteParser.raiseExpr(builder, level, raise_expr)

    @JvmStatic
    fun raiseFunctionExt(
            builder: PsiBuilder,
            level: Int,
            raise_function: Parser
    ): Boolean = customSqliteParser.raiseFunction(builder, level, raise_function)

    @JvmStatic
    fun literalValueExt(
            builder: PsiBuilder,
            level: Int,
            literal_value: Parser
    ): Boolean = customSqliteParser.literalValue(builder, level, literal_value)

    @JvmStatic
    fun numericLiteralExt(
            builder: PsiBuilder,
            level: Int,
            numeric_literal: Parser
    ): Boolean = customSqliteParser.numericLiteral(builder, level, numeric_literal)

    @JvmStatic
    fun insertStmtExt(
            builder: PsiBuilder,
            level: Int,
            insert_stmt: Parser
    ): Boolean = customSqliteParser.insertStmt(builder, level, insert_stmt)

    @JvmStatic
    fun pragmaStmtExt(
            builder: PsiBuilder,
            level: Int,
            pragma_stmt: Parser
    ): Boolean = customSqliteParser.pragmaStmt(builder, level, pragma_stmt)

    @JvmStatic
    fun pragmaValueExt(
            builder: PsiBuilder,
            level: Int,
            pragma_value: Parser
    ): Boolean = customSqliteParser.pragmaValue(builder, level, pragma_value)

    @JvmStatic
    fun reindexStmtExt(
            builder: PsiBuilder,
            level: Int,
            reindex_stmt: Parser
    ): Boolean = customSqliteParser.reindexStmt(builder, level, reindex_stmt)

    @JvmStatic
    fun compoundSelectStmtExt(
            builder: PsiBuilder,
            level: Int,
            compound_select_stmt: Parser
    ): Boolean = customSqliteParser.compoundSelectStmt(builder, level, compound_select_stmt)

    @JvmStatic
    fun limitingTermExt(
            builder: PsiBuilder,
            level: Int,
            limiting_term: Parser
    ): Boolean = customSqliteParser.limitingTerm(builder, level, limiting_term)

    @JvmStatic
    fun selectStmtExt(
            builder: PsiBuilder,
            level: Int,
            select_stmt: Parser
    ): Boolean = customSqliteParser.selectStmt(builder, level, select_stmt)

    @JvmStatic
    fun valuesExpressionExt(
            builder: PsiBuilder,
            level: Int,
            values_expression: Parser
    ): Boolean = customSqliteParser.valuesExpression(builder, level, values_expression)

    @JvmStatic
    fun joinClauseExt(
            builder: PsiBuilder,
            level: Int,
            join_clause: Parser
    ): Boolean = customSqliteParser.joinClause(builder, level, join_clause)

    @JvmStatic
    fun tableOrSubqueryExt(
            builder: PsiBuilder,
            level: Int,
            table_or_subquery: Parser
    ): Boolean = customSqliteParser.tableOrSubquery(builder, level, table_or_subquery)

    @JvmStatic
    fun resultColumnExt(
            builder: PsiBuilder,
            level: Int,
            result_column: Parser
    ): Boolean = customSqliteParser.resultColumn(builder, level, result_column)

    @JvmStatic
    fun joinOperatorExt(
            builder: PsiBuilder,
            level: Int,
            join_operator: Parser
    ): Boolean = customSqliteParser.joinOperator(builder, level, join_operator)

    @JvmStatic
    fun joinConstraintExt(
            builder: PsiBuilder,
            level: Int,
            join_constraint: Parser
    ): Boolean = customSqliteParser.joinConstraint(builder, level, join_constraint)

    @JvmStatic
    fun orderingTermExt(
            builder: PsiBuilder,
            level: Int,
            ordering_term: Parser
    ): Boolean = customSqliteParser.orderingTerm(builder, level, ordering_term)

    @JvmStatic
    fun compoundOperatorExt(
            builder: PsiBuilder,
            level: Int,
            compound_operator: Parser
    ): Boolean = customSqliteParser.compoundOperator(builder, level, compound_operator)

    @JvmStatic
    fun updateStmtExt(
            builder: PsiBuilder,
            level: Int,
            update_stmt: Parser
    ): Boolean = customSqliteParser.updateStmt(builder, level, update_stmt)

    @JvmStatic
    fun updateStmtLimitedExt(
            builder: PsiBuilder,
            level: Int,
            update_stmt_limited: Parser
    ): Boolean = customSqliteParser.updateStmtLimited(builder, level, update_stmt_limited)

    @JvmStatic
    fun setterExpressionExt(
            builder: PsiBuilder,
            level: Int,
            setter_expression: Parser
    ): Boolean = customSqliteParser.setterExpression(builder, level, setter_expression)

    @JvmStatic
    fun qualifiedTableNameExt(
            builder: PsiBuilder,
            level: Int,
            qualified_table_name: Parser
    ): Boolean = customSqliteParser.qualifiedTableName(builder, level, qualified_table_name)

    @JvmStatic
    fun vacuumStmtExt(
            builder: PsiBuilder,
            level: Int,
            vacuum_stmt: Parser
    ): Boolean = customSqliteParser.vacuumStmt(builder, level, vacuum_stmt)

    @JvmStatic
    fun tableNameExt(
            builder: PsiBuilder,
            level: Int,
            table_name: Parser
    ): Boolean = customSqliteParser.tableName(builder, level, table_name)

    @JvmStatic
    fun databaseNameExt(
            builder: PsiBuilder,
            level: Int,
            database_name: Parser
    ): Boolean = customSqliteParser.databaseName(builder, level, database_name)

    @JvmStatic
    fun indexNameExt(
            builder: PsiBuilder,
            level: Int,
            index_name: Parser
    ): Boolean = customSqliteParser.indexName(builder, level, index_name)

    @JvmStatic
    fun columnNameExt(
            builder: PsiBuilder,
            level: Int,
            column_name: Parser
    ): Boolean = customSqliteParser.columnName(builder, level, column_name)

    @JvmStatic
    fun columnAliasExt(
            builder: PsiBuilder,
            level: Int,
            column_alias: Parser
    ): Boolean = customSqliteParser.columnAlias(builder, level, column_alias)

    @JvmStatic
    fun tableAliasExt(
            builder: PsiBuilder,
            level: Int,
            table_alias: Parser
    ): Boolean = customSqliteParser.tableAlias(builder, level, table_alias)

    @JvmStatic
    fun foreignTableExt(
            builder: PsiBuilder,
            level: Int,
            foreign_table: Parser
    ): Boolean = customSqliteParser.foreignTable(builder, level, foreign_table)

    @JvmStatic
    fun identifierExt(
            builder: PsiBuilder,
            level: Int,
            identifier: Parser
    ): Boolean = customSqliteParser.identifier(builder, level, identifier)

    @JvmStatic
    fun pragmaNameExt(
            builder: PsiBuilder,
            level: Int,
            pragma_name: Parser
    ): Boolean = customSqliteParser.pragmaName(builder, level, pragma_name)

    @JvmStatic
    fun functionNameExt(
            builder: PsiBuilder,
            level: Int,
            function_name: Parser
    ): Boolean = customSqliteParser.functionName(builder, level, function_name)

    @JvmStatic
    fun stringLiteralExt(
            builder: PsiBuilder,
            level: Int,
            string_literal: Parser
    ): Boolean = customSqliteParser.stringLiteral(builder, level, string_literal)

    @JvmStatic
    fun tableOrIndexNameExt(
            builder: PsiBuilder,
            level: Int,
            table_or_index_name: Parser
    ): Boolean = customSqliteParser.tableOrIndexName(builder, level, table_or_index_name)

    @JvmStatic
    fun newTableNameExt(
            builder: PsiBuilder,
            level: Int,
            new_table_name: Parser
    ): Boolean = customSqliteParser.newTableName(builder, level, new_table_name)

    @JvmStatic
    fun savepointNameExt(
            builder: PsiBuilder,
            level: Int,
            savepoint_name: Parser
    ): Boolean = customSqliteParser.savepointName(builder, level, savepoint_name)

    @JvmStatic
    fun triggerNameExt(
            builder: PsiBuilder,
            level: Int,
            trigger_name: Parser
    ): Boolean = customSqliteParser.triggerName(builder, level, trigger_name)

    @JvmStatic
    fun blobLiteralExt(
            builder: PsiBuilder,
            level: Int,
            blob_literal: Parser
    ): Boolean = customSqliteParser.blobLiteral(builder, level, blob_literal)

    @JvmStatic
    fun collationNameExt(
            builder: PsiBuilder,
            level: Int,
            collation_name: Parser
    ): Boolean = customSqliteParser.collationName(builder, level, collation_name)

    @JvmStatic
    fun errorMessageExt(
            builder: PsiBuilder,
            level: Int,
            error_message: Parser
    ): Boolean = customSqliteParser.errorMessage(builder, level, error_message)

    @JvmStatic
    fun viewNameExt(
            builder: PsiBuilder,
            level: Int,
            view_name: Parser
    ): Boolean = customSqliteParser.viewName(builder, level, view_name)

    @JvmStatic
    fun moduleNameExt(
            builder: PsiBuilder,
            level: Int,
            module_name: Parser
    ): Boolean = customSqliteParser.moduleName(builder, level, module_name)

    @JvmStatic
    fun bindParameterExt(
            builder: PsiBuilder,
            level: Int,
            bind_parameter: Parser
    ): Boolean = customSqliteParser.bindParameter(builder, level, bind_parameter)
}
