/*
 * Decompiled with CFR 0.152.
 */
package com.alecstrong.sqlite.psi.core;

import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/alecstrong/sqlite/psi/core/CoreFileIndex;", "Lcom/intellij/openapi/roots/impl/ProjectFileIndexImpl;", "sourceFolders", "", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "directoryIndex", "Lcom/intellij/openapi/roots/impl/DirectoryIndex;", "fileTypeRegistry", "Lcom/intellij/openapi/fileTypes/FileTypeRegistry;", "(Ljava/util/List;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/impl/DirectoryIndex;Lcom/intellij/openapi/fileTypes/FileTypeRegistry;)V", "getSourceFolders", "()Ljava/util/List;", "iterateContent", "", "iterator", "Lcom/intellij/openapi/roots/ContentIterator;", "iterateContentUnderDirectory", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "core"})
final class CoreFileIndex
extends ProjectFileIndexImpl {
    @NotNull
    private final List<File> sourceFolders;

    public boolean iterateContent(@NotNull ContentIterator iterator) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
            Iterable $receiver$iv = this.sourceFolders;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    File it = (File)element$iv;
                    VirtualFile file = localFileSystem.findFileByPath(it.getAbsolutePath());
                    if (file == null) {
                        throw (Throwable)new NullPointerException("File " + it.getAbsolutePath() + " not found");
                    }
                    if (this.iterateContentUnderDirectory(file, iterator)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile file, @NotNull ContentIterator iterator) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
        if (file.isDirectory()) {
            VirtualFile[] virtualFileArray = file.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"file.children");
            for (Object element$iv : (Object[])virtualFileArray) {
                VirtualFile it;
                VirtualFile virtualFile = it = (VirtualFile)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                if (this.iterateContentUnderDirectory(virtualFile, iterator)) continue;
                return false;
            }
            return true;
        }
        return iterator.processFile(file);
    }

    @NotNull
    public final List<File> getSourceFolders() {
        return this.sourceFolders;
    }

    public CoreFileIndex(@NotNull List<? extends File> sourceFolders, @NotNull Project project, @NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeRegistry) {
        Intrinsics.checkParameterIsNotNull(sourceFolders, (String)"sourceFolders");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)directoryIndex, (String)"directoryIndex");
        Intrinsics.checkParameterIsNotNull((Object)fileTypeRegistry, (String)"fileTypeRegistry");
        super(project, directoryIndex, fileTypeRegistry);
        this.sourceFolders = sourceFolders;
    }
}

