/*
 * Decompiled with CFR 0.152.
 */
package com.alexstyl.contactstore;

import android.content.ContentUris;
import android.net.Uri;
import android.provider.ContactsContract;
import com.alexstyl.contactstore.Contact;
import com.alexstyl.contactstore.ContactColumn;
import com.alexstyl.contactstore.EventDate;
import com.alexstyl.contactstore.GroupMembership;
import com.alexstyl.contactstore.ImAddress;
import com.alexstyl.contactstore.ImageData;
import com.alexstyl.contactstore.LabeledValue;
import com.alexstyl.contactstore.LookupKey;
import com.alexstyl.contactstore.MailAddress;
import com.alexstyl.contactstore.MutableContact;
import com.alexstyl.contactstore.Note;
import com.alexstyl.contactstore.PhoneNumber;
import com.alexstyl.contactstore.PostalAddress;
import com.alexstyl.contactstore.Relation;
import com.alexstyl.contactstore.SipAddress;
import com.alexstyl.contactstore.WebAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u001a#\u0010\t\u001a\u00020\n*\u00020\u00022\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\b\u000e\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"thumbnailUri", "Landroid/net/Uri;", "Lcom/alexstyl/contactstore/Contact;", "getThumbnailUri", "(Lcom/alexstyl/contactstore/Contact;)Landroid/net/Uri;", "containsColumn", "", "column", "Lcom/alexstyl/contactstore/ContactColumn;", "mutableCopy", "Lcom/alexstyl/contactstore/MutableContact;", "builder", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "library_release"})
public final class ContactKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean containsColumn(Contact iterator, ContactColumn contactColumn) {
        Intrinsics.checkNotNullParameter(iterator, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contactColumn, (String)"column");
        iterator = iterator.getColumns();
        if (iterator instanceof Collection && iterator.isEmpty()) {
            return false;
        }
        iterator = iterator.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!Intrinsics.areEqual((Object)((ContactColumn)iterator.next()), (Object)contactColumn));
        return true;
    }

    public static final MutableContact mutableCopy(Contact contact, Function1<? super MutableContact, Unit> function1) {
        Intrinsics.checkNotNullParameter((Object)contact, (String)"<this>");
        Intrinsics.checkNotNullParameter(function1, (String)"builder");
        MutableContact mutableContact = ContactKt.mutableCopy(contact);
        function1.invoke((Object)mutableContact);
        return mutableContact;
    }

    public static final MutableContact mutableCopy(Contact list) {
        ArrayList<GroupMembership> arrayList;
        ArrayList<LabeledValue<Relation>> arrayList2;
        ArrayList<LabeledValue<ImAddress>> arrayList3;
        ArrayList<LabeledValue<SipAddress>> arrayList4;
        ArrayList<LabeledValue<WebAddress>> arrayList5;
        ArrayList<LabeledValue<PostalAddress>> arrayList6;
        ArrayList<LabeledValue<EventDate>> arrayList7;
        ArrayList<LabeledValue<MailAddress>> arrayList8;
        ArrayList<LabeledValue<PhoneNumber>> arrayList9;
        Contact contact = list;
        Intrinsics.checkNotNullParameter((Object)contact, (String)"<this>");
        long l2 = contact.getContactId();
        LookupKey lookupKey = contact.getLookupKey();
        ContactColumn.Names names = ContactColumn.Names.INSTANCE;
        String string2 = ContactKt.containsColumn(contact, names) ? list.getFirstName() : "";
        Object object = ContactColumn.Organization.INSTANCE;
        String string3 = ContactKt.containsColumn((Contact)((Object)list), (ContactColumn)object) ? list.getOrganization() : "";
        object = ContactKt.containsColumn((Contact)((Object)list), (ContactColumn)object) ? list.getJobTitle() : "";
        String string4 = ContactKt.containsColumn((Contact)((Object)list), names) ? list.getLastName() : "";
        Contact contact2 = list;
        boolean bl = contact2.isStarred();
        ImageData imageData = ContactKt.containsColumn(contact2, ContactColumn.Image.INSTANCE) ? list.getImageData() : null;
        if (ContactKt.containsColumn((Contact)((Object)list), ContactColumn.Phones.INSTANCE)) {
            arrayList9 = CollectionsKt.toMutableList(list.getPhones());
        } else {
            ArrayList arrayList10;
            arrayList9 = arrayList10;
            arrayList10 = new ArrayList();
        }
        if (ContactKt.containsColumn((Contact)((Object)list), ContactColumn.Mails.INSTANCE)) {
            arrayList8 = CollectionsKt.toMutableList(list.getMails());
        } else {
            ArrayList arrayList11;
            arrayList8 = arrayList11;
            arrayList11 = new ArrayList();
        }
        if (ContactKt.containsColumn((Contact)((Object)list), ContactColumn.Events.INSTANCE)) {
            arrayList7 = CollectionsKt.toMutableList(list.getEvents());
        } else {
            ArrayList arrayList12;
            arrayList7 = arrayList12;
            arrayList12 = new ArrayList();
        }
        if (ContactKt.containsColumn((Contact)((Object)list), ContactColumn.PostalAddresses.INSTANCE)) {
            arrayList6 = CollectionsKt.toMutableList(list.getPostalAddresses());
        } else {
            ArrayList arrayList13;
            arrayList6 = arrayList13;
            arrayList13 = new ArrayList();
        }
        if (ContactKt.containsColumn((Contact)((Object)list), ContactColumn.WebAddresses.INSTANCE)) {
            arrayList5 = CollectionsKt.toMutableList(list.getWebAddresses());
        } else {
            ArrayList arrayList14;
            arrayList5 = arrayList14;
            arrayList14 = new ArrayList();
        }
        if (ContactKt.containsColumn((Contact)((Object)list), ContactColumn.SipAddresses.INSTANCE)) {
            arrayList4 = CollectionsKt.toMutableList(list.getSipAddresses());
        } else {
            ArrayList arrayList15;
            arrayList4 = arrayList15;
            arrayList15 = new ArrayList();
        }
        if (ContactKt.containsColumn((Contact)((Object)list), ContactColumn.ImAddresses.INSTANCE)) {
            arrayList3 = CollectionsKt.toMutableList(list.getImAddresses());
        } else {
            ArrayList arrayList16;
            arrayList3 = arrayList16;
            arrayList16 = new ArrayList();
        }
        if (ContactKt.containsColumn((Contact)((Object)list), ContactColumn.Relations.INSTANCE)) {
            arrayList2 = CollectionsKt.toMutableList(list.getRelations());
        } else {
            ArrayList arrayList17;
            arrayList2 = arrayList17;
            arrayList17 = new ArrayList();
        }
        Note note = ContactKt.containsColumn((Contact)((Object)list), ContactColumn.Note.INSTANCE) ? list.getNote() : null;
        List<ContactColumn> list2 = list.getColumns();
        String string5 = ContactKt.containsColumn((Contact)((Object)list), names) ? list.getMiddleName() : "";
        String string6 = ContactKt.containsColumn((Contact)((Object)list), names) ? list.getPrefix() : "";
        String string7 = ContactKt.containsColumn((Contact)((Object)list), names) ? list.getSuffix() : "";
        int n2 = ContactKt.containsColumn((Contact)((Object)list), names) ? list.getPhoneticNameStyle() : 0;
        String string8 = ContactKt.containsColumn((Contact)((Object)list), names) ? list.getPhoneticFirstName() : "";
        String string9 = ContactKt.containsColumn((Contact)((Object)list), names) ? list.getPhoneticLastName() : "";
        String string10 = ContactKt.containsColumn((Contact)((Object)list), names) ? list.getPhoneticMiddleName() : "";
        if (ContactKt.containsColumn((Contact)((Object)list), ContactColumn.GroupMemberships.INSTANCE)) {
            arrayList = CollectionsKt.toMutableList(list.getGroups());
        } else {
            ArrayList arrayList18;
            arrayList = arrayList18;
            arrayList18 = new ArrayList();
        }
        int n3 = ContactKt.containsColumn((Contact)((Object)list), names) ? list.getFullNameStyle() : 0;
        String string11 = ContactKt.containsColumn((Contact)((Object)list), ContactColumn.Nickname.INSTANCE) ? list.getNickname() : "";
        list = ContactKt.containsColumn((Contact)((Object)list), ContactColumn.CustomDataItems.INSTANCE) ? list.getCustomDataItems() : CollectionsKt.emptyList();
        return new MutableContact(l2, lookupKey, imageData, arrayList9, arrayList8, arrayList7, arrayList6, arrayList5, note, bl, string2, string4, string5, string6, string7, string8, string10, string9, n3, n2, string11, string3, (String)object, arrayList, list, arrayList3, arrayList4, arrayList2, list2);
    }

    public static final Uri getThumbnailUri(Contact contact) {
        Intrinsics.checkNotNullParameter((Object)contact, (String)"<this>");
        Uri uri = ContentUris.withAppendedId((Uri)ContactsContract.Contacts.CONTENT_URI, (long)contact.getContactId());
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"withAppendedId(Contacts.CONTENT_URI, contactId)");
        Uri uri2 = Uri.withAppendedPath((Uri)uri, (String)"photo");
        Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"withAppendedPath(contact\u2026 Photo.CONTENT_DIRECTORY)");
        return uri2;
    }
}

