/*
 * Copyright (C) 2015 Matthew Lee
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.github.mthli.knife.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcel;
import android.text.Layout;
import android.text.style.QuoteSpan;

public class KnifeQuoteSpan extends QuoteSpan {

    private int quoteColor;
    private int quoteStripeWidth;
    private int quoteGap;

    public KnifeQuoteSpan(int quoteColor, int quoteStripeWidth, int quoteGap) {
        this.quoteColor = quoteColor;
        this.quoteStripeWidth = quoteStripeWidth;
        this.quoteGap = quoteGap;
    }

    @SuppressWarnings("unused") // Parcelable implementation
    public KnifeQuoteSpan(Parcel src) {
        super(src);
        this.quoteColor = src.readInt();
        this.quoteStripeWidth = src.readInt();
        this.quoteGap = src.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(quoteColor);
        dest.writeInt(quoteStripeWidth);
        dest.writeInt(quoteGap);
    }

    @Override
    public int getLeadingMargin(boolean first) {
        return quoteStripeWidth + quoteGap;
    }

    @Override
    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir,
            int top, int baseline, int bottom,
            CharSequence text, int start, int end,
            boolean first, Layout layout) {
        Paint.Style style = p.getStyle();
        int color = p.getColor();

        p.setStyle(Paint.Style.FILL);
        p.setColor(quoteColor);
        c.drawRect(x, top, x + dir * quoteStripeWidth, bottom, p);

        p.setStyle(style);
        p.setColor(color);
    }

}
