/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.ConfigBase;
import com.algolia.search.StatefulHost;
import com.algolia.search.javax.annotation.Nonnull;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.common.CompressionType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public final class AnalyticsConfig
extends ConfigBase {
    private AnalyticsConfig(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends ConfigBase.Builder<Builder> {
        public Builder(@Nonnull String applicationID, @Nonnull String apiKey) {
            super(applicationID, apiKey, Builder.createDefaultHosts("us"), CompressionType.NONE);
        }

        public Builder(@Nonnull String applicationID, @Nonnull String apiKey, @Nonnull String region) {
            super(applicationID, apiKey, Builder.createDefaultHosts(region), CompressionType.NONE);
        }

        @Override
        public Builder getThis() {
            return this;
        }

        public AnalyticsConfig build() {
            return new AnalyticsConfig(this);
        }

        private static List<StatefulHost> createDefaultHosts(@Nonnull String region) {
            return Collections.singletonList(new StatefulHost(String.format("analytics.%s.algolia.com", region), EnumSet.of(CallType.READ, CallType.WRITE)));
        }
    }
}

