/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SearchClientBase;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.javax.annotation.Nonnull;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.apikeys.AddApiKeyResponse;
import com.algolia.search.models.apikeys.ApiKey;
import com.algolia.search.models.apikeys.ApiKeys;
import com.algolia.search.models.apikeys.DeleteApiKeyResponse;
import com.algolia.search.models.apikeys.RestoreApiKeyResponse;
import com.algolia.search.models.apikeys.SecuredApiKeyRestriction;
import com.algolia.search.models.apikeys.UpdateApiKeyResponse;
import com.algolia.search.models.common.CallType;
import com.algolia.search.util.AlgoliaUtils;
import com.algolia.search.util.HmacShaUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface SearchClientAPIKeys
extends SearchClientBase {
    default public List<ApiKey> listApiKeys() {
        return this.listApiKeys(null);
    }

    default public List<ApiKey> listApiKeys(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.listApiKeysAsync(requestOptions));
    }

    default public CompletableFuture<List<ApiKey>> listApiKeysAsync() {
        return this.listApiKeysAsync(null);
    }

    default public CompletableFuture<List<ApiKey>> listApiKeysAsync(RequestOptions requestOptions) {
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/keys", CallType.READ, null, ApiKeys.class, requestOptions).thenApplyAsync(ApiKeys::getKeys, (Executor)this.getConfig().getExecutor());
    }

    default public ApiKey getApiKey(@Nonnull String apiKey) {
        return LaunderThrowable.await(this.getApiKeyAsync(apiKey, null));
    }

    default public ApiKey getApiKey(@Nonnull String apiKey, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getApiKeyAsync(apiKey, requestOptions));
    }

    default public CompletableFuture<ApiKey> getApiKeyAsync(@Nonnull String apiKey) {
        return this.getApiKeyAsync(apiKey, null);
    }

    default public CompletableFuture<ApiKey> getApiKeyAsync(@Nonnull String apiKey, RequestOptions requestOptions) {
        Objects.requireNonNull(apiKey, "An API key is required.");
        if (AlgoliaUtils.isNullOrEmptyWhiteSpace(apiKey).booleanValue()) {
            throw new AlgoliaRuntimeException("objectID must not be empty.");
        }
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/keys/" + apiKey, CallType.READ, null, ApiKey.class, requestOptions);
    }

    default public AddApiKeyResponse addApiKey(@Nonnull ApiKey acl) {
        return LaunderThrowable.await(this.addApiKeyAsync(acl));
    }

    default public AddApiKeyResponse addApiKey(@Nonnull ApiKey acl, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.addApiKeyAsync(acl, requestOptions));
    }

    default public CompletableFuture<AddApiKeyResponse> addApiKeyAsync(@Nonnull ApiKey acl) {
        return this.addApiKeyAsync(acl, null);
    }

    default public CompletableFuture<AddApiKeyResponse> addApiKeyAsync(@Nonnull ApiKey acl, RequestOptions requestOptions) {
        Objects.requireNonNull(acl, "An API key is required.");
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/keys", CallType.WRITE, acl, AddApiKeyResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setGetApiKeyFunction(this::getApiKey);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public DeleteApiKeyResponse deleteApiKey(@Nonnull String apiKey) {
        return LaunderThrowable.await(this.deleteApiKeyAsync(apiKey));
    }

    default public DeleteApiKeyResponse deleteApiKey(@Nonnull String apiKey, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.deleteApiKeyAsync(apiKey, requestOptions));
    }

    default public CompletableFuture<DeleteApiKeyResponse> deleteApiKeyAsync(@Nonnull String apiKey) {
        return this.deleteApiKeyAsync(apiKey, null);
    }

    default public CompletableFuture<DeleteApiKeyResponse> deleteApiKeyAsync(@Nonnull String apiKey, RequestOptions requestOptions) {
        Objects.requireNonNull(apiKey, "An API key is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(apiKey).booleanValue()) {
            throw new AlgoliaRuntimeException("API key must not be empty.");
        }
        return this.getTransport().executeRequestAsync(HttpMethod.DELETE, "/1/keys/" + apiKey, CallType.WRITE, DeleteApiKeyResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setKey(apiKey);
            resp.setGetApiKeyFunction(this::getApiKey);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public UpdateApiKeyResponse updateApiKey(@Nonnull ApiKey request) {
        return LaunderThrowable.await(this.updateApiKeyAsync(request, null));
    }

    default public UpdateApiKeyResponse updateApiKey(@Nonnull ApiKey request, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.updateApiKeyAsync(request, requestOptions));
    }

    default public CompletableFuture<UpdateApiKeyResponse> updateApiKeyAsync(@Nonnull ApiKey request) {
        return this.updateApiKeyAsync(request, null);
    }

    default public CompletableFuture<UpdateApiKeyResponse> updateApiKeyAsync(@Nonnull ApiKey request, RequestOptions requestOptions) {
        Objects.requireNonNull(request, "An API key is required.");
        if (AlgoliaUtils.isNullOrEmptyWhiteSpace(request.getValue()).booleanValue()) {
            throw new AlgoliaRuntimeException("objectID must not be empty.");
        }
        return this.getTransport().executeRequestAsync(HttpMethod.PUT, "/1/keys/" + request.getValue(), CallType.WRITE, request, UpdateApiKeyResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setPendingKey(request);
            resp.setGetApiKeyFunction(this::getApiKey);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public RestoreApiKeyResponse restoreApiKey(@Nonnull String apiKey) {
        return LaunderThrowable.await(this.restoreApiKeyAsync(apiKey));
    }

    default public RestoreApiKeyResponse restoreApiKey(@Nonnull String apiKey, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.restoreApiKeyAsync(apiKey, requestOptions));
    }

    default public CompletableFuture<RestoreApiKeyResponse> restoreApiKeyAsync(@Nonnull String apiKey) {
        return this.restoreApiKeyAsync(apiKey, null);
    }

    default public CompletableFuture<RestoreApiKeyResponse> restoreApiKeyAsync(@Nonnull String apiKey, RequestOptions requestOptions) {
        Objects.requireNonNull(apiKey, "An API Key is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(apiKey).booleanValue()) {
            throw new AlgoliaRuntimeException("API Key must not be empty.");
        }
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/keys/" + apiKey + "/restore", CallType.WRITE, RestoreApiKeyResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setKey(apiKey);
            resp.setGetApiKeyFunction(this::getApiKey);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public String generateSecuredAPIKey(@Nonnull String parentAPIKey, SecuredApiKeyRestriction restriction) throws Exception {
        return HmacShaUtils.generateSecuredApiKey(parentAPIKey, restriction);
    }

    default public Duration getSecuredApiKeyRemainingValidity(@Nonnull String securedAPIKey) {
        if (AlgoliaUtils.isNullOrEmptyWhiteSpace(securedAPIKey).booleanValue()) {
            throw new AlgoliaRuntimeException("securedAPIKey must not be empty, null or whitespaces");
        }
        byte[] decodedBytes = Base64.getDecoder().decode(securedAPIKey);
        String decodedString = new String(decodedBytes);
        Pattern pattern = Pattern.compile("validUntil=\\d+");
        Matcher matcher = pattern.matcher(decodedString);
        if (!matcher.find()) {
            throw new AlgoliaRuntimeException("The Secured API Key doesn't have a validUntil parameter.");
        }
        String validUntilMatch = matcher.group(0);
        long timeStamp = Long.parseLong(validUntilMatch.replace("validUntil=", ""));
        return Duration.ofSeconds(timeStamp - Instant.now().getEpochSecond());
    }
}

