/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SearchClientBase;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.javax.annotation.Nonnull;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.indexing.CopyResponse;
import com.algolia.search.models.indexing.CopyToRequest;
import com.algolia.search.models.indexing.MoveIndexRequest;
import com.algolia.search.models.indexing.MoveIndexResponse;
import com.algolia.search.util.AlgoliaUtils;
import com.algolia.search.util.QueryStringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public interface SearchClientCopyOperations
extends SearchClientBase {
    default public CopyResponse copySettings(@Nonnull String sourceIndex, @Nonnull String destinationIndex) {
        return LaunderThrowable.await(this.copySettingsAsync(sourceIndex, destinationIndex));
    }

    default public CopyResponse copySettings(@Nonnull String sourceIndex, @Nonnull String destinationIndex, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.copySettingsAsync(sourceIndex, destinationIndex, requestOptions));
    }

    default public CompletableFuture<CopyResponse> copySettingsAsync(@Nonnull String sourceIndex, @Nonnull String destinationIndex) {
        return this.copyIndexAsync(sourceIndex, destinationIndex, Collections.singletonList("settings"), null);
    }

    default public CompletableFuture<CopyResponse> copySettingsAsync(@Nonnull String sourceIndex, @Nonnull String destinationIndex, RequestOptions requestOptions) {
        return this.copyIndexAsync(sourceIndex, destinationIndex, Collections.singletonList("settings"), null);
    }

    default public CopyResponse copyRules(@Nonnull String sourceIndex, @Nonnull String destinationIndex) {
        return LaunderThrowable.await(this.copyRulesAsync(sourceIndex, destinationIndex));
    }

    default public CopyResponse copyRules(@Nonnull String sourceIndex, @Nonnull String destinationIndex, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.copyRulesAsync(sourceIndex, destinationIndex, requestOptions));
    }

    default public CompletableFuture<CopyResponse> copyRulesAsync(@Nonnull String sourceIndex, @Nonnull String destinationIndex) {
        return this.copyIndexAsync(sourceIndex, destinationIndex, Collections.singletonList("rules"), null);
    }

    default public CompletableFuture<CopyResponse> copyRulesAsync(@Nonnull String sourceIndex, @Nonnull String destinationIndex, RequestOptions requestOptions) {
        return this.copyIndexAsync(sourceIndex, destinationIndex, Collections.singletonList("rules"), null);
    }

    default public CopyResponse copySynonyms(@Nonnull String sourceIndex, @Nonnull String destinationIndex) {
        return LaunderThrowable.await(this.copySynonymsAsync(sourceIndex, destinationIndex));
    }

    default public CopyResponse copySynonyms(@Nonnull String sourceIndex, @Nonnull String destinationIndex, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.copySynonymsAsync(sourceIndex, destinationIndex, requestOptions));
    }

    default public CompletableFuture<CopyResponse> copySynonymsAsync(@Nonnull String sourceIndex, @Nonnull String destinationIndex) {
        return this.copyIndexAsync(sourceIndex, destinationIndex, Collections.singletonList("synonyms"), null);
    }

    default public CompletableFuture<CopyResponse> copySynonymsAsync(@Nonnull String sourceIndex, @Nonnull String destinationIndex, RequestOptions requestOptions) {
        return this.copyIndexAsync(sourceIndex, destinationIndex, Collections.singletonList("synonyms"), requestOptions);
    }

    default public CopyResponse copyIndex(@Nonnull String sourceIndex, @Nonnull String destinationIndex) {
        return LaunderThrowable.await(this.copyIndexAsync(sourceIndex, destinationIndex));
    }

    default public CopyResponse copyIndex(@Nonnull String sourceIndex, @Nonnull String destinationIndex, List<String> scopes) {
        return LaunderThrowable.await(this.copyIndexAsync(sourceIndex, destinationIndex, scopes));
    }

    default public CopyResponse copyIndex(@Nonnull String sourceIndex, @Nonnull String destinationIndex, List<String> scopes, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.copyIndexAsync(sourceIndex, destinationIndex, scopes, requestOptions));
    }

    default public CompletableFuture<CopyResponse> copyIndexAsync(@Nonnull String sourceIndex, @Nonnull String destinationIndex) {
        return this.copyIndexAsync(sourceIndex, destinationIndex, null, null);
    }

    default public CompletableFuture<CopyResponse> copyIndexAsync(@Nonnull String sourceIndex, @Nonnull String destinationIndex, List<String> scopes) {
        return this.copyIndexAsync(sourceIndex, destinationIndex, scopes, null);
    }

    default public CompletableFuture<CopyResponse> copyIndexAsync(@Nonnull String sourceIndex, @Nonnull String destinationIndex, List<String> scopes, RequestOptions requestOptions) {
        this.checkIndicesBeforeMoving(sourceIndex, destinationIndex);
        CopyToRequest request = new CopyToRequest().setDestination(destinationIndex).setScope(scopes).setOperation("copy");
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/" + QueryStringUtils.urlEncodeUTF8(sourceIndex) + "/operation", CallType.WRITE, request, CopyResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setIndexName(sourceIndex);
            resp.setWaitConsumer(this::waitTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public MoveIndexResponse moveIndex(@Nonnull String sourceIndex, @Nonnull String destinationIndex) {
        return LaunderThrowable.await(this.moveIndexAsync(sourceIndex, destinationIndex));
    }

    default public MoveIndexResponse moveIndex(@Nonnull String sourceIndex, @Nonnull String destinationIndex, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.moveIndexAsync(sourceIndex, destinationIndex, requestOptions));
    }

    default public CompletableFuture<MoveIndexResponse> moveIndexAsync(@Nonnull String sourceIndex, @Nonnull String destinationIndex) {
        return this.moveIndexAsync(sourceIndex, destinationIndex, null);
    }

    default public CompletableFuture<MoveIndexResponse> moveIndexAsync(@Nonnull String sourceIndex, @Nonnull String destinationIndex, RequestOptions requestOptions) {
        this.checkIndicesBeforeMoving(sourceIndex, destinationIndex);
        MoveIndexRequest request = new MoveIndexRequest().setDestination(destinationIndex).setOperation("move");
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/indexes/" + QueryStringUtils.urlEncodeUTF8(sourceIndex) + "/operation", CallType.WRITE, request, MoveIndexResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setIndexName(destinationIndex);
            resp.setWaitBiConsumer(this::waitTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public void checkIndicesBeforeMoving(@Nonnull String sourceIndex, @Nonnull String destinationIndex) {
        Objects.requireNonNull(sourceIndex, "The source index is required.");
        Objects.requireNonNull(destinationIndex, "The destination index is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(sourceIndex).booleanValue()) {
            throw new AlgoliaRuntimeException("Source index must not be empty or white spaces.");
        }
        if (AlgoliaUtils.isEmptyWhiteSpace(destinationIndex).booleanValue()) {
            throw new AlgoliaRuntimeException("Destination index must not be empty or white spaces.");
        }
    }
}

