/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SearchClientBase;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.javax.annotation.Nonnull;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.dictionary.Dictionary;
import com.algolia.search.models.dictionary.DictionaryEntry;
import com.algolia.search.models.dictionary.DictionaryRequest;
import com.algolia.search.models.dictionary.DictionaryResponse;
import com.algolia.search.models.dictionary.DictionarySettings;
import com.algolia.search.models.indexing.Query;
import com.algolia.search.models.indexing.SearchResult;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public interface SearchClientDictionary
extends SearchClientBase {
    default public DictionaryResponse saveDictionaryEntries(@Nonnull Dictionary dictionary, @Nonnull List<DictionaryEntry> dictionaryEntries) {
        return this.saveDictionaryEntries(dictionary, dictionaryEntries, null);
    }

    default public DictionaryResponse saveDictionaryEntries(@Nonnull Dictionary dictionary, @Nonnull List<DictionaryEntry> dictionaryEntries, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.saveDictionaryEntriesAsync(dictionary, dictionaryEntries, requestOptions));
    }

    default public CompletableFuture<DictionaryResponse> saveDictionaryEntriesAsync(@Nonnull Dictionary dictionary, @Nonnull List<DictionaryEntry> dictionaryEntries) {
        return this.saveDictionaryEntriesAsync(dictionary, dictionaryEntries, null);
    }

    default public CompletableFuture<DictionaryResponse> saveDictionaryEntriesAsync(@Nonnull Dictionary dictionary, @Nonnull List<DictionaryEntry> dictionaryEntries, RequestOptions requestOptions) {
        Objects.requireNonNull(dictionary, "A dictionary is required.");
        Objects.requireNonNull(dictionaryEntries, "Dictionary entries is required.");
        DictionaryRequest request = DictionaryRequest.add(false, dictionaryEntries);
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/dictionaries/" + (Object)((Object)dictionary) + "/batch", CallType.WRITE, request, DictionaryResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitAppTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public DictionaryResponse replaceDictionaryEntries(@Nonnull Dictionary dictionary, @Nonnull List<DictionaryEntry> dictionaryEntries) {
        return this.replaceDictionaryEntries(dictionary, dictionaryEntries, null);
    }

    default public DictionaryResponse replaceDictionaryEntries(@Nonnull Dictionary dictionary, @Nonnull List<DictionaryEntry> dictionaryEntries, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.replaceDictionaryEntriesAsync(dictionary, dictionaryEntries, requestOptions));
    }

    default public CompletableFuture<DictionaryResponse> replaceDictionaryEntriesAsync(@Nonnull Dictionary dictionary, @Nonnull List<DictionaryEntry> dictionaryEntries) {
        return this.replaceDictionaryEntriesAsync(dictionary, dictionaryEntries, null);
    }

    default public CompletableFuture<DictionaryResponse> replaceDictionaryEntriesAsync(@Nonnull Dictionary dictionary, @Nonnull List<DictionaryEntry> dictionaryEntries, RequestOptions requestOptions) {
        Objects.requireNonNull(dictionary, "A dictionary is required.");
        Objects.requireNonNull(dictionaryEntries, "Dictionary entries is required.");
        DictionaryRequest request = DictionaryRequest.add(true, dictionaryEntries);
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/dictionaries/" + (Object)((Object)dictionary) + "/batch", CallType.WRITE, request, DictionaryResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitAppTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public DictionaryResponse deleteDictionaryEntries(@Nonnull Dictionary dictionary, @Nonnull List<String> objectIDs) {
        return this.deleteDictionaryEntries(dictionary, objectIDs, null);
    }

    default public DictionaryResponse deleteDictionaryEntries(@Nonnull Dictionary dictionary, @Nonnull List<String> objectIDs, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.deleteDictionaryEntriesAsync(dictionary, objectIDs, requestOptions));
    }

    default public CompletableFuture<DictionaryResponse> deleteDictionaryEntriesAsync(@Nonnull Dictionary dictionary, @Nonnull List<String> objectIDs) {
        return this.deleteDictionaryEntriesAsync(dictionary, objectIDs, null);
    }

    default public CompletableFuture<DictionaryResponse> deleteDictionaryEntriesAsync(@Nonnull Dictionary dictionary, @Nonnull List<String> objectIDs, RequestOptions requestOptions) {
        Objects.requireNonNull(dictionary, "A dictionary is required.");
        Objects.requireNonNull(objectIDs, "Dictionary entries is required.");
        if (objectIDs.isEmpty()) {
            throw new IllegalArgumentException("objectIDs can't be empty.");
        }
        DictionaryRequest request = DictionaryRequest.delete(objectIDs);
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/dictionaries/" + (Object)((Object)dictionary) + "/batch", CallType.WRITE, request, DictionaryResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitAppTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public DictionaryResponse clearDictionaryEntries(@Nonnull Dictionary dictionary) {
        return this.clearDictionaryEntries(dictionary, null);
    }

    default public DictionaryResponse clearDictionaryEntries(@Nonnull Dictionary dictionary, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.clearDictionaryEntriesAsync(dictionary, requestOptions));
    }

    default public CompletableFuture<DictionaryResponse> clearDictionaryEntriesAsync(@Nonnull Dictionary dictionary) {
        return this.clearDictionaryEntriesAsync(dictionary, null);
    }

    default public CompletableFuture<DictionaryResponse> clearDictionaryEntriesAsync(@Nonnull Dictionary dictionary, RequestOptions requestOptions) {
        return this.replaceDictionaryEntriesAsync(dictionary, Collections.emptyList(), requestOptions);
    }

    default public <T> SearchResult<T> searchDictionaryEntries(@Nonnull Dictionary dictionary, @Nonnull Query query) {
        return this.searchDictionaryEntries(dictionary, query, null);
    }

    default public <T> SearchResult<T> searchDictionaryEntries(@Nonnull Dictionary dictionary, @Nonnull Query query, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.searchDictionaryEntriesAsync(dictionary, query, requestOptions));
    }

    default public <T> CompletableFuture<SearchResult<T>> searchDictionaryEntriesAsync(@Nonnull Dictionary dictionary, @Nonnull Query query) {
        return this.searchDictionaryEntriesAsync(dictionary, query, null);
    }

    default public <T> CompletableFuture<SearchResult<T>> searchDictionaryEntriesAsync(@Nonnull Dictionary dictionary, @Nonnull Query query, RequestOptions requestOptions) {
        Objects.requireNonNull(dictionary, "A dictionary is required.");
        Objects.requireNonNull(query, "A query key is required.");
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/dictionaries/" + (Object)((Object)dictionary) + "/search", CallType.READ, query, SearchResult.class, dictionary.getEntry(), requestOptions).thenComposeAsync(resp -> {
            CompletableFuture<SearchResult> r = new CompletableFuture<SearchResult>();
            r.complete((SearchResult)resp);
            return r;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public DictionaryResponse setDictionarySettings(@Nonnull DictionarySettings dictionarySettings) {
        return this.setDictionarySettings(dictionarySettings, null);
    }

    default public DictionaryResponse setDictionarySettings(@Nonnull DictionarySettings dictionarySettings, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.setDictionarySettingsAsync(dictionarySettings, requestOptions));
    }

    default public CompletableFuture<DictionaryResponse> setDictionarySettingsAsync(@Nonnull DictionarySettings dictionarySettings) {
        return this.setDictionarySettingsAsync(dictionarySettings, null);
    }

    default public CompletableFuture<DictionaryResponse> setDictionarySettingsAsync(@Nonnull DictionarySettings dictionarySettings, RequestOptions requestOptions) {
        Objects.requireNonNull(dictionarySettings, "Dictionary settings is required.");
        return this.getTransport().executeRequestAsync(HttpMethod.PUT, "/1/dictionaries/*/settings", CallType.WRITE, dictionarySettings, DictionaryResponse.class, requestOptions).thenApplyAsync(resp -> {
            resp.setWaitConsumer(this::waitAppTask);
            return resp;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public DictionarySettings getDictionarySettings() {
        return this.getDictionarySettings(null);
    }

    default public DictionarySettings getDictionarySettings(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getDictionarySettingsAsync(requestOptions));
    }

    default public CompletableFuture<DictionarySettings> getDictionarySettingsAsync() {
        return this.getDictionarySettingsAsync(null);
    }

    default public CompletableFuture<DictionarySettings> getDictionarySettingsAsync(RequestOptions requestOptions) {
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/dictionaries/*/settings", CallType.READ, DictionarySettings.class, requestOptions);
    }
}

