/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.models.indexing;

import com.algolia.search.com.fasterxml.jackson.core.JsonParser;
import com.algolia.search.com.fasterxml.jackson.core.JsonToken;
import com.algolia.search.com.fasterxml.jackson.databind.DeserializationContext;
import com.algolia.search.com.fasterxml.jackson.databind.JsonDeserializer;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class FiltersJsonDeserializer
extends JsonDeserializer<List<List<String>>> {
    FiltersJsonDeserializer() {
    }

    @Override
    public List<List<String>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken = p.getCurrentToken();
        List<List<String>> result = null;
        switch (currentToken) {
            case START_ARRAY: {
                List list = p.readValueAs(List.class);
                result = this.buildFilters(list);
                break;
            }
            case VALUE_STRING: {
                String string = p.getValueAsString();
                result = this.buildFilters(string);
                break;
            }
            case VALUE_NULL: {
                break;
            }
            default: {
                throw new AlgoliaRuntimeException("Unexpected JSON format occurred during the deserialization of filters.");
            }
        }
        return result;
    }

    private List<List<String>> buildFilters(List list) {
        return list.stream().map(element -> {
            if (element instanceof String) {
                return Collections.singletonList((String)element);
            }
            return element;
        }).collect(Collectors.toList());
    }

    private List<List<String>> buildFilters(String string) {
        List<String> groups = Arrays.asList(string.split(",(?![^()]*\\))"));
        return groups.stream().map(group -> {
            if (group.startsWith("(") && group.endsWith(")")) {
                String input = group.substring(1, group.length() - 1);
                return Arrays.asList(input.split(","));
            }
            return Collections.singletonList(group);
        }).collect(Collectors.toList());
    }
}

