/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.models.indexing;

import com.algolia.search.com.fasterxml.jackson.annotation.JsonSetter;
import com.algolia.search.javax.annotation.Nonnull;
import com.algolia.search.models.indexing.Explain;
import com.algolia.search.models.indexing.FacetStats;
import com.algolia.search.models.rules.RenderingContent;
import com.algolia.search.util.AlgoliaUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class SearchResult<T>
implements Serializable {
    private Long page;
    private Long nbHits;
    private Long nbPages;
    private Long hitsPerPage;
    private Long processingTimeMS;
    private Map<String, Map<String, Long>> facets;
    private Map<String, FacetStats> facets_stats;
    private Boolean exhaustiveFacetsCount;
    private String query;
    private String params;
    private List<T> hits;
    private String index;
    private Boolean processed;
    private String queryID;
    private Explain explain;
    private List<Map<String, Object>> userData;
    private List<Map<String, Object>> appliedRules;
    private Boolean exhaustiveNbHits;
    private Integer appliedRelevancyStrictness;
    private Integer nbSortedHits;
    private RenderingContent renderingContent;
    private Long offset;
    private Long length;
    private String parsedQuery;
    private Long abTestVariantID;
    private String indexUsed;
    private String serverUsed;
    private String automaticRadius;
    private String aroundLatLng;
    private String message;
    private String queryAfterRemoval;

    public Explain getExplain() {
        return this.explain;
    }

    public SearchResult<T> setExplain(Explain explain) {
        this.explain = explain;
        return this;
    }

    public Long getOffset() {
        return this.offset;
    }

    public SearchResult<T> setOffset(Long offset) {
        this.offset = offset;
        return this;
    }

    public Long getLength() {
        return this.length;
    }

    public SearchResult<T> setLength(Long length) {
        this.length = length;
        return this;
    }

    public String getParsedQuery() {
        return this.parsedQuery;
    }

    public SearchResult<T> setParsedQuery(String parsedQuery) {
        this.parsedQuery = parsedQuery;
        return this;
    }

    public Long getAbTestVariantID() {
        return this.abTestVariantID;
    }

    public SearchResult<T> setAbTestVariantID(Long abTestVariantID) {
        this.abTestVariantID = abTestVariantID;
        return this;
    }

    public String getIndexUsed() {
        return this.indexUsed;
    }

    public SearchResult<T> setIndexUsed(String indexUsed) {
        this.indexUsed = indexUsed;
        return this;
    }

    public String getServerUsed() {
        return this.serverUsed;
    }

    public SearchResult<T> setServerUsed(String serverUsed) {
        this.serverUsed = serverUsed;
        return this;
    }

    public String getAutomaticRadius() {
        return this.automaticRadius;
    }

    public SearchResult<T> setAutomaticRadius(String automaticRadius) {
        this.automaticRadius = automaticRadius;
        return this;
    }

    public String getAroundLatLng() {
        return this.aroundLatLng;
    }

    public SearchResult<T> setAroundLatLng(String aroundLatLng) {
        this.aroundLatLng = aroundLatLng;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public SearchResult<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getQueryAfterRemoval() {
        return this.queryAfterRemoval;
    }

    public SearchResult<T> setQueryAfterRemoval(String queryAfterRemoval) {
        this.queryAfterRemoval = queryAfterRemoval;
        return this;
    }

    public RenderingContent getRenderingContent() {
        return this.renderingContent;
    }

    public SearchResult<T> setRenderingContent(RenderingContent renderingContent) {
        this.renderingContent = renderingContent;
        return this;
    }

    public List<Map<String, Object>> getAppliedRules() {
        return this.appliedRules;
    }

    public void setAppliedRules(List<Map<String, Object>> appliedRules) {
        this.appliedRules = appliedRules;
    }

    public List<Map<String, Object>> getUserData() {
        return this.userData;
    }

    public void setUserData(List<Map<String, Object>> userData) {
        this.userData = userData;
    }

    public List<T> getHits() {
        return this.hits;
    }

    public SearchResult<T> setHits(List<T> hits) {
        this.hits = hits;
        return this;
    }

    public Long getPage() {
        return this.page;
    }

    public SearchResult<T> setPage(Integer page) {
        return this.setPage(page.longValue());
    }

    @JsonSetter
    public SearchResult<T> setPage(Long page) {
        this.page = page;
        return this;
    }

    public Long getNbHits() {
        return this.nbHits;
    }

    public SearchResult<T> setNbHits(Integer nbHits) {
        return this.setNbHits(nbHits.longValue());
    }

    @JsonSetter
    public SearchResult<T> setNbHits(Long nbHits) {
        this.nbHits = nbHits;
        return this;
    }

    public Long getNbPages() {
        return this.nbPages;
    }

    public SearchResult<T> setNbPages(Integer nbPages) {
        return this.setNbPages(nbPages.longValue());
    }

    @JsonSetter
    public SearchResult<T> setNbPages(Long nbPages) {
        this.nbPages = nbPages;
        return this;
    }

    public Long getHitsPerPage() {
        return this.hitsPerPage;
    }

    public SearchResult<T> setHitsPerPage(Integer hitsPerPage) {
        return this.setHitsPerPage(hitsPerPage.longValue());
    }

    @JsonSetter
    public SearchResult<T> setHitsPerPage(Long hitsPerPage) {
        this.hitsPerPage = hitsPerPage;
        return this;
    }

    public Long getProcessingTimeMS() {
        return this.processingTimeMS;
    }

    public SearchResult<T> setProcessingTimeMS(Integer processingTimeMS) {
        return this.setProcessingTimeMS(processingTimeMS.longValue());
    }

    @JsonSetter
    public SearchResult<T> setProcessingTimeMS(Long processingTimeMS) {
        this.processingTimeMS = processingTimeMS;
        return this;
    }

    public Map<String, Map<String, Long>> getFacets() {
        return this.facets;
    }

    public SearchResult<T> setFacets(Map<String, Map<String, Long>> facets) {
        this.facets = facets;
        return this;
    }

    public Boolean getExhaustiveFacetsCount() {
        return this.exhaustiveFacetsCount;
    }

    public SearchResult<T> setExhaustiveFacetsCount(Boolean exhaustiveFacetsCount) {
        this.exhaustiveFacetsCount = exhaustiveFacetsCount;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public SearchResult<T> setQuery(String query) {
        this.query = query;
        return this;
    }

    public String getParams() {
        return this.params;
    }

    public SearchResult<T> setParams(String params) {
        this.params = params;
        return this;
    }

    public String getIndex() {
        return this.index;
    }

    public SearchResult<T> setIndex(String index) {
        this.index = index;
        return this;
    }

    public Boolean getProcessed() {
        return this.processed;
    }

    public SearchResult<T> setProcessed(Boolean processed) {
        this.processed = processed;
        return this;
    }

    public String getQueryID() {
        return this.queryID;
    }

    public SearchResult<T> setQueryID(String queryID) {
        this.queryID = queryID;
        return this;
    }

    public Map<String, FacetStats> getFacets_stats() {
        return this.facets_stats;
    }

    public SearchResult<T> setFacets_stats(Map<String, FacetStats> facets_stats) {
        this.facets_stats = facets_stats;
        return this;
    }

    public int getObjectPosition(@Nonnull String objectID, @Nonnull Class<T> clazz) {
        return IntStream.range(0, this.hits.size()).filter(i -> objectID.equals(AlgoliaUtils.getObjectID(this.hits.get(i), clazz))).findFirst().orElse(-1);
    }

    public Boolean getExhaustiveNbHits() {
        return this.exhaustiveNbHits;
    }

    public SearchResult<T> setExhaustiveNbHits(Boolean exhaustiveNbHits) {
        this.exhaustiveNbHits = exhaustiveNbHits;
        return this;
    }

    public Integer getAppliedRelevancyStrictness() {
        return this.appliedRelevancyStrictness;
    }

    public SearchResult<T> setAppliedRelevancyStrictness(Integer appliedRelevancyStrictness) {
        this.appliedRelevancyStrictness = appliedRelevancyStrictness;
        return this;
    }

    public Integer getNbSortedHits() {
        return this.nbSortedHits;
    }

    public SearchResult<T> setNbSortedHits(Integer nbSortedHits) {
        this.nbSortedHits = nbSortedHits;
        return this;
    }

    public String toString() {
        return "SearchResult{page=" + this.page + ", nbHits=" + this.nbHits + ", nbPages=" + this.nbPages + ", hitsPerPage=" + this.hitsPerPage + ", processingTimeMS=" + this.processingTimeMS + ", facets=" + this.facets + ", facets_stats=" + this.facets_stats + ", exhaustiveFacetsCount=" + this.exhaustiveFacetsCount + ", query='" + this.query + '\'' + ", params='" + this.params + '\'' + ", hits=" + this.hits + ", index='" + this.index + '\'' + ", processed=" + this.processed + '\'' + ", exhaustiveNbHits=" + this.exhaustiveNbHits + '\'' + ", appliedRelevancyStrictness=" + this.appliedRelevancyStrictness + '\'' + ", nbSortedHits=" + this.nbSortedHits + '\'' + ", renderingContent=" + this.renderingContent + '}';
    }
}

