/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.models.rules;

import com.algolia.search.com.fasterxml.jackson.core.JsonParser;
import com.algolia.search.com.fasterxml.jackson.databind.DeserializationContext;
import com.algolia.search.com.fasterxml.jackson.databind.JsonDeserializer;
import com.algolia.search.com.fasterxml.jackson.databind.JsonNode;
import com.algolia.search.models.rules.TimeRange;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

class TimeRangeDeserializer
extends JsonDeserializer<TimeRange> {
    TimeRangeDeserializer() {
    }

    @Override
    public TimeRange deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        long fromTimestamp = node.get("from").asLong();
        Instant fromInstant = Instant.ofEpochSecond(fromTimestamp);
        OffsetDateTime from = OffsetDateTime.ofInstant(fromInstant, ZoneOffset.UTC);
        long untilTimestamp = node.get("until").asLong();
        Instant untilInstant = Instant.ofEpochSecond(untilTimestamp);
        OffsetDateTime until = OffsetDateTime.ofInstant(untilInstant, ZoneOffset.UTC);
        return new TimeRange(from, until);
    }
}

