/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.ConfigBase;
import com.algolia.search.HttpRequester;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.models.HttpRequest;
import com.algolia.search.models.HttpResponse;
import com.algolia.search.util.HttpStatusCodeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.util.EntityUtils;

public final class ApacheHttpRequester
implements HttpRequester {
    private final CloseableHttpAsyncClient asyncHttpClient;
    private final RequestConfig requestConfig;
    private final ConfigBase config;

    public ApacheHttpRequester(@Nonnull ConfigBase config) {
        this(config, config.getUseSystemProxy() ? HttpAsyncClientBuilder.create().useSystemProperties() : HttpAsyncClientBuilder.create().setMaxConnPerRoute(100));
    }

    public ApacheHttpRequester(@Nonnull ConfigBase config, @Nonnull HttpAsyncClientBuilder builder) {
        this.config = config;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(config.getConnectTimeOut().intValue()).setContentCompressionEnabled(true).build();
        this.asyncHttpClient = builder.build();
        this.asyncHttpClient.start();
    }

    public CompletableFuture<HttpResponse> performRequestAsync(HttpRequest request) {
        HttpRequestBase requestToSend = this.buildRequest(request);
        return ((CompletableFuture)ApacheHttpRequester.toCompletableFuture(fc -> this.asyncHttpClient.execute((HttpUriRequest)requestToSend, fc)).thenApplyAsync(this::buildResponse, (Executor)this.config.getExecutor())).exceptionally(t -> {
            if (t.getCause() instanceof ConnectTimeoutException || t.getCause() instanceof SocketTimeoutException || t.getCause() instanceof ConnectException || t.getCause() instanceof TimeoutException || t.getCause() instanceof ConnectionPoolTimeoutException || t.getCause() instanceof NoHttpResponseException) {
                return new HttpResponse(true);
            }
            if (t.getCause() instanceof HttpException || t.getCause() instanceof SSLException) {
                return new HttpResponse().setNetworkError(true);
            }
            throw new AlgoliaRuntimeException(t);
        });
    }

    public void close() throws IOException {
        this.asyncHttpClient.close();
    }

    private HttpResponse buildResponse(org.apache.http.HttpResponse response) {
        try {
            if (HttpStatusCodeUtils.isSuccess((int)response.getStatusLine().getStatusCode())) {
                HttpEntity entity = ApacheHttpRequester.handleCompressedEntity(response.getEntity());
                return new HttpResponse(response.getStatusLine().getStatusCode(), entity.getContent());
            }
            return new HttpResponse(response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (IOException e) {
            throw new AlgoliaRuntimeException((Throwable)e);
        }
    }

    private HttpRequestBase buildRequest(HttpRequest algoliaRequest) {
        switch (algoliaRequest.getMethod().toString()) {
            case "GET": {
                HttpGet get = new HttpGet(algoliaRequest.getUri().toString());
                get.setConfig(this.buildRequestConfig(algoliaRequest));
                return this.addHeaders((HttpRequestBase)get, algoliaRequest.getHeaders());
            }
            case "DELETE": {
                HttpDelete delete = new HttpDelete(algoliaRequest.getUri().toString());
                delete.setConfig(this.buildRequestConfig(algoliaRequest));
                return this.addHeaders((HttpRequestBase)delete, algoliaRequest.getHeaders());
            }
            case "POST": {
                HttpPost post = new HttpPost(algoliaRequest.getUri().toString());
                if (algoliaRequest.getBodySupplier() != null) {
                    post.setEntity(this.addEntity(algoliaRequest));
                }
                post.setConfig(this.buildRequestConfig(algoliaRequest));
                return this.addHeaders((HttpRequestBase)post, algoliaRequest.getHeaders());
            }
            case "PUT": {
                HttpPut put = new HttpPut(algoliaRequest.getUri().toString());
                if (algoliaRequest.getBodySupplier() != null) {
                    put.setEntity(this.addEntity(algoliaRequest));
                }
                put.setConfig(this.buildRequestConfig(algoliaRequest));
                return this.addHeaders((HttpRequestBase)put, algoliaRequest.getHeaders());
            }
            case "PATCH": {
                HttpPatch patch = new HttpPatch(algoliaRequest.getUri().toString());
                if (algoliaRequest.getBodySupplier() != null) {
                    patch.setEntity(this.addEntity(algoliaRequest));
                }
                patch.setConfig(this.buildRequestConfig(algoliaRequest));
                return this.addHeaders((HttpRequestBase)patch, algoliaRequest.getHeaders());
            }
        }
        throw new UnsupportedOperationException("HTTP method not supported: " + algoliaRequest.getMethod().toString());
    }

    private RequestConfig buildRequestConfig(HttpRequest algoliaRequest) {
        return RequestConfig.copy((RequestConfig)this.requestConfig).setSocketTimeout(algoliaRequest.getTimeout()).build();
    }

    private HttpRequestBase addHeaders(HttpRequestBase request, Map<String, String> headers) {
        headers.forEach((arg_0, arg_1) -> ((HttpRequestBase)request).addHeader(arg_0, arg_1));
        return request;
    }

    private HttpEntity addEntity(@Nonnull HttpRequest request) {
        try {
            InputStream body = (InputStream)request.getBodySupplier().get();
            InputStreamEntity entity = new InputStreamEntity(body, (long)body.available(), ContentType.APPLICATION_JSON);
            if (request.canCompress()) {
                entity.setContentEncoding("gzip");
            }
            return entity;
        }
        catch (IOException e) {
            throw new AlgoliaRuntimeException("Error while getting body's content length.", (Throwable)e);
        }
    }

    private static HttpEntity handleCompressedEntity(HttpEntity entity) {
        Header contentEncoding = entity.getContentEncoding();
        if (contentEncoding != null) {
            for (HeaderElement e : contentEncoding.getElements()) {
                if ("gzip".equalsIgnoreCase(e.getName())) {
                    return new GzipDecompressingEntity(entity);
                }
                if (!"deflate".equalsIgnoreCase(e.getName())) continue;
                return new DeflateDecompressingEntity(entity);
            }
        }
        return entity;
    }

    private static CompletableFuture<org.apache.http.HttpResponse> toCompletableFuture(Consumer<FutureCallback<org.apache.http.HttpResponse>> c) {
        final CompletableFuture<org.apache.http.HttpResponse> promise = new CompletableFuture<org.apache.http.HttpResponse>();
        c.accept(new FutureCallback<org.apache.http.HttpResponse>(){

            public void completed(org.apache.http.HttpResponse t) {
                promise.complete(t);
            }

            public void failed(Exception e) {
                promise.completeExceptionally(e);
            }

            public void cancelled() {
                promise.cancel(true);
            }
        });
        return promise;
    }
}

