/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.ConfigBase;
import com.algolia.search.HttpRequester;
import com.algolia.search.HttpTransport;
import com.algolia.search.InsightsConfig;
import com.algolia.search.UserInsightsClient;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.insights.InsightsEvent;
import com.algolia.search.models.insights.InsightsRequest;
import com.algolia.search.models.insights.InsightsResult;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public final class InsightsClient
implements Closeable {
    private final HttpTransport transport;
    private final ConfigBase config;

    public InsightsClient(@Nonnull InsightsConfig config, @Nonnull HttpRequester httpRequester) {
        Objects.requireNonNull(httpRequester, "An httpRequester is required.");
        Objects.requireNonNull(config, "A configuration is required.");
        this.config = config;
        this.transport = new HttpTransport(config, httpRequester);
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }

    public ConfigBase getConfig() {
        return this.config;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public UserInsightsClient user(@Nonnull String userToken) {
        return new UserInsightsClient(userToken, this);
    }

    public InsightsResult sendEvent(@Nonnull InsightsEvent event) {
        return LaunderThrowable.await(this.sendEventAsync(event));
    }

    public InsightsResult sendEvent(@Nonnull InsightsEvent event, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.sendEventAsync(event, requestOptions));
    }

    public CompletableFuture<InsightsResult> sendEventAsync(@Nonnull InsightsEvent event) {
        List<InsightsEvent> events = Collections.singletonList(event);
        return this.sendEventsAsync(events, null);
    }

    public CompletableFuture<InsightsResult> sendEventAsync(@Nonnull InsightsEvent event, RequestOptions requestOptions) {
        List<InsightsEvent> events = Collections.singletonList(event);
        return this.sendEventsAsync(events, requestOptions);
    }

    public InsightsResult sendEvents(@Nonnull List<InsightsEvent> events) {
        return LaunderThrowable.await(this.sendEventsAsync(events));
    }

    public InsightsResult sendEvents(@Nonnull List<InsightsEvent> events, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.sendEventsAsync(events, requestOptions));
    }

    public CompletableFuture<InsightsResult> sendEventsAsync(@Nonnull List<InsightsEvent> events) {
        return this.sendEventsAsync(events, null);
    }

    public CompletableFuture<InsightsResult> sendEventsAsync(@Nonnull List<InsightsEvent> events, RequestOptions requestOptions) {
        InsightsRequest request = new InsightsRequest().setEvents(events);
        return this.transport.executeRequestAsync(HttpMethod.POST, "/1/events", CallType.WRITE, request, InsightsResult.class, requestOptions);
    }
}

