/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.HttpRequester;
import com.algolia.search.HttpTransport;
import com.algolia.search.SearchConfig;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.indexing.RecommendHit;
import com.algolia.search.models.indexing.RecommendationsResult;
import com.algolia.search.models.recommend.FrequentlyBoughtTogetherQuery;
import com.algolia.search.models.recommend.GetRecommendationsResponse;
import com.algolia.search.models.recommend.RecommendationsQuery;
import com.algolia.search.models.recommend.RecommendationsRequests;
import com.algolia.search.models.recommend.RelatedProductsQuery;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public final class RecommendClient
implements Closeable {
    private final HttpTransport transport;
    private final SearchConfig config;

    public RecommendClient(@Nonnull SearchConfig config, @Nonnull HttpRequester httpRequester) {
        Objects.requireNonNull(httpRequester, "An httpRequester is required.");
        Objects.requireNonNull(config, "A configuration is required.");
        this.config = config;
        this.transport = new HttpTransport(config, httpRequester);
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public SearchConfig getConfig() {
        return this.config;
    }

    public <T extends RecommendHit> List<RecommendationsResult<T>> getRecommendations(@Nonnull List<RecommendationsQuery> requests, @Nonnull Class<T> clazz) {
        return LaunderThrowable.await(this.getRecommendationsAsync(requests, clazz));
    }

    public <T extends RecommendHit> List<RecommendationsResult<T>> getRecommendations(@Nonnull List<RecommendationsQuery> requests, @Nonnull Class<T> clazz, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getRecommendationsAsync(requests, clazz, requestOptions));
    }

    public <T extends RecommendHit> CompletableFuture<List<RecommendationsResult<T>>> getRecommendationsAsync(@Nonnull List<RecommendationsQuery> requests, @Nonnull Class<T> clazz) {
        return this.getRecommendationsAsync(requests, clazz, null);
    }

    public <T extends RecommendHit> CompletableFuture<List<RecommendationsResult<T>>> getRecommendationsAsync(@Nonnull List<RecommendationsQuery> requests, @Nonnull Class<T> clazz, RequestOptions requestOptions) {
        Objects.requireNonNull(requests);
        Objects.requireNonNull(clazz);
        RecommendationsRequests<RecommendationsQuery> data = new RecommendationsRequests<RecommendationsQuery>(requests);
        return this.performGetRecommends(clazz, requestOptions, data);
    }

    public <T extends RecommendHit> List<RecommendationsResult<T>> getRelatedProducts(@Nonnull List<RelatedProductsQuery> requests, @Nonnull Class<T> clazz) {
        return LaunderThrowable.await(this.getRelatedProductsAsync(requests, clazz));
    }

    public <T extends RecommendHit> List<RecommendationsResult<T>> getRelatedProducts(@Nonnull List<RelatedProductsQuery> requests, @Nonnull Class<T> clazz, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getRelatedProductsAsync(requests, clazz, requestOptions));
    }

    public <T extends RecommendHit> CompletableFuture<List<RecommendationsResult<T>>> getRelatedProductsAsync(@Nonnull List<RelatedProductsQuery> requests, @Nonnull Class<T> clazz) {
        return this.getRelatedProductsAsync(requests, clazz, null);
    }

    public <T extends RecommendHit> CompletableFuture<List<RecommendationsResult<T>>> getRelatedProductsAsync(@Nonnull List<RelatedProductsQuery> requests, @Nonnull Class<T> clazz, RequestOptions requestOptions) {
        Objects.requireNonNull(requests);
        Objects.requireNonNull(clazz);
        RecommendationsRequests<RelatedProductsQuery> data = new RecommendationsRequests<RelatedProductsQuery>(requests);
        return this.performGetRecommends(clazz, requestOptions, data);
    }

    public <T extends RecommendHit> List<RecommendationsResult<T>> getFrequentlyBoughtTogether(@Nonnull List<FrequentlyBoughtTogetherQuery> requests, @Nonnull Class<T> clazz) {
        return LaunderThrowable.await(this.getFrequentlyBoughtTogetherAsync(requests, clazz));
    }

    public <T extends RecommendHit> List<RecommendationsResult<T>> getFrequentlyBoughtTogether(@Nonnull List<FrequentlyBoughtTogetherQuery> requests, @Nonnull Class<T> clazz, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getFrequentlyBoughtTogetherAsync(requests, clazz, requestOptions));
    }

    public <T extends RecommendHit> CompletableFuture<List<RecommendationsResult<T>>> getFrequentlyBoughtTogetherAsync(@Nonnull List<FrequentlyBoughtTogetherQuery> requests, @Nonnull Class<T> clazz) {
        return this.getFrequentlyBoughtTogetherAsync(requests, clazz, null);
    }

    public <T extends RecommendHit> CompletableFuture<List<RecommendationsResult<T>>> getFrequentlyBoughtTogetherAsync(@Nonnull List<FrequentlyBoughtTogetherQuery> requests, @Nonnull Class<T> clazz, RequestOptions requestOptions) {
        Objects.requireNonNull(requests);
        Objects.requireNonNull(clazz);
        RecommendationsRequests<FrequentlyBoughtTogetherQuery> data = new RecommendationsRequests<FrequentlyBoughtTogetherQuery>(requests);
        return this.performGetRecommends(clazz, requestOptions, data);
    }

    private <T extends RecommendHit> CompletableFuture<List<RecommendationsResult<T>>> performGetRecommends(Class<T> clazz, RequestOptions requestOptions, RecommendationsRequests<?> data) {
        return this.transport.executeRequestAsync(HttpMethod.POST, "/1/indexes/*/recommendations", CallType.READ, data, GetRecommendationsResponse.class, clazz, requestOptions).thenComposeAsync(resp -> {
            CompletableFuture r = new CompletableFuture();
            r.complete(resp.getResults());
            return r;
        }, (Executor)this.config.getExecutor());
    }
}

