/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.SearchClientBase;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.exceptions.LaunderThrowable;
import com.algolia.search.models.HttpMethod;
import com.algolia.search.models.RequestOptions;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.indexing.SearchResult;
import com.algolia.search.models.mcm.AssignUserIdRequest;
import com.algolia.search.models.mcm.AssignUserIdResponse;
import com.algolia.search.models.mcm.AssignUserIdsRequest;
import com.algolia.search.models.mcm.AssignUserIdsResponse;
import com.algolia.search.models.mcm.HasPendingMappingsResponse;
import com.algolia.search.models.mcm.ListClustersResponse;
import com.algolia.search.models.mcm.ListUserIdsResponse;
import com.algolia.search.models.mcm.RemoveUserIdResponse;
import com.algolia.search.models.mcm.SearchUserIdsRequest;
import com.algolia.search.models.mcm.TopUserIdResponse;
import com.algolia.search.models.mcm.UserId;
import com.algolia.search.util.AlgoliaUtils;
import com.algolia.search.util.QueryStringUtils;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public interface SearchClientMcm
extends SearchClientBase {
    default public ListClustersResponse listClusters() {
        return LaunderThrowable.await(this.listClustersAsync());
    }

    default public ListClustersResponse listClusters(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.listClustersAsync(requestOptions));
    }

    default public CompletableFuture<ListClustersResponse> listClustersAsync() {
        return this.listClustersAsync(null);
    }

    default public CompletableFuture<ListClustersResponse> listClustersAsync(RequestOptions requestOptions) {
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/clusters", CallType.READ, ListClustersResponse.class, requestOptions);
    }

    default public SearchResult<UserId> searchUserIDs(@Nonnull SearchUserIdsRequest query) {
        return LaunderThrowable.await(this.searchUserIDsAsync(query));
    }

    default public SearchResult<UserId> searchUserIDs(@Nonnull SearchUserIdsRequest query, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.searchUserIDsAsync(query, requestOptions));
    }

    default public CompletableFuture<SearchResult<UserId>> searchUserIDsAsync(@Nonnull SearchUserIdsRequest query) {
        return this.searchUserIDsAsync(query, null);
    }

    default public CompletableFuture<SearchResult<UserId>> searchUserIDsAsync(@Nonnull SearchUserIdsRequest query, RequestOptions requestOptions) {
        Objects.requireNonNull(query, "A query is required");
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/clusters/mapping/search", CallType.READ, query, SearchResult.class, UserId.class, requestOptions).thenComposeAsync(resp -> {
            CompletableFuture<SearchResult> r = new CompletableFuture<SearchResult>();
            r.complete((SearchResult)resp);
            return r;
        }, (Executor)this.getConfig().getExecutor());
    }

    default public ListUserIdsResponse listUserIDs() {
        return LaunderThrowable.await(this.listUserIDsAsync());
    }

    default public ListUserIdsResponse listUserIDs(int page, int hitsPerPage, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.listUserIDsAsync(page, hitsPerPage, requestOptions));
    }

    default public ListUserIdsResponse listUserIDs(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.listUserIDsAsync(requestOptions));
    }

    default public CompletableFuture<ListUserIdsResponse> listUserIDsAsync() {
        return this.listUserIDsAsync(0, 10, null);
    }

    default public CompletableFuture<ListUserIdsResponse> listUserIDsAsync(int page, int hitsPerPage, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.addExtraQueryParameters("page", String.valueOf(page));
        requestOptions.addExtraQueryParameters("hitsPerPage", String.valueOf(hitsPerPage));
        return this.listUserIDsAsync(requestOptions);
    }

    default public CompletableFuture<ListUserIdsResponse> listUserIDsAsync(RequestOptions requestOptions) {
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/clusters/mapping", CallType.READ, ListUserIdsResponse.class, requestOptions);
    }

    default public UserId getUserID(@Nonnull String userID) {
        return LaunderThrowable.await(this.getUserIDAsync(userID));
    }

    default public UserId getUserID(@Nonnull String userID, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getUserIDAsync(userID, requestOptions));
    }

    default public CompletableFuture<UserId> getUserIDAsync(@Nonnull String userID) {
        Objects.requireNonNull(userID, "The userID is required.");
        return this.getUserIDAsync(userID, null);
    }

    default public CompletableFuture<UserId> getUserIDAsync(@Nonnull String userID, RequestOptions requestOptions) {
        Objects.requireNonNull(userID, "The userID is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(userID).booleanValue()) {
            throw new AlgoliaRuntimeException("userID must not be empty.");
        }
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/clusters/mapping/" + QueryStringUtils.urlEncodeUTF8(userID), CallType.READ, UserId.class, requestOptions);
    }

    default public TopUserIdResponse getTopUserID() {
        return LaunderThrowable.await(this.getTopUserIDAsync());
    }

    default public TopUserIdResponse getTopUserID(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.getTopUserIDAsync(requestOptions));
    }

    default public CompletableFuture<TopUserIdResponse> getTopUserIDAsync() {
        return this.getTopUserIDAsync(null);
    }

    default public CompletableFuture<TopUserIdResponse> getTopUserIDAsync(RequestOptions requestOptions) {
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/clusters/mapping/top", CallType.READ, TopUserIdResponse.class, requestOptions);
    }

    default public RemoveUserIdResponse removeUserID(@Nonnull String userId) {
        return LaunderThrowable.await(this.removeUserIDAsync(userId, null));
    }

    default public RemoveUserIdResponse removeUserID(@Nonnull String userId, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.removeUserIDAsync(userId, requestOptions));
    }

    default public CompletableFuture<RemoveUserIdResponse> removeUserIDAsync(@Nonnull String userId) {
        return this.removeUserIDAsync(userId, null);
    }

    default public CompletableFuture<RemoveUserIdResponse> removeUserIDAsync(@Nonnull String userId, RequestOptions requestOptions) {
        Objects.requireNonNull(userId, "userId key is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(userId).booleanValue()) {
            throw new AlgoliaRuntimeException("userId must not be empty or white spaces.");
        }
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.addExtraHeader("X-Algolia-USER-ID", userId);
        return this.getTransport().executeRequestAsync(HttpMethod.DELETE, "/1/clusters/mapping", CallType.WRITE, RemoveUserIdResponse.class, requestOptions);
    }

    default public AssignUserIdResponse assignUserID(@Nonnull String userId, @Nonnull String clusterName) {
        return LaunderThrowable.await(this.assignUserIDAsync(userId, clusterName));
    }

    default public AssignUserIdResponse assignUserID(@Nonnull String userId, @Nonnull String clusterName, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.assignUserIDAsync(userId, clusterName, requestOptions));
    }

    default public CompletableFuture<AssignUserIdResponse> assignUserIDAsync(@Nonnull String userId, @Nonnull String clusterName) {
        return this.assignUserIDAsync(userId, clusterName, null);
    }

    default public CompletableFuture<AssignUserIdResponse> assignUserIDAsync(@Nonnull String userId, @Nonnull String clusterName, RequestOptions requestOptions) {
        Objects.requireNonNull(userId, "userId key is required.");
        Objects.requireNonNull(clusterName, "clusterName key is required.");
        if (AlgoliaUtils.isEmptyWhiteSpace(userId).booleanValue()) {
            throw new AlgoliaRuntimeException("userId must not be empty.");
        }
        if (AlgoliaUtils.isEmptyWhiteSpace(clusterName).booleanValue()) {
            throw new AlgoliaRuntimeException("clusterName must not be empty.");
        }
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.addExtraHeader("X-Algolia-USER-ID", userId);
        AssignUserIdRequest request = new AssignUserIdRequest(clusterName);
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/clusters/mapping", CallType.WRITE, request, AssignUserIdResponse.class, requestOptions);
    }

    default public AssignUserIdsResponse assignUserIDs(@Nonnull List<String> userIds, @Nonnull String clusterName) {
        return LaunderThrowable.await(this.assignUserIDsAsync(userIds, clusterName));
    }

    default public AssignUserIdsResponse assignUserIDs(@Nonnull List<String> userIds, @Nonnull String clusterName, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.assignUserIDsAsync(userIds, clusterName, requestOptions));
    }

    default public CompletableFuture<AssignUserIdsResponse> assignUserIDsAsync(@Nonnull List<String> userIds, @Nonnull String clusterName) {
        return this.assignUserIDsAsync(userIds, clusterName, null);
    }

    default public CompletableFuture<AssignUserIdsResponse> assignUserIDsAsync(@Nonnull List<String> userIds, @Nonnull String clusterName, RequestOptions requestOptions) {
        Objects.requireNonNull(userIds, "userIds are required required.");
        Objects.requireNonNull(clusterName, "clusterName key is required.");
        if (userIds.stream().anyMatch(AlgoliaUtils::isEmptyWhiteSpace)) {
            throw new AlgoliaRuntimeException("userId must not be empty.");
        }
        if (AlgoliaUtils.isEmptyWhiteSpace(clusterName).booleanValue()) {
            throw new AlgoliaRuntimeException("clusterName must not be empty.");
        }
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        AssignUserIdsRequest request = new AssignUserIdsRequest(clusterName, userIds);
        return this.getTransport().executeRequestAsync(HttpMethod.POST, "/1/clusters/mapping/batch", CallType.WRITE, request, AssignUserIdsResponse.class, requestOptions);
    }

    default public HasPendingMappingsResponse hasPendingMappings() {
        return LaunderThrowable.await(this.hasPendingMappingsAsync());
    }

    default public HasPendingMappingsResponse hasPendingMappings(@Nonnull Boolean retrieveMappings) {
        return LaunderThrowable.await(this.hasPendingMappingsAsync(retrieveMappings));
    }

    default public HasPendingMappingsResponse hasPendingMappings(RequestOptions requestOptions) {
        return LaunderThrowable.await(this.hasPendingMappingsAsync(requestOptions));
    }

    default public HasPendingMappingsResponse hasPendingMappings(@Nonnull Boolean retrieveMappings, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.hasPendingMappingsAsync(retrieveMappings, requestOptions));
    }

    default public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync() {
        return this.hasPendingMappingsAsync(false, null);
    }

    default public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync(@Nonnull Boolean retrieveMappings) {
        return this.hasPendingMappingsAsync(retrieveMappings, null);
    }

    default public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync(RequestOptions requestOptions) {
        return this.hasPendingMappingsAsync(false, requestOptions);
    }

    default public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync(@Nonnull Boolean retrieveMappings, RequestOptions requestOptions) {
        Objects.requireNonNull(retrieveMappings, "retrieveMappings is required.");
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.addExtraQueryParameters("getClusters", retrieveMappings.toString());
        return this.getTransport().executeRequestAsync(HttpMethod.GET, "/1/clusters/mapping/pending", CallType.READ, HasPendingMappingsResponse.class, requestOptions);
    }
}

