/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.ConfigBase;
import com.algolia.search.StatefulHost;
import com.algolia.search.models.common.CallType;
import com.algolia.search.models.common.CompressionType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class SearchConfig
extends ConfigBase {
    private SearchConfig(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends ConfigBase.Builder<Builder> {
        public Builder(@Nonnull String applicationID, @Nonnull String apiKey) {
            super(applicationID, apiKey, Builder.createDefaultHosts(applicationID), CompressionType.NONE);
        }

        @Override
        public Builder getThis() {
            return this;
        }

        public SearchConfig build() {
            return new SearchConfig(this);
        }

        private static List<StatefulHost> createDefaultHosts(@Nonnull String applicationID) {
            List<StatefulHost> hosts = Arrays.asList(new StatefulHost(String.format("%s-dsn.algolia.net", applicationID), EnumSet.of(CallType.READ)), new StatefulHost(String.format("%s.algolia.net", applicationID), EnumSet.of(CallType.WRITE)));
            List<StatefulHost> commonHosts = Arrays.asList(new StatefulHost(String.format("%s-1.algolianet.com", applicationID), EnumSet.of(CallType.READ, CallType.WRITE)), new StatefulHost(String.format("%s-2.algolianet.com", applicationID), EnumSet.of(CallType.READ, CallType.WRITE)), new StatefulHost(String.format("%s-3.algolianet.com", applicationID), EnumSet.of(CallType.READ, CallType.WRITE)));
            Collections.shuffle(commonHosts, new Random());
            return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
        }

        public Builder setCompressionType(@Nonnull CompressionType compressionType) {
            this.compressionType = compressionType;
            return this;
        }
    }
}

