/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.ConfigBase;
import com.algolia.search.HttpRequester;
import com.algolia.search.exceptions.AlgoliaRuntimeException;
import com.algolia.search.models.HttpRequest;
import com.algolia.search.models.HttpResponse;
import com.algolia.search.util.HttpStatusCodeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;

public final class JavaNetHttpRequester
implements HttpRequester {
    private final HttpClient client;

    public JavaNetHttpRequester(@Nonnull ConfigBase config) {
        this(config, config.getUseSystemProxy() ? HttpClient.newBuilder().proxy(ProxySelector.getDefault()) : HttpClient.newBuilder());
    }

    public JavaNetHttpRequester(@Nonnull ConfigBase config, HttpClient.Builder builder) {
        this.client = builder.executor(config.getExecutor()).version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NEVER).connectTimeout(Duration.ofMillis(config.getConnectTimeOut().intValue())).build();
    }

    public CompletableFuture<HttpResponse> performRequestAsync(@Nonnull HttpRequest request) {
        return ((CompletableFuture)this.client.sendAsync(this.buildRequest(request), HttpResponse.BodyHandlers.ofInputStream()).thenApply(this::buildResponse)).exceptionally(t -> {
            if (t.getCause() instanceof HttpConnectTimeoutException || t.getCause() instanceof HttpTimeoutException) {
                return new HttpResponse(true);
            }
            if (t.getCause() instanceof SecurityException || t.getCause() instanceof IOException || t.getCause() instanceof InterruptedException) {
                return new HttpResponse().setNetworkError(true);
            }
            throw new AlgoliaRuntimeException(t);
        });
    }

    private HttpResponse buildResponse(java.net.http.HttpResponse<InputStream> response) {
        if (HttpStatusCodeUtils.isSuccess((int)response.statusCode())) {
            return new HttpResponse(response.statusCode(), this.responseBodyHandler(response));
        }
        return new HttpResponse(response.statusCode(), this.convertStreamToString(response.body()));
    }

    private java.net.http.HttpRequest buildRequest(@Nonnull HttpRequest algoliaRequest) {
        HttpRequest.Builder builder = java.net.http.HttpRequest.newBuilder();
        this.buildHeaders(builder, algoliaRequest.getHeaders());
        this.buildURI(builder, algoliaRequest.getUri());
        builder.timeout(Duration.ofMillis(algoliaRequest.getTimeout()));
        HttpRequest.BodyPublisher body = this.buildRequestBody(builder, algoliaRequest);
        builder.method(algoliaRequest.getMethod().toString(), body);
        return builder.build();
    }

    private HttpRequest.BodyPublisher buildRequestBody(@Nonnull HttpRequest.Builder builder, @Nonnull HttpRequest algoliaRequest) {
        Supplier bodySupplier = algoliaRequest.getBodySupplier();
        if (bodySupplier == null) {
            return HttpRequest.BodyPublishers.noBody();
        }
        if (algoliaRequest.canCompress()) {
            builder.header("Content-Encoding", "gzip");
        } else {
            builder.header("Content-Type", "application/json");
        }
        return HttpRequest.BodyPublishers.ofInputStream(bodySupplier);
    }

    private InputStream responseBodyHandler(java.net.http.HttpResponse<InputStream> response) {
        InputStream ret;
        String encoding = response.headers().firstValue("Content-Encoding").orElse("");
        if (encoding.equals("gzip")) {
            try {
                ret = new GZIPInputStream(response.body());
            }
            catch (IOException e) {
                throw new AlgoliaRuntimeException((Throwable)e);
            }
        } else {
            ret = response.body();
        }
        return ret;
    }

    private void buildURI(@Nonnull HttpRequest.Builder builder, @Nonnull URL url) {
        try {
            builder.uri(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new AlgoliaRuntimeException((Throwable)e);
        }
    }

    private void buildHeaders(@Nonnull HttpRequest.Builder builder, @Nonnull Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            builder.header(entry.getKey(), entry.getValue());
        }
    }

    private String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is, StandardCharsets.UTF_8).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public void close() {
    }
}

