/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.saas;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public class Query {
    protected List<String> attributes;
    protected List<String> attributesToHighlight;
    protected List<String> attributesToSnippet;
    protected List<String> noTypoToleranceOn;
    protected Integer minWordSizeForApprox1;
    protected Integer minWordSizeForApprox2;
    protected Boolean getRankingInfo;
    protected Boolean ignorePlural;
    protected Integer distinct;
    protected Boolean advancedSyntax;
    protected Integer page;
    protected Integer hitsPerPage;
    protected String restrictSearchableAttributes;
    protected String tags;
    protected String filters;
    protected String highlightPreTag;
    protected String highlightPostTag;
    protected String snippetEllipsisText;
    protected Integer minProximity;
    protected String numerics;
    protected String insideBoundingBox;
    protected String insidePolygon;
    protected String aroundLatLong;
    protected Boolean aroundLatLongViaIP;
    protected String query;
    protected String similarQuery;
    protected String facetQuery;
    protected QueryType queryType;
    protected String optionalWords;
    protected String facets;
    protected String facetFilters;
    protected Integer maxNumberOfFacets;
    protected Boolean analytics;
    protected Boolean synonyms;
    protected Boolean replaceSynonyms;
    protected Boolean allowTyposOnNumericTokens;
    protected RemoveWordsType removeWordsIfNoResult;
    protected TypoTolerance typoTolerance;
    protected String analyticsTags;
    protected int aroundPrecision;
    protected Object aroundRadius;
    protected int minimumAroundRadius;
    protected Object removeStopWords;
    protected String userToken;
    protected String referers;
    protected Integer validUntil;
    protected String restrictSources;
    protected String restrictIndices;
    protected String exactOnSingleWordQuery;
    protected String alternativesAsExact;

    public Query(String query) {
        this.minWordSizeForApprox1 = null;
        this.minWordSizeForApprox2 = null;
        this.getRankingInfo = null;
        this.ignorePlural = null;
        this.distinct = null;
        this.page = null;
        this.minProximity = null;
        this.hitsPerPage = null;
        this.query = query;
        this.similarQuery = null;
        this.queryType = QueryType.PREFIX_NOTSET;
        this.maxNumberOfFacets = null;
        this.advancedSyntax = null;
        this.removeStopWords = null;
        this.allowTyposOnNumericTokens = null;
        this.replaceSynonyms = null;
        this.synonyms = null;
        this.analytics = null;
        this.analyticsTags = null;
        this.typoTolerance = TypoTolerance.TYPO_NOTSET;
        this.removeWordsIfNoResult = RemoveWordsType.REMOVE_NOTSET;
        this.minimumAroundRadius = 0;
        this.aroundPrecision = 0;
        this.aroundRadius = null;
        this.referers = null;
        this.userToken = null;
        this.validUntil = null;
        this.restrictSources = null;
        this.restrictIndices = null;
        this.exactOnSingleWordQuery = null;
        this.alternativesAsExact = null;
    }

    public Query() {
        this((String)null);
    }

    public Query(Query other) {
        if (other.noTypoToleranceOn != null) {
            this.noTypoToleranceOn = new ArrayList<String>(other.noTypoToleranceOn);
        }
        if (other.attributesToHighlight != null) {
            this.attributesToHighlight = new ArrayList<String>(other.attributesToHighlight);
        }
        if (other.attributes != null) {
            this.attributes = new ArrayList<String>(other.attributes);
        }
        if (other.attributesToSnippet != null) {
            this.attributesToSnippet = new ArrayList<String>(other.attributesToSnippet);
        }
        this.minWordSizeForApprox1 = other.minWordSizeForApprox1;
        this.minWordSizeForApprox2 = other.minWordSizeForApprox2;
        this.getRankingInfo = other.getRankingInfo;
        this.ignorePlural = other.ignorePlural;
        this.minProximity = other.minProximity;
        this.highlightPreTag = other.highlightPreTag;
        this.highlightPostTag = other.highlightPostTag;
        this.snippetEllipsisText = other.snippetEllipsisText;
        this.distinct = other.distinct;
        this.advancedSyntax = other.advancedSyntax;
        this.removeStopWords = other.removeStopWords;
        this.page = other.page;
        this.hitsPerPage = other.hitsPerPage;
        this.restrictSearchableAttributes = other.restrictSearchableAttributes;
        this.tags = other.tags;
        this.numerics = other.numerics;
        this.insideBoundingBox = other.insideBoundingBox;
        this.insidePolygon = other.insidePolygon;
        this.aroundRadius = other.aroundRadius;
        this.minimumAroundRadius = other.minimumAroundRadius;
        this.aroundPrecision = other.aroundPrecision;
        this.aroundLatLong = other.aroundLatLong;
        this.aroundLatLongViaIP = other.aroundLatLongViaIP;
        this.query = other.query;
        this.similarQuery = other.similarQuery;
        this.queryType = other.queryType;
        this.optionalWords = other.optionalWords;
        this.facets = other.facets;
        this.facetFilters = other.facetFilters;
        this.filters = other.filters;
        this.maxNumberOfFacets = other.maxNumberOfFacets;
        this.analytics = other.analytics;
        this.analyticsTags = other.analyticsTags;
        this.synonyms = other.synonyms;
        this.replaceSynonyms = other.replaceSynonyms;
        this.typoTolerance = other.typoTolerance;
        this.allowTyposOnNumericTokens = other.allowTyposOnNumericTokens;
        this.removeWordsIfNoResult = other.removeWordsIfNoResult;
        this.referers = other.referers;
        this.userToken = other.userToken;
        this.validUntil = other.validUntil;
        this.restrictSources = other.restrictSources;
        this.restrictIndices = other.restrictIndices;
        this.exactOnSingleWordQuery = other.exactOnSingleWordQuery;
        this.alternativesAsExact = other.alternativesAsExact;
    }

    public Query removeWordsIfNoResult(RemoveWordsType type) {
        this.removeWordsIfNoResult = type;
        return this;
    }

    public Query restrictSearchableAttributes(String attributes) {
        this.restrictSearchableAttributes = attributes;
        return this;
    }

    public Query setSimilarQueryString(String query) {
        this.similarQuery = query;
        return this;
    }

    public Query setAttributesToRetrieve(List<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Query disableTypoToleranceOnAttributes(List<String> attributes) {
        this.noTypoToleranceOn = attributes;
        return this;
    }

    public Query enableDistinct(boolean distinct) {
        this.distinct = distinct ? 1 : 0;
        return this;
    }

    public Query enableDistinct(int nbHitsToKeep) {
        this.distinct = nbHitsToKeep;
        return this;
    }

    public Query enableAnalytics(boolean enabled) {
        this.analytics = enabled;
        return this;
    }

    public Query enableSynonyms(boolean enabled) {
        this.synonyms = enabled;
        return this;
    }

    public Query enableReplaceSynonymsInHighlight(boolean enabled) {
        this.replaceSynonyms = enabled;
        return this;
    }

    public Query enableTypoTolerance(boolean enabled) {
        this.typoTolerance = enabled ? TypoTolerance.TYPO_TRUE : TypoTolerance.TYPO_FALSE;
        return this;
    }

    public Query setMinWordSizeToAllowOneTypo(int nbChars) {
        this.minWordSizeForApprox1 = nbChars;
        return this;
    }

    public Query setMinProximity(int value) {
        this.minProximity = value;
        return this;
    }

    public Query setHighlightingTags(String preTag, String postTag) {
        this.highlightPreTag = preTag;
        this.highlightPostTag = postTag;
        return this;
    }

    public Query setSnippetEllipsisText(String snippetEllipsisText) {
        this.snippetEllipsisText = snippetEllipsisText;
        return this;
    }

    public Query setMinWordSizeToAllowTwoTypos(int nbChars) {
        this.minWordSizeForApprox2 = nbChars;
        return this;
    }

    public Query enableTyposOnNumericTokens(boolean enabled) {
        this.allowTyposOnNumericTokens = enabled;
        return this;
    }

    public Query getRankingInfo(boolean enabled) {
        this.getRankingInfo = enabled;
        return this;
    }

    public Query ignorePlural(boolean enabled) {
        this.ignorePlural = enabled;
        return this;
    }

    @Deprecated
    public Query setNbHitsPerPage(int nbHitsPerPage) {
        return this.setHitsPerPage(nbHitsPerPage);
    }

    public Query setUserToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    public Query setReferers(String referers) {
        this.referers = referers;
        return this;
    }

    public Query aroundLatitudeLongitude(float latitude, float longitude) {
        this.aroundLatLong = "aroundLatLng=" + latitude + "," + longitude;
        return this;
    }

    public Query aroundLatitudeLongitude(float latitude, float longitude, int radius) {
        this.aroundLatLong = "aroundLatLng=" + latitude + "," + longitude;
        this.aroundRadius = radius;
        return this;
    }

    public Query setAroundRadius(int radius) {
        this.aroundRadius = radius;
        return this;
    }

    public Query setAroundRadiusAll() {
        this.aroundRadius = "all";
        return this;
    }

    public Query setMinimumAroundRadius(int radius) {
        this.minimumAroundRadius = radius;
        return this;
    }

    public Query setAroundPrecision(int precision) {
        this.aroundPrecision = precision;
        return this;
    }

    public Query aroundLatitudeLongitude(float latitude, float longitude, int radius, int precision) {
        this.aroundLatLong = "aroundLatLng=" + latitude + "," + longitude;
        this.aroundRadius = radius;
        this.aroundPrecision = precision;
        return this;
    }

    public Query aroundLatitudeLongitudeViaIP(boolean enabled) {
        this.aroundLatLongViaIP = enabled;
        return this;
    }

    public Query aroundLatitudeLongitudeViaIP(boolean enabled, int radius) {
        this.aroundRadius = radius;
        this.aroundLatLongViaIP = enabled;
        return this;
    }

    public Query aroundLatitudeLongitudeViaIP(boolean enabled, int radius, int precision) {
        this.aroundRadius = radius;
        this.aroundPrecision = precision;
        this.aroundLatLongViaIP = enabled;
        return this;
    }

    public Query insideBoundingBox(float latitudeP1, float longitudeP1, float latitudeP2, float longitudeP2) {
        if (this.insideBoundingBox == null) {
            this.insideBoundingBox = "insideBoundingBox=" + latitudeP1 + "," + longitudeP1 + "," + latitudeP2 + "," + longitudeP2;
        } else if (this.insideBoundingBox.length() > 18) {
            this.insideBoundingBox = this.insideBoundingBox + "," + latitudeP1 + "," + longitudeP1 + "," + latitudeP2 + "," + longitudeP2;
        }
        return this;
    }

    public Query addInsidePolygon(float latitude, float longitude) {
        if (this.insidePolygon == null) {
            this.insidePolygon = "insidePolygon=" + latitude + "," + longitude;
        } else if (this.insidePolygon.length() > 14) {
            this.insidePolygon = this.insidePolygon + "," + latitude + "," + longitude;
        }
        return this;
    }

    public Query setOptionalWords(String words) {
        this.optionalWords = words;
        return this;
    }

    public Query setFacetFilters(List<String> facets) {
        JSONArray obj = new JSONArray();
        for (String facet : facets) {
            obj.put((Object)facet);
        }
        this.facetFilters = obj.toString();
        return this;
    }

    public Query setTagFilters(String tags) {
        this.tags = tags;
        return this;
    }

    public Query setNumericFilters(String numerics) {
        this.numerics = numerics;
        return this;
    }

    public Query setNumericFilters(List<String> numerics) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String n : numerics) {
            if (!first) {
                builder.append(",");
            }
            builder.append(n);
            first = false;
        }
        this.numerics = builder.toString();
        return this;
    }

    public Query enableRemoveStopWords(boolean removeStopWords) {
        this.removeStopWords = removeStopWords;
        return this;
    }

    public Query enableRemoveStopWords(String removeStopWords) {
        this.removeStopWords = removeStopWords;
        return this;
    }

    public Query enableAvancedSyntax(boolean advancedSyntax) {
        this.advancedSyntax = advancedSyntax;
        return this;
    }

    public Query setRestrictIndicies(String indices) {
        this.restrictIndices = indices;
        return this;
    }

    public Query setExactOnSingleWordQuery(String exactOnSingleWordQuery) {
        this.exactOnSingleWordQuery = exactOnSingleWordQuery;
        return this;
    }

    public Query setAlternativesAsExact(String alternativesAsExact) {
        this.alternativesAsExact = alternativesAsExact;
        return this;
    }

    public String getRestrictSources() {
        return this.restrictSources;
    }

    public Query setRestrictSources(String restrictSources) {
        this.restrictSources = restrictSources;
        return this;
    }

    private StringBuilder append(StringBuilder stringBuilder, String key, List<String> values) throws UnsupportedEncodingException {
        if (values != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(key).append("=");
            boolean first = true;
            for (String attr : values) {
                if (!first) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(URLEncoder.encode(attr, "UTF-8"));
                first = false;
            }
        }
        return stringBuilder;
    }

    private StringBuilder append(StringBuilder stringBuilder, String key, String value) {
        if (value != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(key).append("=").append(value);
        }
        return stringBuilder;
    }

    private StringBuilder appendWithEncoding(StringBuilder stringBuilder, String key, String value) throws UnsupportedEncodingException {
        if (value != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(key).append("=").append(URLEncoder.encode(value, "UTF-8"));
        }
        return stringBuilder;
    }

    private StringBuilder append(StringBuilder stringBuilder, String key, Integer value) {
        if (value != null && value > 0) {
            return this.append(stringBuilder, key, value.toString());
        }
        return stringBuilder;
    }

    private StringBuilder append(StringBuilder stringBuilder, String key, Boolean value) {
        if (value != null) {
            return this.append(stringBuilder, key, value != false ? "1" : "0");
        }
        return stringBuilder;
    }

    private StringBuilder append(StringBuilder stringBuilder, String key, Object value) throws UnsupportedEncodingException {
        if (value != null) {
            return this.appendWithEncoding(stringBuilder, key, value.toString());
        }
        return stringBuilder;
    }

    protected String getQueryString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder = this.append(stringBuilder, "attributes", this.attributes);
            stringBuilder = this.append(stringBuilder, "disableTypoToleranceOnAttributes", this.noTypoToleranceOn);
            stringBuilder = this.append(stringBuilder, "attributesToHighlight", this.attributesToHighlight);
            stringBuilder = this.append(stringBuilder, "attributesToSnippet", this.attributesToSnippet);
            if (this.typoTolerance != TypoTolerance.TYPO_NOTSET) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("typoTolerance=");
                switch (this.typoTolerance) {
                    case TYPO_FALSE: {
                        stringBuilder.append("false");
                        break;
                    }
                    case TYPO_MIN: {
                        stringBuilder.append("min");
                        break;
                    }
                    case TYPO_STRICT: {
                        stringBuilder.append("strict");
                        break;
                    }
                    case TYPO_TRUE: {
                        stringBuilder.append("true");
                        break;
                    }
                    case TYPO_NOTSET: {
                        throw new IllegalStateException("code not reachable");
                    }
                }
            }
            stringBuilder = this.append(stringBuilder, "allowTyposOnNumericTokens", this.allowTyposOnNumericTokens);
            stringBuilder = this.append(stringBuilder, "minWordSizefor1Typo", this.minWordSizeForApprox1);
            stringBuilder = this.append(stringBuilder, "minWordSizefor2Typos", this.minWordSizeForApprox2);
            switch (this.removeWordsIfNoResult) {
                case REMOVE_LAST_WORDS: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("removeWordsIfNoResult=LastWords");
                    break;
                }
                case REMOVE_FIRST_WORDS: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("removeWordsIfNoResult=FirstWords");
                    break;
                }
                case REMOVE_ALLOPTIONAL: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("removeWordsIfNoResult=allOptional");
                    break;
                }
                case REMOVE_NONE: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("removeWordsIfNoResult=none");
                    break;
                }
            }
            stringBuilder = this.append(stringBuilder, "getRankingInfo", this.getRankingInfo);
            stringBuilder = this.append(stringBuilder, "ignorePlural", this.ignorePlural);
            stringBuilder = this.append(stringBuilder, "analytics", this.analytics);
            stringBuilder = this.append(stringBuilder, "analyticsTags", this.analyticsTags);
            stringBuilder = this.append(stringBuilder, "synonyms", this.synonyms);
            stringBuilder = this.append(stringBuilder, "replaceSynonymsInHighlight", this.replaceSynonyms);
            stringBuilder = this.append(stringBuilder, "distinct", this.distinct);
            stringBuilder = this.append(stringBuilder, "removeStopWords", this.removeStopWords);
            stringBuilder = this.append(stringBuilder, "advancedSyntax", this.advancedSyntax);
            stringBuilder = this.append(stringBuilder, "page", this.page);
            stringBuilder = this.append(stringBuilder, "minProximity", this.minProximity);
            if (this.highlightPreTag != null && this.highlightPostTag != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append("highlightPreTag=");
                stringBuilder.append(this.highlightPreTag);
                stringBuilder.append("&highlightPostTag=");
                stringBuilder.append(this.highlightPostTag);
            }
            if (this.snippetEllipsisText != null) {
                this.appendWithEncoding(stringBuilder, "snippetEllipsisText", this.snippetEllipsisText);
            }
            stringBuilder = this.append(stringBuilder, "hitsPerPage", this.hitsPerPage);
            stringBuilder = this.appendWithEncoding(stringBuilder, "tagFilters", this.tags);
            stringBuilder = this.appendWithEncoding(stringBuilder, "numericFilters", this.numerics);
            if (this.insideBoundingBox != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(this.insideBoundingBox);
            } else if (this.aroundLatLong != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(this.aroundLatLong);
            } else if (this.insidePolygon != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(this.insidePolygon);
            }
            stringBuilder = this.append(stringBuilder, "aroundLatLongViaIP", this.aroundLatLongViaIP);
            stringBuilder = this.append(stringBuilder, "aroundRadius", this.aroundRadius);
            stringBuilder = this.append(stringBuilder, "minimumAroundRadius", this.minimumAroundRadius);
            stringBuilder = this.append(stringBuilder, "aroundPrecision", this.aroundPrecision);
            stringBuilder = this.appendWithEncoding(stringBuilder, "query", this.query);
            stringBuilder = this.appendWithEncoding(stringBuilder, "similarQuery", this.similarQuery);
            stringBuilder = this.appendWithEncoding(stringBuilder, "facetQuery", this.facetQuery);
            stringBuilder = this.appendWithEncoding(stringBuilder, "facets", this.facets);
            stringBuilder = this.appendWithEncoding(stringBuilder, "filters", this.filters);
            stringBuilder = this.appendWithEncoding(stringBuilder, "facetFilters", this.facetFilters);
            stringBuilder = this.append(stringBuilder, "maxNumberOfFacets", this.maxNumberOfFacets);
            stringBuilder = this.appendWithEncoding(stringBuilder, "optionalWords", this.optionalWords);
            stringBuilder = this.appendWithEncoding(stringBuilder, "restrictSearchableAttributes", this.restrictSearchableAttributes);
            switch (this.queryType) {
                case PREFIX_ALL: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("queryType=prefixAll");
                    break;
                }
                case PREFIX_LAST: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("queryType=prefixLast");
                    break;
                }
                case PREFIX_NONE: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append("queryType=prefixNone");
                    break;
                }
            }
            stringBuilder = this.appendWithEncoding(stringBuilder, "referer", this.referers);
            stringBuilder = this.appendWithEncoding(stringBuilder, "userToken", this.userToken);
            stringBuilder = this.append(stringBuilder, "validUntil", this.validUntil);
            stringBuilder = this.append(stringBuilder, "restrictSources", this.restrictSources);
            stringBuilder = this.appendWithEncoding(stringBuilder, "restrictIndices", this.restrictIndices);
            stringBuilder = this.appendWithEncoding(stringBuilder, "exactOnSingleWordQuery", this.exactOnSingleWordQuery);
            stringBuilder = this.appendWithEncoding(stringBuilder, "alternativesAsExact", this.alternativesAsExact);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return stringBuilder.toString();
    }

    public Query setQueryString(String query) {
        this.query = query;
        return this;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public List<String> getAttributesToHighlight() {
        return this.attributesToHighlight;
    }

    public Query setAttributesToHighlight(List<String> attributes) {
        this.attributesToHighlight = attributes;
        return this;
    }

    public List<String> getAttributesToSnippet() {
        return this.attributesToSnippet;
    }

    public Query setAttributesToSnippet(List<String> attributes) {
        this.attributesToSnippet = attributes;
        return this;
    }

    public Integer getMinWordSizeForApprox1() {
        return this.minWordSizeForApprox1;
    }

    public Integer getMinWordSizeForApprox2() {
        return this.minWordSizeForApprox2;
    }

    public Boolean isGetRankingInfo() {
        return this.getRankingInfo;
    }

    public Boolean isIgnorePlural() {
        return this.ignorePlural;
    }

    public Boolean isDistinct() {
        return this.distinct > 0;
    }

    public Integer getDistinct() {
        return this.distinct;
    }

    public Boolean isAdvancedSyntax() {
        return this.advancedSyntax;
    }

    public Integer getPage() {
        return this.page;
    }

    public Query setPage(int page) {
        this.page = page;
        return this;
    }

    public Integer getHitsPerPage() {
        return this.hitsPerPage;
    }

    public Query setHitsPerPage(int nbHitsPerPage) {
        this.hitsPerPage = nbHitsPerPage;
        return this;
    }

    public String getRestrictSearchableAttributes() {
        return this.restrictSearchableAttributes;
    }

    public String getTags() {
        return this.tags;
    }

    public String getNumerics() {
        return this.numerics;
    }

    public String getInsideBoundingBox() {
        return this.insideBoundingBox;
    }

    public String getAroundLatLong() {
        return this.aroundLatLong;
    }

    public Boolean isAroundLatLongViaIP() {
        return this.aroundLatLongViaIP;
    }

    public String getQuery() {
        return this.query;
    }

    public String getSimilarQuery() {
        return this.similarQuery;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public Query setQueryType(QueryType type) {
        this.queryType = type;
        return this;
    }

    public String getOptionalWords() {
        return this.optionalWords;
    }

    public Query setOptionalWords(List<String> words) {
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            builder.append(word);
            builder.append(",");
        }
        this.optionalWords = builder.toString();
        return this;
    }

    public String getFacets() {
        return this.facets;
    }

    public Query setFacets(List<String> facets) {
        JSONArray obj = new JSONArray();
        for (String facet : facets) {
            obj.put((Object)facet);
        }
        this.facets = obj.toString();
        return this;
    }

    public String getFilters() {
        return this.filters;
    }

    public Query setFilters(String filters) {
        this.filters = filters;
        return this;
    }

    public String getFacetFilters() {
        return this.facetFilters;
    }

    public Query setFacetFilters(String facetFilters) {
        this.facetFilters = facetFilters;
        return this;
    }

    public Integer getMaxNumberOfFacets() {
        return this.maxNumberOfFacets;
    }

    public Query setMaxNumberOfFacets(int n) {
        this.maxNumberOfFacets = n;
        return this;
    }

    public Boolean isAnalytics() {
        return this.analytics;
    }

    public String getAnalyticsTags() {
        return this.analyticsTags;
    }

    public Query setAnalyticsTags(String analyticsTags) {
        this.analyticsTags = analyticsTags;
        return this;
    }

    public Boolean isSynonyms() {
        return this.synonyms;
    }

    public Boolean isReplaceSynonyms() {
        return this.replaceSynonyms;
    }

    public Boolean isAllowTyposOnNumericTokens() {
        return this.allowTyposOnNumericTokens;
    }

    public RemoveWordsType getRemoveWordsIfNoResult() {
        return this.removeWordsIfNoResult;
    }

    public TypoTolerance getTypoTolerance() {
        return this.typoTolerance;
    }

    public Query setTypoTolerance(TypoTolerance typoTolerance) {
        this.typoTolerance = typoTolerance;
        return this;
    }

    public Integer getValidUntil() {
        return this.validUntil;
    }

    public Query setValidUntil(Integer timestamp) {
        this.validUntil = timestamp;
        return this;
    }

    public String getRestrictIndices() {
        return this.restrictIndices;
    }

    Query setFacetQuery(String facetQuery) {
        this.facetQuery = facetQuery;
        return this;
    }

    public static enum TypoTolerance {
        TYPO_TRUE,
        TYPO_FALSE,
        TYPO_MIN,
        TYPO_STRICT,
        TYPO_NOTSET;

    }

    public static enum RemoveWordsType {
        REMOVE_LAST_WORDS,
        REMOVE_FIRST_WORDS,
        REMOVE_NONE,
        REMOVE_ALLOPTIONAL,
        REMOVE_NOTSET;

    }

    public static enum QueryType {
        PREFIX_ALL,
        PREFIX_LAST,
        PREFIX_NONE,
        PREFIX_NOTSET;

    }
}

