/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.saas;

import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.AlgoliaInnerException;
import com.algolia.search.saas.Index;
import com.algolia.search.saas.Query;
import com.algolia.search.saas.RequestOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.http.util.VersionInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class APIClient {
    private static final String version;
    private static final String fallbackDomain;
    private final String applicationID;
    private final String apiKey;
    private final List<String> buildHostsArray;
    private final List<String> queryHostsArray;
    private final HttpClient httpClient;
    private final boolean verbose;
    private int httpSocketTimeoutMS = 20000;
    private int httpConnectTimeoutMS = 2000;
    private int httpSearchTimeoutMS = 2000;
    private int hostDownTimeoutMS = 300000;
    private String forwardRateLimitAPIKey = null;
    private String forwardEndUserIP = null;
    private String forwardAdminAPIKey = null;
    private HashMap<String, String> headers;
    private String userAgent;
    private Map<String, HostStatus> hostStatuses = new HashMap<String, HostStatus>();

    public APIClient(String applicationID, String apiKey) {
        this(applicationID, apiKey, Arrays.asList(applicationID + "-1." + fallbackDomain, applicationID + "-2." + fallbackDomain, applicationID + "-3." + fallbackDomain));
        this.buildHostsArray.add(0, applicationID + ".algolia.net");
        this.queryHostsArray.add(0, applicationID + "-dsn.algolia.net");
    }

    public APIClient(String applicationID, String apiKey, List<String> hostsArray) {
        this(applicationID, apiKey, hostsArray, hostsArray);
    }

    public APIClient(String applicationID, String apiKey, List<String> buildHostsArray, List<String> queryHostsArray) {
        this.userAgent = "Algolia for Java (" + version + "); JVM (" + System.getProperty("java.version") + ")";
        this.verbose = System.getenv("VERBOSE") != null;
        if (applicationID == null || applicationID.length() == 0) {
            throw new RuntimeException("AlgoliaSearch requires an applicationID.");
        }
        this.applicationID = applicationID;
        if (apiKey == null || apiKey.length() == 0) {
            throw new RuntimeException("AlgoliaSearch requires an apiKey.");
        }
        this.apiKey = apiKey;
        if (buildHostsArray == null || buildHostsArray.size() == 0 || queryHostsArray == null || queryHostsArray.size() == 0) {
            throw new RuntimeException("AlgoliaSearch requires a list of hostnames.");
        }
        this.buildHostsArray = new ArrayList<String>(buildHostsArray);
        this.queryHostsArray = new ArrayList<String>(queryHostsArray);
        HttpClientBuilder builder = HttpClientBuilder.create().disableAutomaticRetries();
        if (System.getProperty("com.google.appengine.runtime.version") == null) {
            builder = builder.useSystemProperties();
        }
        this.httpClient = builder.build();
        this.headers = new HashMap();
    }

    private static String hmac(String key, String msg) {
        Mac hmac;
        try {
            hmac = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        try {
            hmac.init(new SecretKeySpec(key.getBytes(), "HmacSHA256"));
        }
        catch (InvalidKeyException e) {
            throw new Error(e);
        }
        byte[] rawHmac = hmac.doFinal(msg.getBytes());
        byte[] hexBytes = new Hex().encode(rawHmac);
        return new String(hexBytes);
    }

    static String getFallbackDomain() {
        boolean apacheClientHasSNI;
        String version = System.getProperty("java.version");
        int pos = version.indexOf(46);
        boolean javaHasSNI = Double.parseDouble(version.substring(0, pos = version.indexOf(46, pos + 1))) >= 1.7;
        VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.http.client", (ClassLoader)APIClient.class.getClassLoader());
        version = vi.getRelease();
        String[] split = version.split("\\.");
        int major = Integer.parseInt(split[0]);
        int minor = Integer.parseInt(split[1]);
        int patch = Integer.parseInt(split[2]);
        boolean bl = apacheClientHasSNI = major > 4 || major == 4 && minor > 3 || major == 4 && minor == 3 && patch >= 2;
        if (apacheClientHasSNI && javaHasSNI) {
            return "algolianet.com";
        }
        return "algolia.net";
    }

    public void setUserAgent(String agent, String agentVersion) {
        this.userAgent = String.format("Algolia for Java (%s); JVM (%s); %s (%s)", version, System.getProperty("java.version"), agent, agentVersion);
    }

    public void enableRateLimitForward(String adminAPIKey, String endUserIP, String rateLimitAPIKey) {
        this.forwardAdminAPIKey = adminAPIKey;
        this.forwardEndUserIP = endUserIP;
        this.forwardRateLimitAPIKey = rateLimitAPIKey;
    }

    public void disableRateLimitForward() {
        this.forwardRateLimitAPIKey = null;
        this.forwardEndUserIP = null;
        this.forwardAdminAPIKey = null;
    }

    public void setExtraHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setTimeout(int connectTimeout, int readTimeout) {
        this.httpSocketTimeoutMS = readTimeout;
        this.httpConnectTimeoutMS = connectTimeout;
    }

    public void setHostDownTimeoutMS(int hostDownTimeoutMS) {
        this.hostDownTimeoutMS = hostDownTimeoutMS;
    }

    public JSONObject listIndexes() throws AlgoliaException {
        return this.listIndexes(RequestOptions.empty);
    }

    public JSONObject listIndexes(RequestOptions requestOptions) throws AlgoliaException {
        return this.getRequest("/1/indexes/", false, requestOptions);
    }

    public JSONObject deleteIndex(String indexName) throws AlgoliaException {
        return this.deleteIndex(indexName, RequestOptions.empty);
    }

    public JSONObject deleteIndex(String indexName, RequestOptions requestOptions) throws AlgoliaException {
        try {
            return this.deleteRequest("/1/indexes/" + URLEncoder.encode(indexName, "UTF-8"), requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject moveIndex(String srcIndexName, String dstIndexName) throws AlgoliaException {
        return this.operationOnIndex("move", srcIndexName, dstIndexName, RequestOptions.empty);
    }

    public JSONObject moveIndex(String srcIndexName, String dstIndexName, RequestOptions requestOptions) throws AlgoliaException {
        return this.operationOnIndex("move", srcIndexName, dstIndexName, requestOptions);
    }

    public JSONObject copyIndex(String srcIndexName, String dstIndexName) throws AlgoliaException {
        return this.operationOnIndex("copy", srcIndexName, dstIndexName, RequestOptions.empty);
    }

    public JSONObject copyIndex(String srcIndexName, String dstIndexName, RequestOptions requestOptions) throws AlgoliaException {
        return this.operationOnIndex("copy", srcIndexName, dstIndexName, requestOptions);
    }

    private JSONObject operationOnIndex(String operation, String srcIndexName, String dstIndexName, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONObject content = new JSONObject();
            content.put("operation", (Object)operation);
            content.put("destination", (Object)dstIndexName);
            return this.postRequest("/1/indexes/" + URLEncoder.encode(srcIndexName, "UTF-8") + "/operation", content.toString(), true, false, requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject getLogs() throws AlgoliaException {
        return this.getLogs(RequestOptions.empty);
    }

    public JSONObject getLogs(RequestOptions requestOptions) throws AlgoliaException {
        return this.getRequest("/1/logs", false, requestOptions);
    }

    public JSONObject getLogs(int offset, int length) throws AlgoliaException {
        return this.getLogs(offset, length, LogType.LOG_ALL);
    }

    public JSONObject getLogs(int offset, int length, RequestOptions requestOptions) throws AlgoliaException {
        return this.getLogs(offset, length, LogType.LOG_ALL, requestOptions);
    }

    public JSONObject getLogs(int offset, int length, boolean onlyErrors) throws AlgoliaException {
        return this.getLogs(offset, length, onlyErrors ? LogType.LOG_ERROR : LogType.LOG_ALL);
    }

    public JSONObject getLogs(int offset, int length, boolean onlyErrors, RequestOptions requestOptions) throws AlgoliaException {
        return this.getLogs(offset, length, onlyErrors ? LogType.LOG_ERROR : LogType.LOG_ALL, requestOptions);
    }

    public JSONObject getLogs(int offset, int length, LogType logType) throws AlgoliaException {
        return this.getLogs(offset, length, logType, RequestOptions.empty);
    }

    public JSONObject getLogs(int offset, int length, LogType logType, RequestOptions requestOptions) throws AlgoliaException {
        String type = null;
        switch (logType) {
            case LOG_BUILD: {
                type = "build";
                break;
            }
            case LOG_QUERY: {
                type = "query";
                break;
            }
            case LOG_ERROR: {
                type = "error";
                break;
            }
            case LOG_ALL: {
                type = "all";
            }
        }
        return this.getRequest("/1/logs?offset=" + offset + "&length=" + length + "&type=" + type, false, requestOptions);
    }

    public Index initIndex(String indexName) {
        return new Index(this, indexName);
    }

    @Deprecated
    public JSONObject listUserKeys() throws AlgoliaException {
        return this.listApiKeys();
    }

    public JSONObject listApiKeys() throws AlgoliaException {
        return this.listApiKeys(RequestOptions.empty);
    }

    public JSONObject listApiKeys(RequestOptions requestOptions) throws AlgoliaException {
        return this.getRequest("/1/keys", false, requestOptions);
    }

    @Deprecated
    public JSONObject getUserKeyACL(String key) throws AlgoliaException {
        return this.getApiKey(key);
    }

    public JSONObject getApiKey(String key) throws AlgoliaException {
        return this.getApiKey(key, RequestOptions.empty);
    }

    public JSONObject getApiKey(String key, RequestOptions requestOptions) throws AlgoliaException {
        return this.getRequest("/1/keys/" + key, false, requestOptions);
    }

    @Deprecated
    public JSONObject deleteUserKey(String key) throws AlgoliaException {
        return this.deleteApiKey(key);
    }

    public JSONObject deleteApiKey(String key) throws AlgoliaException {
        return this.deleteApiKey(key, RequestOptions.empty);
    }

    public JSONObject deleteApiKey(String key, RequestOptions requestOptions) throws AlgoliaException {
        return this.deleteRequest("/1/keys/" + key, requestOptions);
    }

    @Deprecated
    public JSONObject addUserKey(JSONObject params) throws AlgoliaException {
        return this.addApiKey(params);
    }

    public JSONObject addApiKey(JSONObject params) throws AlgoliaException {
        return this.addApiKey(params, RequestOptions.empty);
    }

    public JSONObject addApiKey(JSONObject params, RequestOptions requestOptions) throws AlgoliaException {
        return this.postRequest("/1/keys", params.toString(), true, false, requestOptions);
    }

    @Deprecated
    public JSONObject addUserKey(List<String> acls) throws AlgoliaException {
        return this.addApiKey(acls);
    }

    public JSONObject addApiKey(List<String> acls) throws AlgoliaException {
        return this.addApiKey(acls, 0, 0, 0, null, RequestOptions.empty);
    }

    public JSONObject addApiKey(List<String> acls, RequestOptions requestOptions) throws AlgoliaException {
        return this.addApiKey(acls, 0, 0, 0, null, requestOptions);
    }

    @Deprecated
    public JSONObject updateUserKey(String key, JSONObject params) throws AlgoliaException {
        return this.updateApiKey(key, params);
    }

    public JSONObject updateApiKey(String key, JSONObject params) throws AlgoliaException {
        return this.updateApiKey(key, params, RequestOptions.empty);
    }

    public JSONObject updateApiKey(String key, JSONObject params, RequestOptions requestOptions) throws AlgoliaException {
        return this.putRequest("/1/keys/" + key, params.toString(), requestOptions);
    }

    @Deprecated
    public JSONObject updateUserKey(String key, List<String> acls) throws AlgoliaException {
        return this.updateApiKey(key, acls);
    }

    public JSONObject updateApiKey(String key, List<String> acls) throws AlgoliaException {
        return this.updateApiKey(key, acls, RequestOptions.empty);
    }

    public JSONObject updateApiKey(String key, List<String> acls, RequestOptions requestOptions) throws AlgoliaException {
        return this.updateApiKey(key, acls, 0, 0, 0, null, requestOptions);
    }

    @Deprecated
    public JSONObject addUserKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        return this.addApiKey(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery);
    }

    public JSONObject addApiKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        return this.addApiKey(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, null, RequestOptions.empty);
    }

    public JSONObject addApiKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, RequestOptions requestOptions) throws AlgoliaException {
        return this.addApiKey(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, null, requestOptions);
    }

    @Deprecated
    public JSONObject updateUserKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        return this.updateApiKey(key, acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery);
    }

    public JSONObject updateApiKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        return this.updateApiKey(key, acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, null, RequestOptions.empty);
    }

    public JSONObject updateApiKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, RequestOptions requestOptions) throws AlgoliaException {
        return this.updateApiKey(key, acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, null, requestOptions);
    }

    @Deprecated
    public JSONObject addUserKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, List<String> indexes) throws AlgoliaException {
        return this.addApiKey(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, indexes);
    }

    public JSONObject addApiKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, List<String> indexes) throws AlgoliaException {
        JSONObject jsonObject = this.generateUserKeyJson(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, indexes);
        return this.addApiKey(jsonObject);
    }

    public JSONObject addApiKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, List<String> indexes, RequestOptions requestOptions) throws AlgoliaException {
        JSONObject jsonObject = this.generateUserKeyJson(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, indexes);
        return this.addApiKey(jsonObject, requestOptions);
    }

    @Deprecated
    public JSONObject updateUserKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, List<String> indexes) throws AlgoliaException {
        return this.updateApiKey(key, acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, indexes);
    }

    public JSONObject updateApiKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, List<String> indexes) throws AlgoliaException {
        JSONObject jsonObject = this.generateUserKeyJson(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, indexes);
        return this.updateApiKey(key, jsonObject);
    }

    public JSONObject updateApiKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, List<String> indexes, RequestOptions requestOptions) throws AlgoliaException {
        JSONObject jsonObject = this.generateUserKeyJson(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, indexes);
        return this.updateApiKey(key, jsonObject, requestOptions);
    }

    private JSONObject generateUserKeyJson(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, List<String> indexes) {
        JSONArray array = new JSONArray(acls);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("acl", (Object)array);
            jsonObject.put("validity", validity);
            jsonObject.put("maxQueriesPerIPPerHour", maxQueriesPerIPPerHour);
            jsonObject.put("maxHitsPerQuery", maxHitsPerQuery);
            if (indexes != null) {
                jsonObject.put("indexes", (Object)new JSONArray(indexes));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return jsonObject;
    }

    @Deprecated
    public String generateSecuredApiKey(String privateApiKey, String tagFilters) throws NoSuchAlgorithmException, InvalidKeyException {
        if (!tagFilters.contains("=")) {
            return this.generateSecuredApiKey(privateApiKey, new Query().setTagFilters(tagFilters), null);
        }
        return Base64.encodeBase64String((byte[])String.format("%s%s", APIClient.hmac(privateApiKey, tagFilters), tagFilters).getBytes(Charset.forName("UTF8")));
    }

    public String generateSecuredApiKey(String privateApiKey, Query query) throws NoSuchAlgorithmException, InvalidKeyException {
        return this.generateSecuredApiKey(privateApiKey, query, null);
    }

    @Deprecated
    public String generateSecuredApiKey(String privateApiKey, String tagFilters, String userToken) throws NoSuchAlgorithmException, InvalidKeyException, AlgoliaException {
        if (!tagFilters.contains("=")) {
            return this.generateSecuredApiKey(privateApiKey, new Query().setTagFilters(tagFilters), userToken);
        }
        if (userToken != null && userToken.length() > 0) {
            try {
                tagFilters = String.format("%s%s%s", tagFilters, "&userToken=", URLEncoder.encode(userToken, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AlgoliaException(e.getMessage());
            }
        }
        return Base64.encodeBase64String((byte[])String.format("%s%s", APIClient.hmac(privateApiKey, tagFilters), tagFilters).getBytes(Charset.forName("UTF8")));
    }

    public String generateSecuredApiKey(String privateApiKey, Query query, String userToken) throws NoSuchAlgorithmException, InvalidKeyException {
        if (userToken != null && userToken.length() > 0) {
            query.setUserToken(userToken);
        }
        String queryStr = query.getQueryString();
        String key = APIClient.hmac(privateApiKey, queryStr);
        return Base64.encodeBase64String((byte[])String.format("%s%s", key, queryStr).getBytes(Charset.forName("UTF8")));
    }

    protected JSONObject getRequest(String url, boolean search, RequestOptions requestOptions) throws AlgoliaException {
        return this._request(Method.GET, url, null, false, search, requestOptions);
    }

    protected JSONObject deleteRequest(String url, RequestOptions requestOptions) throws AlgoliaException {
        return this._request(Method.DELETE, url, null, true, false, requestOptions);
    }

    protected JSONObject postRequest(String url, String obj, boolean build, boolean search, RequestOptions requestOptions) throws AlgoliaException {
        return this._request(Method.POST, url, obj, build, search, requestOptions);
    }

    protected JSONObject putRequest(String url, String obj, RequestOptions requestOptions) throws AlgoliaException {
        return this._request(Method.PUT, url, obj, true, false, requestOptions);
    }

    private JSONObject _requestByHost(HttpRequestBase req, String host, String url, String json, List<AlgoliaInnerException> errors, boolean searchTimeout, RequestOptions requestOptions) throws AlgoliaException {
        HttpResponse response;
        req.reset();
        try {
            req.setURI(new URI("https://" + host + url));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        req.setHeader("Accept-Encoding", "gzip");
        req.setHeader("X-Algolia-Application-Id", this.applicationID);
        if (this.forwardAdminAPIKey == null) {
            req.setHeader("X-Algolia-API-Key", this.apiKey);
        } else {
            req.setHeader("X-Algolia-API-Key", this.forwardAdminAPIKey);
            req.setHeader("X-Forwarded-For", this.forwardEndUserIP);
            req.setHeader("X-Forwarded-API-Key", this.forwardRateLimitAPIKey);
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            req.setHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : requestOptions.generateExtraHeaders().entrySet()) {
            req.setHeader(entry.getKey(), entry.getValue());
        }
        req.setHeader("User-Agent", this.userAgent);
        if (json != null) {
            if (!(req instanceof HttpEntityEnclosingRequestBase)) {
                throw new IllegalArgumentException("Method " + req.getMethod() + " cannot enclose entity");
            }
            req.setHeader("Content-type", "application/json");
            try {
                StringEntity se = new StringEntity(json, "UTF-8");
                se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
                ((HttpEntityEnclosingRequestBase)req).setEntity((HttpEntity)se);
            }
            catch (Exception e) {
                throw new AlgoliaException("Invalid JSON Object: " + json);
            }
        }
        RequestConfig config = RequestConfig.custom().setSocketTimeout(searchTimeout ? this.httpSearchTimeoutMS : this.httpSocketTimeoutMS).setConnectTimeout(this.httpConnectTimeoutMS).setConnectionRequestTimeout(this.httpConnectTimeoutMS).build();
        req.setConfig(config);
        try {
            response = this.httpClient.execute((HttpUriRequest)req);
        }
        catch (IOException e) {
            if (this.verbose) {
                System.out.println(String.format("%s: %s=%s", host, e.getClass().getName(), e.getMessage()));
            }
            errors.add(new AlgoliaInnerException(host, e));
            return null;
        }
        try {
            int read;
            String encoding;
            int code = response.getStatusLine().getStatusCode();
            if (code / 100 == 4) {
                String message = "";
                try {
                    message = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (code == 400) {
                    throw new AlgoliaException(code, message.length() > 0 ? message : "Bad request");
                }
                if (code == 403) {
                    throw new AlgoliaException(code, message.length() > 0 ? message : "Invalid Application-ID or API-Key");
                }
                if (code == 404) {
                    throw new AlgoliaException(code, message.length() > 0 ? message : "Resource does not exist");
                }
                throw new AlgoliaException(code, message.length() > 0 ? message : "Error");
            }
            if (code / 100 != 2) {
                try {
                    if (this.verbose) {
                        System.out.println(String.format("%s: %s", host, EntityUtils.toString((HttpEntity)response.getEntity())));
                    }
                    errors.add(new AlgoliaInnerException(host, EntityUtils.toString((HttpEntity)response.getEntity())));
                }
                catch (IOException e) {
                    if (this.verbose) {
                        System.out.println(String.format("%s: %s", host, String.valueOf(code)));
                    }
                    errors.add(new AlgoliaInnerException(host, e));
                }
                JSONObject e = null;
                return e;
            }
            InputStream istream = response.getEntity().getContent();
            String string = encoding = response.getEntity().getContentEncoding() != null ? response.getEntity().getContentEncoding().getValue() : null;
            if (encoding != null && encoding.contains("gzip")) {
                istream = new GZIPInputStream(istream);
            }
            InputStreamReader is = new InputStreamReader(istream, "UTF-8");
            StringBuilder jsonRaw = new StringBuilder();
            char[] buffer = new char[4096];
            while ((read = is.read(buffer)) > 0) {
                jsonRaw.append(buffer, 0, read);
            }
            is.close();
            JSONObject jSONObject = new JSONObject(jsonRaw.toString());
            return jSONObject;
        }
        finally {
            req.releaseConnection();
        }
    }

    private List<String> queryHostsThatAreUp() {
        return this.hostsThatAreUp(this.queryHostsArray);
    }

    private List<String> buildHostsThatAreUp() {
        return this.hostsThatAreUp(this.buildHostsArray);
    }

    private List<String> hostsThatAreUp(List<String> hosts) {
        ArrayList<String> result = new ArrayList<String>(hosts.size());
        for (String host : hosts) {
            if (!this.isHostUpOrCouldBeRetried(host)) continue;
            result.add(host);
        }
        return result;
    }

    private boolean isHostUpOrCouldBeRetried(String host) {
        HostStatus status = this.hostStatuses.get(host);
        if (status == null) {
            this.hostStatuses.put(host, HostStatus.up());
            return true;
        }
        return status.isUp || new Date().getTime() - status.lastModifiedTimestamp >= (long)this.hostDownTimeoutMS;
    }

    private JSONObject _request(Method m, String url, String json, boolean build, boolean search, RequestOptions requestOptions) throws AlgoliaException {
        HttpDelete req;
        switch (m) {
            case DELETE: {
                req = new HttpDelete();
                break;
            }
            case GET: {
                req = new HttpGet();
                break;
            }
            case POST: {
                req = new HttpPost();
                break;
            }
            case PUT: {
                req = new HttpPut();
                break;
            }
            default: {
                throw new IllegalArgumentException("Method " + (Object)((Object)m) + " is not supported");
            }
        }
        ArrayList<AlgoliaInnerException> errors = new ArrayList<AlgoliaInnerException>();
        List<String> hosts = build ? this.buildHostsThatAreUp() : this.queryHostsThatAreUp();
        for (String host : hosts) {
            JSONObject res = this._requestByHost((HttpRequestBase)req, host, url, json, errors, search, requestOptions);
            if (res != null) {
                this.hostStatuses.put(host, HostStatus.up());
                return res;
            }
            this.hostStatuses.put(host, HostStatus.down());
        }
        throw AlgoliaException.from("Hosts unreachable", errors);
    }

    public JSONObject multipleQueries(List<IndexQuery> queries) throws AlgoliaException {
        return this.multipleQueries(queries, "none", RequestOptions.empty);
    }

    public JSONObject multipleQueries(List<IndexQuery> queries, RequestOptions requestOptions) throws AlgoliaException {
        return this.multipleQueries(queries, "none", requestOptions);
    }

    public JSONObject multipleQueries(List<IndexQuery> queries, String strategy, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONArray requests = new JSONArray();
            for (IndexQuery indexQuery : queries) {
                String paramsString = indexQuery.getQuery().getQueryString();
                requests.put((Object)new JSONObject().put("indexName", (Object)indexQuery.getIndex()).put("params", (Object)paramsString));
            }
            JSONObject body = new JSONObject().put("requests", (Object)requests);
            return this.postRequest("/1/indexes/*/queries?strategy=" + strategy, body.toString(), false, true, requestOptions);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e);
        }
    }

    public JSONObject batch(JSONArray actions) throws AlgoliaException {
        return this.postBatch(actions, RequestOptions.empty);
    }

    public JSONObject batch(JSONArray actions, RequestOptions requestOptions) throws AlgoliaException {
        return this.postBatch(actions, requestOptions);
    }

    public JSONObject batch(List<JSONObject> actions) throws AlgoliaException {
        return this.postBatch(actions, RequestOptions.empty);
    }

    public JSONObject batch(List<JSONObject> actions, RequestOptions requestOptions) throws AlgoliaException {
        return this.postBatch(actions, requestOptions);
    }

    private JSONObject postBatch(Object actions, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONObject content = new JSONObject();
            content.put("requests", actions);
            return this.postRequest("/1/indexes/*/batch", content.toString(), true, false, requestOptions);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    static {
        String tmp = "N/A";
        try {
            InputStream versionStream = APIClient.class.getResourceAsStream("/version.properties");
            if (versionStream != null) {
                BufferedReader versionReader = new BufferedReader(new InputStreamReader(versionStream));
                tmp = versionReader.readLine();
                versionReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        version = tmp;
        fallbackDomain = APIClient.getFallbackDomain();
    }

    public static class IndexQuery {
        private String index;
        private Query query;

        public IndexQuery(String index, Query q) {
            this.index = index;
            this.query = q;
        }

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public Query getQuery() {
            return this.query;
        }

        public void setQuery(Query query) {
            this.query = query;
        }
    }

    private static class HostStatus {
        public boolean isUp = true;
        public long lastModifiedTimestamp = new Date().getTime();

        private HostStatus() {
        }

        public static HostStatus up() {
            return new HostStatus();
        }

        public static HostStatus down() {
            return new HostStatus().setDown();
        }

        private HostStatus setDown() {
            this.isUp = false;
            return this;
        }
    }

    private static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }

    public static enum LogType {
        LOG_QUERY,
        LOG_BUILD,
        LOG_ERROR,
        LOG_ALL;

    }
}

