/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.saas;

import com.algolia.search.saas.APIClient;
import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.Query;
import com.algolia.search.saas.RequestOptions;
import com.algolia.search.saas.RuleQuery;
import com.algolia.search.saas.SynonymQuery;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Index {
    private static final long MAX_TIME_MS_TO_WAIT = 10000L;
    private APIClient client;
    private String encodedIndexName;
    private String indexName;

    protected Index(APIClient client, String indexName) {
        try {
            this.client = client;
            this.encodedIndexName = URLEncoder.encode(indexName, "UTF-8");
            this.indexName = indexName;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public JSONObject addObject(JSONObject obj) throws AlgoliaException {
        return this.addObject(obj, RequestOptions.empty);
    }

    public JSONObject addObject(JSONObject obj, RequestOptions requestOptions) throws AlgoliaException {
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName, obj.toString(), true, false, requestOptions);
    }

    public JSONObject addObject(JSONObject obj, String objectID) throws AlgoliaException {
        return this.addObject(obj, objectID, RequestOptions.empty);
    }

    public JSONObject addObject(JSONObject obj, String objectID, RequestOptions requestOptions) throws AlgoliaException {
        try {
            return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8"), obj.toString(), requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject batch(JSONArray actions) throws AlgoliaException {
        return this.postBatch(actions, RequestOptions.empty);
    }

    public JSONObject batch(JSONArray actions, RequestOptions requestOptions) throws AlgoliaException {
        return this.postBatch(actions, requestOptions);
    }

    public JSONObject batch(List<JSONObject> actions) throws AlgoliaException {
        return this.postBatch(actions, RequestOptions.empty);
    }

    public JSONObject batch(List<JSONObject> actions, RequestOptions requestOptions) throws AlgoliaException {
        return this.postBatch(actions, requestOptions);
    }

    private JSONObject postBatch(Object actions, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONObject content = new JSONObject();
            content.put("requests", actions);
            return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/batch", content.toString(), true, false, requestOptions);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e);
        }
    }

    public JSONObject addObjects(List<JSONObject> objects) throws AlgoliaException {
        return this.addObjects(objects, RequestOptions.empty);
    }

    public JSONObject addObjects(List<JSONObject> objects, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (JSONObject obj : objects) {
                JSONObject action = new JSONObject();
                action.put("action", (Object)"addObject");
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array, requestOptions);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject addObjects(JSONArray objects) throws AlgoliaException {
        return this.addObjects(objects, RequestOptions.empty);
    }

    public JSONObject addObjects(JSONArray objects, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (int n = 0; n < objects.length(); ++n) {
                JSONObject action = new JSONObject();
                action.put("action", (Object)"addObject");
                action.put("body", (Object)objects.getJSONObject(n));
                array.put((Object)action);
            }
            return this.batch(array, requestOptions);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject getObject(String objectID) throws AlgoliaException {
        return this.getObject(objectID, RequestOptions.empty);
    }

    public JSONObject getObject(String objectID, RequestOptions requestOptions) throws AlgoliaException {
        try {
            return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8"), false, requestOptions);
        }
        catch (AlgoliaException e) {
            if (e.getCode() == 404) {
                return null;
            }
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject getObject(String objectID, List<String> attributesToRetrieve) throws AlgoliaException {
        return this.getObject(objectID, attributesToRetrieve, RequestOptions.empty);
    }

    public JSONObject getObject(String objectID, List<String> attributesToRetrieve, RequestOptions requestOptions) throws AlgoliaException {
        try {
            String params = this.encodeAttributes(attributesToRetrieve, true);
            return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8") + params.toString(), false, requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject getObjects(List<String> objectIDs) throws AlgoliaException {
        return this.getObjects(objectIDs, null, RequestOptions.empty);
    }

    public JSONObject getObjects(List<String> objectIDs, RequestOptions requestOptions) throws AlgoliaException {
        return this.getObjects(objectIDs, null, requestOptions);
    }

    public JSONObject getObjects(List<String> objectIDs, List<String> attributesToRetrieve) throws AlgoliaException {
        return this.getObjects(objectIDs, attributesToRetrieve, RequestOptions.empty);
    }

    public JSONObject getObjects(List<String> objectIDs, List<String> attributesToRetrieve, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONArray requests = new JSONArray();
            for (String id : objectIDs) {
                JSONObject request = new JSONObject();
                request.put("indexName", (Object)this.indexName);
                request.put("objectID", (Object)id);
                request.put("attributesToRetrieve", (Object)this.encodeAttributes(attributesToRetrieve, false));
                requests.put((Object)request);
            }
            JSONObject body = new JSONObject();
            body.put("requests", (Object)requests);
            return this.client.postRequest("/1/indexes/*/objects", body.toString(), false, false, requestOptions);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    private String encodeAttributes(List<String> attributesToRetrieve, boolean forURL) throws UnsupportedEncodingException {
        if (attributesToRetrieve == null) {
            return null;
        }
        StringBuilder params = new StringBuilder();
        if (forURL) {
            params.append("?attributes=");
        }
        for (int i = 0; i < attributesToRetrieve.size(); ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append(URLEncoder.encode(attributesToRetrieve.get(i), "UTF-8"));
        }
        return params.toString();
    }

    public JSONObject partialUpdateObject(JSONObject partialObject, String objectID) throws AlgoliaException {
        return this.partialUpdateObject(partialObject, objectID, true, RequestOptions.empty);
    }

    public JSONObject partialUpdateObject(JSONObject partialObject, String objectID, RequestOptions requestOptions) throws AlgoliaException {
        return this.partialUpdateObject(partialObject, objectID, true, requestOptions);
    }

    public JSONObject partialUpdateObjectNoCreate(JSONObject partialObject, String objectID) throws AlgoliaException {
        return this.partialUpdateObject(partialObject, objectID, false, RequestOptions.empty);
    }

    public JSONObject partialUpdateObjectNoCreate(JSONObject partialObject, String objectID, RequestOptions requestOptions) throws AlgoliaException {
        return this.partialUpdateObject(partialObject, objectID, false, requestOptions);
    }

    private JSONObject partialUpdateObject(JSONObject partialObject, String objectID, Boolean createIfNotExists, RequestOptions requestOptions) throws AlgoliaException {
        String parameters = "";
        if (!createIfNotExists.booleanValue()) {
            parameters = "?createIfNotExists=false";
        }
        try {
            return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8") + "/partial" + parameters, partialObject.toString(), true, false, requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject partialUpdateObjects(JSONArray objects) throws AlgoliaException {
        return this.partialUpdateObjects(objects, RequestOptions.empty);
    }

    public JSONObject partialUpdateObjects(JSONArray objects, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (int n = 0; n < objects.length(); ++n) {
                array.put((Object)this.partialUpdateObject(objects.getJSONObject(n)));
            }
            return this.batch(array, requestOptions);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject partialUpdateObjects(List<JSONObject> objects) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (JSONObject obj : objects) {
                array.put((Object)this.partialUpdateObject(obj));
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject partialUpdateObjects(List<JSONObject> objects, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (JSONObject obj : objects) {
                array.put((Object)this.partialUpdateObject(obj));
            }
            return this.batch(array, requestOptions);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    private JSONObject partialUpdateObject(JSONObject object) throws JSONException {
        JSONObject action = new JSONObject();
        action.put("action", (Object)"partialUpdateObject");
        action.put("objectID", (Object)object.getString("objectID"));
        action.put("body", (Object)object);
        return action;
    }

    public JSONObject saveObject(JSONObject object, String objectID) throws AlgoliaException {
        return this.saveObject(object, objectID, RequestOptions.empty);
    }

    public JSONObject saveObject(JSONObject object, String objectID, RequestOptions requestOptions) throws AlgoliaException {
        try {
            return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8"), object.toString(), requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject saveObjects(List<JSONObject> objects) throws AlgoliaException {
        return this.saveObjects(objects, RequestOptions.empty);
    }

    public JSONObject saveObjects(List<JSONObject> objects, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (JSONObject obj : objects) {
                JSONObject action = new JSONObject();
                action.put("action", (Object)"updateObject");
                action.put("objectID", (Object)obj.getString("objectID"));
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array, requestOptions);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject saveObjects(JSONArray objects) throws AlgoliaException {
        return this.saveObjects(objects, RequestOptions.empty);
    }

    public JSONObject saveObjects(JSONArray objects, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (int n = 0; n < objects.length(); ++n) {
                JSONObject obj = objects.getJSONObject(n);
                JSONObject action = new JSONObject();
                action.put("action", (Object)"updateObject");
                action.put("objectID", (Object)obj.getString("objectID"));
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array, requestOptions);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject deleteObject(String objectID) throws AlgoliaException {
        return this.deleteObject(objectID, RequestOptions.empty);
    }

    public JSONObject deleteObject(String objectID, RequestOptions requestOptions) throws AlgoliaException {
        if (objectID == null || objectID.length() == 0) {
            throw new AlgoliaException("Invalid objectID");
        }
        try {
            return this.client.deleteRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8"), requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteByQuery(Query query) throws AlgoliaException {
        this.deleteByQuery(query, 100000);
    }

    public void deleteByQuery(Query query, RequestOptions requestOptions) throws AlgoliaException {
        this.deleteByQuery(query, 100000, requestOptions);
    }

    public void deleteByQuery(Query query, int batchLimit) throws AlgoliaException {
        this.deleteByQuery(query, batchLimit, RequestOptions.empty);
    }

    public void deleteByQuery(Query query, int batchLimit, RequestOptions requestOptions) throws AlgoliaException {
        ArrayList<String> attributesToRetrieve = new ArrayList<String>();
        attributesToRetrieve.add("objectID");
        query.setAttributesToRetrieve(attributesToRetrieve);
        query.setAttributesToHighlight(new ArrayList<String>());
        query.setAttributesToSnippet(new ArrayList<String>());
        query.setHitsPerPage(1000);
        query.enableDistinct(false);
        IndexBrowser it = this.browse(query, requestOptions);
        try {
            do {
                ArrayList<String> objectIDs = new ArrayList<String>();
                while (it.hasNext()) {
                    JSONObject elt = it.next();
                    objectIDs.add(elt.getString("objectID"));
                    if (objectIDs.size() <= batchLimit) continue;
                    break;
                }
                JSONObject task = this.deleteObjects(objectIDs);
                this.waitTask(task.getString("taskID"));
            } while (it.hasNext());
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject search(Query params) throws AlgoliaException {
        return this.search(params, RequestOptions.empty);
    }

    public JSONObject search(Query params, RequestOptions requestOptions) throws AlgoliaException {
        String paramsString = params.getQueryString();
        JSONObject body = new JSONObject();
        try {
            body.put("params", (Object)paramsString);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/query", body.toString(), false, true, requestOptions);
    }

    public JSONObject searchInFacetValues(String facetName, String facetQuery, Query params) throws AlgoliaException {
        return this.searchInFacetValues(facetName, facetQuery, params, RequestOptions.empty);
    }

    public JSONObject searchInFacetValues(String facetName, String facetQuery, Query params, RequestOptions requestOptions) throws AlgoliaException {
        String encodedFacetName;
        params = params == null ? new Query() : params;
        String paramsString = params.setFacetQuery(facetQuery).getQueryString();
        JSONObject body = new JSONObject();
        try {
            encodedFacetName = URLEncoder.encode(facetName, "UTF-8");
            body.put("params", (Object)paramsString);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/facets/" + encodedFacetName + "/query", body.toString(), false, true, requestOptions);
    }

    public JSONObject deleteObjects(List<String> objects) throws AlgoliaException {
        return this.deleteObjects(objects, RequestOptions.empty);
    }

    public JSONObject deleteObjects(List<String> objects, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (String id : objects) {
                JSONObject obj = new JSONObject();
                obj.put("objectID", (Object)id);
                JSONObject action = new JSONObject();
                action.put("action", (Object)"deleteObject");
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array, requestOptions);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject browse(int page) throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/browse?page=" + page, false, RequestOptions.empty);
    }

    public IndexBrowser browse(Query params) throws AlgoliaException {
        return new IndexBrowser(this.client, this.encodedIndexName, params, null, RequestOptions.empty);
    }

    public IndexBrowser browse(Query params, RequestOptions requestOptions) throws AlgoliaException {
        return new IndexBrowser(this.client, this.encodedIndexName, params, null, requestOptions);
    }

    public IndexBrowser browseFrom(Query params, String cursor) throws AlgoliaException {
        return new IndexBrowser(this.client, this.encodedIndexName, params, cursor, RequestOptions.empty);
    }

    public IndexBrowser browseFrom(Query params, String cursor, RequestOptions requestOptions) throws AlgoliaException {
        return new IndexBrowser(this.client, this.encodedIndexName, params, cursor, requestOptions);
    }

    @Deprecated
    public IndexBrowser browseFrow(Query params, String cursor) throws AlgoliaException {
        return this.browseFrom(params, cursor);
    }

    public JSONObject browse(int page, int hitsPerPage) throws AlgoliaException {
        return this.browse(page, hitsPerPage, RequestOptions.empty);
    }

    public JSONObject browse(int page, int hitsPerPage, RequestOptions requestOptions) throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/browse?page=" + page + "&hitsPerPage=" + hitsPerPage, false, requestOptions);
    }

    public void waitTask(String taskID, long timeToWait) throws AlgoliaException {
        this.waitTask(taskID, timeToWait, RequestOptions.empty);
    }

    public void waitTask(String taskID, long timeToWait, RequestOptions requestOptions) throws AlgoliaException {
        try {
            while (true) {
                JSONObject obj;
                if ((obj = this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/task/" + URLEncoder.encode(taskID, "UTF-8"), false, requestOptions)).getString("status").equals("published")) {
                    return;
                }
                try {
                    Thread.sleep(timeToWait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                timeToWait = (timeToWait *= 2L) > 10000L ? 10000L : timeToWait;
            }
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitTask(String taskID) throws AlgoliaException {
        this.waitTask(taskID, 100L);
    }

    public JSONObject getSettings() throws AlgoliaException {
        return this.getSettings(RequestOptions.empty);
    }

    public JSONObject getSettings(RequestOptions requestOptions) throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/settings?getVersion=2", false, requestOptions);
    }

    public JSONObject clearIndex() throws AlgoliaException {
        return this.clearIndex(RequestOptions.empty);
    }

    public JSONObject clearIndex(RequestOptions requestOptions) throws AlgoliaException {
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/clear", "", true, false, requestOptions);
    }

    public JSONObject setSettings(JSONObject settings) throws AlgoliaException {
        return this.setSettings(settings, false);
    }

    public JSONObject setSettings(JSONObject settings, RequestOptions requestOptions) throws AlgoliaException {
        return this.setSettings(settings, false, requestOptions);
    }

    public JSONObject setSettings(JSONObject settings, Boolean forwardToReplicas) throws AlgoliaException {
        return this.setSettings(settings, forwardToReplicas, RequestOptions.empty);
    }

    public JSONObject setSettings(JSONObject settings, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/settings?forwardToReplicas=" + forwardToReplicas.toString(), settings.toString(), requestOptions);
    }

    @Deprecated
    public JSONObject listUserKeys() throws AlgoliaException {
        return this.listApiKeys();
    }

    public JSONObject listApiKeys() throws AlgoliaException {
        return this.listApiKeys(RequestOptions.empty);
    }

    public JSONObject listApiKeys(RequestOptions requestOptions) throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/keys", false, requestOptions);
    }

    @Deprecated
    public JSONObject getUserKeyACL(String key) throws AlgoliaException {
        return this.getApiKey(key);
    }

    public JSONObject getApiKey(String key) throws AlgoliaException {
        return this.getApiKey(key, RequestOptions.empty);
    }

    public JSONObject getApiKey(String key, RequestOptions requestOptions) throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/keys/" + key, false, requestOptions);
    }

    @Deprecated
    public JSONObject deleteUserKey(String key) throws AlgoliaException {
        return this.deleteApiKey(key);
    }

    public JSONObject deleteApiKey(String key) throws AlgoliaException {
        return this.deleteApiKey(key, RequestOptions.empty);
    }

    public JSONObject deleteApiKey(String key, RequestOptions requestOptions) throws AlgoliaException {
        return this.client.deleteRequest("/1/indexes/" + this.encodedIndexName + "/keys/" + key, requestOptions);
    }

    @Deprecated
    public JSONObject addUserKey(JSONObject params) throws AlgoliaException {
        return this.addApiKey(params);
    }

    public JSONObject addApiKey(JSONObject params) throws AlgoliaException {
        return this.addApiKey(params, RequestOptions.empty);
    }

    public JSONObject addApiKey(JSONObject params, RequestOptions requestOptions) throws AlgoliaException {
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/keys", params.toString(), true, false, requestOptions);
    }

    @Deprecated
    public JSONObject addUserKey(List<String> acls) throws AlgoliaException {
        return this.addApiKey(acls);
    }

    public JSONObject addApiKey(List<String> acls) throws AlgoliaException {
        return this.addApiKey(acls, 0, 0, 0);
    }

    @Deprecated
    public JSONObject updateUserKey(String key, JSONObject params) throws AlgoliaException {
        return this.updateApiKey(key, params);
    }

    public JSONObject updateApiKey(String key, JSONObject params) throws AlgoliaException {
        return this.updateApiKey(key, params, RequestOptions.empty);
    }

    public JSONObject updateApiKey(String key, JSONObject params, RequestOptions requestOptions) throws AlgoliaException {
        return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/keys/" + key, params.toString(), requestOptions);
    }

    @Deprecated
    public JSONObject updateUserKey(String key, List<String> acls) throws AlgoliaException {
        return this.updateApiKey(key, acls);
    }

    public JSONObject updateApiKey(String key, List<String> acls) throws AlgoliaException {
        return this.updateApiKey(key, acls, 0, 0, 0);
    }

    @Deprecated
    public JSONObject addUserKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        return this.addApiKey(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery);
    }

    public JSONObject addApiKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        return this.addApiKey(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, RequestOptions.empty);
    }

    public JSONObject addApiKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONObject jsonObject = this.generateUpdateUser(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery);
            return this.addApiKey(jsonObject, requestOptions);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public JSONObject updateUserKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        return this.updateApiKey(key, acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery, RequestOptions.empty);
    }

    public JSONObject updateApiKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        try {
            JSONObject jsonObject = this.generateUpdateUser(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery);
            return this.updateApiKey(key, jsonObject);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject updateApiKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery, RequestOptions requestOptions) throws AlgoliaException {
        try {
            JSONObject jsonObject = this.generateUpdateUser(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery);
            return this.updateApiKey(key, jsonObject, requestOptions);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONObject generateUpdateUser(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("acl", (Object)new JSONArray(acls));
        jsonObject.put("validity", validity);
        jsonObject.put("maxQueriesPerIPPerHour", maxQueriesPerIPPerHour);
        jsonObject.put("maxHitsPerQuery", maxHitsPerQuery);
        return jsonObject;
    }

    public JSONObject searchDisjunctiveFaceting(Query query, List<String> disjunctiveFacets, Map<String, List<String>> refinements) throws AlgoliaException {
        if (refinements == null) {
            refinements = new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> disjunctiveRefinements = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> elt : refinements.entrySet()) {
            if (!disjunctiveFacets.contains(elt.getKey())) continue;
            disjunctiveRefinements.put(elt.getKey(), elt.getValue());
        }
        ArrayList<APIClient.IndexQuery> queries = new ArrayList<APIClient.IndexQuery>();
        StringBuilder filters = new StringBuilder();
        boolean first_global = true;
        for (Map.Entry<String, List<String>> elt : refinements.entrySet()) {
            StringBuilder or = new StringBuilder();
            or.append("(");
            boolean bl = true;
            for (String val : elt.getValue()) {
                if (disjunctiveRefinements.containsKey(elt.getKey())) {
                    if (!bl) {
                        or.append(',');
                    }
                    bl = false;
                    or.append(String.format("%s:%s", elt.getKey(), val));
                    continue;
                }
                if (!first_global) {
                    filters.append(',');
                }
                first_global = false;
                filters.append(String.format("%s:%s", elt.getKey(), val));
            }
            if (!disjunctiveRefinements.containsKey(elt.getKey())) continue;
            or.append(')');
            if (!first_global) {
                filters.append(',');
            }
            first_global = false;
            filters.append(or.toString());
        }
        queries.add(new APIClient.IndexQuery(this.indexName, new Query(query).setFacetFilters(filters.toString())));
        for (String disjunctiveFacet : disjunctiveFacets) {
            filters = new StringBuilder();
            first_global = true;
            for (Map.Entry entry : refinements.entrySet()) {
                if (disjunctiveFacet.equals(entry.getKey())) continue;
                StringBuilder or = new StringBuilder();
                or.append("(");
                boolean first = true;
                for (String val : (List)entry.getValue()) {
                    if (disjunctiveRefinements.containsKey(entry.getKey())) {
                        if (!first) {
                            or.append(',');
                        }
                        first = false;
                        or.append(String.format("%s:%s", entry.getKey(), val));
                        continue;
                    }
                    if (!first_global) {
                        filters.append(',');
                    }
                    first_global = false;
                    filters.append(String.format("%s:%s", entry.getKey(), val));
                }
                if (!disjunctiveRefinements.containsKey(entry.getKey())) continue;
                or.append(')');
                if (!first_global) {
                    filters.append(',');
                }
                first_global = false;
                filters.append(or.toString());
            }
            ArrayList<String> facets = new ArrayList<String>();
            facets.add(disjunctiveFacet);
            queries.add(new APIClient.IndexQuery(this.indexName, new Query(query).setHitsPerPage(0).enableAnalytics(false).setAttributesToRetrieve(new ArrayList<String>()).setAttributesToHighlight(new ArrayList<String>()).setAttributesToSnippet(new ArrayList<String>()).setFacets(facets).setFacetFilters(filters.toString())));
        }
        JSONObject answers = this.client.multipleQueries(queries);
        try {
            JSONArray results = answers.getJSONArray("results");
            JSONObject aggregatedAnswer = results.getJSONObject(0);
            JSONObject jSONObject = new JSONObject();
            for (int i = 1; i < results.length(); ++i) {
                JSONObject facets = results.getJSONObject(i).getJSONObject("facets");
                Iterator keys = facets.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    jSONObject.put(key, (Object)facets.getJSONObject(key));
                    if (!disjunctiveRefinements.containsKey(key)) continue;
                    for (String refine : (List)disjunctiveRefinements.get(key)) {
                        if (jSONObject.getJSONObject(key).has(refine)) continue;
                        jSONObject.getJSONObject(key).put(refine, 0);
                    }
                }
            }
            aggregatedAnswer.put("disjunctiveFacets", (Object)jSONObject);
            return aggregatedAnswer;
        }
        catch (JSONException e) {
            throw new Error(e);
        }
    }

    public JSONObject searchDisjunctiveFaceting(Query query, List<String> disjunctiveFacets) throws AlgoliaException {
        return this.searchDisjunctiveFaceting(query, disjunctiveFacets, null);
    }

    public JSONObject searchSynonyms(SynonymQuery query) throws AlgoliaException, JSONException {
        return this.searchSynonyms(query, RequestOptions.empty);
    }

    public JSONObject searchSynonyms(SynonymQuery query, RequestOptions requestOptions) throws AlgoliaException, JSONException {
        JSONObject body = new JSONObject().put("query", (Object)query.getQueryString());
        if (query.hasTypes()) {
            StringBuilder type = new StringBuilder();
            boolean first = true;
            for (SynonymQuery.SynonymType t : query.getTypes()) {
                if (!first) {
                    type.append(",");
                }
                type.append(t.name);
                first = false;
            }
            body = body.put("type", (Object)type.toString());
        }
        if (query.getPage() != null) {
            body = body.put("page", (Object)query.getPage());
        }
        if (query.getHitsPerPage() != null) {
            body = body.put("hitsPerPage", (Object)query.getHitsPerPage());
        }
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/synonyms/search", body.toString(), false, true, requestOptions);
    }

    public JSONObject getSynonym(String objectID) throws AlgoliaException {
        return this.getSynonym(objectID, RequestOptions.empty);
    }

    public JSONObject getSynonym(String objectID, RequestOptions requestOptions) throws AlgoliaException {
        if (objectID == null || objectID.length() == 0) {
            throw new AlgoliaException("Invalid objectID");
        }
        try {
            return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/synonyms/" + URLEncoder.encode(objectID, "UTF-8"), true, requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject deleteSynonym(String objectID, boolean forwardToReplicas) throws AlgoliaException {
        return this.deleteSynonym(objectID, forwardToReplicas, RequestOptions.empty);
    }

    public JSONObject deleteSynonym(String objectID, boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        if (objectID == null || objectID.length() == 0) {
            throw new AlgoliaException("Invalid objectID");
        }
        try {
            return this.client.deleteRequest("/1/indexes/" + this.encodedIndexName + "/synonyms/" + URLEncoder.encode(objectID, "UTF-8") + "/?page=forwardToReplicas" + forwardToReplicas, requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject deleteSynonym(String objectID) throws AlgoliaException {
        return this.deleteSynonym(objectID, false);
    }

    public JSONObject deleteSynonym(String objectID, RequestOptions requestOptions) throws AlgoliaException {
        return this.deleteSynonym(objectID, false, requestOptions);
    }

    public JSONObject clearSynonyms(boolean forwardToReplicas) throws AlgoliaException {
        return this.clearSynonyms(forwardToReplicas, RequestOptions.empty);
    }

    public JSONObject clearSynonyms(boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/synonyms/clear?forwardToReplicas=" + forwardToReplicas, "", true, false, requestOptions);
    }

    public JSONObject clearSynonyms() throws AlgoliaException {
        return this.clearSynonyms(false);
    }

    public JSONObject clearSynonyms(RequestOptions requestOptions) throws AlgoliaException {
        return this.clearSynonyms(false, requestOptions);
    }

    public JSONObject batchSynonyms(List<JSONObject> objects, boolean forwardToReplicas, boolean replaceExistingSynonyms) throws AlgoliaException {
        return this.batchSynonyms(objects, forwardToReplicas, replaceExistingSynonyms, RequestOptions.empty);
    }

    public JSONObject batchSynonyms(List<JSONObject> objects, boolean forwardToReplicas, boolean replaceExistingSynonyms, RequestOptions requestOptions) throws AlgoliaException {
        JSONArray array = new JSONArray();
        for (JSONObject obj : objects) {
            array.put((Object)obj);
        }
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/synonyms/batch?forwardToReplicas=" + forwardToReplicas + "&replaceExistingSynonyms=" + replaceExistingSynonyms, array.toString(), true, false, requestOptions);
    }

    public JSONObject batchSynonyms(List<JSONObject> objects, boolean forwardToReplicas) throws AlgoliaException {
        return this.batchSynonyms(objects, forwardToReplicas, false);
    }

    public JSONObject batchSynonyms(List<JSONObject> objects, boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        return this.batchSynonyms(objects, forwardToReplicas, false, requestOptions);
    }

    public JSONObject batchSynonyms(List<JSONObject> objects) throws AlgoliaException {
        return this.batchSynonyms(objects, false, false);
    }

    public JSONObject batchSynonyms(List<JSONObject> objects, RequestOptions requestOptions) throws AlgoliaException {
        return this.batchSynonyms(objects, false, false, requestOptions);
    }

    public JSONObject saveSynonym(String objectID, JSONObject content, boolean forwardToReplicas) throws AlgoliaException {
        return this.saveSynonym(objectID, content, forwardToReplicas, RequestOptions.empty);
    }

    public JSONObject saveSynonym(String objectID, JSONObject content, boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        try {
            return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/synonyms/" + URLEncoder.encode(objectID, "UTF-8") + "?forwardToReplicas=" + forwardToReplicas, content.toString(), requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject saveSynonym(String objectID, JSONObject content) throws AlgoliaException {
        return this.saveSynonym(objectID, content, false);
    }

    public JSONObject saveSynonym(String objectID, JSONObject content, RequestOptions requestOptions) throws AlgoliaException {
        return this.saveSynonym(objectID, content, false, requestOptions);
    }

    public JSONObject saveRule(String objectID, JSONObject rule, boolean forwardToReplicas) throws AlgoliaException {
        return this.saveRule(objectID, rule, forwardToReplicas, RequestOptions.empty);
    }

    public JSONObject saveRule(String objectID, JSONObject rule, boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        try {
            return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/rules/" + URLEncoder.encode(objectID, "UTF-8") + "?forwardToReplicas=" + forwardToReplicas, rule.toString(), requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject saveRule(String objectID, JSONObject rule) throws AlgoliaException {
        return this.saveRule(objectID, rule, false);
    }

    public JSONObject batchRules(List<JSONObject> rules, boolean forwardToReplicas, boolean clearExistingRules) throws AlgoliaException {
        return this.batchRules(rules, forwardToReplicas, clearExistingRules, RequestOptions.empty);
    }

    public JSONObject batchRules(List<JSONObject> rules, boolean forwardToReplicas, boolean clearExistingRules, RequestOptions requestOptions) throws AlgoliaException {
        JSONArray array = new JSONArray();
        for (JSONObject obj : rules) {
            array.put((Object)obj);
        }
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/rules/batch?forwardToReplicas=" + forwardToReplicas + "&clearExistingRules=" + clearExistingRules, array.toString(), true, false, requestOptions);
    }

    public JSONObject batchRules(List<JSONObject> rules, boolean forwardToReplicas) throws AlgoliaException {
        return this.batchRules(rules, forwardToReplicas, false);
    }

    public JSONObject batchRules(List<JSONObject> rules) throws AlgoliaException {
        return this.batchRules(rules, false, false);
    }

    public JSONObject getRule(String objectID) throws AlgoliaException {
        return this.getRule(objectID, RequestOptions.empty);
    }

    public JSONObject getRule(String objectID, RequestOptions requestOptions) throws AlgoliaException {
        if (objectID == null || objectID.length() == 0) {
            throw new AlgoliaException("Invalid objectID");
        }
        try {
            return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/rules/" + URLEncoder.encode(objectID, "UTF-8"), true, requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject deleteRule(String objectID) throws AlgoliaException {
        return this.deleteRule(objectID, RequestOptions.empty);
    }

    public JSONObject deleteRule(String objectID, RequestOptions requestOptions) throws AlgoliaException {
        if (objectID == null || objectID.length() == 0) {
            throw new AlgoliaException("Invalid objectID");
        }
        try {
            return this.client.deleteRequest("/1/indexes/" + this.encodedIndexName + "/rules/" + URLEncoder.encode(objectID, "UTF-8"), requestOptions);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject clearRules(boolean forwardToReplicas) throws AlgoliaException {
        return this.clearRules(forwardToReplicas, RequestOptions.empty);
    }

    public JSONObject clearRules(boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaException {
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/rules/clear?forwardToReplicas=" + forwardToReplicas, "", true, false, requestOptions);
    }

    public JSONObject clearRules() throws AlgoliaException {
        return this.clearRules(false);
    }

    public JSONObject searchRules(RuleQuery query) throws AlgoliaException, JSONException {
        return this.searchRules(query, RequestOptions.empty);
    }

    public JSONObject searchRules(RuleQuery query, RequestOptions requestOptions) throws AlgoliaException, JSONException {
        JSONObject body = new JSONObject();
        if (query.getQuery() != null) {
            body = body.put("query", (Object)query.getQuery());
        }
        if (query.getAnchoring() != null) {
            body = body.put("anchoring", (Object)query.getAnchoring());
        }
        if (query.getContext() != null) {
            body = body.put("context", (Object)query.getContext());
        }
        if (query.getPage() != null) {
            body = body.put("page", (Object)query.getPage());
        }
        if (query.getHitsPerPage() != null) {
            body = body.put("hitsPerPage", (Object)query.getHitsPerPage());
        }
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/rules/search", body.toString(), false, true, requestOptions);
    }

    public static class IndexBrowser
    implements Iterator<JSONObject> {
        final APIClient client;
        final Query params;
        final String encodedIndexName;
        final RequestOptions requestOptions;
        JSONObject answer;
        JSONObject hit;
        int pos;

        IndexBrowser(APIClient client, String encodedIndexName, Query params, String startingCursor, RequestOptions requestOptions) throws AlgoliaException {
            this.client = client;
            this.params = params;
            this.encodedIndexName = encodedIndexName;
            this.requestOptions = requestOptions;
            this.doQuery(startingCursor);
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.pos < this.answer.getJSONArray("hits").length() || this.answer.has("cursor") && !this.answer.getString("cursor").isEmpty();
            }
            catch (JSONException e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public JSONObject next() {
            block5: {
                try {
                    while (true) {
                        if (this.pos < this.answer.getJSONArray("hits").length()) {
                            this.hit = this.answer.getJSONArray("hits").getJSONObject(this.pos);
                            ++this.pos;
                            break block5;
                        }
                        if (!this.answer.has("cursor") || this.answer.getString("cursor").isEmpty()) break;
                        this.pos = 0;
                        this.doQuery(this.getCursor());
                    }
                    return null;
                }
                catch (JSONException e) {
                    throw new IllegalStateException(e);
                }
                catch (AlgoliaException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return this.hit;
        }

        public String getCursor() {
            try {
                return this.answer != null && this.answer.has("cursor") ? this.answer.getString("cursor") : null;
            }
            catch (JSONException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Cannot remove while browsing");
        }

        private void doQuery(String cursor) throws AlgoliaException {
            String paramsString = this.params.getQueryString();
            if (cursor != null) {
                try {
                    paramsString = paramsString + (paramsString.length() > 0 ? "&" : "") + "cursor=" + URLEncoder.encode(cursor, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.answer = this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/browse" + (paramsString.length() > 0 ? "?" + paramsString : ""), true, this.requestOptions);
        }
    }

    static class IndexBrower
    extends IndexBrowser {
        IndexBrower(APIClient client, String encodedIndexName, Query params, String startingCursor) throws AlgoliaException {
            super(client, encodedIndexName, params, startingCursor, RequestOptions.empty);
        }
    }
}

