/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.saas;

import com.algolia.search.saas.APIClient;
import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.Query;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Index {
    private APIClient client;
    private String encodedIndexName;
    private String indexName;
    private final long MAX_TIME_MS_TO_WAIT = 10000L;

    protected Index(APIClient client, String indexName) {
        try {
            this.client = client;
            this.encodedIndexName = URLEncoder.encode(indexName, "UTF-8");
            this.indexName = indexName;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public JSONObject addObject(JSONObject obj) throws AlgoliaException {
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName, obj.toString(), true, false);
    }

    public JSONObject addObject(JSONObject obj, String objectID) throws AlgoliaException {
        try {
            return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8"), obj.toString(), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject batch(JSONArray actions) throws AlgoliaException {
        try {
            JSONObject content = new JSONObject();
            content.put("requests", (Object)actions);
            return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/batch", content.toString(), true, false);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject batch(List<JSONObject> actions) throws AlgoliaException {
        try {
            JSONObject content = new JSONObject();
            content.put("requests", actions);
            return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/batch", content.toString(), true, false);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject addObjects(List<JSONObject> objects) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (JSONObject obj : objects) {
                JSONObject action = new JSONObject();
                action.put("action", (Object)"addObject");
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject addObjects(JSONArray inputArray) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (int n = 0; n < inputArray.length(); ++n) {
                JSONObject action = new JSONObject();
                action.put("action", (Object)"addObject");
                action.put("body", (Object)inputArray.getJSONObject(n));
                array.put((Object)action);
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject getObject(String objectID) throws AlgoliaException {
        try {
            return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8"), false);
        }
        catch (AlgoliaException e) {
            if (e.getCode() == 404) {
                return null;
            }
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject getObject(String objectID, List<String> attributesToRetrieve) throws AlgoliaException {
        try {
            StringBuilder params = new StringBuilder();
            params.append("?attributes=");
            for (int i = 0; i < attributesToRetrieve.size(); ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append(URLEncoder.encode(attributesToRetrieve.get(i), "UTF-8"));
            }
            return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8") + params.toString(), false);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject getObjects(List<String> objectIDs) throws AlgoliaException {
        try {
            JSONArray requests = new JSONArray();
            for (String id : objectIDs) {
                JSONObject request = new JSONObject();
                request.put("indexName", (Object)this.indexName);
                request.put("objectID", (Object)id);
                requests.put((Object)request);
            }
            JSONObject body = new JSONObject();
            body.put("requests", (Object)requests);
            return this.client.postRequest("/1/indexes/*/objects", body.toString(), false, false);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject partialUpdateObject(JSONObject partialObject, String objectID) throws AlgoliaException {
        try {
            return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8") + "/partial", partialObject.toString(), true, false);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject partialUpdateObjects(JSONArray inputArray) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (int n = 0; n < inputArray.length(); ++n) {
                JSONObject obj = inputArray.getJSONObject(n);
                JSONObject action = new JSONObject();
                action.put("action", (Object)"partialUpdateObject");
                action.put("objectID", (Object)obj.getString("objectID"));
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject partialUpdateObjects(List<JSONObject> objects) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (JSONObject obj : objects) {
                JSONObject action = new JSONObject();
                action.put("action", (Object)"partialUpdateObject");
                action.put("objectID", (Object)obj.getString("objectID"));
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject saveObject(JSONObject object, String objectID) throws AlgoliaException {
        try {
            return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8"), object.toString(), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject saveObjects(List<JSONObject> objects) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (JSONObject obj : objects) {
                JSONObject action = new JSONObject();
                action.put("action", (Object)"updateObject");
                action.put("objectID", (Object)obj.getString("objectID"));
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject saveObjects(JSONArray inputArray) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (int n = 0; n < inputArray.length(); ++n) {
                JSONObject obj = inputArray.getJSONObject(n);
                JSONObject action = new JSONObject();
                action.put("action", (Object)"updateObject");
                action.put("objectID", (Object)obj.getString("objectID"));
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject deleteObject(String objectID) throws AlgoliaException {
        if (objectID.length() == 0 || objectID == null) {
            throw new AlgoliaException("Invalid objectID");
        }
        try {
            return this.client.deleteRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8"), false);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteByQuery(Query query) throws AlgoliaException {
        ArrayList<String> attributesToRetrieve = new ArrayList<String>();
        attributesToRetrieve.add("objectID");
        query.setAttributesToRetrieve(attributesToRetrieve);
        query.setHitsPerPage(1000);
        JSONObject results = this.search(query);
        try {
            while (results.getInt("nbHits") != 0) {
                ArrayList<String> objectIDs = new ArrayList<String>();
                for (int i = 0; i < results.getJSONArray("hits").length(); ++i) {
                    JSONObject hit = results.getJSONArray("hits").getJSONObject(i);
                    objectIDs.add(hit.getString("objectID"));
                }
                JSONObject task = this.deleteObjects(objectIDs);
                this.waitTask(task.getString("taskID"));
                results = this.search(query);
            }
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject search(Query params) throws AlgoliaException {
        String paramsString = params.getQueryString();
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + (paramsString.length() > 0 ? "?" + paramsString : ""), true);
    }

    public JSONObject deleteObjects(List<String> objects) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (String id : objects) {
                JSONObject obj = new JSONObject();
                obj.put("objectID", (Object)id);
                JSONObject action = new JSONObject();
                action.put("action", (Object)"deleteObject");
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject browse(int page) throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/browse?page=" + page, false);
    }

    public JSONObject browse(int page, int hitsPerPage) throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/browse?page=" + page + "&hitsPerPage=" + hitsPerPage, false);
    }

    public void waitTask(String taskID, long timeToWait) throws AlgoliaException {
        try {
            while (true) {
                JSONObject obj;
                if ((obj = this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/task/" + URLEncoder.encode(taskID, "UTF-8"), false)).getString("status").equals("published")) {
                    return;
                }
                try {
                    Thread.sleep(timeToWait > 10000L ? 10000L : timeToWait);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                timeToWait *= 2L;
            }
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitTask(String taskID) throws AlgoliaException {
        this.waitTask(taskID, 100L);
    }

    public JSONObject getSettings() throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/settings", false);
    }

    public JSONObject clearIndex() throws AlgoliaException {
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/clear", "", true, false);
    }

    public JSONObject setSettings(JSONObject settings) throws AlgoliaException {
        return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/settings", settings.toString(), true);
    }

    public JSONObject listUserKeys() throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/keys", false);
    }

    public JSONObject getUserKeyACL(String key) throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/keys/" + key, false);
    }

    public JSONObject deleteUserKey(String key) throws AlgoliaException {
        return this.client.deleteRequest("/1/indexes/" + this.encodedIndexName + "/keys/" + key, true);
    }

    public JSONObject addUserKey(List<String> acls) throws AlgoliaException {
        JSONArray array = new JSONArray(acls);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("acl", (Object)array);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/keys", jsonObject.toString(), true, false);
    }

    public JSONObject updateUserKey(String key, List<String> acls) throws AlgoliaException {
        JSONArray array = new JSONArray(acls);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("acl", (Object)array);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/keys/" + key, jsonObject.toString(), true);
    }

    public JSONObject addUserKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        JSONArray array = new JSONArray(acls);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("acl", (Object)array);
            jsonObject.put("validity", validity);
            jsonObject.put("maxQueriesPerIPPerHour", maxQueriesPerIPPerHour);
            jsonObject.put("maxHitsPerQuery", maxHitsPerQuery);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/keys", jsonObject.toString(), true, false);
    }

    public JSONObject updateUserKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        JSONArray array = new JSONArray(acls);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("acl", (Object)array);
            jsonObject.put("validity", validity);
            jsonObject.put("maxQueriesPerIPPerHour", maxQueriesPerIPPerHour);
            jsonObject.put("maxHitsPerQuery", maxHitsPerQuery);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/keys/" + key, jsonObject.toString(), true);
    }

    public JSONObject searchDisjunctiveFaceting(Query query, List<String> disjunctiveFacets, Map<String, List<String>> refinements) throws AlgoliaException {
        if (refinements == null) {
            refinements = new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> disjunctiveRefinements = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> elt : refinements.entrySet()) {
            if (!disjunctiveFacets.contains(elt.getKey())) continue;
            disjunctiveRefinements.put(elt.getKey(), elt.getValue());
        }
        ArrayList<APIClient.IndexQuery> queries = new ArrayList<APIClient.IndexQuery>();
        StringBuilder filters = new StringBuilder();
        boolean first_global = true;
        for (Map.Entry<String, List<String>> elt : refinements.entrySet()) {
            StringBuilder or = new StringBuilder();
            or.append("(");
            boolean first = true;
            for (String val : elt.getValue()) {
                if (disjunctiveRefinements.containsKey(elt.getKey())) {
                    if (!first) {
                        or.append(',');
                    }
                    first = false;
                    or.append(String.format("%s:%s", elt.getKey(), val));
                    continue;
                }
                if (!first_global) {
                    filters.append(',');
                }
                first_global = false;
                filters.append(String.format("%s:%s", elt.getKey(), val));
            }
            if (!disjunctiveRefinements.containsKey(elt.getKey())) continue;
            or.append(')');
            if (!first_global) {
                filters.append(',');
            }
            first_global = false;
            filters.append(or.toString());
        }
        queries.add(new APIClient.IndexQuery(this.indexName, new Query(query).setFacetFilters(filters.toString())));
        for (String disjunctiveFacet : disjunctiveFacets) {
            filters = new StringBuilder();
            first_global = true;
            for (Map.Entry<String, List<String>> elt : refinements.entrySet()) {
                if (disjunctiveFacet.equals(elt.getKey())) continue;
                StringBuilder or = new StringBuilder();
                or.append("(");
                boolean first = true;
                for (String val : elt.getValue()) {
                    if (disjunctiveRefinements.containsKey(elt.getKey())) {
                        if (!first) {
                            or.append(',');
                        }
                        first = false;
                        or.append(String.format("%s:%s", elt.getKey(), val));
                        continue;
                    }
                    if (!first_global) {
                        filters.append(',');
                    }
                    first_global = false;
                    filters.append(String.format("%s:%s", elt.getKey(), val));
                }
                if (!disjunctiveRefinements.containsKey(elt.getKey())) continue;
                or.append(')');
                if (!first_global) {
                    filters.append(',');
                }
                first_global = false;
                filters.append(or.toString());
            }
            ArrayList<String> facets = new ArrayList<String>();
            facets.add(disjunctiveFacet);
            queries.add(new APIClient.IndexQuery(this.indexName, new Query(query).setHitsPerPage(0).enableAnalytics(false).setAttributesToRetrieve(new ArrayList<String>()).setAttributesToHighlight(new ArrayList<String>()).setAttributesToSnippet(new ArrayList<String>()).setFacets(facets).setFacetFilters(filters.toString())));
        }
        JSONObject answers = this.client.multipleQueries(queries);
        try {
            JSONArray results = answers.getJSONArray("results");
            JSONObject aggregatedAnswer = results.getJSONObject(0);
            JSONObject disjunctiveFacetsJSON = new JSONObject();
            for (int i = 1; i < results.length(); ++i) {
                JSONObject facets = results.getJSONObject(i).getJSONObject("facets");
                Iterator keys = facets.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    disjunctiveFacetsJSON.put(key, (Object)facets.getJSONObject(key));
                    if (!disjunctiveRefinements.containsKey(key)) continue;
                    for (String refine : (List)disjunctiveRefinements.get(key)) {
                        if (disjunctiveFacetsJSON.getJSONObject(key).has(refine)) continue;
                        disjunctiveFacetsJSON.getJSONObject(key).put(refine, 0);
                    }
                }
            }
            aggregatedAnswer.put("disjunctiveFacets", (Object)disjunctiveFacetsJSON);
            return aggregatedAnswer;
        }
        catch (JSONException e) {
            throw new Error(e);
        }
    }

    public JSONObject searchDisjunctiveFaceting(Query query, List<String> disjunctiveFacets) throws AlgoliaException {
        return this.searchDisjunctiveFaceting(query, disjunctiveFacets, null);
    }
}

