/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.saas;

import com.algolia.search.saas.AlgoliaInnerException;
import java.util.List;

public class AlgoliaException
extends Exception {
    private final int code;
    private static final long serialVersionUID = 1L;

    public AlgoliaException(Throwable cause) {
        super(cause);
        this.code = 0;
    }

    public AlgoliaException(String message) {
        this(0, message);
    }

    public AlgoliaException(int code, String message) {
        super(message);
        this.code = code;
    }

    public AlgoliaException(String message, Throwable cause) {
        super(message, cause);
        this.code = 0;
    }

    public int getCode() {
        return this.code;
    }

    public static AlgoliaException from(String message, List<AlgoliaInnerException> errorsByHost) {
        AlgoliaInnerException lastException = null;
        if (!errorsByHost.isEmpty()) {
            lastException = errorsByHost.get(errorsByHost.size() - 1);
        }
        StringBuilder m = new StringBuilder(message);
        for (AlgoliaInnerException e : errorsByHost) {
            m.append("\n").append(e.getHost()).append(": ").append(e.getMessage());
        }
        return new AlgoliaException(m.toString(), lastException);
    }
}

