/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search.saas;

import com.algolia.search.saas.APIClient;
import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.Query;
import com.algolia.search.saas.SynonymQuery;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Index {
    private static final long MAX_TIME_MS_TO_WAIT = 10000L;
    private APIClient client;
    private String encodedIndexName;
    private String indexName;

    protected Index(APIClient client, String indexName) {
        try {
            this.client = client;
            this.encodedIndexName = URLEncoder.encode(indexName, "UTF-8");
            this.indexName = indexName;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public JSONObject addObject(JSONObject obj) throws AlgoliaException {
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName, obj.toString(), true, false);
    }

    public JSONObject addObject(JSONObject obj, String objectID) throws AlgoliaException {
        try {
            return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8"), obj.toString(), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject batch(JSONArray actions) throws AlgoliaException {
        return this.postBatch(actions);
    }

    public JSONObject batch(List<JSONObject> actions) throws AlgoliaException {
        return this.postBatch(actions);
    }

    private JSONObject postBatch(Object actions) throws AlgoliaException {
        try {
            JSONObject content = new JSONObject();
            content.put("requests", actions);
            return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/batch", content.toString(), true, false);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e);
        }
    }

    public JSONObject addObjects(List<JSONObject> objects) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (JSONObject obj : objects) {
                JSONObject action = new JSONObject();
                action.put("action", (Object)"addObject");
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject addObjects(JSONArray objects) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (int n = 0; n < objects.length(); ++n) {
                JSONObject action = new JSONObject();
                action.put("action", (Object)"addObject");
                action.put("body", (Object)objects.getJSONObject(n));
                array.put((Object)action);
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject getObject(String objectID) throws AlgoliaException {
        try {
            return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8"), false);
        }
        catch (AlgoliaException e) {
            if (e.getCode() == 404) {
                return null;
            }
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject getObject(String objectID, List<String> attributesToRetrieve) throws AlgoliaException {
        try {
            String params = this.encodeAttributes(attributesToRetrieve, true);
            return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8") + params.toString(), false);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject getObjects(List<String> objectIDs) throws AlgoliaException {
        return this.getObjects(objectIDs, null);
    }

    public JSONObject getObjects(List<String> objectIDs, List<String> attributesToRetrieve) throws AlgoliaException {
        try {
            JSONArray requests = new JSONArray();
            for (String id : objectIDs) {
                JSONObject request = new JSONObject();
                request.put("indexName", (Object)this.indexName);
                request.put("objectID", (Object)id);
                request.put("attributesToRetrieve", (Object)this.encodeAttributes(attributesToRetrieve, false));
                requests.put((Object)request);
            }
            JSONObject body = new JSONObject();
            body.put("requests", (Object)requests);
            return this.client.postRequest("/1/indexes/*/objects", body.toString(), false, false);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    private String encodeAttributes(List<String> attributesToRetrieve, boolean forURL) throws UnsupportedEncodingException {
        if (attributesToRetrieve == null) {
            return null;
        }
        StringBuilder params = new StringBuilder();
        if (forURL) {
            params.append("?attributes=");
        }
        for (int i = 0; i < attributesToRetrieve.size(); ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append(URLEncoder.encode(attributesToRetrieve.get(i), "UTF-8"));
        }
        return params.toString();
    }

    public JSONObject partialUpdateObject(JSONObject partialObject, String objectID) throws AlgoliaException {
        return this.partialUpdateObject(partialObject, objectID, true);
    }

    public JSONObject partialUpdateObjectNoCreate(JSONObject partialObject, String objectID) throws AlgoliaException {
        return this.partialUpdateObject(partialObject, objectID, false);
    }

    private JSONObject partialUpdateObject(JSONObject partialObject, String objectID, Boolean createIfNotExists) throws AlgoliaException {
        String parameters = "";
        if (!createIfNotExists.booleanValue()) {
            parameters = "?createIfNotExists=false";
        }
        try {
            return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8") + "/partial" + parameters, partialObject.toString(), true, false);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject partialUpdateObjects(JSONArray objects) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (int n = 0; n < objects.length(); ++n) {
                array.put((Object)this.partialUpdateObject(objects.getJSONObject(n)));
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject partialUpdateObjects(List<JSONObject> objects) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (JSONObject obj : objects) {
                array.put((Object)this.partialUpdateObject(obj));
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    private JSONObject partialUpdateObject(JSONObject object) throws JSONException {
        JSONObject action = new JSONObject();
        action.put("action", (Object)"partialUpdateObject");
        action.put("objectID", (Object)object.getString("objectID"));
        action.put("body", (Object)object);
        return action;
    }

    public JSONObject saveObject(JSONObject object, String objectID) throws AlgoliaException {
        try {
            return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8"), object.toString(), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject saveObjects(List<JSONObject> objects) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (JSONObject obj : objects) {
                JSONObject action = new JSONObject();
                action.put("action", (Object)"updateObject");
                action.put("objectID", (Object)obj.getString("objectID"));
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject saveObjects(JSONArray objects) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (int n = 0; n < objects.length(); ++n) {
                JSONObject obj = objects.getJSONObject(n);
                JSONObject action = new JSONObject();
                action.put("action", (Object)"updateObject");
                action.put("objectID", (Object)obj.getString("objectID"));
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject deleteObject(String objectID) throws AlgoliaException {
        if (objectID == null || objectID.length() == 0) {
            throw new AlgoliaException("Invalid objectID");
        }
        try {
            return this.client.deleteRequest("/1/indexes/" + this.encodedIndexName + "/" + URLEncoder.encode(objectID, "UTF-8"), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteByQuery(Query query) throws AlgoliaException {
        this.deleteByQuery(query, 100000);
    }

    public void deleteByQuery(Query query, int batchLimit) throws AlgoliaException {
        ArrayList<String> attributesToRetrieve = new ArrayList<String>();
        attributesToRetrieve.add("objectID");
        query.setAttributesToRetrieve(attributesToRetrieve);
        query.setAttributesToHighlight(new ArrayList<String>());
        query.setAttributesToSnippet(new ArrayList<String>());
        query.setHitsPerPage(1000);
        query.enableDistinct(false);
        IndexBrowser it = this.browse(query);
        try {
            do {
                ArrayList<String> objectIDs = new ArrayList<String>();
                while (it.hasNext()) {
                    JSONObject elt = it.next();
                    objectIDs.add(elt.getString("objectID"));
                    if (objectIDs.size() <= batchLimit) continue;
                    break;
                }
                JSONObject task = this.deleteObjects(objectIDs);
                this.waitTask(task.getString("taskID"));
            } while (it.hasNext());
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject search(Query params) throws AlgoliaException {
        String paramsString = params.getQueryString();
        JSONObject body = new JSONObject();
        try {
            body.put("params", (Object)paramsString);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/query", body.toString(), false, true);
    }

    public JSONObject deleteObjects(List<String> objects) throws AlgoliaException {
        try {
            JSONArray array = new JSONArray();
            for (String id : objects) {
                JSONObject obj = new JSONObject();
                obj.put("objectID", (Object)id);
                JSONObject action = new JSONObject();
                action.put("action", (Object)"deleteObject");
                action.put("body", (Object)obj);
                array.put((Object)action);
            }
            return this.batch(array);
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
    }

    public JSONObject browse(int page) throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/browse?page=" + page, false);
    }

    public IndexBrowser browse(Query params) throws AlgoliaException {
        return new IndexBrowser(this.client, this.encodedIndexName, params, null);
    }

    public IndexBrowser browseFrom(Query params, String cursor) throws AlgoliaException {
        return new IndexBrowser(this.client, this.encodedIndexName, params, cursor);
    }

    @Deprecated
    public IndexBrowser browseFrow(Query params, String cursor) throws AlgoliaException {
        return this.browseFrom(params, cursor);
    }

    public JSONObject browse(int page, int hitsPerPage) throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/browse?page=" + page + "&hitsPerPage=" + hitsPerPage, false);
    }

    public void waitTask(String taskID, long timeToWait) throws AlgoliaException {
        try {
            while (true) {
                JSONObject obj;
                if ((obj = this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/task/" + URLEncoder.encode(taskID, "UTF-8"), false)).getString("status").equals("published")) {
                    return;
                }
                try {
                    Thread.sleep(timeToWait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                timeToWait = (timeToWait *= 2L) > 10000L ? 10000L : timeToWait;
            }
        }
        catch (JSONException e) {
            throw new AlgoliaException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitTask(String taskID) throws AlgoliaException {
        this.waitTask(taskID, 100L);
    }

    public JSONObject getSettings() throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/settings?getVersion=2", false);
    }

    public JSONObject clearIndex() throws AlgoliaException {
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/clear", "", true, false);
    }

    public JSONObject setSettings(JSONObject settings) throws AlgoliaException {
        return this.setSettings(settings, false);
    }

    public JSONObject setSettings(JSONObject settings, Boolean forwardToReplicas) throws AlgoliaException {
        return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/settings?forwardToReplicas=" + forwardToReplicas.toString(), settings.toString(), true);
    }

    public JSONObject listUserKeys() throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/keys", false);
    }

    public JSONObject getUserKeyACL(String key) throws AlgoliaException {
        return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/keys/" + key, false);
    }

    public JSONObject deleteUserKey(String key) throws AlgoliaException {
        return this.client.deleteRequest("/1/indexes/" + this.encodedIndexName + "/keys/" + key, true);
    }

    public JSONObject addUserKey(JSONObject params) throws AlgoliaException {
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/keys", params.toString(), true, false);
    }

    public JSONObject addUserKey(List<String> acls) throws AlgoliaException {
        return this.addUserKey(acls, 0, 0, 0);
    }

    public JSONObject updateUserKey(String key, JSONObject params) throws AlgoliaException {
        return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/keys/" + key, params.toString(), true);
    }

    public JSONObject updateUserKey(String key, List<String> acls) throws AlgoliaException {
        return this.updateUserKey(key, acls, 0, 0, 0);
    }

    public JSONObject addUserKey(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        try {
            JSONObject jsonObject = this.generateUpdateUser(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery);
            return this.addUserKey(jsonObject);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject updateUserKey(String key, List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws AlgoliaException {
        try {
            JSONObject jsonObject = this.generateUpdateUser(acls, validity, maxQueriesPerIPPerHour, maxHitsPerQuery);
            return this.updateUserKey(key, jsonObject);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONObject generateUpdateUser(List<String> acls, int validity, int maxQueriesPerIPPerHour, int maxHitsPerQuery) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("acl", (Object)new JSONArray(acls));
        jsonObject.put("validity", validity);
        jsonObject.put("maxQueriesPerIPPerHour", maxQueriesPerIPPerHour);
        jsonObject.put("maxHitsPerQuery", maxHitsPerQuery);
        return jsonObject;
    }

    public JSONObject searchDisjunctiveFaceting(Query query, List<String> disjunctiveFacets, Map<String, List<String>> refinements) throws AlgoliaException {
        if (refinements == null) {
            refinements = new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> disjunctiveRefinements = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> elt : refinements.entrySet()) {
            if (!disjunctiveFacets.contains(elt.getKey())) continue;
            disjunctiveRefinements.put(elt.getKey(), elt.getValue());
        }
        ArrayList<APIClient.IndexQuery> queries = new ArrayList<APIClient.IndexQuery>();
        StringBuilder filters = new StringBuilder();
        boolean first_global = true;
        for (Map.Entry<String, List<String>> elt : refinements.entrySet()) {
            StringBuilder or = new StringBuilder();
            or.append("(");
            boolean bl = true;
            for (String val : elt.getValue()) {
                if (disjunctiveRefinements.containsKey(elt.getKey())) {
                    if (!bl) {
                        or.append(',');
                    }
                    bl = false;
                    or.append(String.format("%s:%s", elt.getKey(), val));
                    continue;
                }
                if (!first_global) {
                    filters.append(',');
                }
                first_global = false;
                filters.append(String.format("%s:%s", elt.getKey(), val));
            }
            if (!disjunctiveRefinements.containsKey(elt.getKey())) continue;
            or.append(')');
            if (!first_global) {
                filters.append(',');
            }
            first_global = false;
            filters.append(or.toString());
        }
        queries.add(new APIClient.IndexQuery(this.indexName, new Query(query).setFacetFilters(filters.toString())));
        for (String disjunctiveFacet : disjunctiveFacets) {
            filters = new StringBuilder();
            first_global = true;
            for (Map.Entry entry : refinements.entrySet()) {
                if (disjunctiveFacet.equals(entry.getKey())) continue;
                StringBuilder or = new StringBuilder();
                or.append("(");
                boolean first = true;
                for (String val : (List)entry.getValue()) {
                    if (disjunctiveRefinements.containsKey(entry.getKey())) {
                        if (!first) {
                            or.append(',');
                        }
                        first = false;
                        or.append(String.format("%s:%s", entry.getKey(), val));
                        continue;
                    }
                    if (!first_global) {
                        filters.append(',');
                    }
                    first_global = false;
                    filters.append(String.format("%s:%s", entry.getKey(), val));
                }
                if (!disjunctiveRefinements.containsKey(entry.getKey())) continue;
                or.append(')');
                if (!first_global) {
                    filters.append(',');
                }
                first_global = false;
                filters.append(or.toString());
            }
            ArrayList<String> facets = new ArrayList<String>();
            facets.add(disjunctiveFacet);
            queries.add(new APIClient.IndexQuery(this.indexName, new Query(query).setHitsPerPage(0).enableAnalytics(false).setAttributesToRetrieve(new ArrayList<String>()).setAttributesToHighlight(new ArrayList<String>()).setAttributesToSnippet(new ArrayList<String>()).setFacets(facets).setFacetFilters(filters.toString())));
        }
        JSONObject answers = this.client.multipleQueries(queries);
        try {
            JSONArray results = answers.getJSONArray("results");
            JSONObject aggregatedAnswer = results.getJSONObject(0);
            JSONObject jSONObject = new JSONObject();
            for (int i = 1; i < results.length(); ++i) {
                JSONObject facets = results.getJSONObject(i).getJSONObject("facets");
                Iterator keys = facets.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    jSONObject.put(key, (Object)facets.getJSONObject(key));
                    if (!disjunctiveRefinements.containsKey(key)) continue;
                    for (String refine : (List)disjunctiveRefinements.get(key)) {
                        if (jSONObject.getJSONObject(key).has(refine)) continue;
                        jSONObject.getJSONObject(key).put(refine, 0);
                    }
                }
            }
            aggregatedAnswer.put("disjunctiveFacets", (Object)jSONObject);
            return aggregatedAnswer;
        }
        catch (JSONException e) {
            throw new Error(e);
        }
    }

    public JSONObject searchDisjunctiveFaceting(Query query, List<String> disjunctiveFacets) throws AlgoliaException {
        return this.searchDisjunctiveFaceting(query, disjunctiveFacets, null);
    }

    public JSONObject searchSynonyms(SynonymQuery query) throws AlgoliaException, JSONException {
        JSONObject body = new JSONObject().put("query", (Object)query.getQueryString());
        if (query.hasTypes()) {
            String type = "";
            boolean first = true;
            for (SynonymQuery.SynonymType t : query.getTypes()) {
                if (!first) {
                    type = type + ",";
                }
                type = type + t.name;
                first = false;
            }
            body = body.put("type", (Object)type);
        }
        if (query.getPage() != null) {
            body = body.put("page", (Object)query.getPage());
        }
        if (query.getHitsPerPage() != null) {
            body = body.put("hitsPerPage", (Object)query.getHitsPerPage());
        }
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/synonyms/search", body.toString(), false, true);
    }

    public JSONObject getSynonym(String objectID) throws AlgoliaException {
        if (objectID == null || objectID.length() == 0) {
            throw new AlgoliaException("Invalid objectID");
        }
        try {
            return this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/synonyms/" + URLEncoder.encode(objectID, "UTF-8"), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject deleteSynonym(String objectID, boolean forwardToReplicas) throws AlgoliaException {
        if (objectID == null || objectID.length() == 0) {
            throw new AlgoliaException("Invalid objectID");
        }
        try {
            return this.client.deleteRequest("/1/indexes/" + this.encodedIndexName + "/synonyms/" + URLEncoder.encode(objectID, "UTF-8") + "/?page=forwardToReplicas" + forwardToReplicas, false);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject deleteSynonym(String objectID) throws AlgoliaException {
        return this.deleteSynonym(objectID, false);
    }

    public JSONObject clearSynonyms(boolean forwardToReplicas) throws AlgoliaException {
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/synonyms/clear?forwardToReplicas=" + forwardToReplicas, "", true, false);
    }

    public JSONObject clearSynonyms() throws AlgoliaException {
        return this.clearSynonyms(false);
    }

    public JSONObject batchSynonyms(List<JSONObject> objects, boolean forwardToReplicas, boolean replaceExistingSynonyms) throws AlgoliaException {
        JSONArray array = new JSONArray();
        for (JSONObject obj : objects) {
            array.put((Object)obj);
        }
        return this.client.postRequest("/1/indexes/" + this.encodedIndexName + "/synonyms/batch?forwardToReplicas=" + forwardToReplicas + "&replaceExistingSynonyms=" + replaceExistingSynonyms, array.toString(), true, false);
    }

    public JSONObject batchSynonyms(List<JSONObject> objects, boolean forwardToReplicas) throws AlgoliaException {
        return this.batchSynonyms(objects, forwardToReplicas, false);
    }

    public JSONObject batchSynonyms(List<JSONObject> objects) throws AlgoliaException {
        return this.batchSynonyms(objects, false, false);
    }

    public JSONObject saveSynonym(String objectID, JSONObject content, boolean forwardToReplicas) throws AlgoliaException {
        try {
            return this.client.putRequest("/1/indexes/" + this.encodedIndexName + "/synonyms/" + URLEncoder.encode(objectID, "UTF-8") + "?forwardToReplicas=" + forwardToReplicas, content.toString(), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject saveSynonym(String objectID, JSONObject content) throws AlgoliaException {
        return this.saveSynonym(objectID, content, false);
    }

    public static class IndexBrowser
    implements Iterator<JSONObject> {
        final APIClient client;
        final Query params;
        final String encodedIndexName;
        JSONObject answer;
        JSONObject hit;
        int pos;

        IndexBrowser(APIClient client, String encodedIndexName, Query params, String startingCursor) throws AlgoliaException {
            this.client = client;
            this.params = params;
            this.encodedIndexName = encodedIndexName;
            this.doQuery(startingCursor);
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.pos < this.answer.getJSONArray("hits").length() || this.answer.has("cursor") && !this.answer.getString("cursor").isEmpty();
            }
            catch (JSONException e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public JSONObject next() {
            block5: {
                try {
                    while (true) {
                        if (this.pos < this.answer.getJSONArray("hits").length()) {
                            this.hit = this.answer.getJSONArray("hits").getJSONObject(this.pos);
                            ++this.pos;
                            break block5;
                        }
                        if (!this.answer.has("cursor") || this.answer.getString("cursor").isEmpty()) break;
                        this.pos = 0;
                        this.doQuery(this.getCursor());
                    }
                    return null;
                }
                catch (JSONException e) {
                    throw new IllegalStateException(e);
                }
                catch (AlgoliaException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return this.hit;
        }

        public String getCursor() {
            try {
                return this.answer != null && this.answer.has("cursor") ? this.answer.getString("cursor") : null;
            }
            catch (JSONException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Cannot remove while browsing");
        }

        private void doQuery(String cursor) throws AlgoliaException {
            String paramsString = this.params.getQueryString();
            if (cursor != null) {
                try {
                    paramsString = paramsString + (paramsString.length() > 0 ? "&" : "") + "cursor=" + URLEncoder.encode(cursor, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.answer = this.client.getRequest("/1/indexes/" + this.encodedIndexName + "/browse" + (paramsString.length() > 0 ? "?" + paramsString : ""), true);
        }
    }

    static class IndexBrower
    extends IndexBrowser {
        IndexBrower(APIClient client, String encodedIndexName, Query params, String startingCursor) throws AlgoliaException {
            super(client, encodedIndexName, params, startingCursor);
        }
    }
}

