// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.*;
import com.algolia.config.ClientOptions;
import com.algolia.exceptions.*;
import com.algolia.model.search.*;
import com.algolia.utils.*;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class SearchClient extends ApiClient {

  public SearchClient(String appId, String apiKey) {
    this(appId, apiKey, null);
  }

  public SearchClient(String appId, String apiKey, ClientOptions options) {
    super(appId, apiKey, "Search", options, getDefaultHosts(appId));
  }

  private static List<Host> getDefaultHosts(String appId) {
    List<Host> hosts = new ArrayList<>();
    hosts.add(new Host(appId + "-dsn.algolia.net", EnumSet.of(CallType.READ)));
    hosts.add(new Host(appId + ".algolia.net", EnumSet.of(CallType.WRITE)));

    List<Host> commonHosts = new ArrayList<>();
    hosts.add(new Host(appId + "-1.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
    hosts.add(new Host(appId + "-2.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
    hosts.add(new Host(appId + "-3.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));

    Collections.shuffle(commonHosts, new Random());

    return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
  }

  /**
   * Add a new API key with specific permissions and restrictions. The request must be authenticated
   * with the admin API key. The response returns an API key string.
   *
   * @param apiKey (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public AddApiKeyResponse addApiKey(@Nonnull ApiKey apiKey, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(addApiKeyAsync(apiKey, requestOptions));
  }

  /**
   * Add a new API key with specific permissions and restrictions. The request must be authenticated
   * with the admin API key. The response returns an API key string.
   *
   * @param apiKey (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public AddApiKeyResponse addApiKey(@Nonnull ApiKey apiKey) throws AlgoliaRuntimeException {
    return this.addApiKey(apiKey, null);
  }

  /**
   * (asynchronously) Add a new API key with specific permissions and restrictions. The request must
   * be authenticated with the admin API key. The response returns an API key string.
   *
   * @param apiKey (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<AddApiKeyResponse> addApiKeyAsync(@Nonnull ApiKey apiKey, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(apiKey, "Parameter `apiKey` is required when calling `addApiKey`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/keys").setMethod("POST").setBody(apiKey).build();

    return executeAsync(request, requestOptions, new TypeReference<AddApiKeyResponse>() {});
  }

  /**
   * (asynchronously) Add a new API key with specific permissions and restrictions. The request must
   * be authenticated with the admin API key. The response returns an API key string.
   *
   * @param apiKey (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<AddApiKeyResponse> addApiKeyAsync(@Nonnull ApiKey apiKey) throws AlgoliaRuntimeException {
    return this.addApiKeyAsync(apiKey, null);
  }

  /**
   * If you use an existing `objectID`, the existing record will be replaced with the new one. To
   * update only some attributes of an existing record, use the [`partial`
   * operation](#tag/Records/operation/partialUpdateObject) instead. To add multiple records to your
   * index in a single API request, use the [`batch` operation](#tag/Records/operation/batch).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param body Algolia record. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtWithObjectIdResponse addOrUpdateObject(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(addOrUpdateObjectAsync(indexName, objectID, body, requestOptions));
  }

  /**
   * If you use an existing `objectID`, the existing record will be replaced with the new one. To
   * update only some attributes of an existing record, use the [`partial`
   * operation](#tag/Records/operation/partialUpdateObject) instead. To add multiple records to your
   * index in a single API request, use the [`batch` operation](#tag/Records/operation/batch).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param body Algolia record. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtWithObjectIdResponse addOrUpdateObject(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Object body)
    throws AlgoliaRuntimeException {
    return this.addOrUpdateObject(indexName, objectID, body, null);
  }

  /**
   * (asynchronously) If you use an existing &#x60;objectID&#x60;, the existing record will be
   * replaced with the new one. To update only some attributes of an existing record, use the
   * [&#x60;partial&#x60; operation](#tag/Records/operation/partialUpdateObject) instead. To add
   * multiple records to your index in a single API request, use the [&#x60;batch&#x60;
   * operation](#tag/Records/operation/batch).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param body Algolia record. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtWithObjectIdResponse> addOrUpdateObjectAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `addOrUpdateObject`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `addOrUpdateObject`.");

    Parameters.requireNonNull(body, "Parameter `body` is required when calling `addOrUpdateObject`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/{objectID}", indexName, objectID)
      .setMethod("PUT")
      .setBody(body)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtWithObjectIdResponse>() {});
  }

  /**
   * (asynchronously) If you use an existing &#x60;objectID&#x60;, the existing record will be
   * replaced with the new one. To update only some attributes of an existing record, use the
   * [&#x60;partial&#x60; operation](#tag/Records/operation/partialUpdateObject) instead. To add
   * multiple records to your index in a single API request, use the [&#x60;batch&#x60;
   * operation](#tag/Records/operation/batch).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param body Algolia record. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtWithObjectIdResponse> addOrUpdateObjectAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Object body
  ) throws AlgoliaRuntimeException {
    return this.addOrUpdateObjectAsync(indexName, objectID, body, null);
  }

  /**
   * Add a source to the list of allowed sources.
   *
   * @param source Source to add. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CreatedAtResponse appendSource(@Nonnull Source source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(appendSourceAsync(source, requestOptions));
  }

  /**
   * Add a source to the list of allowed sources.
   *
   * @param source Source to add. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CreatedAtResponse appendSource(@Nonnull Source source) throws AlgoliaRuntimeException {
    return this.appendSource(source, null);
  }

  /**
   * (asynchronously) Add a source to the list of allowed sources.
   *
   * @param source Source to add. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<CreatedAtResponse> appendSourceAsync(@Nonnull Source source, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(source, "Parameter `source` is required when calling `appendSource`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/security/sources/append").setMethod("POST").setBody(source).build();
    return executeAsync(request, requestOptions, new TypeReference<CreatedAtResponse>() {});
  }

  /**
   * (asynchronously) Add a source to the list of allowed sources.
   *
   * @param source Source to add. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<CreatedAtResponse> appendSourceAsync(@Nonnull Source source) throws AlgoliaRuntimeException {
    return this.appendSourceAsync(source, null);
  }

  /**
   * Assign or move a user ID to a cluster. The time it takes to move a user is proportional to the
   * amount of data linked to the user ID.
   *
   * @param xAlgoliaUserID userID to assign. (required)
   * @param assignUserIdParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CreatedAtResponse assignUserId(
    @Nonnull String xAlgoliaUserID,
    @Nonnull AssignUserIdParams assignUserIdParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(assignUserIdAsync(xAlgoliaUserID, assignUserIdParams, requestOptions));
  }

  /**
   * Assign or move a user ID to a cluster. The time it takes to move a user is proportional to the
   * amount of data linked to the user ID.
   *
   * @param xAlgoliaUserID userID to assign. (required)
   * @param assignUserIdParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CreatedAtResponse assignUserId(@Nonnull String xAlgoliaUserID, @Nonnull AssignUserIdParams assignUserIdParams)
    throws AlgoliaRuntimeException {
    return this.assignUserId(xAlgoliaUserID, assignUserIdParams, null);
  }

  /**
   * (asynchronously) Assign or move a user ID to a cluster. The time it takes to move a user is
   * proportional to the amount of data linked to the user ID.
   *
   * @param xAlgoliaUserID userID to assign. (required)
   * @param assignUserIdParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<CreatedAtResponse> assignUserIdAsync(
    @Nonnull String xAlgoliaUserID,
    @Nonnull AssignUserIdParams assignUserIdParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(xAlgoliaUserID, "Parameter `xAlgoliaUserID` is required when calling `assignUserId`.");

    Parameters.requireNonNull(assignUserIdParams, "Parameter `assignUserIdParams` is required when calling `assignUserId`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/clusters/mapping")
      .setMethod("POST")
      .setBody(assignUserIdParams)
      .addHeader("X-Algolia-User-ID", xAlgoliaUserID)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<CreatedAtResponse>() {});
  }

  /**
   * (asynchronously) Assign or move a user ID to a cluster. The time it takes to move a user is
   * proportional to the amount of data linked to the user ID.
   *
   * @param xAlgoliaUserID userID to assign. (required)
   * @param assignUserIdParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<CreatedAtResponse> assignUserIdAsync(
    @Nonnull String xAlgoliaUserID,
    @Nonnull AssignUserIdParams assignUserIdParams
  ) throws AlgoliaRuntimeException {
    return this.assignUserIdAsync(xAlgoliaUserID, assignUserIdParams, null);
  }

  /**
   * To reduce the time spent on network round trips, you can perform several write actions in a
   * single API call. Actions are applied in the order they are specified. The supported `action`s
   * are equivalent to the individual operations of the same name.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param batchWriteParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BatchResponse batch(@Nonnull String indexName, @Nonnull BatchWriteParams batchWriteParams, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(batchAsync(indexName, batchWriteParams, requestOptions));
  }

  /**
   * To reduce the time spent on network round trips, you can perform several write actions in a
   * single API call. Actions are applied in the order they are specified. The supported `action`s
   * are equivalent to the individual operations of the same name.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param batchWriteParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BatchResponse batch(@Nonnull String indexName, @Nonnull BatchWriteParams batchWriteParams) throws AlgoliaRuntimeException {
    return this.batch(indexName, batchWriteParams, null);
  }

  /**
   * (asynchronously) To reduce the time spent on network round trips, you can perform several write
   * actions in a single API call. Actions are applied in the order they are specified. The
   * supported &#x60;action&#x60;s are equivalent to the individual operations of the same name.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param batchWriteParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BatchResponse> batchAsync(
    @Nonnull String indexName,
    @Nonnull BatchWriteParams batchWriteParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `batch`.");

    Parameters.requireNonNull(batchWriteParams, "Parameter `batchWriteParams` is required when calling `batch`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/batch", indexName)
      .setMethod("POST")
      .setBody(batchWriteParams)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<BatchResponse>() {});
  }

  /**
   * (asynchronously) To reduce the time spent on network round trips, you can perform several write
   * actions in a single API call. Actions are applied in the order they are specified. The
   * supported &#x60;action&#x60;s are equivalent to the individual operations of the same name.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param batchWriteParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BatchResponse> batchAsync(@Nonnull String indexName, @Nonnull BatchWriteParams batchWriteParams)
    throws AlgoliaRuntimeException {
    return this.batchAsync(indexName, batchWriteParams, null);
  }

  /**
   * Assign multiple user IDs to a cluster. **You can't _move_ users with this operation.**.
   *
   * @param xAlgoliaUserID userID to assign. (required)
   * @param batchAssignUserIdsParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CreatedAtResponse batchAssignUserIds(
    @Nonnull String xAlgoliaUserID,
    @Nonnull BatchAssignUserIdsParams batchAssignUserIdsParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(batchAssignUserIdsAsync(xAlgoliaUserID, batchAssignUserIdsParams, requestOptions));
  }

  /**
   * Assign multiple user IDs to a cluster. **You can't _move_ users with this operation.**.
   *
   * @param xAlgoliaUserID userID to assign. (required)
   * @param batchAssignUserIdsParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CreatedAtResponse batchAssignUserIds(@Nonnull String xAlgoliaUserID, @Nonnull BatchAssignUserIdsParams batchAssignUserIdsParams)
    throws AlgoliaRuntimeException {
    return this.batchAssignUserIds(xAlgoliaUserID, batchAssignUserIdsParams, null);
  }

  /**
   * (asynchronously) Assign multiple user IDs to a cluster. **You can&#39;t _move_ users with this
   * operation.**.
   *
   * @param xAlgoliaUserID userID to assign. (required)
   * @param batchAssignUserIdsParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<CreatedAtResponse> batchAssignUserIdsAsync(
    @Nonnull String xAlgoliaUserID,
    @Nonnull BatchAssignUserIdsParams batchAssignUserIdsParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(xAlgoliaUserID, "Parameter `xAlgoliaUserID` is required when calling `batchAssignUserIds`.");

    Parameters.requireNonNull(
      batchAssignUserIdsParams,
      "Parameter `batchAssignUserIdsParams` is required when calling `batchAssignUserIds`."
    );

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/clusters/mapping/batch")
      .setMethod("POST")
      .setBody(batchAssignUserIdsParams)
      .addHeader("X-Algolia-User-ID", xAlgoliaUserID)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<CreatedAtResponse>() {});
  }

  /**
   * (asynchronously) Assign multiple user IDs to a cluster. **You can&#39;t _move_ users with this
   * operation.**.
   *
   * @param xAlgoliaUserID userID to assign. (required)
   * @param batchAssignUserIdsParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<CreatedAtResponse> batchAssignUserIdsAsync(
    @Nonnull String xAlgoliaUserID,
    @Nonnull BatchAssignUserIdsParams batchAssignUserIdsParams
  ) throws AlgoliaRuntimeException {
    return this.batchAssignUserIdsAsync(xAlgoliaUserID, batchAssignUserIdsParams, null);
  }

  /**
   * Add or remove a batch of dictionary entries.
   *
   * @param dictionaryName Dictionary to search in. (required)
   * @param batchDictionaryEntriesParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse batchDictionaryEntries(
    @Nonnull DictionaryType dictionaryName,
    @Nonnull BatchDictionaryEntriesParams batchDictionaryEntriesParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(batchDictionaryEntriesAsync(dictionaryName, batchDictionaryEntriesParams, requestOptions));
  }

  /**
   * Add or remove a batch of dictionary entries.
   *
   * @param dictionaryName Dictionary to search in. (required)
   * @param batchDictionaryEntriesParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse batchDictionaryEntries(
    @Nonnull DictionaryType dictionaryName,
    @Nonnull BatchDictionaryEntriesParams batchDictionaryEntriesParams
  ) throws AlgoliaRuntimeException {
    return this.batchDictionaryEntries(dictionaryName, batchDictionaryEntriesParams, null);
  }

  /**
   * (asynchronously) Add or remove a batch of dictionary entries.
   *
   * @param dictionaryName Dictionary to search in. (required)
   * @param batchDictionaryEntriesParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> batchDictionaryEntriesAsync(
    @Nonnull DictionaryType dictionaryName,
    @Nonnull BatchDictionaryEntriesParams batchDictionaryEntriesParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(dictionaryName, "Parameter `dictionaryName` is required when calling `batchDictionaryEntries`.");

    Parameters.requireNonNull(
      batchDictionaryEntriesParams,
      "Parameter `batchDictionaryEntriesParams` is required when calling" + " `batchDictionaryEntries`."
    );

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/dictionaries/{dictionaryName}/batch", dictionaryName)
      .setMethod("POST")
      .setBody(batchDictionaryEntriesParams)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>() {});
  }

  /**
   * (asynchronously) Add or remove a batch of dictionary entries.
   *
   * @param dictionaryName Dictionary to search in. (required)
   * @param batchDictionaryEntriesParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> batchDictionaryEntriesAsync(
    @Nonnull DictionaryType dictionaryName,
    @Nonnull BatchDictionaryEntriesParams batchDictionaryEntriesParams
  ) throws AlgoliaRuntimeException {
    return this.batchDictionaryEntriesAsync(dictionaryName, batchDictionaryEntriesParams, null);
  }

  /**
   * Retrieve up to 1,000 records per call. Supports full-text search and filters. For better
   * performance, it doesn't support: - The `distinct` query parameter - Sorting by typos,
   * proximity, words, or geographical distance.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param browseParams (optional)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> BrowseResponse<T> browse(
    @Nonnull String indexName,
    BrowseParams browseParams,
    Class<T> innerType,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(browseAsync(indexName, browseParams, innerType, requestOptions));
  }

  /**
   * Retrieve up to 1,000 records per call. Supports full-text search and filters. For better
   * performance, it doesn't support: - The `distinct` query parameter - Sorting by typos,
   * proximity, words, or geographical distance.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param browseParams (optional)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> BrowseResponse<T> browse(@Nonnull String indexName, BrowseParams browseParams, Class<T> innerType)
    throws AlgoliaRuntimeException {
    return this.browse(indexName, browseParams, innerType, null);
  }

  /**
   * Retrieve up to 1,000 records per call. Supports full-text search and filters. For better
   * performance, it doesn't support: - The `distinct` query parameter - Sorting by typos,
   * proximity, words, or geographical distance.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> BrowseResponse<T> browse(@Nonnull String indexName, Class<T> innerType, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.browse(indexName, null, innerType, requestOptions);
  }

  /**
   * Retrieve up to 1,000 records per call. Supports full-text search and filters. For better
   * performance, it doesn't support: - The `distinct` query parameter - Sorting by typos,
   * proximity, words, or geographical distance.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> BrowseResponse<T> browse(@Nonnull String indexName, Class<T> innerType) throws AlgoliaRuntimeException {
    return this.browse(indexName, null, innerType, null);
  }

  /**
   * (asynchronously) Retrieve up to 1,000 records per call. Supports full-text search and filters.
   * For better performance, it doesn&#39;t support: - The &#x60;distinct&#x60; query parameter -
   * Sorting by typos, proximity, words, or geographical distance.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param browseParams (optional)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> CompletableFuture<BrowseResponse<T>> browseAsync(
    @Nonnull String indexName,
    BrowseParams browseParams,
    Class<T> innerType,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `browse`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/browse", indexName)
      .setMethod("POST")
      .setBody(browseParams)
      .build();
    return executeAsync(request, requestOptions, BrowseResponse.class, innerType);
  }

  /**
   * (asynchronously) Retrieve up to 1,000 records per call. Supports full-text search and filters.
   * For better performance, it doesn&#39;t support: - The &#x60;distinct&#x60; query parameter -
   * Sorting by typos, proximity, words, or geographical distance.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param browseParams (optional)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> CompletableFuture<BrowseResponse<T>> browseAsync(@Nonnull String indexName, BrowseParams browseParams, Class<T> innerType)
    throws AlgoliaRuntimeException {
    return this.browseAsync(indexName, browseParams, innerType, null);
  }

  /**
   * (asynchronously) Retrieve up to 1,000 records per call. Supports full-text search and filters.
   * For better performance, it doesn&#39;t support: - The &#x60;distinct&#x60; query parameter -
   * Sorting by typos, proximity, words, or geographical distance.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> CompletableFuture<BrowseResponse<T>> browseAsync(@Nonnull String indexName, Class<T> innerType, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.browseAsync(indexName, null, innerType, requestOptions);
  }

  /**
   * (asynchronously) Retrieve up to 1,000 records per call. Supports full-text search and filters.
   * For better performance, it doesn&#39;t support: - The &#x60;distinct&#x60; query parameter -
   * Sorting by typos, proximity, words, or geographical distance.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> CompletableFuture<BrowseResponse<T>> browseAsync(@Nonnull String indexName, Class<T> innerType)
    throws AlgoliaRuntimeException {
    return this.browseAsync(indexName, null, innerType, null);
  }

  /**
   * Delete all synonyms in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse clearAllSynonyms(@Nonnull String indexName, Boolean forwardToReplicas, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(clearAllSynonymsAsync(indexName, forwardToReplicas, requestOptions));
  }

  /**
   * Delete all synonyms in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse clearAllSynonyms(@Nonnull String indexName, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
    return this.clearAllSynonyms(indexName, forwardToReplicas, null);
  }

  /**
   * Delete all synonyms in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse clearAllSynonyms(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.clearAllSynonyms(indexName, null, requestOptions);
  }

  /**
   * Delete all synonyms in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse clearAllSynonyms(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.clearAllSynonyms(indexName, null, null);
  }

  /**
   * (asynchronously) Delete all synonyms in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> clearAllSynonymsAsync(
    @Nonnull String indexName,
    Boolean forwardToReplicas,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `clearAllSynonyms`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/synonyms/clear", indexName)
      .setMethod("POST")
      .addQueryParameter("forwardToReplicas", forwardToReplicas)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>() {});
  }

  /**
   * (asynchronously) Delete all synonyms in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> clearAllSynonymsAsync(@Nonnull String indexName, Boolean forwardToReplicas)
    throws AlgoliaRuntimeException {
    return this.clearAllSynonymsAsync(indexName, forwardToReplicas, null);
  }

  /**
   * (asynchronously) Delete all synonyms in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> clearAllSynonymsAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.clearAllSynonymsAsync(indexName, null, requestOptions);
  }

  /**
   * (asynchronously) Delete all synonyms in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> clearAllSynonymsAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.clearAllSynonymsAsync(indexName, null, null);
  }

  /**
   * Delete the records but leave settings and index-specific API keys untouched.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse clearObjects(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(clearObjectsAsync(indexName, requestOptions));
  }

  /**
   * Delete the records but leave settings and index-specific API keys untouched.
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse clearObjects(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.clearObjects(indexName, null);
  }

  /**
   * (asynchronously) Delete the records but leave settings and index-specific API keys untouched.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> clearObjectsAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `clearObjects`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/clear", indexName).setMethod("POST").build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>() {});
  }

  /**
   * (asynchronously) Delete the records but leave settings and index-specific API keys untouched.
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> clearObjectsAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.clearObjectsAsync(indexName, null);
  }

  /**
   * Delete all rules in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse clearRules(@Nonnull String indexName, Boolean forwardToReplicas, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(clearRulesAsync(indexName, forwardToReplicas, requestOptions));
  }

  /**
   * Delete all rules in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse clearRules(@Nonnull String indexName, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
    return this.clearRules(indexName, forwardToReplicas, null);
  }

  /**
   * Delete all rules in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse clearRules(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.clearRules(indexName, null, requestOptions);
  }

  /**
   * Delete all rules in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse clearRules(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.clearRules(indexName, null, null);
  }

  /**
   * (asynchronously) Delete all rules in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> clearRulesAsync(
    @Nonnull String indexName,
    Boolean forwardToReplicas,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `clearRules`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/rules/clear", indexName)
      .setMethod("POST")
      .addQueryParameter("forwardToReplicas", forwardToReplicas)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>() {});
  }

  /**
   * (asynchronously) Delete all rules in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> clearRulesAsync(@Nonnull String indexName, Boolean forwardToReplicas)
    throws AlgoliaRuntimeException {
    return this.clearRulesAsync(indexName, forwardToReplicas, null);
  }

  /**
   * (asynchronously) Delete all rules in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> clearRulesAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.clearRulesAsync(indexName, null, requestOptions);
  }

  /**
   * (asynchronously) Delete all rules in the index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> clearRulesAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.clearRulesAsync(indexName, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(delAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.del(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.del(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.del(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `del`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.delAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.delAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.delAsync(path, null, null);
  }

  /**
   * Delete an existing API key. The request must be authenticated with the admin API key.
   *
   * @param key API key. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteApiKeyResponse deleteApiKey(@Nonnull String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteApiKeyAsync(key, requestOptions));
  }

  /**
   * Delete an existing API key. The request must be authenticated with the admin API key.
   *
   * @param key API key. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteApiKeyResponse deleteApiKey(@Nonnull String key) throws AlgoliaRuntimeException {
    return this.deleteApiKey(key, null);
  }

  /**
   * (asynchronously) Delete an existing API key. The request must be authenticated with the admin
   * API key.
   *
   * @param key API key. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteApiKeyResponse> deleteApiKeyAsync(@Nonnull String key, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(key, "Parameter `key` is required when calling `deleteApiKey`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/keys/{key}", key).setMethod("DELETE").build();

    return executeAsync(request, requestOptions, new TypeReference<DeleteApiKeyResponse>() {});
  }

  /**
   * (asynchronously) Delete an existing API key. The request must be authenticated with the admin
   * API key.
   *
   * @param key API key. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteApiKeyResponse> deleteApiKeyAsync(@Nonnull String key) throws AlgoliaRuntimeException {
    return this.deleteApiKeyAsync(key, null);
  }

  /**
   * This operation doesn't support all the query options, only its filters (numeric, facet, or tag)
   * and geo queries. It doesn't accept empty filters or queries.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param deleteByParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteBy(@Nonnull String indexName, @Nonnull DeleteByParams deleteByParams, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteByAsync(indexName, deleteByParams, requestOptions));
  }

  /**
   * This operation doesn't support all the query options, only its filters (numeric, facet, or tag)
   * and geo queries. It doesn't accept empty filters or queries.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param deleteByParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteBy(@Nonnull String indexName, @Nonnull DeleteByParams deleteByParams) throws AlgoliaRuntimeException {
    return this.deleteBy(indexName, deleteByParams, null);
  }

  /**
   * (asynchronously) This operation doesn&#39;t support all the query options, only its filters
   * (numeric, facet, or tag) and geo queries. It doesn&#39;t accept empty filters or queries.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param deleteByParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteByAsync(
    @Nonnull String indexName,
    @Nonnull DeleteByParams deleteByParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteBy`.");

    Parameters.requireNonNull(deleteByParams, "Parameter `deleteByParams` is required when calling `deleteBy`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/deleteByQuery", indexName)
      .setMethod("POST")
      .setBody(deleteByParams)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<DeletedAtResponse>() {});
  }

  /**
   * (asynchronously) This operation doesn&#39;t support all the query options, only its filters
   * (numeric, facet, or tag) and geo queries. It doesn&#39;t accept empty filters or queries.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param deleteByParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteByAsync(@Nonnull String indexName, @Nonnull DeleteByParams deleteByParams)
    throws AlgoliaRuntimeException {
    return this.deleteByAsync(indexName, deleteByParams, null);
  }

  /**
   * Delete an existing index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteIndex(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteIndexAsync(indexName, requestOptions));
  }

  /**
   * Delete an existing index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteIndex(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.deleteIndex(indexName, null);
  }

  /**
   * (asynchronously) Delete an existing index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteIndexAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteIndex`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}", indexName).setMethod("DELETE").build();
    return executeAsync(request, requestOptions, new TypeReference<DeletedAtResponse>() {});
  }

  /**
   * (asynchronously) Delete an existing index.
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteIndexAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.deleteIndexAsync(indexName, null);
  }

  /**
   * To delete a set of records matching a query, use the [`deleteByQuery`
   * operation](#tag/Records/operation/deleteBy) instead.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteObject(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteObjectAsync(indexName, objectID, requestOptions));
  }

  /**
   * To delete a set of records matching a query, use the [`deleteByQuery`
   * operation](#tag/Records/operation/deleteBy) instead.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteObject(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
    return this.deleteObject(indexName, objectID, null);
  }

  /**
   * (asynchronously) To delete a set of records matching a query, use the
   * [&#x60;deleteByQuery&#x60; operation](#tag/Records/operation/deleteBy) instead.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteObjectAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteObject`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `deleteObject`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/{objectID}", indexName, objectID)
      .setMethod("DELETE")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<DeletedAtResponse>() {});
  }

  /**
   * (asynchronously) To delete a set of records matching a query, use the
   * [&#x60;deleteByQuery&#x60; operation](#tag/Records/operation/deleteBy) instead.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteObjectAsync(@Nonnull String indexName, @Nonnull String objectID)
    throws AlgoliaRuntimeException {
    return this.deleteObjectAsync(indexName, objectID, null);
  }

  /**
   * Delete a rule by its `objectID`. To find the `objectID` for rules, use the [`search`
   * operation](#tag/Rules/operation/searchRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse deleteRule(
    @Nonnull String indexName,
    @Nonnull String objectID,
    Boolean forwardToReplicas,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteRuleAsync(indexName, objectID, forwardToReplicas, requestOptions));
  }

  /**
   * Delete a rule by its `objectID`. To find the `objectID` for rules, use the [`search`
   * operation](#tag/Rules/operation/searchRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse deleteRule(@Nonnull String indexName, @Nonnull String objectID, Boolean forwardToReplicas)
    throws AlgoliaRuntimeException {
    return this.deleteRule(indexName, objectID, forwardToReplicas, null);
  }

  /**
   * Delete a rule by its `objectID`. To find the `objectID` for rules, use the [`search`
   * operation](#tag/Rules/operation/searchRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse deleteRule(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.deleteRule(indexName, objectID, null, requestOptions);
  }

  /**
   * Delete a rule by its `objectID`. To find the `objectID` for rules, use the [`search`
   * operation](#tag/Rules/operation/searchRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse deleteRule(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
    return this.deleteRule(indexName, objectID, null, null);
  }

  /**
   * (asynchronously) Delete a rule by its &#x60;objectID&#x60;. To find the &#x60;objectID&#x60;
   * for rules, use the [&#x60;search&#x60; operation](#tag/Rules/operation/searchRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> deleteRuleAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    Boolean forwardToReplicas,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteRule`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `deleteRule`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/rules/{objectID}", indexName, objectID)
      .setMethod("DELETE")
      .addQueryParameter("forwardToReplicas", forwardToReplicas)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>() {});
  }

  /**
   * (asynchronously) Delete a rule by its &#x60;objectID&#x60;. To find the &#x60;objectID&#x60;
   * for rules, use the [&#x60;search&#x60; operation](#tag/Rules/operation/searchRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> deleteRuleAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    Boolean forwardToReplicas
  ) throws AlgoliaRuntimeException {
    return this.deleteRuleAsync(indexName, objectID, forwardToReplicas, null);
  }

  /**
   * (asynchronously) Delete a rule by its &#x60;objectID&#x60;. To find the &#x60;objectID&#x60;
   * for rules, use the [&#x60;search&#x60; operation](#tag/Rules/operation/searchRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> deleteRuleAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.deleteRuleAsync(indexName, objectID, null, requestOptions);
  }

  /**
   * (asynchronously) Delete a rule by its &#x60;objectID&#x60;. To find the &#x60;objectID&#x60;
   * for rules, use the [&#x60;search&#x60; operation](#tag/Rules/operation/searchRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> deleteRuleAsync(@Nonnull String indexName, @Nonnull String objectID)
    throws AlgoliaRuntimeException {
    return this.deleteRuleAsync(indexName, objectID, null, null);
  }

  /**
   * Remove a source from the list of allowed sources.
   *
   * @param source IP address range of the source. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteSourceResponse deleteSource(@Nonnull String source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteSourceAsync(source, requestOptions));
  }

  /**
   * Remove a source from the list of allowed sources.
   *
   * @param source IP address range of the source. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteSourceResponse deleteSource(@Nonnull String source) throws AlgoliaRuntimeException {
    return this.deleteSource(source, null);
  }

  /**
   * (asynchronously) Remove a source from the list of allowed sources.
   *
   * @param source IP address range of the source. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteSourceResponse> deleteSourceAsync(@Nonnull String source, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(source, "Parameter `source` is required when calling `deleteSource`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/security/sources/{source}", source).setMethod("DELETE").build();
    return executeAsync(request, requestOptions, new TypeReference<DeleteSourceResponse>() {});
  }

  /**
   * (asynchronously) Remove a source from the list of allowed sources.
   *
   * @param source IP address range of the source. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteSourceResponse> deleteSourceAsync(@Nonnull String source) throws AlgoliaRuntimeException {
    return this.deleteSourceAsync(source, null);
  }

  /**
   * Delete a synonym by its `objectID`. To find the object IDs of your synonyms, use the [`search`
   * operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteSynonym(
    @Nonnull String indexName,
    @Nonnull String objectID,
    Boolean forwardToReplicas,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteSynonymAsync(indexName, objectID, forwardToReplicas, requestOptions));
  }

  /**
   * Delete a synonym by its `objectID`. To find the object IDs of your synonyms, use the [`search`
   * operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteSynonym(@Nonnull String indexName, @Nonnull String objectID, Boolean forwardToReplicas)
    throws AlgoliaRuntimeException {
    return this.deleteSynonym(indexName, objectID, forwardToReplicas, null);
  }

  /**
   * Delete a synonym by its `objectID`. To find the object IDs of your synonyms, use the [`search`
   * operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteSynonym(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.deleteSynonym(indexName, objectID, null, requestOptions);
  }

  /**
   * Delete a synonym by its `objectID`. To find the object IDs of your synonyms, use the [`search`
   * operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteSynonym(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
    return this.deleteSynonym(indexName, objectID, null, null);
  }

  /**
   * (asynchronously) Delete a synonym by its &#x60;objectID&#x60;. To find the object IDs of your
   * synonyms, use the [&#x60;search&#x60; operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteSynonymAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    Boolean forwardToReplicas,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteSynonym`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `deleteSynonym`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/synonyms/{objectID}", indexName, objectID)
      .setMethod("DELETE")
      .addQueryParameter("forwardToReplicas", forwardToReplicas)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<DeletedAtResponse>() {});
  }

  /**
   * (asynchronously) Delete a synonym by its &#x60;objectID&#x60;. To find the object IDs of your
   * synonyms, use the [&#x60;search&#x60; operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteSynonymAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    Boolean forwardToReplicas
  ) throws AlgoliaRuntimeException {
    return this.deleteSynonymAsync(indexName, objectID, forwardToReplicas, null);
  }

  /**
   * (asynchronously) Delete a synonym by its &#x60;objectID&#x60;. To find the object IDs of your
   * synonyms, use the [&#x60;search&#x60; operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteSynonymAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.deleteSynonymAsync(indexName, objectID, null, requestOptions);
  }

  /**
   * (asynchronously) Delete a synonym by its &#x60;objectID&#x60;. To find the object IDs of your
   * synonyms, use the [&#x60;search&#x60; operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteSynonymAsync(@Nonnull String indexName, @Nonnull String objectID)
    throws AlgoliaRuntimeException {
    return this.deleteSynonymAsync(indexName, objectID, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.get(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.get(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.get(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `get`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("GET").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.getAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.getAsync(path, null, null);
  }

  /**
   * Get the permissions and restrictions of a specific API key. When authenticating with the admin
   * API key, you can request information for any of your application's keys. When authenticating
   * with other API keys, you can only retrieve information for that key.
   *
   * @param key API key. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetApiKeyResponse getApiKey(@Nonnull String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getApiKeyAsync(key, requestOptions));
  }

  /**
   * Get the permissions and restrictions of a specific API key. When authenticating with the admin
   * API key, you can request information for any of your application's keys. When authenticating
   * with other API keys, you can only retrieve information for that key.
   *
   * @param key API key. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetApiKeyResponse getApiKey(@Nonnull String key) throws AlgoliaRuntimeException {
    return this.getApiKey(key, null);
  }

  /**
   * (asynchronously) Get the permissions and restrictions of a specific API key. When
   * authenticating with the admin API key, you can request information for any of your
   * application&#39;s keys. When authenticating with other API keys, you can only retrieve
   * information for that key.
   *
   * @param key API key. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetApiKeyResponse> getApiKeyAsync(@Nonnull String key, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(key, "Parameter `key` is required when calling `getApiKey`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/keys/{key}", key).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<GetApiKeyResponse>() {});
  }

  /**
   * (asynchronously) Get the permissions and restrictions of a specific API key. When
   * authenticating with the admin API key, you can request information for any of your
   * application&#39;s keys. When authenticating with other API keys, you can only retrieve
   * information for that key.
   *
   * @param key API key. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetApiKeyResponse> getApiKeyAsync(@Nonnull String key) throws AlgoliaRuntimeException {
    return this.getApiKeyAsync(key, null);
  }

  /**
   * Lists Algolia's [supported
   * languages](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages/)
   * and any customizations applied to each language's [stop
   * word](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-stop-words/),
   * [plural](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-plurals-and-other-declensions/),
   * and [segmentation
   * (compound)](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-segmentation/)
   * features.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Map<String, Languages> getDictionaryLanguages(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getDictionaryLanguagesAsync(requestOptions));
  }

  /**
   * Lists Algolia's [supported
   * languages](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages/)
   * and any customizations applied to each language's [stop
   * word](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-stop-words/),
   * [plural](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-plurals-and-other-declensions/),
   * and [segmentation
   * (compound)](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-segmentation/)
   * features.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Map<String, Languages> getDictionaryLanguages() throws AlgoliaRuntimeException {
    return this.getDictionaryLanguages(null);
  }

  /**
   * (asynchronously) Lists Algolia&#39;s [supported
   * languages](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages/)
   * and any customizations applied to each language&#39;s [stop
   * word](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-stop-words/),
   * [plural](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-plurals-and-other-declensions/),
   * and [segmentation
   * (compound)](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-segmentation/)
   * features.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Map<String, Languages>> getDictionaryLanguagesAsync(RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/dictionaries/*/languages").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<Map<String, Languages>>() {});
  }

  /**
   * (asynchronously) Lists Algolia&#39;s [supported
   * languages](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages/)
   * and any customizations applied to each language&#39;s [stop
   * word](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-stop-words/),
   * [plural](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-plurals-and-other-declensions/),
   * and [segmentation
   * (compound)](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-segmentation/)
   * features.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Map<String, Languages>> getDictionaryLanguagesAsync() throws AlgoliaRuntimeException {
    return this.getDictionaryLanguagesAsync(null);
  }

  /**
   * Get the languages for which [stop words are turned
   * off](#tag/Dictionaries/operation/setDictionarySettings).
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetDictionarySettingsResponse getDictionarySettings(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getDictionarySettingsAsync(requestOptions));
  }

  /**
   * Get the languages for which [stop words are turned
   * off](#tag/Dictionaries/operation/setDictionarySettings).
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetDictionarySettingsResponse getDictionarySettings() throws AlgoliaRuntimeException {
    return this.getDictionarySettings(null);
  }

  /**
   * (asynchronously) Get the languages for which [stop words are turned
   * off](#tag/Dictionaries/operation/setDictionarySettings).
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetDictionarySettingsResponse> getDictionarySettingsAsync(RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/dictionaries/*/settings").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<GetDictionarySettingsResponse>() {});
  }

  /**
   * (asynchronously) Get the languages for which [stop words are turned
   * off](#tag/Dictionaries/operation/setDictionarySettings).
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetDictionarySettingsResponse> getDictionarySettingsAsync() throws AlgoliaRuntimeException {
    return this.getDictionarySettingsAsync(null);
  }

  /**
   * The request must be authenticated by an API key with the [`logs`
   * ACL](https://www.algolia.com/doc/guides/security/api-keys/#access-control-list-acl). Logs are
   * held for the last seven days. There's also a logging limit of 1,000 API calls per server. This
   * request counts towards your [operations
   * quota](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-)
   * but doesn't appear in the logs itself. > **Note**: To fetch the logs for a Distributed Search
   * Network (DSN) cluster, target the [DSN's
   * endpoint](https://www.algolia.com/doc/guides/scaling/distributed-search-network-dsn/#accessing-dsn-servers).
   *
   * @param offset First log entry to retrieve. Sorted by decreasing date with 0 being the most
   *     recent. (optional, default to 0)
   * @param length Maximum number of entries to retrieve. (optional, default to 10)
   * @param indexName Index for which log entries should be retrieved. When omitted, log entries are
   *     retrieved for all indices. (optional)
   * @param type Type of log entries to retrieve. When omitted, all log entries are retrieved.
   *     (optional, default to all)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetLogsResponse getLogs(Integer offset, Integer length, String indexName, LogType type, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getLogsAsync(offset, length, indexName, type, requestOptions));
  }

  /**
   * The request must be authenticated by an API key with the [`logs`
   * ACL](https://www.algolia.com/doc/guides/security/api-keys/#access-control-list-acl). Logs are
   * held for the last seven days. There's also a logging limit of 1,000 API calls per server. This
   * request counts towards your [operations
   * quota](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-)
   * but doesn't appear in the logs itself. > **Note**: To fetch the logs for a Distributed Search
   * Network (DSN) cluster, target the [DSN's
   * endpoint](https://www.algolia.com/doc/guides/scaling/distributed-search-network-dsn/#accessing-dsn-servers).
   *
   * @param offset First log entry to retrieve. Sorted by decreasing date with 0 being the most
   *     recent. (optional, default to 0)
   * @param length Maximum number of entries to retrieve. (optional, default to 10)
   * @param indexName Index for which log entries should be retrieved. When omitted, log entries are
   *     retrieved for all indices. (optional)
   * @param type Type of log entries to retrieve. When omitted, all log entries are retrieved.
   *     (optional, default to all)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetLogsResponse getLogs(Integer offset, Integer length, String indexName, LogType type) throws AlgoliaRuntimeException {
    return this.getLogs(offset, length, indexName, type, null);
  }

  /**
   * The request must be authenticated by an API key with the [`logs`
   * ACL](https://www.algolia.com/doc/guides/security/api-keys/#access-control-list-acl). Logs are
   * held for the last seven days. There's also a logging limit of 1,000 API calls per server. This
   * request counts towards your [operations
   * quota](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-)
   * but doesn't appear in the logs itself. > **Note**: To fetch the logs for a Distributed Search
   * Network (DSN) cluster, target the [DSN's
   * endpoint](https://www.algolia.com/doc/guides/scaling/distributed-search-network-dsn/#accessing-dsn-servers).
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetLogsResponse getLogs(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getLogs(null, null, null, null, requestOptions);
  }

  /**
   * The request must be authenticated by an API key with the [`logs`
   * ACL](https://www.algolia.com/doc/guides/security/api-keys/#access-control-list-acl). Logs are
   * held for the last seven days. There's also a logging limit of 1,000 API calls per server. This
   * request counts towards your [operations
   * quota](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-)
   * but doesn't appear in the logs itself. > **Note**: To fetch the logs for a Distributed Search
   * Network (DSN) cluster, target the [DSN's
   * endpoint](https://www.algolia.com/doc/guides/scaling/distributed-search-network-dsn/#accessing-dsn-servers).
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetLogsResponse getLogs() throws AlgoliaRuntimeException {
    return this.getLogs(null, null, null, null, null);
  }

  /**
   * (asynchronously) The request must be authenticated by an API key with the [&#x60;logs&#x60;
   * ACL](https://www.algolia.com/doc/guides/security/api-keys/#access-control-list-acl). Logs are
   * held for the last seven days. There&#39;s also a logging limit of 1,000 API calls per server.
   * This request counts towards your [operations
   * quota](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-)
   * but doesn&#39;t appear in the logs itself. &gt; **Note**: To fetch the logs for a Distributed
   * Search Network (DSN) cluster, target the [DSN&#39;s
   * endpoint](https://www.algolia.com/doc/guides/scaling/distributed-search-network-dsn/#accessing-dsn-servers).
   *
   * @param offset First log entry to retrieve. Sorted by decreasing date with 0 being the most
   *     recent. (optional, default to 0)
   * @param length Maximum number of entries to retrieve. (optional, default to 10)
   * @param indexName Index for which log entries should be retrieved. When omitted, log entries are
   *     retrieved for all indices. (optional)
   * @param type Type of log entries to retrieve. When omitted, all log entries are retrieved.
   *     (optional, default to all)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetLogsResponse> getLogsAsync(
    Integer offset,
    Integer length,
    String indexName,
    LogType type,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/logs")
      .setMethod("GET")
      .addQueryParameter("offset", offset)
      .addQueryParameter("length", length)
      .addQueryParameter("indexName", indexName)
      .addQueryParameter("type", type)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetLogsResponse>() {});
  }

  /**
   * (asynchronously) The request must be authenticated by an API key with the [&#x60;logs&#x60;
   * ACL](https://www.algolia.com/doc/guides/security/api-keys/#access-control-list-acl). Logs are
   * held for the last seven days. There&#39;s also a logging limit of 1,000 API calls per server.
   * This request counts towards your [operations
   * quota](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-)
   * but doesn&#39;t appear in the logs itself. &gt; **Note**: To fetch the logs for a Distributed
   * Search Network (DSN) cluster, target the [DSN&#39;s
   * endpoint](https://www.algolia.com/doc/guides/scaling/distributed-search-network-dsn/#accessing-dsn-servers).
   *
   * @param offset First log entry to retrieve. Sorted by decreasing date with 0 being the most
   *     recent. (optional, default to 0)
   * @param length Maximum number of entries to retrieve. (optional, default to 10)
   * @param indexName Index for which log entries should be retrieved. When omitted, log entries are
   *     retrieved for all indices. (optional)
   * @param type Type of log entries to retrieve. When omitted, all log entries are retrieved.
   *     (optional, default to all)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetLogsResponse> getLogsAsync(Integer offset, Integer length, String indexName, LogType type)
    throws AlgoliaRuntimeException {
    return this.getLogsAsync(offset, length, indexName, type, null);
  }

  /**
   * (asynchronously) The request must be authenticated by an API key with the [&#x60;logs&#x60;
   * ACL](https://www.algolia.com/doc/guides/security/api-keys/#access-control-list-acl). Logs are
   * held for the last seven days. There&#39;s also a logging limit of 1,000 API calls per server.
   * This request counts towards your [operations
   * quota](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-)
   * but doesn&#39;t appear in the logs itself. &gt; **Note**: To fetch the logs for a Distributed
   * Search Network (DSN) cluster, target the [DSN&#39;s
   * endpoint](https://www.algolia.com/doc/guides/scaling/distributed-search-network-dsn/#accessing-dsn-servers).
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetLogsResponse> getLogsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getLogsAsync(null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) The request must be authenticated by an API key with the [&#x60;logs&#x60;
   * ACL](https://www.algolia.com/doc/guides/security/api-keys/#access-control-list-acl). Logs are
   * held for the last seven days. There&#39;s also a logging limit of 1,000 API calls per server.
   * This request counts towards your [operations
   * quota](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-)
   * but doesn&#39;t appear in the logs itself. &gt; **Note**: To fetch the logs for a Distributed
   * Search Network (DSN) cluster, target the [DSN&#39;s
   * endpoint](https://www.algolia.com/doc/guides/scaling/distributed-search-network-dsn/#accessing-dsn-servers).
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetLogsResponse> getLogsAsync() throws AlgoliaRuntimeException {
    return this.getLogsAsync(null, null, null, null, null);
  }

  /**
   * To get more than one record, use the [`objects` operation](#tag/Records/operation/getObjects).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param attributesToRetrieve Attributes to include with the records in the response. This is
   *     useful to reduce the size of the API response. By default, all retrievable attributes are
   *     returned. `objectID` is always retrieved, even when not specified.
   *     [`unretrievableAttributes`](https://www.algolia.com/doc/api-reference/api-parameters/unretrievableAttributes/)
   *     won't be retrieved unless the request is authenticated with the admin API key. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Map<String, String> getObject(
    @Nonnull String indexName,
    @Nonnull String objectID,
    List<String> attributesToRetrieve,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getObjectAsync(indexName, objectID, attributesToRetrieve, requestOptions));
  }

  /**
   * To get more than one record, use the [`objects` operation](#tag/Records/operation/getObjects).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param attributesToRetrieve Attributes to include with the records in the response. This is
   *     useful to reduce the size of the API response. By default, all retrievable attributes are
   *     returned. `objectID` is always retrieved, even when not specified.
   *     [`unretrievableAttributes`](https://www.algolia.com/doc/api-reference/api-parameters/unretrievableAttributes/)
   *     won't be retrieved unless the request is authenticated with the admin API key. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Map<String, String> getObject(@Nonnull String indexName, @Nonnull String objectID, List<String> attributesToRetrieve)
    throws AlgoliaRuntimeException {
    return this.getObject(indexName, objectID, attributesToRetrieve, null);
  }

  /**
   * To get more than one record, use the [`objects` operation](#tag/Records/operation/getObjects).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Map<String, String> getObject(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getObject(indexName, objectID, null, requestOptions);
  }

  /**
   * To get more than one record, use the [`objects` operation](#tag/Records/operation/getObjects).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Map<String, String> getObject(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
    return this.getObject(indexName, objectID, null, null);
  }

  /**
   * (asynchronously) To get more than one record, use the [&#x60;objects&#x60;
   * operation](#tag/Records/operation/getObjects).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param attributesToRetrieve Attributes to include with the records in the response. This is
   *     useful to reduce the size of the API response. By default, all retrievable attributes are
   *     returned. `objectID` is always retrieved, even when not specified.
   *     [`unretrievableAttributes`](https://www.algolia.com/doc/api-reference/api-parameters/unretrievableAttributes/)
   *     won't be retrieved unless the request is authenticated with the admin API key. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Map<String, String>> getObjectAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    List<String> attributesToRetrieve,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getObject`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `getObject`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/{objectID}", indexName, objectID)
      .setMethod("GET")
      .addQueryParameter("attributesToRetrieve", attributesToRetrieve)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Map<String, String>>() {});
  }

  /**
   * (asynchronously) To get more than one record, use the [&#x60;objects&#x60;
   * operation](#tag/Records/operation/getObjects).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param attributesToRetrieve Attributes to include with the records in the response. This is
   *     useful to reduce the size of the API response. By default, all retrievable attributes are
   *     returned. `objectID` is always retrieved, even when not specified.
   *     [`unretrievableAttributes`](https://www.algolia.com/doc/api-reference/api-parameters/unretrievableAttributes/)
   *     won't be retrieved unless the request is authenticated with the admin API key. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Map<String, String>> getObjectAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    List<String> attributesToRetrieve
  ) throws AlgoliaRuntimeException {
    return this.getObjectAsync(indexName, objectID, attributesToRetrieve, null);
  }

  /**
   * (asynchronously) To get more than one record, use the [&#x60;objects&#x60;
   * operation](#tag/Records/operation/getObjects).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Map<String, String>> getObjectAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getObjectAsync(indexName, objectID, null, requestOptions);
  }

  /**
   * (asynchronously) To get more than one record, use the [&#x60;objects&#x60;
   * operation](#tag/Records/operation/getObjects).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Map<String, String>> getObjectAsync(@Nonnull String indexName, @Nonnull String objectID)
    throws AlgoliaRuntimeException {
    return this.getObjectAsync(indexName, objectID, null, null);
  }

  /**
   * Retrieve one or more records, potentially from different indices, in a single API operation.
   * Results will be received in the same order as the requests.
   *
   * @param getObjectsParams Request object. (required)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> GetObjectsResponse<T> getObjects(
    @Nonnull GetObjectsParams getObjectsParams,
    Class<T> innerType,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getObjectsAsync(getObjectsParams, innerType, requestOptions));
  }

  /**
   * Retrieve one or more records, potentially from different indices, in a single API operation.
   * Results will be received in the same order as the requests.
   *
   * @param getObjectsParams Request object. (required)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> GetObjectsResponse<T> getObjects(@Nonnull GetObjectsParams getObjectsParams, Class<T> innerType)
    throws AlgoliaRuntimeException {
    return this.getObjects(getObjectsParams, innerType, null);
  }

  /**
   * (asynchronously) Retrieve one or more records, potentially from different indices, in a single
   * API operation. Results will be received in the same order as the requests.
   *
   * @param getObjectsParams Request object. (required)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> CompletableFuture<GetObjectsResponse<T>> getObjectsAsync(
    @Nonnull GetObjectsParams getObjectsParams,
    Class<T> innerType,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(getObjectsParams, "Parameter `getObjectsParams` is required when calling `getObjects`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/*/objects")
      .setMethod("POST")
      .setBody(getObjectsParams)
      .setRead(true)
      .build();
    return executeAsync(request, requestOptions, GetObjectsResponse.class, innerType);
  }

  /**
   * (asynchronously) Retrieve one or more records, potentially from different indices, in a single
   * API operation. Results will be received in the same order as the requests.
   *
   * @param getObjectsParams Request object. (required)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> CompletableFuture<GetObjectsResponse<T>> getObjectsAsync(@Nonnull GetObjectsParams getObjectsParams, Class<T> innerType)
    throws AlgoliaRuntimeException {
    return this.getObjectsAsync(getObjectsParams, innerType, null);
  }

  /**
   * Get a rule by its `objectID`. To find the `objectID` for rules, use the [`search`
   * operation](#tag/Rules/operation/searchRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Rule getRule(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRuleAsync(indexName, objectID, requestOptions));
  }

  /**
   * Get a rule by its `objectID`. To find the `objectID` for rules, use the [`search`
   * operation](#tag/Rules/operation/searchRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Rule getRule(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
    return this.getRule(indexName, objectID, null);
  }

  /**
   * (asynchronously) Get a rule by its &#x60;objectID&#x60;. To find the &#x60;objectID&#x60; for
   * rules, use the [&#x60;search&#x60; operation](#tag/Rules/operation/searchRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Rule> getRuleAsync(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getRule`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `getRule`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/rules/{objectID}", indexName, objectID)
      .setMethod("GET")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Rule>() {});
  }

  /**
   * (asynchronously) Get a rule by its &#x60;objectID&#x60;. To find the &#x60;objectID&#x60; for
   * rules, use the [&#x60;search&#x60; operation](#tag/Rules/operation/searchRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Rule> getRuleAsync(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
    return this.getRuleAsync(indexName, objectID, null);
  }

  /**
   * Return an object containing an index's [configuration
   * settings](https://www.algolia.com/doc/api-reference/settings-api-parameters/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexSettings getSettings(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSettingsAsync(indexName, requestOptions));
  }

  /**
   * Return an object containing an index's [configuration
   * settings](https://www.algolia.com/doc/api-reference/settings-api-parameters/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexSettings getSettings(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getSettings(indexName, null);
  }

  /**
   * (asynchronously) Return an object containing an index&#39;s [configuration
   * settings](https://www.algolia.com/doc/api-reference/settings-api-parameters/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexSettings> getSettingsAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getSettings`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/settings", indexName).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<IndexSettings>() {});
  }

  /**
   * (asynchronously) Return an object containing an index&#39;s [configuration
   * settings](https://www.algolia.com/doc/api-reference/settings-api-parameters/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexSettings> getSettingsAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getSettingsAsync(indexName, null);
  }

  /**
   * Get all allowed sources (IP addresses).
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Source> getSources(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSourcesAsync(requestOptions));
  }

  /**
   * Get all allowed sources (IP addresses).
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Source> getSources() throws AlgoliaRuntimeException {
    return this.getSources(null);
  }

  /**
   * (asynchronously) Get all allowed sources (IP addresses).
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Source>> getSourcesAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/security/sources").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<List<Source>>() {});
  }

  /**
   * (asynchronously) Get all allowed sources (IP addresses).
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Source>> getSourcesAsync() throws AlgoliaRuntimeException {
    return this.getSourcesAsync(null);
  }

  /**
   * Get a syonym by its `objectID`. To find the object IDs for your synonyms, use the [`search`
   * operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SynonymHit getSynonym(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSynonymAsync(indexName, objectID, requestOptions));
  }

  /**
   * Get a syonym by its `objectID`. To find the object IDs for your synonyms, use the [`search`
   * operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SynonymHit getSynonym(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
    return this.getSynonym(indexName, objectID, null);
  }

  /**
   * (asynchronously) Get a syonym by its &#x60;objectID&#x60;. To find the object IDs for your
   * synonyms, use the [&#x60;search&#x60; operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SynonymHit> getSynonymAsync(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getSynonym`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `getSynonym`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/synonyms/{objectID}", indexName, objectID)
      .setMethod("GET")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<SynonymHit>() {});
  }

  /**
   * (asynchronously) Get a syonym by its &#x60;objectID&#x60;. To find the object IDs for your
   * synonyms, use the [&#x60;search&#x60; operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SynonymHit> getSynonymAsync(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
    return this.getSynonymAsync(indexName, objectID, null);
  }

  /**
   * Some operations, such as copying an index, will respond with a `taskID` value. Use this value
   * here to check the status of that task.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param taskID Unique task identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTaskResponse getTask(@Nonnull String indexName, @Nonnull Long taskID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTaskAsync(indexName, taskID, requestOptions));
  }

  /**
   * Some operations, such as copying an index, will respond with a `taskID` value. Use this value
   * here to check the status of that task.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param taskID Unique task identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTaskResponse getTask(@Nonnull String indexName, @Nonnull Long taskID) throws AlgoliaRuntimeException {
    return this.getTask(indexName, taskID, null);
  }

  /**
   * (asynchronously) Some operations, such as copying an index, will respond with a
   * &#x60;taskID&#x60; value. Use this value here to check the status of that task.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param taskID Unique task identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTaskResponse> getTaskAsync(@Nonnull String indexName, @Nonnull Long taskID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getTask`.");

    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `getTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/task/{taskID}", indexName, taskID).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<GetTaskResponse>() {});
  }

  /**
   * (asynchronously) Some operations, such as copying an index, will respond with a
   * &#x60;taskID&#x60; value. Use this value here to check the status of that task.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param taskID Unique task identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTaskResponse> getTaskAsync(@Nonnull String indexName, @Nonnull Long taskID) throws AlgoliaRuntimeException {
    return this.getTaskAsync(indexName, taskID, null);
  }

  /**
   * Get the IDs of the 10 users with the highest number of records per cluster. Since it can take
   * up to a few seconds to get the data from the different clusters, the response isn't real-time.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopUserIdsResponse getTopUserIds(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTopUserIdsAsync(requestOptions));
  }

  /**
   * Get the IDs of the 10 users with the highest number of records per cluster. Since it can take
   * up to a few seconds to get the data from the different clusters, the response isn't real-time.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopUserIdsResponse getTopUserIds() throws AlgoliaRuntimeException {
    return this.getTopUserIds(null);
  }

  /**
   * (asynchronously) Get the IDs of the 10 users with the highest number of records per cluster.
   * Since it can take up to a few seconds to get the data from the different clusters, the response
   * isn&#39;t real-time.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopUserIdsResponse> getTopUserIdsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/clusters/mapping/top").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<GetTopUserIdsResponse>() {});
  }

  /**
   * (asynchronously) Get the IDs of the 10 users with the highest number of records per cluster.
   * Since it can take up to a few seconds to get the data from the different clusters, the response
   * isn&#39;t real-time.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopUserIdsResponse> getTopUserIdsAsync() throws AlgoliaRuntimeException {
    return this.getTopUserIdsAsync(null);
  }

  /**
   * Returns the userID data stored in the mapping. Since it can take up to a few seconds to get the
   * data from the different clusters, the response isn't real-time.
   *
   * @param userID userID to assign. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UserId getUserId(@Nonnull String userID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getUserIdAsync(userID, requestOptions));
  }

  /**
   * Returns the userID data stored in the mapping. Since it can take up to a few seconds to get the
   * data from the different clusters, the response isn't real-time.
   *
   * @param userID userID to assign. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UserId getUserId(@Nonnull String userID) throws AlgoliaRuntimeException {
    return this.getUserId(userID, null);
  }

  /**
   * (asynchronously) Returns the userID data stored in the mapping. Since it can take up to a few
   * seconds to get the data from the different clusters, the response isn&#39;t real-time.
   *
   * @param userID userID to assign. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UserId> getUserIdAsync(@Nonnull String userID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(userID, "Parameter `userID` is required when calling `getUserId`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/clusters/mapping/{userID}", userID).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<UserId>() {});
  }

  /**
   * (asynchronously) Returns the userID data stored in the mapping. Since it can take up to a few
   * seconds to get the data from the different clusters, the response isn&#39;t real-time.
   *
   * @param userID userID to assign. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UserId> getUserIdAsync(@Nonnull String userID) throws AlgoliaRuntimeException {
    return this.getUserIdAsync(userID, null);
  }

  /**
   * To determine when the time-consuming process of creating a large batch of users or migrating
   * users from one cluster to another is complete, this operation retrieves the status of the
   * process.
   *
   * @param getClusters Indicates whether to include the cluster's pending mapping state in the
   *     response. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public HasPendingMappingsResponse hasPendingMappings(Boolean getClusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(hasPendingMappingsAsync(getClusters, requestOptions));
  }

  /**
   * To determine when the time-consuming process of creating a large batch of users or migrating
   * users from one cluster to another is complete, this operation retrieves the status of the
   * process.
   *
   * @param getClusters Indicates whether to include the cluster's pending mapping state in the
   *     response. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public HasPendingMappingsResponse hasPendingMappings(Boolean getClusters) throws AlgoliaRuntimeException {
    return this.hasPendingMappings(getClusters, null);
  }

  /**
   * To determine when the time-consuming process of creating a large batch of users or migrating
   * users from one cluster to another is complete, this operation retrieves the status of the
   * process.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public HasPendingMappingsResponse hasPendingMappings(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.hasPendingMappings(null, requestOptions);
  }

  /**
   * To determine when the time-consuming process of creating a large batch of users or migrating
   * users from one cluster to another is complete, this operation retrieves the status of the
   * process.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public HasPendingMappingsResponse hasPendingMappings() throws AlgoliaRuntimeException {
    return this.hasPendingMappings(null, null);
  }

  /**
   * (asynchronously) To determine when the time-consuming process of creating a large batch of
   * users or migrating users from one cluster to another is complete, this operation retrieves the
   * status of the process.
   *
   * @param getClusters Indicates whether to include the cluster's pending mapping state in the
   *     response. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync(Boolean getClusters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/clusters/mapping/pending")
      .setMethod("GET")
      .addQueryParameter("getClusters", getClusters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<HasPendingMappingsResponse>() {});
  }

  /**
   * (asynchronously) To determine when the time-consuming process of creating a large batch of
   * users or migrating users from one cluster to another is complete, this operation retrieves the
   * status of the process.
   *
   * @param getClusters Indicates whether to include the cluster's pending mapping state in the
   *     response. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync(Boolean getClusters) throws AlgoliaRuntimeException {
    return this.hasPendingMappingsAsync(getClusters, null);
  }

  /**
   * (asynchronously) To determine when the time-consuming process of creating a large batch of
   * users or migrating users from one cluster to another is complete, this operation retrieves the
   * status of the process.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync(RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.hasPendingMappingsAsync(null, requestOptions);
  }

  /**
   * (asynchronously) To determine when the time-consuming process of creating a large batch of
   * users or migrating users from one cluster to another is complete, this operation retrieves the
   * status of the process.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync() throws AlgoliaRuntimeException {
    return this.hasPendingMappingsAsync(null, null);
  }

  /**
   * List all API keys associated with your Algolia application, including their permissions and
   * restrictions.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListApiKeysResponse listApiKeys(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(listApiKeysAsync(requestOptions));
  }

  /**
   * List all API keys associated with your Algolia application, including their permissions and
   * restrictions.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListApiKeysResponse listApiKeys() throws AlgoliaRuntimeException {
    return this.listApiKeys(null);
  }

  /**
   * (asynchronously) List all API keys associated with your Algolia application, including their
   * permissions and restrictions.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListApiKeysResponse> listApiKeysAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/keys").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<ListApiKeysResponse>() {});
  }

  /**
   * (asynchronously) List all API keys associated with your Algolia application, including their
   * permissions and restrictions.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListApiKeysResponse> listApiKeysAsync() throws AlgoliaRuntimeException {
    return this.listApiKeysAsync(null);
  }

  /**
   * List the available clusters in a multi-cluster setup.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListClustersResponse listClusters(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(listClustersAsync(requestOptions));
  }

  /**
   * List the available clusters in a multi-cluster setup.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListClustersResponse listClusters() throws AlgoliaRuntimeException {
    return this.listClusters(null);
  }

  /**
   * (asynchronously) List the available clusters in a multi-cluster setup.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListClustersResponse> listClustersAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/clusters").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<ListClustersResponse>() {});
  }

  /**
   * (asynchronously) List the available clusters in a multi-cluster setup.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListClustersResponse> listClustersAsync() throws AlgoliaRuntimeException {
    return this.listClustersAsync(null);
  }

  /**
   * List indices in an Algolia application.
   *
   * @param page Returns the requested page number. The page size is determined by the `hitsPerPage`
   *     parameter. You can see the number of available pages in the `nbPages` response attribute.
   *     When `page` is null, the API response is not paginated. (optional)
   * @param hitsPerPage Maximum number of hits per page. (optional, default to 100)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListIndicesResponse listIndices(Integer page, Integer hitsPerPage, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(listIndicesAsync(page, hitsPerPage, requestOptions));
  }

  /**
   * List indices in an Algolia application.
   *
   * @param page Returns the requested page number. The page size is determined by the `hitsPerPage`
   *     parameter. You can see the number of available pages in the `nbPages` response attribute.
   *     When `page` is null, the API response is not paginated. (optional)
   * @param hitsPerPage Maximum number of hits per page. (optional, default to 100)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListIndicesResponse listIndices(Integer page, Integer hitsPerPage) throws AlgoliaRuntimeException {
    return this.listIndices(page, hitsPerPage, null);
  }

  /**
   * List indices in an Algolia application.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListIndicesResponse listIndices(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.listIndices(null, null, requestOptions);
  }

  /**
   * List indices in an Algolia application.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListIndicesResponse listIndices() throws AlgoliaRuntimeException {
    return this.listIndices(null, null, null);
  }

  /**
   * (asynchronously) List indices in an Algolia application.
   *
   * @param page Returns the requested page number. The page size is determined by the `hitsPerPage`
   *     parameter. You can see the number of available pages in the `nbPages` response attribute.
   *     When `page` is null, the API response is not paginated. (optional)
   * @param hitsPerPage Maximum number of hits per page. (optional, default to 100)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListIndicesResponse> listIndicesAsync(Integer page, Integer hitsPerPage, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes")
      .setMethod("GET")
      .addQueryParameter("page", page)
      .addQueryParameter("hitsPerPage", hitsPerPage)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListIndicesResponse>() {});
  }

  /**
   * (asynchronously) List indices in an Algolia application.
   *
   * @param page Returns the requested page number. The page size is determined by the `hitsPerPage`
   *     parameter. You can see the number of available pages in the `nbPages` response attribute.
   *     When `page` is null, the API response is not paginated. (optional)
   * @param hitsPerPage Maximum number of hits per page. (optional, default to 100)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListIndicesResponse> listIndicesAsync(Integer page, Integer hitsPerPage) throws AlgoliaRuntimeException {
    return this.listIndicesAsync(page, hitsPerPage, null);
  }

  /**
   * (asynchronously) List indices in an Algolia application.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListIndicesResponse> listIndicesAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.listIndicesAsync(null, null, requestOptions);
  }

  /**
   * (asynchronously) List indices in an Algolia application.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListIndicesResponse> listIndicesAsync() throws AlgoliaRuntimeException {
    return this.listIndicesAsync(null, null, null);
  }

  /**
   * List the userIDs assigned to a multi-cluster application. Since it can take up to a few seconds
   * to get the data from the different clusters, the response isn't real-time.
   *
   * @param page Returns the requested page number. The page size is determined by the `hitsPerPage`
   *     parameter. You can see the number of available pages in the `nbPages` response attribute.
   *     When `page` is null, the API response is not paginated. (optional)
   * @param hitsPerPage Maximum number of hits per page. (optional, default to 100)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListUserIdsResponse listUserIds(Integer page, Integer hitsPerPage, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(listUserIdsAsync(page, hitsPerPage, requestOptions));
  }

  /**
   * List the userIDs assigned to a multi-cluster application. Since it can take up to a few seconds
   * to get the data from the different clusters, the response isn't real-time.
   *
   * @param page Returns the requested page number. The page size is determined by the `hitsPerPage`
   *     parameter. You can see the number of available pages in the `nbPages` response attribute.
   *     When `page` is null, the API response is not paginated. (optional)
   * @param hitsPerPage Maximum number of hits per page. (optional, default to 100)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListUserIdsResponse listUserIds(Integer page, Integer hitsPerPage) throws AlgoliaRuntimeException {
    return this.listUserIds(page, hitsPerPage, null);
  }

  /**
   * List the userIDs assigned to a multi-cluster application. Since it can take up to a few seconds
   * to get the data from the different clusters, the response isn't real-time.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListUserIdsResponse listUserIds(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.listUserIds(null, null, requestOptions);
  }

  /**
   * List the userIDs assigned to a multi-cluster application. Since it can take up to a few seconds
   * to get the data from the different clusters, the response isn't real-time.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListUserIdsResponse listUserIds() throws AlgoliaRuntimeException {
    return this.listUserIds(null, null, null);
  }

  /**
   * (asynchronously) List the userIDs assigned to a multi-cluster application. Since it can take up
   * to a few seconds to get the data from the different clusters, the response isn&#39;t real-time.
   *
   * @param page Returns the requested page number. The page size is determined by the `hitsPerPage`
   *     parameter. You can see the number of available pages in the `nbPages` response attribute.
   *     When `page` is null, the API response is not paginated. (optional)
   * @param hitsPerPage Maximum number of hits per page. (optional, default to 100)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListUserIdsResponse> listUserIdsAsync(Integer page, Integer hitsPerPage, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/clusters/mapping")
      .setMethod("GET")
      .addQueryParameter("page", page)
      .addQueryParameter("hitsPerPage", hitsPerPage)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListUserIdsResponse>() {});
  }

  /**
   * (asynchronously) List the userIDs assigned to a multi-cluster application. Since it can take up
   * to a few seconds to get the data from the different clusters, the response isn&#39;t real-time.
   *
   * @param page Returns the requested page number. The page size is determined by the `hitsPerPage`
   *     parameter. You can see the number of available pages in the `nbPages` response attribute.
   *     When `page` is null, the API response is not paginated. (optional)
   * @param hitsPerPage Maximum number of hits per page. (optional, default to 100)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListUserIdsResponse> listUserIdsAsync(Integer page, Integer hitsPerPage) throws AlgoliaRuntimeException {
    return this.listUserIdsAsync(page, hitsPerPage, null);
  }

  /**
   * (asynchronously) List the userIDs assigned to a multi-cluster application. Since it can take up
   * to a few seconds to get the data from the different clusters, the response isn&#39;t real-time.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListUserIdsResponse> listUserIdsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.listUserIdsAsync(null, null, requestOptions);
  }

  /**
   * (asynchronously) List the userIDs assigned to a multi-cluster application. Since it can take up
   * to a few seconds to get the data from the different clusters, the response isn&#39;t real-time.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListUserIdsResponse> listUserIdsAsync() throws AlgoliaRuntimeException {
    return this.listUserIdsAsync(null, null, null);
  }

  /**
   * To reduce the time spent on network round trips, you can perform several write actions in a
   * single request. It's a multi-index version of the [`batch`
   * operation](#tag/Records/operation/batch). Actions are applied in the order they are specified.
   * The supported actions are equivalent to the individual operations of the same name.
   *
   * @param batchParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public MultipleBatchResponse multipleBatch(@Nonnull BatchParams batchParams, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(multipleBatchAsync(batchParams, requestOptions));
  }

  /**
   * To reduce the time spent on network round trips, you can perform several write actions in a
   * single request. It's a multi-index version of the [`batch`
   * operation](#tag/Records/operation/batch). Actions are applied in the order they are specified.
   * The supported actions are equivalent to the individual operations of the same name.
   *
   * @param batchParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public MultipleBatchResponse multipleBatch(@Nonnull BatchParams batchParams) throws AlgoliaRuntimeException {
    return this.multipleBatch(batchParams, null);
  }

  /**
   * (asynchronously) To reduce the time spent on network round trips, you can perform several write
   * actions in a single request. It&#39;s a multi-index version of the [&#x60;batch&#x60;
   * operation](#tag/Records/operation/batch). Actions are applied in the order they are specified.
   * The supported actions are equivalent to the individual operations of the same name.
   *
   * @param batchParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<MultipleBatchResponse> multipleBatchAsync(@Nonnull BatchParams batchParams, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(batchParams, "Parameter `batchParams` is required when calling `multipleBatch`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/indexes/*/batch").setMethod("POST").setBody(batchParams).build();
    return executeAsync(request, requestOptions, new TypeReference<MultipleBatchResponse>() {});
  }

  /**
   * (asynchronously) To reduce the time spent on network round trips, you can perform several write
   * actions in a single request. It&#39;s a multi-index version of the [&#x60;batch&#x60;
   * operation](#tag/Records/operation/batch). Actions are applied in the order they are specified.
   * The supported actions are equivalent to the individual operations of the same name.
   *
   * @param batchParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<MultipleBatchResponse> multipleBatchAsync(@Nonnull BatchParams batchParams) throws AlgoliaRuntimeException {
    return this.multipleBatchAsync(batchParams, null);
  }

  /**
   * This `operation`, _copy_ or _move_, will copy or move a source index's (`IndexName`) records,
   * settings, synonyms, and rules to a `destination` index. If the destination index exists, it
   * will be replaced, except for index-specific API keys and analytics data. If the destination
   * index doesn't exist, it will be created. The choice between moving or copying an index depends
   * on your needs. Choose: - **Move** to rename an index. - **Copy** to create a new index with the
   * same records and configuration as an existing one. > **Note**: When considering copying or
   * moving, be aware of the [rate
   * limitations](https://www.algolia.com/doc/guides/scaling/algolia-service-limits/#application-record-and-index-limits)
   * on these processes and the [impact on your analytics
   * data](https://www.algolia.com/doc/guides/sending-and-managing-data/manage-indices-and-apps/manage-indices/concepts/indices-analytics/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param operationIndexParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse operationIndex(
    @Nonnull String indexName,
    @Nonnull OperationIndexParams operationIndexParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(operationIndexAsync(indexName, operationIndexParams, requestOptions));
  }

  /**
   * This `operation`, _copy_ or _move_, will copy or move a source index's (`IndexName`) records,
   * settings, synonyms, and rules to a `destination` index. If the destination index exists, it
   * will be replaced, except for index-specific API keys and analytics data. If the destination
   * index doesn't exist, it will be created. The choice between moving or copying an index depends
   * on your needs. Choose: - **Move** to rename an index. - **Copy** to create a new index with the
   * same records and configuration as an existing one. > **Note**: When considering copying or
   * moving, be aware of the [rate
   * limitations](https://www.algolia.com/doc/guides/scaling/algolia-service-limits/#application-record-and-index-limits)
   * on these processes and the [impact on your analytics
   * data](https://www.algolia.com/doc/guides/sending-and-managing-data/manage-indices-and-apps/manage-indices/concepts/indices-analytics/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param operationIndexParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse operationIndex(@Nonnull String indexName, @Nonnull OperationIndexParams operationIndexParams)
    throws AlgoliaRuntimeException {
    return this.operationIndex(indexName, operationIndexParams, null);
  }

  /**
   * (asynchronously) This &#x60;operation&#x60;, _copy_ or _move_, will copy or move a source
   * index&#39;s (&#x60;IndexName&#x60;) records, settings, synonyms, and rules to a
   * &#x60;destination&#x60; index. If the destination index exists, it will be replaced, except for
   * index-specific API keys and analytics data. If the destination index doesn&#39;t exist, it will
   * be created. The choice between moving or copying an index depends on your needs. Choose: -
   * **Move** to rename an index. - **Copy** to create a new index with the same records and
   * configuration as an existing one. &gt; **Note**: When considering copying or moving, be aware
   * of the [rate
   * limitations](https://www.algolia.com/doc/guides/scaling/algolia-service-limits/#application-record-and-index-limits)
   * on these processes and the [impact on your analytics
   * data](https://www.algolia.com/doc/guides/sending-and-managing-data/manage-indices-and-apps/manage-indices/concepts/indices-analytics/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param operationIndexParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> operationIndexAsync(
    @Nonnull String indexName,
    @Nonnull OperationIndexParams operationIndexParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `operationIndex`.");

    Parameters.requireNonNull(operationIndexParams, "Parameter `operationIndexParams` is required when calling `operationIndex`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/operation", indexName)
      .setMethod("POST")
      .setBody(operationIndexParams)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>() {});
  }

  /**
   * (asynchronously) This &#x60;operation&#x60;, _copy_ or _move_, will copy or move a source
   * index&#39;s (&#x60;IndexName&#x60;) records, settings, synonyms, and rules to a
   * &#x60;destination&#x60; index. If the destination index exists, it will be replaced, except for
   * index-specific API keys and analytics data. If the destination index doesn&#39;t exist, it will
   * be created. The choice between moving or copying an index depends on your needs. Choose: -
   * **Move** to rename an index. - **Copy** to create a new index with the same records and
   * configuration as an existing one. &gt; **Note**: When considering copying or moving, be aware
   * of the [rate
   * limitations](https://www.algolia.com/doc/guides/scaling/algolia-service-limits/#application-record-and-index-limits)
   * on these processes and the [impact on your analytics
   * data](https://www.algolia.com/doc/guides/sending-and-managing-data/manage-indices-and-apps/manage-indices/concepts/indices-analytics/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param operationIndexParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> operationIndexAsync(
    @Nonnull String indexName,
    @Nonnull OperationIndexParams operationIndexParams
  ) throws AlgoliaRuntimeException {
    return this.operationIndexAsync(indexName, operationIndexParams, null);
  }

  /**
   * Add new attributes or update current ones in an existing record. You can use any first-level
   * attribute but not nested attributes. If you specify a [nested
   * attribute](https://www.algolia.com/doc/guides/sending-and-managing-data/prepare-your-data/how-to/creating-and-using-nested-attributes/),
   * the engine treats it as a replacement for its first-level ancestor.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param attributesToUpdate Object with attributes to update. (required)
   * @param createIfNotExists Indicates whether to create a new record if it doesn't exist yet.
   *     (optional, default to true)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtWithObjectIdResponse partialUpdateObject(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Map<String, AttributeToUpdate> attributesToUpdate,
    Boolean createIfNotExists,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(partialUpdateObjectAsync(indexName, objectID, attributesToUpdate, createIfNotExists, requestOptions));
  }

  /**
   * Add new attributes or update current ones in an existing record. You can use any first-level
   * attribute but not nested attributes. If you specify a [nested
   * attribute](https://www.algolia.com/doc/guides/sending-and-managing-data/prepare-your-data/how-to/creating-and-using-nested-attributes/),
   * the engine treats it as a replacement for its first-level ancestor.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param attributesToUpdate Object with attributes to update. (required)
   * @param createIfNotExists Indicates whether to create a new record if it doesn't exist yet.
   *     (optional, default to true)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtWithObjectIdResponse partialUpdateObject(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Map<String, AttributeToUpdate> attributesToUpdate,
    Boolean createIfNotExists
  ) throws AlgoliaRuntimeException {
    return this.partialUpdateObject(indexName, objectID, attributesToUpdate, createIfNotExists, null);
  }

  /**
   * Add new attributes or update current ones in an existing record. You can use any first-level
   * attribute but not nested attributes. If you specify a [nested
   * attribute](https://www.algolia.com/doc/guides/sending-and-managing-data/prepare-your-data/how-to/creating-and-using-nested-attributes/),
   * the engine treats it as a replacement for its first-level ancestor.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param attributesToUpdate Object with attributes to update. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtWithObjectIdResponse partialUpdateObject(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Map<String, AttributeToUpdate> attributesToUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.partialUpdateObject(indexName, objectID, attributesToUpdate, null, requestOptions);
  }

  /**
   * Add new attributes or update current ones in an existing record. You can use any first-level
   * attribute but not nested attributes. If you specify a [nested
   * attribute](https://www.algolia.com/doc/guides/sending-and-managing-data/prepare-your-data/how-to/creating-and-using-nested-attributes/),
   * the engine treats it as a replacement for its first-level ancestor.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param attributesToUpdate Object with attributes to update. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtWithObjectIdResponse partialUpdateObject(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Map<String, AttributeToUpdate> attributesToUpdate
  ) throws AlgoliaRuntimeException {
    return this.partialUpdateObject(indexName, objectID, attributesToUpdate, null, null);
  }

  /**
   * (asynchronously) Add new attributes or update current ones in an existing record. You can use
   * any first-level attribute but not nested attributes. If you specify a [nested
   * attribute](https://www.algolia.com/doc/guides/sending-and-managing-data/prepare-your-data/how-to/creating-and-using-nested-attributes/),
   * the engine treats it as a replacement for its first-level ancestor.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param attributesToUpdate Object with attributes to update. (required)
   * @param createIfNotExists Indicates whether to create a new record if it doesn't exist yet.
   *     (optional, default to true)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtWithObjectIdResponse> partialUpdateObjectAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Map<String, AttributeToUpdate> attributesToUpdate,
    Boolean createIfNotExists,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `partialUpdateObject`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `partialUpdateObject`.");

    Parameters.requireNonNull(attributesToUpdate, "Parameter `attributesToUpdate` is required when calling `partialUpdateObject`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/{objectID}/partial", indexName, objectID)
      .setMethod("POST")
      .setBody(attributesToUpdate)
      .addQueryParameter("createIfNotExists", createIfNotExists)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtWithObjectIdResponse>() {});
  }

  /**
   * (asynchronously) Add new attributes or update current ones in an existing record. You can use
   * any first-level attribute but not nested attributes. If you specify a [nested
   * attribute](https://www.algolia.com/doc/guides/sending-and-managing-data/prepare-your-data/how-to/creating-and-using-nested-attributes/),
   * the engine treats it as a replacement for its first-level ancestor.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param attributesToUpdate Object with attributes to update. (required)
   * @param createIfNotExists Indicates whether to create a new record if it doesn't exist yet.
   *     (optional, default to true)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtWithObjectIdResponse> partialUpdateObjectAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Map<String, AttributeToUpdate> attributesToUpdate,
    Boolean createIfNotExists
  ) throws AlgoliaRuntimeException {
    return this.partialUpdateObjectAsync(indexName, objectID, attributesToUpdate, createIfNotExists, null);
  }

  /**
   * (asynchronously) Add new attributes or update current ones in an existing record. You can use
   * any first-level attribute but not nested attributes. If you specify a [nested
   * attribute](https://www.algolia.com/doc/guides/sending-and-managing-data/prepare-your-data/how-to/creating-and-using-nested-attributes/),
   * the engine treats it as a replacement for its first-level ancestor.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param attributesToUpdate Object with attributes to update. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtWithObjectIdResponse> partialUpdateObjectAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Map<String, AttributeToUpdate> attributesToUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.partialUpdateObjectAsync(indexName, objectID, attributesToUpdate, null, requestOptions);
  }

  /**
   * (asynchronously) Add new attributes or update current ones in an existing record. You can use
   * any first-level attribute but not nested attributes. If you specify a [nested
   * attribute](https://www.algolia.com/doc/guides/sending-and-managing-data/prepare-your-data/how-to/creating-and-using-nested-attributes/),
   * the engine treats it as a replacement for its first-level ancestor.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param attributesToUpdate Object with attributes to update. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtWithObjectIdResponse> partialUpdateObjectAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Map<String, AttributeToUpdate> attributesToUpdate
  ) throws AlgoliaRuntimeException {
    return this.partialUpdateObjectAsync(indexName, objectID, attributesToUpdate, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(postAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.post(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.post(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.post(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `post`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/1{path}", path)
      .setMethod("POST")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.postAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.postAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.postAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(putAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.put(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.put(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.put(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `put`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/1{path}", path)
      .setMethod("PUT")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.putAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.putAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.putAsync(path, null, null, null);
  }

  /**
   * Remove a userID and its associated data from the multi-clusters.
   *
   * @param userID userID to assign. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RemoveUserIdResponse removeUserId(@Nonnull String userID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(removeUserIdAsync(userID, requestOptions));
  }

  /**
   * Remove a userID and its associated data from the multi-clusters.
   *
   * @param userID userID to assign. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RemoveUserIdResponse removeUserId(@Nonnull String userID) throws AlgoliaRuntimeException {
    return this.removeUserId(userID, null);
  }

  /**
   * (asynchronously) Remove a userID and its associated data from the multi-clusters.
   *
   * @param userID userID to assign. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RemoveUserIdResponse> removeUserIdAsync(@Nonnull String userID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(userID, "Parameter `userID` is required when calling `removeUserId`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/clusters/mapping/{userID}", userID).setMethod("DELETE").build();
    return executeAsync(request, requestOptions, new TypeReference<RemoveUserIdResponse>() {});
  }

  /**
   * (asynchronously) Remove a userID and its associated data from the multi-clusters.
   *
   * @param userID userID to assign. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RemoveUserIdResponse> removeUserIdAsync(@Nonnull String userID) throws AlgoliaRuntimeException {
    return this.removeUserIdAsync(userID, null);
  }

  /**
   * Replace all allowed sources.
   *
   * @param source Allowed sources. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ReplaceSourceResponse replaceSources(@Nonnull List<Source> source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(replaceSourcesAsync(source, requestOptions));
  }

  /**
   * Replace all allowed sources.
   *
   * @param source Allowed sources. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ReplaceSourceResponse replaceSources(@Nonnull List<Source> source) throws AlgoliaRuntimeException {
    return this.replaceSources(source, null);
  }

  /**
   * (asynchronously) Replace all allowed sources.
   *
   * @param source Allowed sources. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ReplaceSourceResponse> replaceSourcesAsync(@Nonnull List<Source> source, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(source, "Parameter `source` is required when calling `replaceSources`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/security/sources").setMethod("PUT").setBody(source).build();
    return executeAsync(request, requestOptions, new TypeReference<ReplaceSourceResponse>() {});
  }

  /**
   * (asynchronously) Replace all allowed sources.
   *
   * @param source Allowed sources. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ReplaceSourceResponse> replaceSourcesAsync(@Nonnull List<Source> source) throws AlgoliaRuntimeException {
    return this.replaceSourcesAsync(source, null);
  }

  /**
   * Restore a deleted API key, along with its associated permissions. The request must be
   * authenticated with the admin API key.
   *
   * @param key API key. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public AddApiKeyResponse restoreApiKey(@Nonnull String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(restoreApiKeyAsync(key, requestOptions));
  }

  /**
   * Restore a deleted API key, along with its associated permissions. The request must be
   * authenticated with the admin API key.
   *
   * @param key API key. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public AddApiKeyResponse restoreApiKey(@Nonnull String key) throws AlgoliaRuntimeException {
    return this.restoreApiKey(key, null);
  }

  /**
   * (asynchronously) Restore a deleted API key, along with its associated permissions. The request
   * must be authenticated with the admin API key.
   *
   * @param key API key. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<AddApiKeyResponse> restoreApiKeyAsync(@Nonnull String key, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(key, "Parameter `key` is required when calling `restoreApiKey`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/keys/{key}/restore", key).setMethod("POST").build();

    return executeAsync(request, requestOptions, new TypeReference<AddApiKeyResponse>() {});
  }

  /**
   * (asynchronously) Restore a deleted API key, along with its associated permissions. The request
   * must be authenticated with the admin API key.
   *
   * @param key API key. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<AddApiKeyResponse> restoreApiKeyAsync(@Nonnull String key) throws AlgoliaRuntimeException {
    return this.restoreApiKeyAsync(key, null);
  }

  /**
   * Add a record (object) to an index or replace it. If the record doesn't contain an `objectID`,
   * Algolia automatically adds it. If you use an existing `objectID`, the existing record is
   * replaced with the new one. To add multiple records to your index in a single API request, use
   * the [`batch` operation](#tag/Records/operation/batch).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param body The Algolia record. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SaveObjectResponse saveObject(@Nonnull String indexName, @Nonnull Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(saveObjectAsync(indexName, body, requestOptions));
  }

  /**
   * Add a record (object) to an index or replace it. If the record doesn't contain an `objectID`,
   * Algolia automatically adds it. If you use an existing `objectID`, the existing record is
   * replaced with the new one. To add multiple records to your index in a single API request, use
   * the [`batch` operation](#tag/Records/operation/batch).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param body The Algolia record. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SaveObjectResponse saveObject(@Nonnull String indexName, @Nonnull Object body) throws AlgoliaRuntimeException {
    return this.saveObject(indexName, body, null);
  }

  /**
   * (asynchronously) Add a record (object) to an index or replace it. If the record doesn&#39;t
   * contain an &#x60;objectID&#x60;, Algolia automatically adds it. If you use an existing
   * &#x60;objectID&#x60;, the existing record is replaced with the new one. To add multiple records
   * to your index in a single API request, use the [&#x60;batch&#x60;
   * operation](#tag/Records/operation/batch).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param body The Algolia record. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SaveObjectResponse> saveObjectAsync(
    @Nonnull String indexName,
    @Nonnull Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `saveObject`.");

    Parameters.requireNonNull(body, "Parameter `body` is required when calling `saveObject`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}", indexName).setMethod("POST").setBody(body).build();
    return executeAsync(request, requestOptions, new TypeReference<SaveObjectResponse>() {});
  }

  /**
   * (asynchronously) Add a record (object) to an index or replace it. If the record doesn&#39;t
   * contain an &#x60;objectID&#x60;, Algolia automatically adds it. If you use an existing
   * &#x60;objectID&#x60;, the existing record is replaced with the new one. To add multiple records
   * to your index in a single API request, use the [&#x60;batch&#x60;
   * operation](#tag/Records/operation/batch).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param body The Algolia record. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SaveObjectResponse> saveObjectAsync(@Nonnull String indexName, @Nonnull Object body)
    throws AlgoliaRuntimeException {
    return this.saveObjectAsync(indexName, body, null);
  }

  /**
   * To create or update more than one rule, use the [`batch`
   * operation](#tag/Rules/operation/saveRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param rule (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedRuleResponse saveRule(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Rule rule,
    Boolean forwardToReplicas,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(saveRuleAsync(indexName, objectID, rule, forwardToReplicas, requestOptions));
  }

  /**
   * To create or update more than one rule, use the [`batch`
   * operation](#tag/Rules/operation/saveRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param rule (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedRuleResponse saveRule(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Rule rule, Boolean forwardToReplicas)
    throws AlgoliaRuntimeException {
    return this.saveRule(indexName, objectID, rule, forwardToReplicas, null);
  }

  /**
   * To create or update more than one rule, use the [`batch`
   * operation](#tag/Rules/operation/saveRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param rule (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedRuleResponse saveRule(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Rule rule,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.saveRule(indexName, objectID, rule, null, requestOptions);
  }

  /**
   * To create or update more than one rule, use the [`batch`
   * operation](#tag/Rules/operation/saveRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param rule (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedRuleResponse saveRule(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Rule rule)
    throws AlgoliaRuntimeException {
    return this.saveRule(indexName, objectID, rule, null, null);
  }

  /**
   * (asynchronously) To create or update more than one rule, use the [&#x60;batch&#x60;
   * operation](#tag/Rules/operation/saveRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param rule (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedRuleResponse> saveRuleAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Rule rule,
    Boolean forwardToReplicas,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `saveRule`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `saveRule`.");

    Parameters.requireNonNull(rule, "Parameter `rule` is required when calling `saveRule`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/rules/{objectID}", indexName, objectID)
      .setMethod("PUT")
      .setBody(rule)
      .addQueryParameter("forwardToReplicas", forwardToReplicas)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedRuleResponse>() {});
  }

  /**
   * (asynchronously) To create or update more than one rule, use the [&#x60;batch&#x60;
   * operation](#tag/Rules/operation/saveRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param rule (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedRuleResponse> saveRuleAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Rule rule,
    Boolean forwardToReplicas
  ) throws AlgoliaRuntimeException {
    return this.saveRuleAsync(indexName, objectID, rule, forwardToReplicas, null);
  }

  /**
   * (asynchronously) To create or update more than one rule, use the [&#x60;batch&#x60;
   * operation](#tag/Rules/operation/saveRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param rule (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedRuleResponse> saveRuleAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull Rule rule,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.saveRuleAsync(indexName, objectID, rule, null, requestOptions);
  }

  /**
   * (asynchronously) To create or update more than one rule, use the [&#x60;batch&#x60;
   * operation](#tag/Rules/operation/saveRules).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a rule object. (required)
   * @param rule (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedRuleResponse> saveRuleAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Rule rule)
    throws AlgoliaRuntimeException {
    return this.saveRuleAsync(indexName, objectID, rule, null, null);
  }

  /**
   * Create or update multiple rules.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param rules (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param clearExistingRules Indicates whether existing rules should be deleted before adding this
   *     batch. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse saveRules(
    @Nonnull String indexName,
    @Nonnull List<Rule> rules,
    Boolean forwardToReplicas,
    Boolean clearExistingRules,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(saveRulesAsync(indexName, rules, forwardToReplicas, clearExistingRules, requestOptions));
  }

  /**
   * Create or update multiple rules.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param rules (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param clearExistingRules Indicates whether existing rules should be deleted before adding this
   *     batch. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse saveRules(
    @Nonnull String indexName,
    @Nonnull List<Rule> rules,
    Boolean forwardToReplicas,
    Boolean clearExistingRules
  ) throws AlgoliaRuntimeException {
    return this.saveRules(indexName, rules, forwardToReplicas, clearExistingRules, null);
  }

  /**
   * Create or update multiple rules.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param rules (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse saveRules(@Nonnull String indexName, @Nonnull List<Rule> rules, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.saveRules(indexName, rules, null, null, requestOptions);
  }

  /**
   * Create or update multiple rules.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param rules (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse saveRules(@Nonnull String indexName, @Nonnull List<Rule> rules) throws AlgoliaRuntimeException {
    return this.saveRules(indexName, rules, null, null, null);
  }

  /**
   * (asynchronously) Create or update multiple rules.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param rules (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param clearExistingRules Indicates whether existing rules should be deleted before adding this
   *     batch. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> saveRulesAsync(
    @Nonnull String indexName,
    @Nonnull List<Rule> rules,
    Boolean forwardToReplicas,
    Boolean clearExistingRules,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `saveRules`.");

    Parameters.requireNonNull(rules, "Parameter `rules` is required when calling `saveRules`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/rules/batch", indexName)
      .setMethod("POST")
      .setBody(rules)
      .addQueryParameter("forwardToReplicas", forwardToReplicas)
      .addQueryParameter("clearExistingRules", clearExistingRules)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>() {});
  }

  /**
   * (asynchronously) Create or update multiple rules.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param rules (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param clearExistingRules Indicates whether existing rules should be deleted before adding this
   *     batch. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> saveRulesAsync(
    @Nonnull String indexName,
    @Nonnull List<Rule> rules,
    Boolean forwardToReplicas,
    Boolean clearExistingRules
  ) throws AlgoliaRuntimeException {
    return this.saveRulesAsync(indexName, rules, forwardToReplicas, clearExistingRules, null);
  }

  /**
   * (asynchronously) Create or update multiple rules.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param rules (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> saveRulesAsync(
    @Nonnull String indexName,
    @Nonnull List<Rule> rules,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.saveRulesAsync(indexName, rules, null, null, requestOptions);
  }

  /**
   * (asynchronously) Create or update multiple rules.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param rules (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> saveRulesAsync(@Nonnull String indexName, @Nonnull List<Rule> rules)
    throws AlgoliaRuntimeException {
    return this.saveRulesAsync(indexName, rules, null, null, null);
  }

  /**
   * Add a
   * [synonym](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#the-different-types-of-synonyms)
   * to an index or replace it. If the synonym `objectID` doesn't exist, Algolia adds a new one. If
   * you use an existing synonym `objectID`, the existing synonym is replaced with the new one. To
   * add multiple synonyms in a single API request, use the [`batch`
   * operation](#tag/Synonyms/operation/saveSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param synonymHit (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SaveSynonymResponse saveSynonym(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull SynonymHit synonymHit,
    Boolean forwardToReplicas,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(saveSynonymAsync(indexName, objectID, synonymHit, forwardToReplicas, requestOptions));
  }

  /**
   * Add a
   * [synonym](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#the-different-types-of-synonyms)
   * to an index or replace it. If the synonym `objectID` doesn't exist, Algolia adds a new one. If
   * you use an existing synonym `objectID`, the existing synonym is replaced with the new one. To
   * add multiple synonyms in a single API request, use the [`batch`
   * operation](#tag/Synonyms/operation/saveSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param synonymHit (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SaveSynonymResponse saveSynonym(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull SynonymHit synonymHit,
    Boolean forwardToReplicas
  ) throws AlgoliaRuntimeException {
    return this.saveSynonym(indexName, objectID, synonymHit, forwardToReplicas, null);
  }

  /**
   * Add a
   * [synonym](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#the-different-types-of-synonyms)
   * to an index or replace it. If the synonym `objectID` doesn't exist, Algolia adds a new one. If
   * you use an existing synonym `objectID`, the existing synonym is replaced with the new one. To
   * add multiple synonyms in a single API request, use the [`batch`
   * operation](#tag/Synonyms/operation/saveSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param synonymHit (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SaveSynonymResponse saveSynonym(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull SynonymHit synonymHit,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.saveSynonym(indexName, objectID, synonymHit, null, requestOptions);
  }

  /**
   * Add a
   * [synonym](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#the-different-types-of-synonyms)
   * to an index or replace it. If the synonym `objectID` doesn't exist, Algolia adds a new one. If
   * you use an existing synonym `objectID`, the existing synonym is replaced with the new one. To
   * add multiple synonyms in a single API request, use the [`batch`
   * operation](#tag/Synonyms/operation/saveSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param synonymHit (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SaveSynonymResponse saveSynonym(@Nonnull String indexName, @Nonnull String objectID, @Nonnull SynonymHit synonymHit)
    throws AlgoliaRuntimeException {
    return this.saveSynonym(indexName, objectID, synonymHit, null, null);
  }

  /**
   * (asynchronously) Add a
   * [synonym](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#the-different-types-of-synonyms)
   * to an index or replace it. If the synonym &#x60;objectID&#x60; doesn&#39;t exist, Algolia adds
   * a new one. If you use an existing synonym &#x60;objectID&#x60;, the existing synonym is
   * replaced with the new one. To add multiple synonyms in a single API request, use the
   * [&#x60;batch&#x60; operation](#tag/Synonyms/operation/saveSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param synonymHit (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull SynonymHit synonymHit,
    Boolean forwardToReplicas,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `saveSynonym`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `saveSynonym`.");

    Parameters.requireNonNull(synonymHit, "Parameter `synonymHit` is required when calling `saveSynonym`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/synonyms/{objectID}", indexName, objectID)
      .setMethod("PUT")
      .setBody(synonymHit)
      .addQueryParameter("forwardToReplicas", forwardToReplicas)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<SaveSynonymResponse>() {});
  }

  /**
   * (asynchronously) Add a
   * [synonym](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#the-different-types-of-synonyms)
   * to an index or replace it. If the synonym &#x60;objectID&#x60; doesn&#39;t exist, Algolia adds
   * a new one. If you use an existing synonym &#x60;objectID&#x60;, the existing synonym is
   * replaced with the new one. To add multiple synonyms in a single API request, use the
   * [&#x60;batch&#x60; operation](#tag/Synonyms/operation/saveSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param synonymHit (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull SynonymHit synonymHit,
    Boolean forwardToReplicas
  ) throws AlgoliaRuntimeException {
    return this.saveSynonymAsync(indexName, objectID, synonymHit, forwardToReplicas, null);
  }

  /**
   * (asynchronously) Add a
   * [synonym](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#the-different-types-of-synonyms)
   * to an index or replace it. If the synonym &#x60;objectID&#x60; doesn&#39;t exist, Algolia adds
   * a new one. If you use an existing synonym &#x60;objectID&#x60;, the existing synonym is
   * replaced with the new one. To add multiple synonyms in a single API request, use the
   * [&#x60;batch&#x60; operation](#tag/Synonyms/operation/saveSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param synonymHit (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull SynonymHit synonymHit,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.saveSynonymAsync(indexName, objectID, synonymHit, null, requestOptions);
  }

  /**
   * (asynchronously) Add a
   * [synonym](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#the-different-types-of-synonyms)
   * to an index or replace it. If the synonym &#x60;objectID&#x60; doesn&#39;t exist, Algolia adds
   * a new one. If you use an existing synonym &#x60;objectID&#x60;, the existing synonym is
   * replaced with the new one. To add multiple synonyms in a single API request, use the
   * [&#x60;batch&#x60; operation](#tag/Synonyms/operation/saveSynonyms).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param objectID Unique identifier of a synonym object. (required)
   * @param synonymHit (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(
    @Nonnull String indexName,
    @Nonnull String objectID,
    @Nonnull SynonymHit synonymHit
  ) throws AlgoliaRuntimeException {
    return this.saveSynonymAsync(indexName, objectID, synonymHit, null, null);
  }

  /**
   * Create or update multiple synonyms.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param synonymHit (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param replaceExistingSynonyms Indicates whether to replace all synonyms in the index with the
   *     ones sent with this request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse saveSynonyms(
    @Nonnull String indexName,
    @Nonnull List<SynonymHit> synonymHit,
    Boolean forwardToReplicas,
    Boolean replaceExistingSynonyms,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(saveSynonymsAsync(indexName, synonymHit, forwardToReplicas, replaceExistingSynonyms, requestOptions));
  }

  /**
   * Create or update multiple synonyms.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param synonymHit (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param replaceExistingSynonyms Indicates whether to replace all synonyms in the index with the
   *     ones sent with this request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse saveSynonyms(
    @Nonnull String indexName,
    @Nonnull List<SynonymHit> synonymHit,
    Boolean forwardToReplicas,
    Boolean replaceExistingSynonyms
  ) throws AlgoliaRuntimeException {
    return this.saveSynonyms(indexName, synonymHit, forwardToReplicas, replaceExistingSynonyms, null);
  }

  /**
   * Create or update multiple synonyms.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param synonymHit (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse saveSynonyms(@Nonnull String indexName, @Nonnull List<SynonymHit> synonymHit, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.saveSynonyms(indexName, synonymHit, null, null, requestOptions);
  }

  /**
   * Create or update multiple synonyms.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param synonymHit (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse saveSynonyms(@Nonnull String indexName, @Nonnull List<SynonymHit> synonymHit) throws AlgoliaRuntimeException {
    return this.saveSynonyms(indexName, synonymHit, null, null, null);
  }

  /**
   * (asynchronously) Create or update multiple synonyms.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param synonymHit (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param replaceExistingSynonyms Indicates whether to replace all synonyms in the index with the
   *     ones sent with this request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> saveSynonymsAsync(
    @Nonnull String indexName,
    @Nonnull List<SynonymHit> synonymHit,
    Boolean forwardToReplicas,
    Boolean replaceExistingSynonyms,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `saveSynonyms`.");

    Parameters.requireNonNull(synonymHit, "Parameter `synonymHit` is required when calling `saveSynonyms`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/synonyms/batch", indexName)
      .setMethod("POST")
      .setBody(synonymHit)
      .addQueryParameter("forwardToReplicas", forwardToReplicas)
      .addQueryParameter("replaceExistingSynonyms", replaceExistingSynonyms)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>() {});
  }

  /**
   * (asynchronously) Create or update multiple synonyms.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param synonymHit (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param replaceExistingSynonyms Indicates whether to replace all synonyms in the index with the
   *     ones sent with this request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> saveSynonymsAsync(
    @Nonnull String indexName,
    @Nonnull List<SynonymHit> synonymHit,
    Boolean forwardToReplicas,
    Boolean replaceExistingSynonyms
  ) throws AlgoliaRuntimeException {
    return this.saveSynonymsAsync(indexName, synonymHit, forwardToReplicas, replaceExistingSynonyms, null);
  }

  /**
   * (asynchronously) Create or update multiple synonyms.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param synonymHit (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> saveSynonymsAsync(
    @Nonnull String indexName,
    @Nonnull List<SynonymHit> synonymHit,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.saveSynonymsAsync(indexName, synonymHit, null, null, requestOptions);
  }

  /**
   * (asynchronously) Create or update multiple synonyms.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param synonymHit (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> saveSynonymsAsync(@Nonnull String indexName, @Nonnull List<SynonymHit> synonymHit)
    throws AlgoliaRuntimeException {
    return this.saveSynonymsAsync(indexName, synonymHit, null, null, null);
  }

  /**
   * Send multiple search queries to one or more indices.
   *
   * @param searchMethodParams Query requests and strategies. Results will be received in the same
   *     order as the queries. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchResponses search(@Nonnull SearchMethodParams searchMethodParams, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchAsync(searchMethodParams, requestOptions));
  }

  /**
   * Send multiple search queries to one or more indices.
   *
   * @param searchMethodParams Query requests and strategies. Results will be received in the same
   *     order as the queries. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchResponses search(@Nonnull SearchMethodParams searchMethodParams) throws AlgoliaRuntimeException {
    return this.search(searchMethodParams, null);
  }

  /**
   * (asynchronously) Send multiple search queries to one or more indices.
   *
   * @param searchMethodParams Query requests and strategies. Results will be received in the same
   *     order as the queries. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchResponses> searchAsync(@Nonnull SearchMethodParams searchMethodParams, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(searchMethodParams, "Parameter `searchMethodParams` is required when calling `search`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/*/queries")
      .setMethod("POST")
      .setBody(searchMethodParams)
      .setRead(true)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<SearchResponses>() {});
  }

  /**
   * (asynchronously) Send multiple search queries to one or more indices.
   *
   * @param searchMethodParams Query requests and strategies. Results will be received in the same
   *     order as the queries. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchResponses> searchAsync(@Nonnull SearchMethodParams searchMethodParams) throws AlgoliaRuntimeException {
    return this.searchAsync(searchMethodParams, null);
  }

  /**
   * Search for standard and
   * [custom](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-stop-words/)
   * entries in the [stop
   * words](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-stop-words/),
   * [plurals](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-plurals-and-other-declensions/),
   * or [segmentation
   * (compounds)](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-segmentation/)
   * dictionaries.
   *
   * @param dictionaryName Dictionary to search in. (required)
   * @param searchDictionaryEntriesParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse searchDictionaryEntries(
    @Nonnull DictionaryType dictionaryName,
    @Nonnull SearchDictionaryEntriesParams searchDictionaryEntriesParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchDictionaryEntriesAsync(dictionaryName, searchDictionaryEntriesParams, requestOptions));
  }

  /**
   * Search for standard and
   * [custom](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-stop-words/)
   * entries in the [stop
   * words](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-stop-words/),
   * [plurals](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-plurals-and-other-declensions/),
   * or [segmentation
   * (compounds)](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-segmentation/)
   * dictionaries.
   *
   * @param dictionaryName Dictionary to search in. (required)
   * @param searchDictionaryEntriesParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse searchDictionaryEntries(
    @Nonnull DictionaryType dictionaryName,
    @Nonnull SearchDictionaryEntriesParams searchDictionaryEntriesParams
  ) throws AlgoliaRuntimeException {
    return this.searchDictionaryEntries(dictionaryName, searchDictionaryEntriesParams, null);
  }

  /**
   * (asynchronously) Search for standard and
   * [custom](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-stop-words/)
   * entries in the [stop
   * words](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-stop-words/),
   * [plurals](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-plurals-and-other-declensions/),
   * or [segmentation
   * (compounds)](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-segmentation/)
   * dictionaries.
   *
   * @param dictionaryName Dictionary to search in. (required)
   * @param searchDictionaryEntriesParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> searchDictionaryEntriesAsync(
    @Nonnull DictionaryType dictionaryName,
    @Nonnull SearchDictionaryEntriesParams searchDictionaryEntriesParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(dictionaryName, "Parameter `dictionaryName` is required when calling `searchDictionaryEntries`.");

    Parameters.requireNonNull(
      searchDictionaryEntriesParams,
      "Parameter `searchDictionaryEntriesParams` is required when calling" + " `searchDictionaryEntries`."
    );

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/dictionaries/{dictionaryName}/search", dictionaryName)
      .setMethod("POST")
      .setBody(searchDictionaryEntriesParams)
      .setRead(true)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>() {});
  }

  /**
   * (asynchronously) Search for standard and
   * [custom](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-stop-words/)
   * entries in the [stop
   * words](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-stop-words/),
   * [plurals](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-plurals-and-other-declensions/),
   * or [segmentation
   * (compounds)](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-segmentation/)
   * dictionaries.
   *
   * @param dictionaryName Dictionary to search in. (required)
   * @param searchDictionaryEntriesParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> searchDictionaryEntriesAsync(
    @Nonnull DictionaryType dictionaryName,
    @Nonnull SearchDictionaryEntriesParams searchDictionaryEntriesParams
  ) throws AlgoliaRuntimeException {
    return this.searchDictionaryEntriesAsync(dictionaryName, searchDictionaryEntriesParams, null);
  }

  /**
   * [Search for a facet's
   * values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values),
   * optionally restricting the returned values to those contained in records matching other search
   * criteria. > **Note**: Pagination isn't supported (`page` and `hitsPerPage` are ignored). By
   * default, the engine returns a maximum of 10 values but you can adjust this with `maxFacetHits`.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param facetName Facet name. (required)
   * @param searchForFacetValuesRequest (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchForFacetValuesResponse searchForFacetValues(
    @Nonnull String indexName,
    @Nonnull String facetName,
    SearchForFacetValuesRequest searchForFacetValuesRequest,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchForFacetValuesAsync(indexName, facetName, searchForFacetValuesRequest, requestOptions));
  }

  /**
   * [Search for a facet's
   * values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values),
   * optionally restricting the returned values to those contained in records matching other search
   * criteria. > **Note**: Pagination isn't supported (`page` and `hitsPerPage` are ignored). By
   * default, the engine returns a maximum of 10 values but you can adjust this with `maxFacetHits`.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param facetName Facet name. (required)
   * @param searchForFacetValuesRequest (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchForFacetValuesResponse searchForFacetValues(
    @Nonnull String indexName,
    @Nonnull String facetName,
    SearchForFacetValuesRequest searchForFacetValuesRequest
  ) throws AlgoliaRuntimeException {
    return this.searchForFacetValues(indexName, facetName, searchForFacetValuesRequest, null);
  }

  /**
   * [Search for a facet's
   * values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values),
   * optionally restricting the returned values to those contained in records matching other search
   * criteria. > **Note**: Pagination isn't supported (`page` and `hitsPerPage` are ignored). By
   * default, the engine returns a maximum of 10 values but you can adjust this with `maxFacetHits`.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param facetName Facet name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchForFacetValuesResponse searchForFacetValues(
    @Nonnull String indexName,
    @Nonnull String facetName,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.searchForFacetValues(indexName, facetName, null, requestOptions);
  }

  /**
   * [Search for a facet's
   * values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values),
   * optionally restricting the returned values to those contained in records matching other search
   * criteria. > **Note**: Pagination isn't supported (`page` and `hitsPerPage` are ignored). By
   * default, the engine returns a maximum of 10 values but you can adjust this with `maxFacetHits`.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param facetName Facet name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchForFacetValuesResponse searchForFacetValues(@Nonnull String indexName, @Nonnull String facetName)
    throws AlgoliaRuntimeException {
    return this.searchForFacetValues(indexName, facetName, null, null);
  }

  /**
   * (asynchronously) [Search for a facet&#39;s
   * values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values),
   * optionally restricting the returned values to those contained in records matching other search
   * criteria. &gt; **Note**: Pagination isn&#39;t supported (&#x60;page&#x60; and
   * &#x60;hitsPerPage&#x60; are ignored). By default, the engine returns a maximum of 10 values but
   * you can adjust this with &#x60;maxFacetHits&#x60;.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param facetName Facet name. (required)
   * @param searchForFacetValuesRequest (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(
    @Nonnull String indexName,
    @Nonnull String facetName,
    SearchForFacetValuesRequest searchForFacetValuesRequest,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `searchForFacetValues`.");

    Parameters.requireNonNull(facetName, "Parameter `facetName` is required when calling `searchForFacetValues`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/facets/{facetName}/query", indexName, facetName)
      .setMethod("POST")
      .setBody(searchForFacetValuesRequest)
      .setRead(true)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<SearchForFacetValuesResponse>() {});
  }

  /**
   * (asynchronously) [Search for a facet&#39;s
   * values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values),
   * optionally restricting the returned values to those contained in records matching other search
   * criteria. &gt; **Note**: Pagination isn&#39;t supported (&#x60;page&#x60; and
   * &#x60;hitsPerPage&#x60; are ignored). By default, the engine returns a maximum of 10 values but
   * you can adjust this with &#x60;maxFacetHits&#x60;.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param facetName Facet name. (required)
   * @param searchForFacetValuesRequest (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(
    @Nonnull String indexName,
    @Nonnull String facetName,
    SearchForFacetValuesRequest searchForFacetValuesRequest
  ) throws AlgoliaRuntimeException {
    return this.searchForFacetValuesAsync(indexName, facetName, searchForFacetValuesRequest, null);
  }

  /**
   * (asynchronously) [Search for a facet&#39;s
   * values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values),
   * optionally restricting the returned values to those contained in records matching other search
   * criteria. &gt; **Note**: Pagination isn&#39;t supported (&#x60;page&#x60; and
   * &#x60;hitsPerPage&#x60; are ignored). By default, the engine returns a maximum of 10 values but
   * you can adjust this with &#x60;maxFacetHits&#x60;.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param facetName Facet name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(
    @Nonnull String indexName,
    @Nonnull String facetName,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.searchForFacetValuesAsync(indexName, facetName, null, requestOptions);
  }

  /**
   * (asynchronously) [Search for a facet&#39;s
   * values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values),
   * optionally restricting the returned values to those contained in records matching other search
   * criteria. &gt; **Note**: Pagination isn&#39;t supported (&#x60;page&#x60; and
   * &#x60;hitsPerPage&#x60; are ignored). By default, the engine returns a maximum of 10 values but
   * you can adjust this with &#x60;maxFacetHits&#x60;.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param facetName Facet name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(@Nonnull String indexName, @Nonnull String facetName)
    throws AlgoliaRuntimeException {
    return this.searchForFacetValuesAsync(indexName, facetName, null, null);
  }

  /**
   * Search for rules in your index. You can control the search with parameters. To list all rules,
   * send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param searchRulesParams (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRulesResponse searchRules(@Nonnull String indexName, SearchRulesParams searchRulesParams, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchRulesAsync(indexName, searchRulesParams, requestOptions));
  }

  /**
   * Search for rules in your index. You can control the search with parameters. To list all rules,
   * send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param searchRulesParams (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRulesResponse searchRules(@Nonnull String indexName, SearchRulesParams searchRulesParams) throws AlgoliaRuntimeException {
    return this.searchRules(indexName, searchRulesParams, null);
  }

  /**
   * Search for rules in your index. You can control the search with parameters. To list all rules,
   * send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRulesResponse searchRules(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.searchRules(indexName, null, requestOptions);
  }

  /**
   * Search for rules in your index. You can control the search with parameters. To list all rules,
   * send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRulesResponse searchRules(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.searchRules(indexName, null, null);
  }

  /**
   * (asynchronously) Search for rules in your index. You can control the search with parameters. To
   * list all rules, send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param searchRulesParams (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRulesResponse> searchRulesAsync(
    @Nonnull String indexName,
    SearchRulesParams searchRulesParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `searchRules`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/rules/search", indexName)
      .setMethod("POST")
      .setBody(searchRulesParams)
      .setRead(true)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<SearchRulesResponse>() {});
  }

  /**
   * (asynchronously) Search for rules in your index. You can control the search with parameters. To
   * list all rules, send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param searchRulesParams (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRulesResponse> searchRulesAsync(@Nonnull String indexName, SearchRulesParams searchRulesParams)
    throws AlgoliaRuntimeException {
    return this.searchRulesAsync(indexName, searchRulesParams, null);
  }

  /**
   * (asynchronously) Search for rules in your index. You can control the search with parameters. To
   * list all rules, send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRulesResponse> searchRulesAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.searchRulesAsync(indexName, null, requestOptions);
  }

  /**
   * (asynchronously) Search for rules in your index. You can control the search with parameters. To
   * list all rules, send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRulesResponse> searchRulesAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.searchRulesAsync(indexName, null, null);
  }

  /**
   * Return records that match the query.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param searchParams (optional)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> SearchResponse<T> searchSingleIndex(
    @Nonnull String indexName,
    SearchParams searchParams,
    Class<T> innerType,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchSingleIndexAsync(indexName, searchParams, innerType, requestOptions));
  }

  /**
   * Return records that match the query.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param searchParams (optional)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> SearchResponse<T> searchSingleIndex(@Nonnull String indexName, SearchParams searchParams, Class<T> innerType)
    throws AlgoliaRuntimeException {
    return this.searchSingleIndex(indexName, searchParams, innerType, null);
  }

  /**
   * Return records that match the query.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> SearchResponse<T> searchSingleIndex(@Nonnull String indexName, Class<T> innerType, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.searchSingleIndex(indexName, null, innerType, requestOptions);
  }

  /**
   * Return records that match the query.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> SearchResponse<T> searchSingleIndex(@Nonnull String indexName, Class<T> innerType) throws AlgoliaRuntimeException {
    return this.searchSingleIndex(indexName, null, innerType, null);
  }

  /**
   * (asynchronously) Return records that match the query.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param searchParams (optional)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> CompletableFuture<SearchResponse<T>> searchSingleIndexAsync(
    @Nonnull String indexName,
    SearchParams searchParams,
    Class<T> innerType,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `searchSingleIndex`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/query", indexName)
      .setMethod("POST")
      .setBody(searchParams)
      .setRead(true)
      .build();
    return executeAsync(request, requestOptions, SearchResponse.class, innerType);
  }

  /**
   * (asynchronously) Return records that match the query.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param searchParams (optional)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> CompletableFuture<SearchResponse<T>> searchSingleIndexAsync(
    @Nonnull String indexName,
    SearchParams searchParams,
    Class<T> innerType
  ) throws AlgoliaRuntimeException {
    return this.searchSingleIndexAsync(indexName, searchParams, innerType, null);
  }

  /**
   * (asynchronously) Return records that match the query.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> CompletableFuture<SearchResponse<T>> searchSingleIndexAsync(
    @Nonnull String indexName,
    Class<T> innerType,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.searchSingleIndexAsync(indexName, null, innerType, requestOptions);
  }

  /**
   * (asynchronously) Return records that match the query.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public <T> CompletableFuture<SearchResponse<T>> searchSingleIndexAsync(@Nonnull String indexName, Class<T> innerType)
    throws AlgoliaRuntimeException {
    return this.searchSingleIndexAsync(indexName, null, innerType, null);
  }

  /**
   * Search for synonyms in your index. You can control and filter the search with parameters. To
   * get all synonyms, send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param type Search for specific [types of
   *     synonyms](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#the-different-types-of-synonyms).
   *     (optional)
   * @param page Returns the requested page number (the first page is 0). Page size is set by
   *     `hitsPerPage`. When null, there's no pagination. (optional, default to 0)
   * @param hitsPerPage Maximum number of hits per page. (optional, default to 100)
   * @param searchSynonymsParams Body of the `searchSynonyms` operation. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchSynonymsResponse searchSynonyms(
    @Nonnull String indexName,
    SynonymType type,
    Integer page,
    Integer hitsPerPage,
    SearchSynonymsParams searchSynonymsParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchSynonymsAsync(indexName, type, page, hitsPerPage, searchSynonymsParams, requestOptions));
  }

  /**
   * Search for synonyms in your index. You can control and filter the search with parameters. To
   * get all synonyms, send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param type Search for specific [types of
   *     synonyms](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#the-different-types-of-synonyms).
   *     (optional)
   * @param page Returns the requested page number (the first page is 0). Page size is set by
   *     `hitsPerPage`. When null, there's no pagination. (optional, default to 0)
   * @param hitsPerPage Maximum number of hits per page. (optional, default to 100)
   * @param searchSynonymsParams Body of the `searchSynonyms` operation. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchSynonymsResponse searchSynonyms(
    @Nonnull String indexName,
    SynonymType type,
    Integer page,
    Integer hitsPerPage,
    SearchSynonymsParams searchSynonymsParams
  ) throws AlgoliaRuntimeException {
    return this.searchSynonyms(indexName, type, page, hitsPerPage, searchSynonymsParams, null);
  }

  /**
   * Search for synonyms in your index. You can control and filter the search with parameters. To
   * get all synonyms, send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchSynonymsResponse searchSynonyms(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.searchSynonyms(indexName, null, null, null, null, requestOptions);
  }

  /**
   * Search for synonyms in your index. You can control and filter the search with parameters. To
   * get all synonyms, send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchSynonymsResponse searchSynonyms(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.searchSynonyms(indexName, null, null, null, null, null);
  }

  /**
   * (asynchronously) Search for synonyms in your index. You can control and filter the search with
   * parameters. To get all synonyms, send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param type Search for specific [types of
   *     synonyms](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#the-different-types-of-synonyms).
   *     (optional)
   * @param page Returns the requested page number (the first page is 0). Page size is set by
   *     `hitsPerPage`. When null, there's no pagination. (optional, default to 0)
   * @param hitsPerPage Maximum number of hits per page. (optional, default to 100)
   * @param searchSynonymsParams Body of the `searchSynonyms` operation. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchSynonymsResponse> searchSynonymsAsync(
    @Nonnull String indexName,
    SynonymType type,
    Integer page,
    Integer hitsPerPage,
    SearchSynonymsParams searchSynonymsParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `searchSynonyms`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/synonyms/search", indexName)
      .setMethod("POST")
      .setBody(searchSynonymsParams)
      .setRead(true)
      .addQueryParameter("type", type)
      .addQueryParameter("page", page)
      .addQueryParameter("hitsPerPage", hitsPerPage)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<SearchSynonymsResponse>() {});
  }

  /**
   * (asynchronously) Search for synonyms in your index. You can control and filter the search with
   * parameters. To get all synonyms, send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param type Search for specific [types of
   *     synonyms](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/#the-different-types-of-synonyms).
   *     (optional)
   * @param page Returns the requested page number (the first page is 0). Page size is set by
   *     `hitsPerPage`. When null, there's no pagination. (optional, default to 0)
   * @param hitsPerPage Maximum number of hits per page. (optional, default to 100)
   * @param searchSynonymsParams Body of the `searchSynonyms` operation. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchSynonymsResponse> searchSynonymsAsync(
    @Nonnull String indexName,
    SynonymType type,
    Integer page,
    Integer hitsPerPage,
    SearchSynonymsParams searchSynonymsParams
  ) throws AlgoliaRuntimeException {
    return this.searchSynonymsAsync(indexName, type, page, hitsPerPage, searchSynonymsParams, null);
  }

  /**
   * (asynchronously) Search for synonyms in your index. You can control and filter the search with
   * parameters. To get all synonyms, send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchSynonymsResponse> searchSynonymsAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.searchSynonymsAsync(indexName, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Search for synonyms in your index. You can control and filter the search with
   * parameters. To get all synonyms, send an empty request body.
   *
   * @param indexName Index on which to perform the request. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchSynonymsResponse> searchSynonymsAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.searchSynonymsAsync(indexName, null, null, null, null, null);
  }

  /**
   * Since it can take up to a few seconds to get the data from the different clusters, the response
   * isn't real-time. To ensure rapid updates, the user IDs index isn't built at the same time as
   * the mapping. Instead, it's built every 12 hours, at the same time as the update of user ID
   * usage. For example, if you add or move a user ID, the search will show an old value until the
   * next time the mapping is rebuilt (every 12 hours).
   *
   * @param searchUserIdsParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchUserIdsResponse searchUserIds(@Nonnull SearchUserIdsParams searchUserIdsParams, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchUserIdsAsync(searchUserIdsParams, requestOptions));
  }

  /**
   * Since it can take up to a few seconds to get the data from the different clusters, the response
   * isn't real-time. To ensure rapid updates, the user IDs index isn't built at the same time as
   * the mapping. Instead, it's built every 12 hours, at the same time as the update of user ID
   * usage. For example, if you add or move a user ID, the search will show an old value until the
   * next time the mapping is rebuilt (every 12 hours).
   *
   * @param searchUserIdsParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchUserIdsResponse searchUserIds(@Nonnull SearchUserIdsParams searchUserIdsParams) throws AlgoliaRuntimeException {
    return this.searchUserIds(searchUserIdsParams, null);
  }

  /**
   * (asynchronously) Since it can take up to a few seconds to get the data from the different
   * clusters, the response isn&#39;t real-time. To ensure rapid updates, the user IDs index
   * isn&#39;t built at the same time as the mapping. Instead, it&#39;s built every 12 hours, at the
   * same time as the update of user ID usage. For example, if you add or move a user ID, the search
   * will show an old value until the next time the mapping is rebuilt (every 12 hours).
   *
   * @param searchUserIdsParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchUserIdsResponse> searchUserIdsAsync(
    @Nonnull SearchUserIdsParams searchUserIdsParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(searchUserIdsParams, "Parameter `searchUserIdsParams` is required when calling `searchUserIds`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/clusters/mapping/search")
      .setMethod("POST")
      .setBody(searchUserIdsParams)
      .setRead(true)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<SearchUserIdsResponse>() {});
  }

  /**
   * (asynchronously) Since it can take up to a few seconds to get the data from the different
   * clusters, the response isn&#39;t real-time. To ensure rapid updates, the user IDs index
   * isn&#39;t built at the same time as the mapping. Instead, it&#39;s built every 12 hours, at the
   * same time as the update of user ID usage. For example, if you add or move a user ID, the search
   * will show an old value until the next time the mapping is rebuilt (every 12 hours).
   *
   * @param searchUserIdsParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchUserIdsResponse> searchUserIdsAsync(@Nonnull SearchUserIdsParams searchUserIdsParams)
    throws AlgoliaRuntimeException {
    return this.searchUserIdsAsync(searchUserIdsParams, null);
  }

  /**
   * Set stop word settings for a specific language.
   *
   * @param dictionarySettingsParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse setDictionarySettings(@Nonnull DictionarySettingsParams dictionarySettingsParams, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(setDictionarySettingsAsync(dictionarySettingsParams, requestOptions));
  }

  /**
   * Set stop word settings for a specific language.
   *
   * @param dictionarySettingsParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse setDictionarySettings(@Nonnull DictionarySettingsParams dictionarySettingsParams)
    throws AlgoliaRuntimeException {
    return this.setDictionarySettings(dictionarySettingsParams, null);
  }

  /**
   * (asynchronously) Set stop word settings for a specific language.
   *
   * @param dictionarySettingsParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> setDictionarySettingsAsync(
    @Nonnull DictionarySettingsParams dictionarySettingsParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(
      dictionarySettingsParams,
      "Parameter `dictionarySettingsParams` is required when calling `setDictionarySettings`."
    );

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/dictionaries/*/settings")
      .setMethod("PUT")
      .setBody(dictionarySettingsParams)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>() {});
  }

  /**
   * (asynchronously) Set stop word settings for a specific language.
   *
   * @param dictionarySettingsParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> setDictionarySettingsAsync(@Nonnull DictionarySettingsParams dictionarySettingsParams)
    throws AlgoliaRuntimeException {
    return this.setDictionarySettingsAsync(dictionarySettingsParams, null);
  }

  /**
   * Update the specified [index
   * settings](https://www.algolia.com/doc/api-reference/settings-api-parameters/). Specifying null
   * for a setting resets it to its default value.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param indexSettings (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse setSettings(
    @Nonnull String indexName,
    @Nonnull IndexSettings indexSettings,
    Boolean forwardToReplicas,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(setSettingsAsync(indexName, indexSettings, forwardToReplicas, requestOptions));
  }

  /**
   * Update the specified [index
   * settings](https://www.algolia.com/doc/api-reference/settings-api-parameters/). Specifying null
   * for a setting resets it to its default value.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param indexSettings (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse setSettings(@Nonnull String indexName, @Nonnull IndexSettings indexSettings, Boolean forwardToReplicas)
    throws AlgoliaRuntimeException {
    return this.setSettings(indexName, indexSettings, forwardToReplicas, null);
  }

  /**
   * Update the specified [index
   * settings](https://www.algolia.com/doc/api-reference/settings-api-parameters/). Specifying null
   * for a setting resets it to its default value.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param indexSettings (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse setSettings(@Nonnull String indexName, @Nonnull IndexSettings indexSettings, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.setSettings(indexName, indexSettings, null, requestOptions);
  }

  /**
   * Update the specified [index
   * settings](https://www.algolia.com/doc/api-reference/settings-api-parameters/). Specifying null
   * for a setting resets it to its default value.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param indexSettings (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdatedAtResponse setSettings(@Nonnull String indexName, @Nonnull IndexSettings indexSettings) throws AlgoliaRuntimeException {
    return this.setSettings(indexName, indexSettings, null, null);
  }

  /**
   * (asynchronously) Update the specified [index
   * settings](https://www.algolia.com/doc/api-reference/settings-api-parameters/). Specifying null
   * for a setting resets it to its default value.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param indexSettings (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> setSettingsAsync(
    @Nonnull String indexName,
    @Nonnull IndexSettings indexSettings,
    Boolean forwardToReplicas,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `setSettings`.");

    Parameters.requireNonNull(indexSettings, "Parameter `indexSettings` is required when calling `setSettings`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/settings", indexName)
      .setMethod("PUT")
      .setBody(indexSettings)
      .addQueryParameter("forwardToReplicas", forwardToReplicas)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>() {});
  }

  /**
   * (asynchronously) Update the specified [index
   * settings](https://www.algolia.com/doc/api-reference/settings-api-parameters/). Specifying null
   * for a setting resets it to its default value.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param indexSettings (required)
   * @param forwardToReplicas Indicates whether changed index settings are forwarded to the replica
   *     indices. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> setSettingsAsync(
    @Nonnull String indexName,
    @Nonnull IndexSettings indexSettings,
    Boolean forwardToReplicas
  ) throws AlgoliaRuntimeException {
    return this.setSettingsAsync(indexName, indexSettings, forwardToReplicas, null);
  }

  /**
   * (asynchronously) Update the specified [index
   * settings](https://www.algolia.com/doc/api-reference/settings-api-parameters/). Specifying null
   * for a setting resets it to its default value.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param indexSettings (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> setSettingsAsync(
    @Nonnull String indexName,
    @Nonnull IndexSettings indexSettings,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.setSettingsAsync(indexName, indexSettings, null, requestOptions);
  }

  /**
   * (asynchronously) Update the specified [index
   * settings](https://www.algolia.com/doc/api-reference/settings-api-parameters/). Specifying null
   * for a setting resets it to its default value.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param indexSettings (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdatedAtResponse> setSettingsAsync(@Nonnull String indexName, @Nonnull IndexSettings indexSettings)
    throws AlgoliaRuntimeException {
    return this.setSettingsAsync(indexName, indexSettings, null, null);
  }

  /**
   * Replace the permissions of an existing API key. Any unspecified parameter resets that
   * permission to its default value. The request must be authenticated with the admin API key.
   *
   * @param key API key. (required)
   * @param apiKey (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdateApiKeyResponse updateApiKey(@Nonnull String key, @Nonnull ApiKey apiKey, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(updateApiKeyAsync(key, apiKey, requestOptions));
  }

  /**
   * Replace the permissions of an existing API key. Any unspecified parameter resets that
   * permission to its default value. The request must be authenticated with the admin API key.
   *
   * @param key API key. (required)
   * @param apiKey (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public UpdateApiKeyResponse updateApiKey(@Nonnull String key, @Nonnull ApiKey apiKey) throws AlgoliaRuntimeException {
    return this.updateApiKey(key, apiKey, null);
  }

  /**
   * (asynchronously) Replace the permissions of an existing API key. Any unspecified parameter
   * resets that permission to its default value. The request must be authenticated with the admin
   * API key.
   *
   * @param key API key. (required)
   * @param apiKey (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdateApiKeyResponse> updateApiKeyAsync(
    @Nonnull String key,
    @Nonnull ApiKey apiKey,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(key, "Parameter `key` is required when calling `updateApiKey`.");

    Parameters.requireNonNull(apiKey, "Parameter `apiKey` is required when calling `updateApiKey`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/keys/{key}", key).setMethod("PUT").setBody(apiKey).build();
    return executeAsync(request, requestOptions, new TypeReference<UpdateApiKeyResponse>() {});
  }

  /**
   * (asynchronously) Replace the permissions of an existing API key. Any unspecified parameter
   * resets that permission to its default value. The request must be authenticated with the admin
   * API key.
   *
   * @param key API key. (required)
   * @param apiKey (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<UpdateApiKeyResponse> updateApiKeyAsync(@Nonnull String key, @Nonnull ApiKey apiKey)
    throws AlgoliaRuntimeException {
    return this.updateApiKeyAsync(key, apiKey, null);
  }

  /**
   * Helper: Wait for a task to complete with `indexName` and `taskID`.
   *
   * @param indexName The `indexName` where the operation was performed.
   * @param taskID The `taskID` returned in the method response.
   * @param maxRetries The maximum number of retry. 50 by default. (optional)
   * @param timeout The function to decide how long to wait between retries. min(retries * 200,
   *     5000) by default. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions. (optional)
   */
  public void waitForTask(String indexName, Long taskID, int maxRetries, IntUnaryOperator timeout, RequestOptions requestOptions) {
    TaskUtils.retryUntil(
      () -> this.getTask(indexName, taskID, requestOptions),
      (GetTaskResponse task) -> task.getStatus() == TaskStatus.PUBLISHED,
      maxRetries,
      timeout
    );
  }

  /**
   * Helper: Wait for a task to complete with `indexName` and `taskID`.
   *
   * @param indexName The `indexName` where the operation was performed.
   * @param taskID The `taskID` returned in the method response.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions. (optional)
   */
  public void waitForTask(String indexName, Long taskID, RequestOptions requestOptions) {
    this.waitForTask(indexName, taskID, TaskUtils.DEFAULT_MAX_RETRIES, TaskUtils.DEFAULT_TIMEOUT, requestOptions);
  }

  /**
   * Helper: Wait for a task to complete with `indexName` and `taskID`.
   *
   * @param indexName The `indexName` where the operation was performed.
   * @param taskID The `taskID` returned in the method response.
   * @param maxRetries The maximum number of retry. 50 by default. (optional)
   * @param timeout The function to decide how long to wait between retries. min(retries * 200,
   *     5000) by default. (optional)
   */
  public void waitForTask(String indexName, Long taskID, int maxRetries, IntUnaryOperator timeout) {
    this.waitForTask(indexName, taskID, maxRetries, timeout, null);
  }

  /**
   * Helper: Wait for a task to complete with `indexName` and `taskID`.
   *
   * @param indexName The `indexName` where the operation was performed.
   * @param taskID The `taskID` returned in the method response.
   */
  public void waitForTask(String indexName, Long taskID) {
    this.waitForTask(indexName, taskID, TaskUtils.DEFAULT_MAX_RETRIES, TaskUtils.DEFAULT_TIMEOUT, null);
  }

  /**
   * Helper: Wait for an API key to be added, updated or deleted based on a given `operation`.
   *
   * @param operation The `operation` that was done on a `key`.
   * @param key The `key` that has been added, deleted or updated.
   * @param apiKey Necessary to know if an `update` operation has been processed, compare fields of
   *     the response with it.
   * @param maxRetries The maximum number of retry. 50 by default. (optional)
   * @param timeout The function to decide how long to wait between retries. min(retries * 200,
   *     5000) by default. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions. (optional)
   */
  public GetApiKeyResponse waitForApiKey(
    ApiKeyOperation operation,
    String key,
    ApiKey apiKey,
    int maxRetries,
    IntUnaryOperator timeout,
    RequestOptions requestOptions
  ) {
    if (operation == ApiKeyOperation.UPDATE) {
      if (apiKey == null) {
        throw new AlgoliaRuntimeException("`apiKey` is required when waiting for an `update` operation.");
      }

      // when updating an api key, we poll the api until we receive a different key
      return TaskUtils.retryUntil(
        () -> this.getApiKey(key, requestOptions),
        (GetApiKeyResponse respKey) -> {
          // we need to convert to an ApiKey object to use the `equals` method
          ApiKey sameType = new ApiKey()
            .setAcl(respKey.getAcl())
            .setDescription(respKey.getDescription())
            .setIndexes(respKey.getIndexes())
            .setMaxHitsPerQuery(respKey.getMaxHitsPerQuery())
            .setMaxQueriesPerIPPerHour(respKey.getMaxQueriesPerIPPerHour())
            .setQueryParameters(respKey.getQueryParameters())
            .setReferers(respKey.getReferers())
            .setValidity(respKey.getValidity());

          return apiKey.equals(sameType);
        },
        maxRetries,
        timeout
      );
    }

    // bypass lambda restriction to modify final object
    final GetApiKeyResponse[] addedKey = new GetApiKeyResponse[] { null };

    // check the status of the getApiKey method
    TaskUtils.retryUntil(
      () -> {
        try {
          addedKey[0] = this.getApiKey(key, requestOptions);
          // magic number to signify we found the key
          return -2;
        } catch (AlgoliaApiException e) {
          return e.getStatusCode();
        }
      },
      (Integer status) -> {
        switch (operation) {
          case ADD:
            // stop either when the key is created or when we don't receive 404
            return status == -2 || status != 404;
          case DELETE:
            // stop when the key is not found
            return status == 404;
          default:
            // continue
            return false;
        }
      },
      maxRetries,
      timeout
    );

    return addedKey[0];
  }

  /**
   * Helper: Wait for an API key to be added, updated or deleted based on a given `operation`.
   *
   * @param operation The `operation` that was done on a `key`. (ADD or DELETE only)
   * @param key The `key` that has been added, deleted or updated.
   * @param maxRetries The maximum number of retry. 50 by default. (optional)
   * @param timeout The function to decide how long to wait between retries. min(retries * 200,
   *     5000) by default. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions. (optional)
   */
  public GetApiKeyResponse waitForApiKey(
    ApiKeyOperation operation,
    String key,
    int maxRetries,
    IntUnaryOperator timeout,
    RequestOptions requestOptions
  ) {
    return this.waitForApiKey(operation, key, null, maxRetries, timeout, requestOptions);
  }

  /**
   * Helper: Wait for an API key to be added, updated or deleted based on a given `operation`.
   *
   * @param operation The `operation` that was done on a `key`.
   * @param key The `key` that has been added, deleted or updated.
   * @param apiKey Necessary to know if an `update` operation has been processed, compare fields of
   *     the response with it.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions. (optional)
   */
  public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, ApiKey apiKey, RequestOptions requestOptions) {
    return this.waitForApiKey(operation, key, apiKey, TaskUtils.DEFAULT_MAX_RETRIES, TaskUtils.DEFAULT_TIMEOUT, requestOptions);
  }

  /**
   * Helper: Wait for an API key to be added, updated or deleted based on a given `operation`.
   *
   * @param operation The `operation` that was done on a `key`. (ADD or DELETE only)
   * @param key The `key` that has been added, deleted or updated.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions. (optional)
   */
  public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, RequestOptions requestOptions) {
    return this.waitForApiKey(operation, key, null, TaskUtils.DEFAULT_MAX_RETRIES, TaskUtils.DEFAULT_TIMEOUT, requestOptions);
  }

  /**
   * Helper: Wait for an API key to be added, updated or deleted based on a given `operation`.
   *
   * @param operation The `operation` that was done on a `key`.
   * @param key The `key` that has been added, deleted or updated.
   * @param apiKey Necessary to know if an `update` operation has been processed, compare fields of
   *     the response with it.
   * @param maxRetries The maximum number of retry. 50 by default. (optional)
   * @param timeout The function to decide how long to wait between retries. min(retries * 200,
   *     5000) by default. (optional)
   */
  public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, ApiKey apiKey, int maxRetries, IntUnaryOperator timeout) {
    return this.waitForApiKey(operation, key, apiKey, maxRetries, timeout, null);
  }

  /**
   * Helper: Wait for an API key to be added, updated or deleted based on a given `operation`.
   *
   * @param operation The `operation` that was done on a `key`. (ADD or DELETE only)
   * @param key The `key` that has been added, deleted or updated.
   * @param maxRetries The maximum number of retry. 50 by default. (optional)
   * @param timeout The function to decide how long to wait between retries. min(retries * 200,
   *     5000) by default. (optional)
   */
  public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, int maxRetries, IntUnaryOperator timeout) {
    return this.waitForApiKey(operation, key, null, maxRetries, timeout, null);
  }

  /**
   * Helper: Wait for an API key to be added, updated or deleted based on a given `operation`.
   *
   * @param operation The `operation` that was done on a `key`.
   * @param key The `key` that has been added, deleted or updated.
   * @param apiKey Necessary to know if an `update` operation has been processed, compare fields of
   *     the response with it.
   */
  public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, ApiKey apiKey) {
    return this.waitForApiKey(operation, key, apiKey, TaskUtils.DEFAULT_MAX_RETRIES, TaskUtils.DEFAULT_TIMEOUT, null);
  }

  /**
   * Helper: Wait for an API key to be added, updated or deleted based on a given `operation`.
   *
   * @param operation The `operation` that was done on a `key`. (ADD or DELETE only)
   * @param key The `key` that has been added, deleted or updated.
   */
  public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key) {
    return this.waitForApiKey(operation, key, null, TaskUtils.DEFAULT_MAX_RETRIES, TaskUtils.DEFAULT_TIMEOUT, null);
  }

  /**
   * Helper: Returns an iterator on top of the `browse` method.
   *
   * @param indexName The index in which to perform the request.
   * @param params The `browse` parameters.
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions. (optional)
   */
  public <T> Iterable<T> browseObjects(String indexName, BrowseParamsObject params, Class<T> innerType, RequestOptions requestOptions) {
    final Holder<String> currentCursor = new Holder<>();

    return AlgoliaIterableHelper.createIterable(
      () -> {
        BrowseResponse<T> response = this.browse(indexName, params, innerType, requestOptions);
        params.setCursor(response.getCursor());
        currentCursor.value = response.getCursor();
        return response.getHits().iterator();
      },
      () -> currentCursor.value != null
    );
  }

  /**
   * Helper: Returns an iterator on top of the `browse` method.
   *
   * @param indexName The index in which to perform the request.
   * @param params The `browse` parameters.
   * @param innerType The class held by the index, could be your custom class or {@link Object}.
   */
  public <T> Iterable<T> browseObjects(String indexName, BrowseParamsObject params, Class<T> innerType) {
    return browseObjects(indexName, params, innerType, null);
  }

  /**
   * Helper: Returns an iterator on top of the `searchSynonyms` method.
   *
   * @param indexName The index in which to perform the request.
   * @param type The synonym type. (optional)
   * @param params The `searchSynonyms` parameters. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions. (optional)
   */
  public Iterable<SynonymHit> browseSynonyms(
    String indexName,
    SynonymType type,
    SearchSynonymsParams params,
    RequestOptions requestOptions
  ) {
    final Holder<Integer> currentPage = new Holder<>(0);
    final int hitsPerPage = 1000;

    return AlgoliaIterableHelper.createIterable(
      () -> {
        SearchSynonymsResponse response = this.searchSynonyms(indexName, type, currentPage.value, hitsPerPage, params, requestOptions);
        currentPage.value = response.getNbHits() < hitsPerPage ? null : currentPage.value + 1;
        return response.getHits().iterator();
      },
      () -> currentPage.value != null
    );
  }

  /**
   * Helper: Returns an iterator on top of the `searchSynonyms` method.
   *
   * @param indexName The index in which to perform the request.
   * @param type The synonym type. (optional)
   * @param params The `searchSynonyms` parameters .(optional)
   */
  public Iterable<SynonymHit> browseSynonyms(String indexName, SynonymType type, SearchSynonymsParams params) {
    return browseSynonyms(indexName, type, params, null);
  }

  /**
   * Helper: Returns an iterator on top of the `searchSynonyms` method.
   *
   * @param indexName The index in which to perform the request.
   */
  public Iterable<SynonymHit> browseSynonyms(String indexName) {
    return browseSynonyms(indexName, null, null, null);
  }

  /**
   * Helper: Returns an iterator on top of the `searchRules` method.
   *
   * @param indexName The index in which to perform the request.
   * @param params The `searchRules` parameters. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions. (optional)
   */
  public Iterable<Rule> browseRules(String indexName, SearchRulesParams params, RequestOptions requestOptions) {
    final Holder<Integer> currentPage = new Holder<>(0);
    final int hitsPerPage = 1000;
    params.setHitsPerPage(hitsPerPage);

    return AlgoliaIterableHelper.createIterable(
      () -> {
        SearchRulesResponse response = this.searchRules(indexName, params.setPage(currentPage.value), requestOptions);
        currentPage.value = response.getNbHits() < hitsPerPage ? null : currentPage.value + 1;
        return response.getHits().iterator();
      },
      () -> currentPage.value != null
    );
  }

  /**
   * Helper: Returns an iterator on top of the `searchRules` method.
   *
   * @param indexName The index in which to perform the request.
   * @param params The `searchRules` parameters. (optional)
   */
  public Iterable<Rule> browseRules(String indexName, SearchRulesParams params) {
    return browseRules(indexName, params, null);
  }

  /**
   * Helper: Returns an iterator on top of the `searchRules` method.
   *
   * @param indexName The index in which to perform the request.
   */
  public Iterable<Rule> browseRules(String indexName) {
    return browseRules(indexName, new SearchRulesParams(), null);
  }

  /**
   * Executes a synchronous search for the provided search requests, with certainty that we will
   * only request Algolia records (hits). Results will be received in the same order as the queries.
   *
   * @param requests A list of search requests to be executed.
   */
  public List<SearchResponse<?>> searchForHits(@Nonnull List<SearchForHits> requests) {
    return LaunderThrowable.await(searchForHitsAsync(requests, null, null));
  }

  /**
   * Executes a synchronous search for the provided search requests, with certainty that we will
   * only request Algolia records (hits). Results will be received in the same order as the queries.
   *
   * @param requests A list of search requests to be executed.
   * @param strategy The search strategy to be employed during the search.
   */
  public List<SearchResponse<?>> searchForHits(@Nonnull List<SearchForHits> requests, SearchStrategy strategy) {
    return LaunderThrowable.await(searchForHitsAsync(requests, strategy, null));
  }

  /**
   * Executes a synchronous search for the provided search requests, with certainty that we will
   * only request Algolia records (hits). Results will be received in the same order as the queries.
   *
   * @param requests A list of search requests to be executed.
   * @param strategy The search strategy to be employed during the search.
   * @param requestOptions Additional options for the search request.
   */
  public List<SearchResponse<?>> searchForHits(
    @Nonnull List<SearchForHits> requests,
    SearchStrategy strategy,
    RequestOptions requestOptions
  ) {
    return LaunderThrowable.await(searchForHitsAsync(requests, strategy, requestOptions));
  }

  /**
   * Executes an asynchronous search for the provided search requests, with certainty that we will
   * only request Algolia records (hits). Results will be received in the same order as the queries.
   *
   * @param requests A list of search requests to be executed.
   */
  public CompletableFuture<List<SearchResponse<?>>> searchForHitsAsync(@Nonnull List<SearchForHits> requests) {
    return searchForHitsAsync(requests, null, null);
  }

  /**
   * Executes an asynchronous search for the provided search requests, with certainty that we will
   * only request Algolia records (hits). Results will be received in the same order as the queries.
   *
   * @param requests A list of search requests to be executed.
   * @param strategy The search strategy to be employed during the search.
   */
  public CompletableFuture<List<SearchResponse<?>>> searchForHitsAsync(@Nonnull List<SearchForHits> requests, SearchStrategy strategy) {
    return searchForHitsAsync(requests, strategy, null);
  }

  /**
   * Executes an asynchronous search for the provided search requests, with certainty that we will
   * only request Algolia records (hits). Results will be received in the same order as the queries.
   *
   * @param requests A list of search requests to be executed.
   * @param strategy The search strategy to be employed during the search.
   * @param requestOptions Additional options for the search request.
   */
  public CompletableFuture<List<SearchResponse<?>>> searchForHitsAsync(
    @Nonnull List<SearchForHits> requests,
    SearchStrategy strategy,
    RequestOptions requestOptions
  ) {
    final List<SearchQuery> searchQueries = new ArrayList<>(requests); // Upcast the list
    final SearchMethodParams params = new SearchMethodParams().setRequests(searchQueries).setStrategy(strategy);
    return searchAsync(params)
      .thenApply(searchResponses -> searchResponses.getResults().stream().map(res -> (SearchResponse<?>) res).collect(Collectors.toList()));
  }

  /**
   * Executes a synchronous search for the provided search requests, with certainty that we will
   * only request Algolia facets. Results will be received in the same order as the queries.
   *
   * @param requests A list of search requests to be executed.
   */
  public List<SearchForFacetValuesResponse> searchForFacets(@Nonnull List<SearchForFacets> requests) {
    return LaunderThrowable.await(searchForFacetsAsync(requests, null, null));
  }

  /**
   * Executes a synchronous search for the provided search requests, with certainty that we will
   * only request Algolia facets. Results will be received in the same order as the queries.
   *
   * @param requests A list of search requests to be executed.
   * @param strategy The search strategy to be employed during the search.
   */
  public List<SearchForFacetValuesResponse> searchForFacets(@Nonnull List<SearchForFacets> requests, SearchStrategy strategy) {
    return LaunderThrowable.await(searchForFacetsAsync(requests, strategy, null));
  }

  /**
   * Executes a synchronous search for the provided search requests, with certainty that we will
   * only request Algolia facets. Results will be received in the same order as the queries.
   *
   * @param requests A list of search requests to be executed.
   * @param strategy The search strategy to be employed during the search.
   * @param requestOptions Additional options for the search request.
   */
  public List<SearchForFacetValuesResponse> searchForFacets(
    @Nonnull List<SearchForFacets> requests,
    SearchStrategy strategy,
    RequestOptions requestOptions
  ) {
    return LaunderThrowable.await(searchForFacetsAsync(requests, strategy, requestOptions));
  }

  /**
   * Executes an asynchronous search for the provided search requests, with certainty that we will
   * only request Algolia facets. Results will be received in the same order as the queries.
   *
   * @param requests A list of search requests to be executed.
   */
  public CompletableFuture<List<SearchForFacetValuesResponse>> searchForFacetsAsync(@Nonnull List<SearchForFacets> requests) {
    return searchForFacetsAsync(requests, null, null);
  }

  /**
   * Executes an asynchronous search for the provided search requests, with certainty that we will
   * only request Algolia facets. Results will be received in the same order as the queries.
   *
   * @param requests A list of search requests to be executed.
   * @param strategy The search strategy to be employed during the search.
   */
  public CompletableFuture<List<SearchForFacetValuesResponse>> searchForFacetsAsync(
    @Nonnull List<SearchForFacets> requests,
    SearchStrategy strategy
  ) {
    return searchForFacetsAsync(requests, strategy, null);
  }

  /**
   * Executes an asynchronous search for the provided search requests, with certainty that we will
   * only request Algolia facets. Results will be received in the same order as the queries.
   *
   * @param requests A list of search requests to be executed.
   * @param strategy The search strategy to be employed during the search.
   * @param requestOptions Additional options for the search request.
   */
  public CompletableFuture<List<SearchForFacetValuesResponse>> searchForFacetsAsync(
    @Nonnull List<SearchForFacets> requests,
    SearchStrategy strategy,
    RequestOptions requestOptions
  ) {
    final List<SearchQuery> searchQueries = new ArrayList<>(requests); // Upcast the list
    final SearchMethodParams params = new SearchMethodParams().setRequests(searchQueries).setStrategy(strategy);
    return searchAsync(params)
      .thenApply(searchResponses ->
        searchResponses.getResults().stream().map(res -> (SearchForFacetValuesResponse) res).collect(Collectors.toList())
      );
  }
}
