// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.querysuggestions;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Query Suggestions configuration. */
public class QuerySuggestionsConfiguration {

  @JsonProperty("sourceIndices")
  private List<SourceIndex> sourceIndices = new ArrayList<>();

  @JsonProperty("languages")
  private Languages languages;

  @JsonProperty("exclude")
  private List<String> exclude;

  @JsonProperty("enablePersonalization")
  private Boolean enablePersonalization;

  @JsonProperty("allowSpecialCharacters")
  private Boolean allowSpecialCharacters;

  public QuerySuggestionsConfiguration setSourceIndices(List<SourceIndex> sourceIndices) {
    this.sourceIndices = sourceIndices;
    return this;
  }

  public QuerySuggestionsConfiguration addSourceIndices(SourceIndex sourceIndicesItem) {
    this.sourceIndices.add(sourceIndicesItem);
    return this;
  }

  /** Algolia indices from which to get the popular searches for query suggestions. */
  @javax.annotation.Nonnull
  public List<SourceIndex> getSourceIndices() {
    return sourceIndices;
  }

  public QuerySuggestionsConfiguration setLanguages(Languages languages) {
    this.languages = languages;
    return this;
  }

  /** Get languages */
  @javax.annotation.Nullable
  public Languages getLanguages() {
    return languages;
  }

  public QuerySuggestionsConfiguration setExclude(List<String> exclude) {
    this.exclude = exclude;
    return this;
  }

  public QuerySuggestionsConfiguration addExclude(String excludeItem) {
    if (this.exclude == null) {
      this.exclude = new ArrayList<>();
    }
    this.exclude.add(excludeItem);
    return this;
  }

  /** Patterns to exclude from query suggestions. */
  @javax.annotation.Nullable
  public List<String> getExclude() {
    return exclude;
  }

  public QuerySuggestionsConfiguration setEnablePersonalization(Boolean enablePersonalization) {
    this.enablePersonalization = enablePersonalization;
    return this;
  }

  /** Turn on personalized query suggestions. */
  @javax.annotation.Nullable
  public Boolean getEnablePersonalization() {
    return enablePersonalization;
  }

  public QuerySuggestionsConfiguration setAllowSpecialCharacters(Boolean allowSpecialCharacters) {
    this.allowSpecialCharacters = allowSpecialCharacters;
    return this;
  }

  /** Allow suggestions with special characters. */
  @javax.annotation.Nullable
  public Boolean getAllowSpecialCharacters() {
    return allowSpecialCharacters;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QuerySuggestionsConfiguration querySuggestionsConfiguration = (QuerySuggestionsConfiguration) o;
    return (
      Objects.equals(this.sourceIndices, querySuggestionsConfiguration.sourceIndices) &&
      Objects.equals(this.languages, querySuggestionsConfiguration.languages) &&
      Objects.equals(this.exclude, querySuggestionsConfiguration.exclude) &&
      Objects.equals(this.enablePersonalization, querySuggestionsConfiguration.enablePersonalization) &&
      Objects.equals(this.allowSpecialCharacters, querySuggestionsConfiguration.allowSpecialCharacters)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceIndices, languages, exclude, enablePersonalization, allowSpecialCharacters);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QuerySuggestionsConfiguration {\n");
    sb.append("    sourceIndices: ").append(toIndentedString(sourceIndices)).append("\n");
    sb.append("    languages: ").append(toIndentedString(languages)).append("\n");
    sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
    sb.append("    enablePersonalization: ").append(toIndentedString(enablePersonalization)).append("\n");
    sb.append("    allowSpecialCharacters: ").append(toIndentedString(allowSpecialCharacters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
