/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.insights.EventsResponse;
import com.algolia.model.insights.InsightsEvents;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class InsightsClient
extends ApiClient {
    private static final String[] allowedRegions = new String[]{"de", "us"};

    public InsightsClient(String appId, String apiKey) {
        this(appId, apiKey, null, null);
    }

    public InsightsClient(String appId, String apiKey, ClientOptions options) {
        this(appId, apiKey, null, options);
    }

    public InsightsClient(String appId, String apiKey, String region) {
        this(appId, apiKey, region, null);
    }

    public InsightsClient(String appId, String apiKey, String region, ClientOptions options) {
        super(appId, apiKey, "Insights", options, InsightsClient.getDefaultHosts(region));
    }

    private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
        boolean found;
        ArrayList<Host> hosts = new ArrayList<Host>();
        boolean bl = found = region == null;
        if (region != null) {
            for (String allowed : allowedRegions) {
                if (!allowed.equals(region)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new AlgoliaRuntimeException("`region` must be one of the following: de, us");
        }
        String url = region == null ? "insights.algolia.io" : "insights.{region}.algolia.io".replace("{region}", region);
        hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
        return hosts;
    }

    public Object del(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.delAsync(path, parameters, requestOptions));
    }

    public Object del(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.del(path, parameters, null);
    }

    public Object del(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.del(path, null, requestOptions);
    }

    public Object del(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.del(path, null, null);
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `del`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.delAsync(path, parameters, null);
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, null);
    }

    public Object get(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAsync(path, parameters, requestOptions));
    }

    public Object get(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.get(path, parameters, null);
    }

    public Object get(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.get(path, null, requestOptions);
    }

    public Object get(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.get(path, null, null);
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `get`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.getAsync(path, parameters, null);
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, null);
    }

    public Object post(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.postAsync(path, parameters, body, requestOptions));
    }

    public Object post(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.post(path, parameters, body, null);
    }

    public Object post(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.post(path, null, null, requestOptions);
    }

    public Object post(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.post(path, null, null, null);
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `post`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.postAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, null);
    }

    public EventsResponse pushEvents(@Nonnull InsightsEvents insightsEvents, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.pushEventsAsync(insightsEvents, requestOptions));
    }

    public EventsResponse pushEvents(@Nonnull InsightsEvents insightsEvents) throws AlgoliaRuntimeException {
        return this.pushEvents(insightsEvents, null);
    }

    public CompletableFuture<EventsResponse> pushEventsAsync(@Nonnull InsightsEvents insightsEvents, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(insightsEvents, "Parameter `insightsEvents` is required when calling `pushEvents`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/events").setMethod("POST").setBody(insightsEvents).build();
        return this.executeAsync(request, requestOptions, new TypeReference<EventsResponse>(){});
    }

    public CompletableFuture<EventsResponse> pushEventsAsync(@Nonnull InsightsEvents insightsEvents) throws AlgoliaRuntimeException {
        return this.pushEventsAsync(insightsEvents, null);
    }

    public Object put(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.putAsync(path, parameters, body, requestOptions));
    }

    public Object put(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.put(path, parameters, body, null);
    }

    public Object put(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.put(path, null, null, requestOptions);
    }

    public Object put(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.put(path, null, null, null);
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `put`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.putAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, null);
    }
}

