/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.personalization.DeleteUserProfileResponse;
import com.algolia.model.personalization.GetUserTokenResponse;
import com.algolia.model.personalization.PersonalizationStrategyParams;
import com.algolia.model.personalization.SetPersonalizationStrategyResponse;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class PersonalizationClient
extends ApiClient {
    private static final String[] allowedRegions = new String[]{"eu", "us"};

    public PersonalizationClient(String appId, String apiKey, String region) {
        this(appId, apiKey, region, null);
    }

    public PersonalizationClient(String appId, String apiKey, String region, ClientOptions options) {
        super(appId, apiKey, "Personalization", options, PersonalizationClient.getDefaultHosts(region));
    }

    private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
        ArrayList<Host> hosts = new ArrayList<Host>();
        boolean found = false;
        if (region != null) {
            for (String allowed : allowedRegions) {
                if (!allowed.equals(region)) continue;
                found = true;
                break;
            }
        }
        if (region == null || !found) {
            throw new AlgoliaRuntimeException("`region` is required and must be one of the following: eu, us");
        }
        String url = "personalization.{region}.algolia.com".replace("{region}", region);
        hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
        return hosts;
    }

    public Object del(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.delAsync(path, parameters, requestOptions));
    }

    public Object del(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.del(path, parameters, null);
    }

    public Object del(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.del(path, null, requestOptions);
    }

    public Object del(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.del(path, null, null);
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `del`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.delAsync(path, parameters, null);
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, null);
    }

    public DeleteUserProfileResponse deleteUserProfile(@Nonnull String userToken, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteUserProfileAsync(userToken, requestOptions));
    }

    public DeleteUserProfileResponse deleteUserProfile(@Nonnull String userToken) throws AlgoliaRuntimeException {
        return this.deleteUserProfile(userToken, null);
    }

    public CompletableFuture<DeleteUserProfileResponse> deleteUserProfileAsync(@Nonnull String userToken, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(userToken, "Parameter `userToken` is required when calling `deleteUserProfile`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/profiles/{userToken}", userToken).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeleteUserProfileResponse>(){});
    }

    public CompletableFuture<DeleteUserProfileResponse> deleteUserProfileAsync(@Nonnull String userToken) throws AlgoliaRuntimeException {
        return this.deleteUserProfileAsync(userToken, null);
    }

    public Object get(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAsync(path, parameters, requestOptions));
    }

    public Object get(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.get(path, parameters, null);
    }

    public Object get(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.get(path, null, requestOptions);
    }

    public Object get(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.get(path, null, null);
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `get`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.getAsync(path, parameters, null);
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, null);
    }

    public PersonalizationStrategyParams getPersonalizationStrategy(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getPersonalizationStrategyAsync(requestOptions));
    }

    public PersonalizationStrategyParams getPersonalizationStrategy() throws AlgoliaRuntimeException {
        return this.getPersonalizationStrategy(null);
    }

    public CompletableFuture<PersonalizationStrategyParams> getPersonalizationStrategyAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/strategies/personalization").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<PersonalizationStrategyParams>(){});
    }

    public CompletableFuture<PersonalizationStrategyParams> getPersonalizationStrategyAsync() throws AlgoliaRuntimeException {
        return this.getPersonalizationStrategyAsync(null);
    }

    public GetUserTokenResponse getUserTokenProfile(@Nonnull String userToken, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getUserTokenProfileAsync(userToken, requestOptions));
    }

    public GetUserTokenResponse getUserTokenProfile(@Nonnull String userToken) throws AlgoliaRuntimeException {
        return this.getUserTokenProfile(userToken, null);
    }

    public CompletableFuture<GetUserTokenResponse> getUserTokenProfileAsync(@Nonnull String userToken, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(userToken, "Parameter `userToken` is required when calling `getUserTokenProfile`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/profiles/personalization/{userToken}", userToken).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetUserTokenResponse>(){});
    }

    public CompletableFuture<GetUserTokenResponse> getUserTokenProfileAsync(@Nonnull String userToken) throws AlgoliaRuntimeException {
        return this.getUserTokenProfileAsync(userToken, null);
    }

    public Object post(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.postAsync(path, parameters, body, requestOptions));
    }

    public Object post(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.post(path, parameters, body, null);
    }

    public Object post(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.post(path, null, null, requestOptions);
    }

    public Object post(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.post(path, null, null, null);
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `post`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.postAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, null);
    }

    public Object put(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.putAsync(path, parameters, body, requestOptions));
    }

    public Object put(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.put(path, parameters, body, null);
    }

    public Object put(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.put(path, null, null, requestOptions);
    }

    public Object put(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.put(path, null, null, null);
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `put`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.putAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, null);
    }

    public SetPersonalizationStrategyResponse setPersonalizationStrategy(@Nonnull PersonalizationStrategyParams personalizationStrategyParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.setPersonalizationStrategyAsync(personalizationStrategyParams, requestOptions));
    }

    public SetPersonalizationStrategyResponse setPersonalizationStrategy(@Nonnull PersonalizationStrategyParams personalizationStrategyParams) throws AlgoliaRuntimeException {
        return this.setPersonalizationStrategy(personalizationStrategyParams, null);
    }

    public CompletableFuture<SetPersonalizationStrategyResponse> setPersonalizationStrategyAsync(@Nonnull PersonalizationStrategyParams personalizationStrategyParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(personalizationStrategyParams, "Parameter `personalizationStrategyParams` is required when calling `setPersonalizationStrategy`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/strategies/personalization").setMethod("POST").setBody(personalizationStrategyParams).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SetPersonalizationStrategyResponse>(){});
    }

    public CompletableFuture<SetPersonalizationStrategyResponse> setPersonalizationStrategyAsync(@Nonnull PersonalizationStrategyParams personalizationStrategyParams) throws AlgoliaRuntimeException {
        return this.setPersonalizationStrategyAsync(personalizationStrategyParams, null);
    }
}

