/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.recommend.DeletedAtResponse;
import com.algolia.model.recommend.GetRecommendTaskResponse;
import com.algolia.model.recommend.GetRecommendationsParams;
import com.algolia.model.recommend.GetRecommendationsResponse;
import com.algolia.model.recommend.RecommendModels;
import com.algolia.model.recommend.RuleResponse;
import com.algolia.model.recommend.SearchRecommendRulesParams;
import com.algolia.model.recommend.SearchRecommendRulesResponse;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class RecommendClient
extends ApiClient {
    public RecommendClient(String appId, String apiKey) {
        this(appId, apiKey, null);
    }

    public RecommendClient(String appId, String apiKey, ClientOptions options) {
        super(appId, apiKey, "Recommend", options, RecommendClient.getDefaultHosts(appId));
    }

    private static List<Host> getDefaultHosts(String appId) {
        ArrayList<Host> hosts = new ArrayList<Host>();
        hosts.add(new Host(appId + "-dsn.algolia.net", EnumSet.of(CallType.READ)));
        hosts.add(new Host(appId + ".algolia.net", EnumSet.of(CallType.WRITE)));
        ArrayList commonHosts = new ArrayList();
        hosts.add(new Host(appId + "-1.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new Host(appId + "-2.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new Host(appId + "-3.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
        Collections.shuffle(commonHosts, new Random());
        return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
    }

    public Object del(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.delAsync(path, parameters, requestOptions));
    }

    public Object del(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.del(path, parameters, null);
    }

    public Object del(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.del(path, null, requestOptions);
    }

    public Object del(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.del(path, null, null);
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `del`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.delAsync(path, parameters, null);
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, null);
    }

    public DeletedAtResponse deleteRecommendRule(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteRecommendRuleAsync(indexName, model, objectID, requestOptions));
    }

    public DeletedAtResponse deleteRecommendRule(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.deleteRecommendRule(indexName, model, objectID, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteRecommendRuleAsync(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteRecommendRule`.");
        Parameters.requireNonNull((Object)model, "Parameter `model` is required when calling `deleteRecommendRule`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `deleteRecommendRule`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/{model}/recommend/rules/{objectID}", new Object[]{indexName, model, objectID}).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeletedAtResponse>(){});
    }

    public CompletableFuture<DeletedAtResponse> deleteRecommendRuleAsync(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.deleteRecommendRuleAsync(indexName, model, objectID, null);
    }

    public Object get(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAsync(path, parameters, requestOptions));
    }

    public Object get(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.get(path, parameters, null);
    }

    public Object get(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.get(path, null, requestOptions);
    }

    public Object get(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.get(path, null, null);
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `get`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.getAsync(path, parameters, null);
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, null);
    }

    public RuleResponse getRecommendRule(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRecommendRuleAsync(indexName, model, objectID, requestOptions));
    }

    public RuleResponse getRecommendRule(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.getRecommendRule(indexName, model, objectID, null);
    }

    public CompletableFuture<RuleResponse> getRecommendRuleAsync(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getRecommendRule`.");
        Parameters.requireNonNull((Object)model, "Parameter `model` is required when calling `getRecommendRule`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `getRecommendRule`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/{model}/recommend/rules/{objectID}", new Object[]{indexName, model, objectID}).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<RuleResponse>(){});
    }

    public CompletableFuture<RuleResponse> getRecommendRuleAsync(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.getRecommendRuleAsync(indexName, model, objectID, null);
    }

    public GetRecommendTaskResponse getRecommendStatus(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull Long taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRecommendStatusAsync(indexName, model, taskID, requestOptions));
    }

    public GetRecommendTaskResponse getRecommendStatus(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull Long taskID) throws AlgoliaRuntimeException {
        return this.getRecommendStatus(indexName, model, taskID, null);
    }

    public CompletableFuture<GetRecommendTaskResponse> getRecommendStatusAsync(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull Long taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getRecommendStatus`.");
        Parameters.requireNonNull((Object)model, "Parameter `model` is required when calling `getRecommendStatus`.");
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `getRecommendStatus`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/{model}/task/{taskID}", new Object[]{indexName, model, taskID}).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetRecommendTaskResponse>(){});
    }

    public CompletableFuture<GetRecommendTaskResponse> getRecommendStatusAsync(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull Long taskID) throws AlgoliaRuntimeException {
        return this.getRecommendStatusAsync(indexName, model, taskID, null);
    }

    public GetRecommendationsResponse getRecommendations(@Nonnull GetRecommendationsParams getRecommendationsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRecommendationsAsync(getRecommendationsParams, requestOptions));
    }

    public GetRecommendationsResponse getRecommendations(@Nonnull GetRecommendationsParams getRecommendationsParams) throws AlgoliaRuntimeException {
        return this.getRecommendations(getRecommendationsParams, null);
    }

    public CompletableFuture<GetRecommendationsResponse> getRecommendationsAsync(@Nonnull GetRecommendationsParams getRecommendationsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(getRecommendationsParams, "Parameter `getRecommendationsParams` is required when calling `getRecommendations`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/*/recommendations").setMethod("POST").setBody(getRecommendationsParams).setRead(true).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetRecommendationsResponse>(){});
    }

    public CompletableFuture<GetRecommendationsResponse> getRecommendationsAsync(@Nonnull GetRecommendationsParams getRecommendationsParams) throws AlgoliaRuntimeException {
        return this.getRecommendationsAsync(getRecommendationsParams, null);
    }

    public Object post(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.postAsync(path, parameters, body, requestOptions));
    }

    public Object post(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.post(path, parameters, body, null);
    }

    public Object post(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.post(path, null, null, requestOptions);
    }

    public Object post(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.post(path, null, null, null);
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `post`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.postAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, null);
    }

    public Object put(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.putAsync(path, parameters, body, requestOptions));
    }

    public Object put(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.put(path, parameters, body, null);
    }

    public Object put(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.put(path, null, null, requestOptions);
    }

    public Object put(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.put(path, null, null, null);
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `put`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.putAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, null);
    }

    public SearchRecommendRulesResponse searchRecommendRules(@Nonnull String indexName, @Nonnull RecommendModels model, SearchRecommendRulesParams searchRecommendRulesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchRecommendRulesAsync(indexName, model, searchRecommendRulesParams, requestOptions));
    }

    public SearchRecommendRulesResponse searchRecommendRules(@Nonnull String indexName, @Nonnull RecommendModels model, SearchRecommendRulesParams searchRecommendRulesParams) throws AlgoliaRuntimeException {
        return this.searchRecommendRules(indexName, model, searchRecommendRulesParams, null);
    }

    public SearchRecommendRulesResponse searchRecommendRules(@Nonnull String indexName, @Nonnull RecommendModels model, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchRecommendRules(indexName, model, null, requestOptions);
    }

    public SearchRecommendRulesResponse searchRecommendRules(@Nonnull String indexName, @Nonnull RecommendModels model) throws AlgoliaRuntimeException {
        return this.searchRecommendRules(indexName, model, null, null);
    }

    public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(@Nonnull String indexName, @Nonnull RecommendModels model, SearchRecommendRulesParams searchRecommendRulesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `searchRecommendRules`.");
        Parameters.requireNonNull((Object)model, "Parameter `model` is required when calling `searchRecommendRules`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/{model}/recommend/rules/search", new Object[]{indexName, model}).setMethod("POST").setBody(searchRecommendRulesParams).setRead(true).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SearchRecommendRulesResponse>(){});
    }

    public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(@Nonnull String indexName, @Nonnull RecommendModels model, SearchRecommendRulesParams searchRecommendRulesParams) throws AlgoliaRuntimeException {
        return this.searchRecommendRulesAsync(indexName, model, searchRecommendRulesParams, null);
    }

    public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(@Nonnull String indexName, @Nonnull RecommendModels model, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchRecommendRulesAsync(indexName, model, null, requestOptions);
    }

    public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(@Nonnull String indexName, @Nonnull RecommendModels model) throws AlgoliaRuntimeException {
        return this.searchRecommendRulesAsync(indexName, model, null, null);
    }
}

