/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.insights;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface Price {
    public static Price of(Double value) {
        return new DoubleWrapper(value);
    }

    public static Price of(String value) {
        return new StringWrapper(value);
    }

    @JsonSerialize(using=Serializer.class)
    public static class DoubleWrapper
    implements Price {
        private final Double value;

        DoubleWrapper(Double value) {
            this.value = value;
        }

        public Double getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<DoubleWrapper> {
            Serializer() {
            }

            public void serialize(DoubleWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject((Object)value.getValue());
            }
        }
    }

    @JsonSerialize(using=Serializer.class)
    public static class StringWrapper
    implements Price {
        private final String value;

        StringWrapper(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<StringWrapper> {
            Serializer() {
            }

            public void serialize(StringWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject((Object)value.getValue());
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Price> {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

        public Price deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isValueNode()) {
                Price price;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        Double value = (Double)parser.readValueAs(Double.class);
                        price = Price.of(value);
                        if (parser == null) break block18;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf Double (error: " + e.getMessage() + ") (type: Double)");
                        }
                    }
                    parser.close();
                }
                return price;
            }
            if (tree.isValueNode()) {
                Price price;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        String value = (String)parser.readValueAs(String.class);
                        price = Price.of(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf String (error: " + e.getMessage() + ") (type: String)");
                        }
                    }
                    parser.close();
                }
                return price;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public Price getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "Price cannot be null");
        }
    }
}

