// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.*;
import com.algolia.config.ClientOptions;
import com.algolia.exceptions.*;
import com.algolia.model.analytics.*;
import com.algolia.utils.*;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class AnalyticsClient extends ApiClient {

  private static final String[] allowedRegions = { "de", "us" };

  public AnalyticsClient(String appId, String apiKey) {
    this(appId, apiKey, null, null);
  }

  public AnalyticsClient(String appId, String apiKey, ClientOptions options) {
    this(appId, apiKey, null, options);
  }

  public AnalyticsClient(String appId, String apiKey, String region) {
    this(appId, apiKey, region, null);
  }

  public AnalyticsClient(String appId, String apiKey, String region, ClientOptions options) {
    super(appId, apiKey, "Analytics", options, getDefaultHosts(region));
  }

  private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
    List<Host> hosts = new ArrayList<>();

    boolean found = region == null;
    if (region != null) {
      for (String allowed : allowedRegions) {
        if (allowed.equals(region)) {
          found = true;
          break;
        }
      }
    }

    if (!found) {
      throw new AlgoliaRuntimeException("`region` must be one of the following: de, us");
    }

    String url = region == null ? "analytics.algolia.com" : "analytics.{region}.algolia.com".replace("{region}", region);

    hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
    return hosts;
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customDeleteAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDelete(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customGetAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGet(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGet(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGet(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("GET").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPostAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPost(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/1{path}", path)
      .setMethod("POST")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPostAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPutAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPut(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/1{path}", path)
      .setMethod("PUT")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPutAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, null);
  }

  /**
   * Return the average click position for the complete time range and for individual days. >
   * **Note**: If all `positions` have a `clickCount` of `0` or `null`, it means Algolia didn't
   * receive any click events for tracked searches. A _tracked_ search is a search request where the
   * `clickAnalytics` parameter is `true`.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetAverageClickPositionResponse getAverageClickPosition(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAverageClickPositionAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Return the average click position for the complete time range and for individual days. >
   * **Note**: If all `positions` have a `clickCount` of `0` or `null`, it means Algolia didn't
   * receive any click events for tracked searches. A _tracked_ search is a search request where the
   * `clickAnalytics` parameter is `true`.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetAverageClickPositionResponse getAverageClickPosition(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getAverageClickPosition(index, startDate, endDate, tags, null);
  }

  /**
   * Return the average click position for the complete time range and for individual days. >
   * **Note**: If all `positions` have a `clickCount` of `0` or `null`, it means Algolia didn't
   * receive any click events for tracked searches. A _tracked_ search is a search request where the
   * `clickAnalytics` parameter is `true`.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetAverageClickPositionResponse getAverageClickPosition(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getAverageClickPosition(index, null, null, null, requestOptions);
  }

  /**
   * Return the average click position for the complete time range and for individual days. >
   * **Note**: If all `positions` have a `clickCount` of `0` or `null`, it means Algolia didn't
   * receive any click events for tracked searches. A _tracked_ search is a search request where the
   * `clickAnalytics` parameter is `true`.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetAverageClickPositionResponse getAverageClickPosition(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getAverageClickPosition(index, null, null, null, null);
  }

  /**
   * (asynchronously) Return the average click position for the complete time range and for
   * individual days. &gt; **Note**: If all &#x60;positions&#x60; have a &#x60;clickCount&#x60; of
   * &#x60;0&#x60; or &#x60;null&#x60;, it means Algolia didn&#39;t receive any click events for
   * tracked searches. A _tracked_ search is a search request where the &#x60;clickAnalytics&#x60;
   * parameter is &#x60;true&#x60;.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getAverageClickPosition`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/clicks/averageClickPosition")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetAverageClickPositionResponse>() {});
  }

  /**
   * (asynchronously) Return the average click position for the complete time range and for
   * individual days. &gt; **Note**: If all &#x60;positions&#x60; have a &#x60;clickCount&#x60; of
   * &#x60;0&#x60; or &#x60;null&#x60;, it means Algolia didn&#39;t receive any click events for
   * tracked searches. A _tracked_ search is a search request where the &#x60;clickAnalytics&#x60;
   * parameter is &#x60;true&#x60;.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getAverageClickPositionAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Return the average click position for the complete time range and for
   * individual days. &gt; **Note**: If all &#x60;positions&#x60; have a &#x60;clickCount&#x60; of
   * &#x60;0&#x60; or &#x60;null&#x60;, it means Algolia didn&#39;t receive any click events for
   * tracked searches. A _tracked_ search is a search request where the &#x60;clickAnalytics&#x60;
   * parameter is &#x60;true&#x60;.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(
    @Nonnull String index,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getAverageClickPositionAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Return the average click position for the complete time range and for
   * individual days. &gt; **Note**: If all &#x60;positions&#x60; have a &#x60;clickCount&#x60; of
   * &#x60;0&#x60; or &#x60;null&#x60;, it means Algolia didn&#39;t receive any click events for
   * tracked searches. A _tracked_ search is a search request where the &#x60;clickAnalytics&#x60;
   * parameter is &#x60;true&#x60;.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetAverageClickPositionResponse> getAverageClickPositionAsync(@Nonnull String index)
    throws AlgoliaRuntimeException {
    return this.getAverageClickPositionAsync(index, null, null, null, null);
  }

  /**
   * Show the number of clicks events and their associated position in the search results. >
   * **Note**: If all `positions` have a `clickCount` of `0` or `null`, it means Algolia didn't
   * receive any click events for tracked searches. A _tracked_ search is a search request where the
   * `clickAnalytics` parameter is `true`.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickPositionsResponse getClickPositions(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getClickPositionsAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Show the number of clicks events and their associated position in the search results. >
   * **Note**: If all `positions` have a `clickCount` of `0` or `null`, it means Algolia didn't
   * receive any click events for tracked searches. A _tracked_ search is a search request where the
   * `clickAnalytics` parameter is `true`.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickPositionsResponse getClickPositions(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getClickPositions(index, startDate, endDate, tags, null);
  }

  /**
   * Show the number of clicks events and their associated position in the search results. >
   * **Note**: If all `positions` have a `clickCount` of `0` or `null`, it means Algolia didn't
   * receive any click events for tracked searches. A _tracked_ search is a search request where the
   * `clickAnalytics` parameter is `true`.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickPositionsResponse getClickPositions(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getClickPositions(index, null, null, null, requestOptions);
  }

  /**
   * Show the number of clicks events and their associated position in the search results. >
   * **Note**: If all `positions` have a `clickCount` of `0` or `null`, it means Algolia didn't
   * receive any click events for tracked searches. A _tracked_ search is a search request where the
   * `clickAnalytics` parameter is `true`.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickPositionsResponse getClickPositions(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getClickPositions(index, null, null, null, null);
  }

  /**
   * (asynchronously) Show the number of clicks events and their associated position in the search
   * results. &gt; **Note**: If all &#x60;positions&#x60; have a &#x60;clickCount&#x60; of
   * &#x60;0&#x60; or &#x60;null&#x60;, it means Algolia didn&#39;t receive any click events for
   * tracked searches. A _tracked_ search is a search request where the &#x60;clickAnalytics&#x60;
   * parameter is &#x60;true&#x60;.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getClickPositions`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/clicks/positions")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetClickPositionsResponse>() {});
  }

  /**
   * (asynchronously) Show the number of clicks events and their associated position in the search
   * results. &gt; **Note**: If all &#x60;positions&#x60; have a &#x60;clickCount&#x60; of
   * &#x60;0&#x60; or &#x60;null&#x60;, it means Algolia didn&#39;t receive any click events for
   * tracked searches. A _tracked_ search is a search request where the &#x60;clickAnalytics&#x60;
   * parameter is &#x60;true&#x60;.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getClickPositionsAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Show the number of clicks events and their associated position in the search
   * results. &gt; **Note**: If all &#x60;positions&#x60; have a &#x60;clickCount&#x60; of
   * &#x60;0&#x60; or &#x60;null&#x60;, it means Algolia didn&#39;t receive any click events for
   * tracked searches. A _tracked_ search is a search request where the &#x60;clickAnalytics&#x60;
   * parameter is &#x60;true&#x60;.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getClickPositionsAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Show the number of clicks events and their associated position in the search
   * results. &gt; **Note**: If all &#x60;positions&#x60; have a &#x60;clickCount&#x60; of
   * &#x60;0&#x60; or &#x60;null&#x60;, it means Algolia didn&#39;t receive any click events for
   * tracked searches. A _tracked_ search is a search request where the &#x60;clickAnalytics&#x60;
   * parameter is &#x60;true&#x60;.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickPositionsResponse> getClickPositionsAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getClickPositionsAsync(index, null, null, null, null);
  }

  /**
   * Returns a [click-through rate
   * (CTR)](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#click-through-rate).
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickThroughRateResponse getClickThroughRate(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getClickThroughRateAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Returns a [click-through rate
   * (CTR)](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#click-through-rate).
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickThroughRateResponse getClickThroughRate(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getClickThroughRate(index, startDate, endDate, tags, null);
  }

  /**
   * Returns a [click-through rate
   * (CTR)](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#click-through-rate).
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickThroughRateResponse getClickThroughRate(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getClickThroughRate(index, null, null, null, requestOptions);
  }

  /**
   * Returns a [click-through rate
   * (CTR)](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#click-through-rate).
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetClickThroughRateResponse getClickThroughRate(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getClickThroughRate(index, null, null, null, null);
  }

  /**
   * (asynchronously) Returns a [click-through rate
   * (CTR)](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#click-through-rate).
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getClickThroughRate`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/clicks/clickThroughRate")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetClickThroughRateResponse>() {});
  }

  /**
   * (asynchronously) Returns a [click-through rate
   * (CTR)](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#click-through-rate).
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getClickThroughRateAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Returns a [click-through rate
   * (CTR)](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#click-through-rate).
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getClickThroughRateAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Returns a [click-through rate
   * (CTR)](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#click-through-rate).
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetClickThroughRateResponse> getClickThroughRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getClickThroughRateAsync(index, null, null, null, null);
  }

  /**
   * Return a [conversion
   * rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#conversion-rate).
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetConversationRateResponse getConversationRate(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getConversationRateAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Return a [conversion
   * rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#conversion-rate).
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetConversationRateResponse getConversationRate(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getConversationRate(index, startDate, endDate, tags, null);
  }

  /**
   * Return a [conversion
   * rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#conversion-rate).
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetConversationRateResponse getConversationRate(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getConversationRate(index, null, null, null, requestOptions);
  }

  /**
   * Return a [conversion
   * rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#conversion-rate).
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetConversationRateResponse getConversationRate(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getConversationRate(index, null, null, null, null);
  }

  /**
   * (asynchronously) Return a [conversion
   * rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#conversion-rate).
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetConversationRateResponse> getConversationRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getConversationRate`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/conversions/conversionRate")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetConversationRateResponse>() {});
  }

  /**
   * (asynchronously) Return a [conversion
   * rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#conversion-rate).
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetConversationRateResponse> getConversationRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getConversationRateAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Return a [conversion
   * rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#conversion-rate).
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetConversationRateResponse> getConversationRateAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getConversationRateAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Return a [conversion
   * rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#conversion-rate).
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetConversationRateResponse> getConversationRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getConversationRateAsync(index, null, null, null, null);
  }

  /**
   * Returns the rate at which searches don't lead to any clicks. The endpoint returns a value for
   * the complete given time range, as well as a value per day. It also returns the count of
   * searches and searches without clicks.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoClickRateResponse getNoClickRate(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getNoClickRateAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Returns the rate at which searches don't lead to any clicks. The endpoint returns a value for
   * the complete given time range, as well as a value per day. It also returns the count of
   * searches and searches without clicks.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoClickRateResponse getNoClickRate(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getNoClickRate(index, startDate, endDate, tags, null);
  }

  /**
   * Returns the rate at which searches don't lead to any clicks. The endpoint returns a value for
   * the complete given time range, as well as a value per day. It also returns the count of
   * searches and searches without clicks.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoClickRateResponse getNoClickRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getNoClickRate(index, null, null, null, requestOptions);
  }

  /**
   * Returns the rate at which searches don't lead to any clicks. The endpoint returns a value for
   * the complete given time range, as well as a value per day. It also returns the count of
   * searches and searches without clicks.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoClickRateResponse getNoClickRate(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getNoClickRate(index, null, null, null, null);
  }

  /**
   * (asynchronously) Returns the rate at which searches don&#39;t lead to any clicks. The endpoint
   * returns a value for the complete given time range, as well as a value per day. It also returns
   * the count of searches and searches without clicks.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getNoClickRate`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/searches/noClickRate")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetNoClickRateResponse>() {});
  }

  /**
   * (asynchronously) Returns the rate at which searches don&#39;t lead to any clicks. The endpoint
   * returns a value for the complete given time range, as well as a value per day. It also returns
   * the count of searches and searches without clicks.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getNoClickRateAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Returns the rate at which searches don&#39;t lead to any clicks. The endpoint
   * returns a value for the complete given time range, as well as a value per day. It also returns
   * the count of searches and searches without clicks.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getNoClickRateAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Returns the rate at which searches don&#39;t lead to any clicks. The endpoint
   * returns a value for the complete given time range, as well as a value per day. It also returns
   * the count of searches and searches without clicks.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoClickRateResponse> getNoClickRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getNoClickRateAsync(index, null, null, null, null);
  }

  /**
   * Returns the rate at which searches didn't return any results.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoResultsRateResponse getNoResultsRate(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getNoResultsRateAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Returns the rate at which searches didn't return any results.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoResultsRateResponse getNoResultsRate(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getNoResultsRate(index, startDate, endDate, tags, null);
  }

  /**
   * Returns the rate at which searches didn't return any results.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoResultsRateResponse getNoResultsRate(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getNoResultsRate(index, null, null, null, requestOptions);
  }

  /**
   * Returns the rate at which searches didn't return any results.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetNoResultsRateResponse getNoResultsRate(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getNoResultsRate(index, null, null, null, null);
  }

  /**
   * (asynchronously) Returns the rate at which searches didn&#39;t return any results.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getNoResultsRate`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/searches/noResultRate")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetNoResultsRateResponse>() {});
  }

  /**
   * (asynchronously) Returns the rate at which searches didn&#39;t return any results.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getNoResultsRateAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Returns the rate at which searches didn&#39;t return any results.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getNoResultsRateAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Returns the rate at which searches didn&#39;t return any results.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetNoResultsRateResponse> getNoResultsRateAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getNoResultsRateAsync(index, null, null, null, null);
  }

  /**
   * Returns the number of searches within a time range.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesCountResponse getSearchesCount(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSearchesCountAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Returns the number of searches within a time range.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesCountResponse getSearchesCount(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getSearchesCount(index, startDate, endDate, tags, null);
  }

  /**
   * Returns the number of searches within a time range.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesCountResponse getSearchesCount(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getSearchesCount(index, null, null, null, requestOptions);
  }

  /**
   * Returns the number of searches within a time range.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesCountResponse getSearchesCount(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getSearchesCount(index, null, null, null, null);
  }

  /**
   * (asynchronously) Returns the number of searches within a time range.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getSearchesCount`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/searches/count")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetSearchesCountResponse>() {});
  }

  /**
   * (asynchronously) Returns the number of searches within a time range.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getSearchesCountAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Returns the number of searches within a time range.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getSearchesCountAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Returns the number of searches within a time range.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesCountResponse> getSearchesCountAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getSearchesCountAsync(index, null, null, null, null);
  }

  /**
   * Return the most popular of the last 1,000 searches that didn't lead to any clicks.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoClicksResponse getSearchesNoClicks(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSearchesNoClicksAsync(index, startDate, endDate, limit, offset, tags, requestOptions));
  }

  /**
   * Return the most popular of the last 1,000 searches that didn't lead to any clicks.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoClicksResponse getSearchesNoClicks(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getSearchesNoClicks(index, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Return the most popular of the last 1,000 searches that didn't lead to any clicks.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoClicksResponse getSearchesNoClicks(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getSearchesNoClicks(index, null, null, null, null, null, requestOptions);
  }

  /**
   * Return the most popular of the last 1,000 searches that didn't lead to any clicks.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoClicksResponse getSearchesNoClicks(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getSearchesNoClicks(index, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Return the most popular of the last 1,000 searches that didn&#39;t lead to any
   * clicks.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getSearchesNoClicks`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/searches/noClicks")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetSearchesNoClicksResponse>() {});
  }

  /**
   * (asynchronously) Return the most popular of the last 1,000 searches that didn&#39;t lead to any
   * clicks.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getSearchesNoClicksAsync(index, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Return the most popular of the last 1,000 searches that didn&#39;t lead to any
   * clicks.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getSearchesNoClicksAsync(index, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Return the most popular of the last 1,000 searches that didn&#39;t lead to any
   * clicks.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoClicksResponse> getSearchesNoClicksAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getSearchesNoClicksAsync(index, null, null, null, null, null, null);
  }

  /**
   * Returns the most popular of the latest 1,000 searches that didn't return any results.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoResultsResponse getSearchesNoResults(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSearchesNoResultsAsync(index, startDate, endDate, limit, offset, tags, requestOptions));
  }

  /**
   * Returns the most popular of the latest 1,000 searches that didn't return any results.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoResultsResponse getSearchesNoResults(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getSearchesNoResults(index, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Returns the most popular of the latest 1,000 searches that didn't return any results.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoResultsResponse getSearchesNoResults(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getSearchesNoResults(index, null, null, null, null, null, requestOptions);
  }

  /**
   * Returns the most popular of the latest 1,000 searches that didn't return any results.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetSearchesNoResultsResponse getSearchesNoResults(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getSearchesNoResults(index, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Returns the most popular of the latest 1,000 searches that didn&#39;t return
   * any results.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getSearchesNoResults`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/searches/noResults")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetSearchesNoResultsResponse>() {});
  }

  /**
   * (asynchronously) Returns the most popular of the latest 1,000 searches that didn&#39;t return
   * any results.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getSearchesNoResultsAsync(index, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Returns the most popular of the latest 1,000 searches that didn&#39;t return
   * any results.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getSearchesNoResultsAsync(index, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Returns the most popular of the latest 1,000 searches that didn&#39;t return
   * any results.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetSearchesNoResultsResponse> getSearchesNoResultsAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getSearchesNoResultsAsync(index, null, null, null, null, null, null);
  }

  /**
   * Return the latest update time of the Analytics API for an index. If the index has been recently
   * created or no search has been performed yet, `updatedAt` will be `null`. > **Note**: The
   * Analytics API is updated every 5&nbsp;minutes.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetStatusResponse getStatus(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getStatusAsync(index, requestOptions));
  }

  /**
   * Return the latest update time of the Analytics API for an index. If the index has been recently
   * created or no search has been performed yet, `updatedAt` will be `null`. > **Note**: The
   * Analytics API is updated every 5&nbsp;minutes.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetStatusResponse getStatus(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getStatus(index, null);
  }

  /**
   * (asynchronously) Return the latest update time of the Analytics API for an index. If the index
   * has been recently created or no search has been performed yet, &#x60;updatedAt&#x60; will be
   * &#x60;null&#x60;. &gt; **Note**: The Analytics API is updated every 5&amp;nbsp;minutes.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetStatusResponse> getStatusAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getStatus`.");

    HttpRequest request = HttpRequest.builder().setPath("/2/status").setMethod("GET").addQueryParameter("index", index).build();
    return executeAsync(request, requestOptions, new TypeReference<GetStatusResponse>() {});
  }

  /**
   * (asynchronously) Return the latest update time of the Analytics API for an index. If the index
   * has been recently created or no search has been performed yet, &#x60;updatedAt&#x60; will be
   * &#x60;null&#x60;. &gt; **Note**: The Analytics API is updated every 5&amp;nbsp;minutes.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetStatusResponse> getStatusAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getStatusAsync(index, null);
  }

  /**
   * Returns top countries. Limited to the 1,000 most frequent ones.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopCountriesResponse getTopCountries(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTopCountriesAsync(index, startDate, endDate, limit, offset, tags, requestOptions));
  }

  /**
   * Returns top countries. Limited to the 1,000 most frequent ones.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopCountriesResponse getTopCountries(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopCountries(index, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Returns top countries. Limited to the 1,000 most frequent ones.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopCountriesResponse getTopCountries(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getTopCountries(index, null, null, null, null, null, requestOptions);
  }

  /**
   * Returns top countries. Limited to the 1,000 most frequent ones.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopCountriesResponse getTopCountries(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopCountries(index, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Returns top countries. Limited to the 1,000 most frequent ones.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopCountries`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/countries")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetTopCountriesResponse>() {});
  }

  /**
   * (asynchronously) Returns top countries. Limited to the 1,000 most frequent ones.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopCountriesAsync(index, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Returns top countries. Limited to the 1,000 most frequent ones.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getTopCountriesAsync(index, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Returns top countries. Limited to the 1,000 most frequent ones.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopCountriesResponse> getTopCountriesAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopCountriesAsync(index, null, null, null, null, null, null);
  }

  /**
   * Return the most popular [filterable
   * attributes](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/) in
   * the 1,000 most recently used filters.
   *
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterAttributesResponse getTopFilterAttributes(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTopFilterAttributesAsync(index, search, startDate, endDate, limit, offset, tags, requestOptions));
  }

  /**
   * Return the most popular [filterable
   * attributes](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/) in
   * the 1,000 most recently used filters.
   *
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterAttributesResponse getTopFilterAttributes(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterAttributes(index, search, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Return the most popular [filterable
   * attributes](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/) in
   * the 1,000 most recently used filters.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterAttributesResponse getTopFilterAttributes(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getTopFilterAttributes(index, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Return the most popular [filterable
   * attributes](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/) in
   * the 1,000 most recently used filters.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterAttributesResponse getTopFilterAttributes(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopFilterAttributes(index, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Return the most popular [filterable
   * attributes](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/) in
   * the 1,000 most recently used filters.
   *
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopFilterAttributes`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/filters")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("search", search)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetTopFilterAttributesResponse>() {});
  }

  /**
   * (asynchronously) Return the most popular [filterable
   * attributes](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/) in
   * the 1,000 most recently used filters.
   *
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterAttributesAsync(index, search, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Return the most popular [filterable
   * attributes](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/) in
   * the 1,000 most recently used filters.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(
    @Nonnull String index,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterAttributesAsync(index, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Return the most popular [filterable
   * attributes](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/) in
   * the 1,000 most recently used filters.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterAttributesResponse> getTopFilterAttributesAsync(@Nonnull String index)
    throws AlgoliaRuntimeException {
    return this.getTopFilterAttributesAsync(index, null, null, null, null, null, null, null);
  }

  /**
   * Returns the most popular filter values for an attribute in the 1,000 most recently used
   * filters.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterForAttributeResponse getTopFilterForAttribute(
    @Nonnull String attribute,
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(
      getTopFilterForAttributeAsync(attribute, index, search, startDate, endDate, limit, offset, tags, requestOptions)
    );
  }

  /**
   * Returns the most popular filter values for an attribute in the 1,000 most recently used
   * filters.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterForAttributeResponse getTopFilterForAttribute(
    @Nonnull String attribute,
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterForAttribute(attribute, index, search, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Returns the most popular filter values for an attribute in the 1,000 most recently used
   * filters.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterForAttributeResponse getTopFilterForAttribute(
    @Nonnull String attribute,
    @Nonnull String index,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterForAttribute(attribute, index, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Returns the most popular filter values for an attribute in the 1,000 most recently used
   * filters.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFilterForAttributeResponse getTopFilterForAttribute(@Nonnull String attribute, @Nonnull String index)
    throws AlgoliaRuntimeException {
    return this.getTopFilterForAttribute(attribute, index, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Returns the most popular filter values for an attribute in the 1,000 most
   * recently used filters.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(
    @Nonnull String attribute,
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(attribute, "Parameter `attribute` is required when calling `getTopFilterForAttribute`.");

    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopFilterForAttribute`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/filters/{attribute}", attribute)
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("search", search)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetTopFilterForAttributeResponse>() {});
  }

  /**
   * (asynchronously) Returns the most popular filter values for an attribute in the 1,000 most
   * recently used filters.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(
    @Nonnull String attribute,
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterForAttributeAsync(attribute, index, search, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Returns the most popular filter values for an attribute in the 1,000 most
   * recently used filters.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(
    @Nonnull String attribute,
    @Nonnull String index,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterForAttributeAsync(attribute, index, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Returns the most popular filter values for an attribute in the 1,000 most
   * recently used filters.
   *
   * @param attribute Attribute name. (required)
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFilterForAttributeResponse> getTopFilterForAttributeAsync(
    @Nonnull String attribute,
    @Nonnull String index
  ) throws AlgoliaRuntimeException {
    return this.getTopFilterForAttributeAsync(attribute, index, null, null, null, null, null, null, null);
  }

  /**
   * Returns top filters for filter-enabled searches that don't return results. Limited to the 1,000
   * most recently used filters.
   *
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFiltersNoResultsResponse getTopFiltersNoResults(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTopFiltersNoResultsAsync(index, search, startDate, endDate, limit, offset, tags, requestOptions));
  }

  /**
   * Returns top filters for filter-enabled searches that don't return results. Limited to the 1,000
   * most recently used filters.
   *
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFiltersNoResultsResponse getTopFiltersNoResults(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopFiltersNoResults(index, search, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Returns top filters for filter-enabled searches that don't return results. Limited to the 1,000
   * most recently used filters.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFiltersNoResultsResponse getTopFiltersNoResults(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getTopFiltersNoResults(index, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Returns top filters for filter-enabled searches that don't return results. Limited to the 1,000
   * most recently used filters.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopFiltersNoResultsResponse getTopFiltersNoResults(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopFiltersNoResults(index, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Returns top filters for filter-enabled searches that don&#39;t return results.
   * Limited to the 1,000 most recently used filters.
   *
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopFiltersNoResults`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/filters/noResults")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("search", search)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetTopFiltersNoResultsResponse>() {});
  }

  /**
   * (asynchronously) Returns top filters for filter-enabled searches that don&#39;t return results.
   * Limited to the 1,000 most recently used filters.
   *
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(
    @Nonnull String index,
    String search,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopFiltersNoResultsAsync(index, search, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Returns top filters for filter-enabled searches that don&#39;t return results.
   * Limited to the 1,000 most recently used filters.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(
    @Nonnull String index,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getTopFiltersNoResultsAsync(index, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Returns top filters for filter-enabled searches that don&#39;t return results.
   * Limited to the 1,000 most recently used filters.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopFiltersNoResultsResponse> getTopFiltersNoResultsAsync(@Nonnull String index)
    throws AlgoliaRuntimeException {
    return this.getTopFiltersNoResultsAsync(index, null, null, null, null, null, null, null);
  }

  /**
   * Return the most popular clicked results in the last 1,000 searches.
   *
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param clickAnalytics Whether to include [click and
   *     conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a
   *     search. (optional, default to false)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopHitsResponse getTopHits(
    @Nonnull String index,
    String search,
    Boolean clickAnalytics,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTopHitsAsync(index, search, clickAnalytics, startDate, endDate, limit, offset, tags, requestOptions));
  }

  /**
   * Return the most popular clicked results in the last 1,000 searches.
   *
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param clickAnalytics Whether to include [click and
   *     conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a
   *     search. (optional, default to false)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopHitsResponse getTopHits(
    @Nonnull String index,
    String search,
    Boolean clickAnalytics,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopHits(index, search, clickAnalytics, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * Return the most popular clicked results in the last 1,000 searches.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopHitsResponse getTopHits(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getTopHits(index, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Return the most popular clicked results in the last 1,000 searches.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopHitsResponse getTopHits(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopHits(index, null, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Return the most popular clicked results in the last 1,000 searches.
   *
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param clickAnalytics Whether to include [click and
   *     conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a
   *     search. (optional, default to false)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(
    @Nonnull String index,
    String search,
    Boolean clickAnalytics,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopHits`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/hits")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("search", search)
      .addQueryParameter("clickAnalytics", clickAnalytics)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetTopHitsResponse>() {});
  }

  /**
   * (asynchronously) Return the most popular clicked results in the last 1,000 searches.
   *
   * @param index Index name to target. (required)
   * @param search User query. (optional)
   * @param clickAnalytics Whether to include [click and
   *     conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a
   *     search. (optional, default to false)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(
    @Nonnull String index,
    String search,
    Boolean clickAnalytics,
    String startDate,
    String endDate,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopHitsAsync(index, search, clickAnalytics, startDate, endDate, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Return the most popular clicked results in the last 1,000 searches.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getTopHitsAsync(index, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Return the most popular clicked results in the last 1,000 searches.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopHitsResponse> getTopHitsAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopHitsAsync(index, null, null, null, null, null, null, null, null);
  }

  /**
   * Returns the most popular of the latest 1,000 searches. For each search, also returns the number
   * of hits.
   *
   * @param index Index name to target. (required)
   * @param clickAnalytics Whether to include [click and
   *     conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a
   *     search. (optional, default to false)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param orderBy Reorder the results. (optional, default to searchCount)
   * @param direction Sorting direction of the results: ascending or descending. (optional, default
   *     to asc)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopSearchesResponse getTopSearches(
    @Nonnull String index,
    Boolean clickAnalytics,
    String startDate,
    String endDate,
    OrderBy orderBy,
    Direction direction,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(
      getTopSearchesAsync(index, clickAnalytics, startDate, endDate, orderBy, direction, limit, offset, tags, requestOptions)
    );
  }

  /**
   * Returns the most popular of the latest 1,000 searches. For each search, also returns the number
   * of hits.
   *
   * @param index Index name to target. (required)
   * @param clickAnalytics Whether to include [click and
   *     conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a
   *     search. (optional, default to false)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param orderBy Reorder the results. (optional, default to searchCount)
   * @param direction Sorting direction of the results: ascending or descending. (optional, default
   *     to asc)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopSearchesResponse getTopSearches(
    @Nonnull String index,
    Boolean clickAnalytics,
    String startDate,
    String endDate,
    OrderBy orderBy,
    Direction direction,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopSearches(index, clickAnalytics, startDate, endDate, orderBy, direction, limit, offset, tags, null);
  }

  /**
   * Returns the most popular of the latest 1,000 searches. For each search, also returns the number
   * of hits.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopSearchesResponse getTopSearches(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getTopSearches(index, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Returns the most popular of the latest 1,000 searches. For each search, also returns the number
   * of hits.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetTopSearchesResponse getTopSearches(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopSearches(index, null, null, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Returns the most popular of the latest 1,000 searches. For each search, also
   * returns the number of hits.
   *
   * @param index Index name to target. (required)
   * @param clickAnalytics Whether to include [click and
   *     conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a
   *     search. (optional, default to false)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param orderBy Reorder the results. (optional, default to searchCount)
   * @param direction Sorting direction of the results: ascending or descending. (optional, default
   *     to asc)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(
    @Nonnull String index,
    Boolean clickAnalytics,
    String startDate,
    String endDate,
    OrderBy orderBy,
    Direction direction,
    Integer limit,
    Integer offset,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getTopSearches`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/searches")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("clickAnalytics", clickAnalytics)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("orderBy", orderBy)
      .addQueryParameter("direction", direction)
      .addQueryParameter("limit", limit)
      .addQueryParameter("offset", offset)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetTopSearchesResponse>() {});
  }

  /**
   * (asynchronously) Returns the most popular of the latest 1,000 searches. For each search, also
   * returns the number of hits.
   *
   * @param index Index name to target. (required)
   * @param clickAnalytics Whether to include [click and
   *     conversion](https://www.algolia.com/doc/guides/sending-events/getting-started/) rates for a
   *     search. (optional, default to false)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param orderBy Reorder the results. (optional, default to searchCount)
   * @param direction Sorting direction of the results: ascending or descending. (optional, default
   *     to asc)
   * @param limit Number of records to return (page size). (optional, default to 10)
   * @param offset Position of the starting record. Used for paging. 0 is the first record.
   *     (optional, default to 0)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(
    @Nonnull String index,
    Boolean clickAnalytics,
    String startDate,
    String endDate,
    OrderBy orderBy,
    Direction direction,
    Integer limit,
    Integer offset,
    String tags
  ) throws AlgoliaRuntimeException {
    return this.getTopSearchesAsync(index, clickAnalytics, startDate, endDate, orderBy, direction, limit, offset, tags, null);
  }

  /**
   * (asynchronously) Returns the most popular of the latest 1,000 searches. For each search, also
   * returns the number of hits.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getTopSearchesAsync(index, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Returns the most popular of the latest 1,000 searches. For each search, also
   * returns the number of hits.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetTopSearchesResponse> getTopSearchesAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getTopSearchesAsync(index, null, null, null, null, null, null, null, null, null);
  }

  /**
   * Return the count of unique users.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetUsersCountResponse getUsersCount(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getUsersCountAsync(index, startDate, endDate, tags, requestOptions));
  }

  /**
   * Return the count of unique users.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetUsersCountResponse getUsersCount(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getUsersCount(index, startDate, endDate, tags, null);
  }

  /**
   * Return the count of unique users.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetUsersCountResponse getUsersCount(@Nonnull String index, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getUsersCount(index, null, null, null, requestOptions);
  }

  /**
   * Return the count of unique users.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetUsersCountResponse getUsersCount(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getUsersCount(index, null, null, null, null);
  }

  /**
   * (asynchronously) Return the count of unique users.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(
    @Nonnull String index,
    String startDate,
    String endDate,
    String tags,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(index, "Parameter `index` is required when calling `getUsersCount`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/2/users/count")
      .setMethod("GET")
      .addQueryParameter("index", index)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("tags", tags)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetUsersCountResponse>() {});
  }

  /**
   * (asynchronously) Return the count of unique users.
   *
   * @param index Index name to target. (required)
   * @param startDate Start date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param endDate End date (a string in the format `YYYY-MM-DD`) of the period to analyze.
   *     (optional)
   * @param tags Filter analytics on the
   *     [`analyticsTags`](https://www.algolia.com/doc/api-reference/api-parameters/analyticsTags/)
   *     set at search time. Multiple tags can be combined with the operators OR and AND. If a tag
   *     contains characters like spaces or parentheses, it must be URL-encoded. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(@Nonnull String index, String startDate, String endDate, String tags)
    throws AlgoliaRuntimeException {
    return this.getUsersCountAsync(index, startDate, endDate, tags, null);
  }

  /**
   * (asynchronously) Return the count of unique users.
   *
   * @param index Index name to target. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(@Nonnull String index, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getUsersCountAsync(index, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Return the count of unique users.
   *
   * @param index Index name to target. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetUsersCountResponse> getUsersCountAsync(@Nonnull String index) throws AlgoliaRuntimeException {
    return this.getUsersCountAsync(index, null, null, null, null);
  }
}
