// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.search;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/** SearchResponse */
@JsonDeserialize(as = SearchResponse.class)
public class SearchResponse<T> implements SearchResult {

  @JsonProperty("abTestID")
  private Integer abTestID;

  @JsonProperty("abTestVariantID")
  private Integer abTestVariantID;

  @JsonProperty("aroundLatLng")
  private String aroundLatLng;

  @JsonProperty("automaticRadius")
  private String automaticRadius;

  @JsonProperty("exhaustive")
  private Exhaustive exhaustive;

  @JsonProperty("exhaustiveFacetsCount")
  private Boolean exhaustiveFacetsCount;

  @JsonProperty("exhaustiveNbHits")
  private Boolean exhaustiveNbHits;

  @JsonProperty("exhaustiveTypo")
  private Boolean exhaustiveTypo;

  @JsonProperty("facets")
  private Map<String, Map<String, Integer>> facets;

  @JsonProperty("facets_stats")
  private Map<String, FacetsStats> facetsStats;

  @JsonProperty("hitsPerPage")
  private Integer hitsPerPage;

  @JsonProperty("index")
  private String index;

  @JsonProperty("indexUsed")
  private String indexUsed;

  @JsonProperty("message")
  private String message;

  @JsonProperty("nbHits")
  private Integer nbHits;

  @JsonProperty("nbPages")
  private Integer nbPages;

  @JsonProperty("nbSortedHits")
  private Integer nbSortedHits;

  @JsonProperty("page")
  private Integer page;

  @JsonProperty("parsedQuery")
  private String parsedQuery;

  @JsonProperty("processingTimeMS")
  private Integer processingTimeMS;

  @JsonProperty("processingTimingsMS")
  private Object processingTimingsMS;

  @JsonProperty("queryAfterRemoval")
  private String queryAfterRemoval;

  @JsonProperty("redirect")
  private Redirect redirect;

  @JsonProperty("renderingContent")
  private RenderingContent renderingContent;

  @JsonProperty("serverTimeMS")
  private Integer serverTimeMS;

  @JsonProperty("serverUsed")
  private String serverUsed;

  @JsonProperty("userData")
  private Object userData;

  @JsonProperty("hits")
  private List<T> hits = new ArrayList<>();

  @JsonProperty("query")
  private String query;

  @JsonProperty("params")
  private String params;

  private Map<String, Object> additionalProperties = new HashMap<>();

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  @JsonAnySetter
  public SearchResponse setAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
    return this;
  }

  public SearchResponse setAbTestID(Integer abTestID) {
    this.abTestID = abTestID;
    return this;
  }

  /**
   * A/B test ID. This is only included in the response for indices that are part of an A/B test.
   */
  @javax.annotation.Nullable
  public Integer getAbTestID() {
    return abTestID;
  }

  public SearchResponse setAbTestVariantID(Integer abTestVariantID) {
    this.abTestVariantID = abTestVariantID;
    return this;
  }

  /**
   * Variant ID. This is only included in the response for indices that are part of an A/B test.
   * minimum: 1
   */
  @javax.annotation.Nullable
  public Integer getAbTestVariantID() {
    return abTestVariantID;
  }

  public SearchResponse setAroundLatLng(String aroundLatLng) {
    this.aroundLatLng = aroundLatLng;
    return this;
  }

  /** Computed geographical location. */
  @javax.annotation.Nullable
  public String getAroundLatLng() {
    return aroundLatLng;
  }

  public SearchResponse setAutomaticRadius(String automaticRadius) {
    this.automaticRadius = automaticRadius;
    return this;
  }

  /** Automatically-computed radius. */
  @javax.annotation.Nullable
  public String getAutomaticRadius() {
    return automaticRadius;
  }

  public SearchResponse setExhaustive(Exhaustive exhaustive) {
    this.exhaustive = exhaustive;
    return this;
  }

  /** Get exhaustive */
  @javax.annotation.Nullable
  public Exhaustive getExhaustive() {
    return exhaustive;
  }

  public SearchResponse setExhaustiveFacetsCount(Boolean exhaustiveFacetsCount) {
    this.exhaustiveFacetsCount = exhaustiveFacetsCount;
    return this;
  }

  /**
   * See the `facetsCount` field of the `exhaustive` object in the response.
   *
   * @deprecated
   */
  @Deprecated
  @javax.annotation.Nullable
  public Boolean getExhaustiveFacetsCount() {
    return exhaustiveFacetsCount;
  }

  public SearchResponse setExhaustiveNbHits(Boolean exhaustiveNbHits) {
    this.exhaustiveNbHits = exhaustiveNbHits;
    return this;
  }

  /**
   * See the `nbHits` field of the `exhaustive` object in the response.
   *
   * @deprecated
   */
  @Deprecated
  @javax.annotation.Nullable
  public Boolean getExhaustiveNbHits() {
    return exhaustiveNbHits;
  }

  public SearchResponse setExhaustiveTypo(Boolean exhaustiveTypo) {
    this.exhaustiveTypo = exhaustiveTypo;
    return this;
  }

  /**
   * See the `typo` field of the `exhaustive` object in the response.
   *
   * @deprecated
   */
  @Deprecated
  @javax.annotation.Nullable
  public Boolean getExhaustiveTypo() {
    return exhaustiveTypo;
  }

  public SearchResponse setFacets(Map<String, Map<String, Integer>> facets) {
    this.facets = facets;
    return this;
  }

  public SearchResponse putFacets(String key, Map<String, Integer> facetsItem) {
    if (this.facets == null) {
      this.facets = new HashMap<>();
    }
    this.facets.put(key, facetsItem);
    return this;
  }

  /** Mapping of each facet name to the corresponding facet counts. */
  @javax.annotation.Nullable
  public Map<String, Map<String, Integer>> getFacets() {
    return facets;
  }

  public SearchResponse setFacetsStats(Map<String, FacetsStats> facetsStats) {
    this.facetsStats = facetsStats;
    return this;
  }

  public SearchResponse putFacetsStats(String key, FacetsStats facetsStatsItem) {
    if (this.facetsStats == null) {
      this.facetsStats = new HashMap<>();
    }
    this.facetsStats.put(key, facetsStatsItem);
    return this;
  }

  /** Statistics for numerical facets. */
  @javax.annotation.Nullable
  public Map<String, FacetsStats> getFacetsStats() {
    return facetsStats;
  }

  public SearchResponse setHitsPerPage(Integer hitsPerPage) {
    this.hitsPerPage = hitsPerPage;
    return this;
  }

  /** Number of hits per page. minimum: 1 maximum: 1000 */
  @javax.annotation.Nonnull
  public Integer getHitsPerPage() {
    return hitsPerPage;
  }

  public SearchResponse setIndex(String index) {
    this.index = index;
    return this;
  }

  /** Index name used for the query. */
  @javax.annotation.Nullable
  public String getIndex() {
    return index;
  }

  public SearchResponse setIndexUsed(String indexUsed) {
    this.indexUsed = indexUsed;
    return this;
  }

  /**
   * Index name used for the query. During A/B testing, the targeted index isn't always the index
   * used by the query.
   */
  @javax.annotation.Nullable
  public String getIndexUsed() {
    return indexUsed;
  }

  public SearchResponse setMessage(String message) {
    this.message = message;
    return this;
  }

  /** Warnings about the query. */
  @javax.annotation.Nullable
  public String getMessage() {
    return message;
  }

  public SearchResponse setNbHits(Integer nbHits) {
    this.nbHits = nbHits;
    return this;
  }

  /** Number of hits the search query matched. */
  @javax.annotation.Nonnull
  public Integer getNbHits() {
    return nbHits;
  }

  public SearchResponse setNbPages(Integer nbPages) {
    this.nbPages = nbPages;
    return this;
  }

  /** Number of pages of results for the current query. */
  @javax.annotation.Nonnull
  public Integer getNbPages() {
    return nbPages;
  }

  public SearchResponse setNbSortedHits(Integer nbSortedHits) {
    this.nbSortedHits = nbSortedHits;
    return this;
  }

  /** Number of hits selected and sorted by the relevant sort algorithm. */
  @javax.annotation.Nullable
  public Integer getNbSortedHits() {
    return nbSortedHits;
  }

  public SearchResponse setPage(Integer page) {
    this.page = page;
    return this;
  }

  /** Page to retrieve (the first page is `0`, not `1`). */
  @javax.annotation.Nonnull
  public Integer getPage() {
    return page;
  }

  public SearchResponse setParsedQuery(String parsedQuery) {
    this.parsedQuery = parsedQuery;
    return this;
  }

  /**
   * Post-[normalization](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/#what-does-normalization-mean)
   * query string that will be searched.
   */
  @javax.annotation.Nullable
  public String getParsedQuery() {
    return parsedQuery;
  }

  public SearchResponse setProcessingTimeMS(Integer processingTimeMS) {
    this.processingTimeMS = processingTimeMS;
    return this;
  }

  /** Time the server took to process the request, in milliseconds. */
  @javax.annotation.Nonnull
  public Integer getProcessingTimeMS() {
    return processingTimeMS;
  }

  public SearchResponse setProcessingTimingsMS(Object processingTimingsMS) {
    this.processingTimingsMS = processingTimingsMS;
    return this;
  }

  /**
   * Experimental. List of processing steps and their times, in milliseconds. You can use this list
   * to investigate performance issues.
   */
  @javax.annotation.Nullable
  public Object getProcessingTimingsMS() {
    return processingTimingsMS;
  }

  public SearchResponse setQueryAfterRemoval(String queryAfterRemoval) {
    this.queryAfterRemoval = queryAfterRemoval;
    return this;
  }

  /**
   * Markup text indicating which parts of the original query have been removed to retrieve a
   * non-empty result set.
   */
  @javax.annotation.Nullable
  public String getQueryAfterRemoval() {
    return queryAfterRemoval;
  }

  public SearchResponse setRedirect(Redirect redirect) {
    this.redirect = redirect;
    return this;
  }

  /** Get redirect */
  @javax.annotation.Nullable
  public Redirect getRedirect() {
    return redirect;
  }

  public SearchResponse setRenderingContent(RenderingContent renderingContent) {
    this.renderingContent = renderingContent;
    return this;
  }

  /** Get renderingContent */
  @javax.annotation.Nullable
  public RenderingContent getRenderingContent() {
    return renderingContent;
  }

  public SearchResponse setServerTimeMS(Integer serverTimeMS) {
    this.serverTimeMS = serverTimeMS;
    return this;
  }

  /** Time the server took to process the request, in milliseconds. */
  @javax.annotation.Nullable
  public Integer getServerTimeMS() {
    return serverTimeMS;
  }

  public SearchResponse setServerUsed(String serverUsed) {
    this.serverUsed = serverUsed;
    return this;
  }

  /** Host name of the server that processed the request. */
  @javax.annotation.Nullable
  public String getServerUsed() {
    return serverUsed;
  }

  public SearchResponse setUserData(Object userData) {
    this.userData = userData;
    return this;
  }

  /** Lets you store custom data in your indices. */
  @javax.annotation.Nullable
  public Object getUserData() {
    return userData;
  }

  public SearchResponse setHits(List<T> hits) {
    this.hits = hits;
    return this;
  }

  public SearchResponse addHits(T hitsItem) {
    this.hits.add(hitsItem);
    return this;
  }

  /** Get hits */
  @javax.annotation.Nonnull
  public List<T> getHits() {
    return hits;
  }

  public SearchResponse setQuery(String query) {
    this.query = query;
    return this;
  }

  /** Text to search for in an index. */
  @javax.annotation.Nonnull
  public String getQuery() {
    return query;
  }

  public SearchResponse setParams(String params) {
    this.params = params;
    return this;
  }

  /** URL-encoded string of all search parameters. */
  @javax.annotation.Nonnull
  public String getParams() {
    return params;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchResponse searchResponse = (SearchResponse) o;
    return (
      Objects.equals(this.abTestID, searchResponse.abTestID) &&
      Objects.equals(this.abTestVariantID, searchResponse.abTestVariantID) &&
      Objects.equals(this.aroundLatLng, searchResponse.aroundLatLng) &&
      Objects.equals(this.automaticRadius, searchResponse.automaticRadius) &&
      Objects.equals(this.exhaustive, searchResponse.exhaustive) &&
      Objects.equals(this.exhaustiveFacetsCount, searchResponse.exhaustiveFacetsCount) &&
      Objects.equals(this.exhaustiveNbHits, searchResponse.exhaustiveNbHits) &&
      Objects.equals(this.exhaustiveTypo, searchResponse.exhaustiveTypo) &&
      Objects.equals(this.facets, searchResponse.facets) &&
      Objects.equals(this.facetsStats, searchResponse.facetsStats) &&
      Objects.equals(this.hitsPerPage, searchResponse.hitsPerPage) &&
      Objects.equals(this.index, searchResponse.index) &&
      Objects.equals(this.indexUsed, searchResponse.indexUsed) &&
      Objects.equals(this.message, searchResponse.message) &&
      Objects.equals(this.nbHits, searchResponse.nbHits) &&
      Objects.equals(this.nbPages, searchResponse.nbPages) &&
      Objects.equals(this.nbSortedHits, searchResponse.nbSortedHits) &&
      Objects.equals(this.page, searchResponse.page) &&
      Objects.equals(this.parsedQuery, searchResponse.parsedQuery) &&
      Objects.equals(this.processingTimeMS, searchResponse.processingTimeMS) &&
      Objects.equals(this.processingTimingsMS, searchResponse.processingTimingsMS) &&
      Objects.equals(this.queryAfterRemoval, searchResponse.queryAfterRemoval) &&
      Objects.equals(this.redirect, searchResponse.redirect) &&
      Objects.equals(this.renderingContent, searchResponse.renderingContent) &&
      Objects.equals(this.serverTimeMS, searchResponse.serverTimeMS) &&
      Objects.equals(this.serverUsed, searchResponse.serverUsed) &&
      Objects.equals(this.userData, searchResponse.userData) &&
      Objects.equals(this.hits, searchResponse.hits) &&
      Objects.equals(this.query, searchResponse.query) &&
      Objects.equals(this.params, searchResponse.params) &&
      super.equals(o)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(
      abTestID,
      abTestVariantID,
      aroundLatLng,
      automaticRadius,
      exhaustive,
      exhaustiveFacetsCount,
      exhaustiveNbHits,
      exhaustiveTypo,
      facets,
      facetsStats,
      hitsPerPage,
      index,
      indexUsed,
      message,
      nbHits,
      nbPages,
      nbSortedHits,
      page,
      parsedQuery,
      processingTimeMS,
      processingTimingsMS,
      queryAfterRemoval,
      redirect,
      renderingContent,
      serverTimeMS,
      serverUsed,
      userData,
      hits,
      query,
      params,
      super.hashCode()
    );
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchResponse {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    abTestID: ").append(toIndentedString(abTestID)).append("\n");
    sb.append("    abTestVariantID: ").append(toIndentedString(abTestVariantID)).append("\n");
    sb.append("    aroundLatLng: ").append(toIndentedString(aroundLatLng)).append("\n");
    sb.append("    automaticRadius: ").append(toIndentedString(automaticRadius)).append("\n");
    sb.append("    exhaustive: ").append(toIndentedString(exhaustive)).append("\n");
    sb.append("    exhaustiveFacetsCount: ").append(toIndentedString(exhaustiveFacetsCount)).append("\n");
    sb.append("    exhaustiveNbHits: ").append(toIndentedString(exhaustiveNbHits)).append("\n");
    sb.append("    exhaustiveTypo: ").append(toIndentedString(exhaustiveTypo)).append("\n");
    sb.append("    facets: ").append(toIndentedString(facets)).append("\n");
    sb.append("    facetsStats: ").append(toIndentedString(facetsStats)).append("\n");
    sb.append("    hitsPerPage: ").append(toIndentedString(hitsPerPage)).append("\n");
    sb.append("    index: ").append(toIndentedString(index)).append("\n");
    sb.append("    indexUsed: ").append(toIndentedString(indexUsed)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    nbHits: ").append(toIndentedString(nbHits)).append("\n");
    sb.append("    nbPages: ").append(toIndentedString(nbPages)).append("\n");
    sb.append("    nbSortedHits: ").append(toIndentedString(nbSortedHits)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    parsedQuery: ").append(toIndentedString(parsedQuery)).append("\n");
    sb.append("    processingTimeMS: ").append(toIndentedString(processingTimeMS)).append("\n");
    sb.append("    processingTimingsMS: ").append(toIndentedString(processingTimingsMS)).append("\n");
    sb.append("    queryAfterRemoval: ").append(toIndentedString(queryAfterRemoval)).append("\n");
    sb.append("    redirect: ").append(toIndentedString(redirect)).append("\n");
    sb.append("    renderingContent: ").append(toIndentedString(renderingContent)).append("\n");
    sb.append("    serverTimeMS: ").append(toIndentedString(serverTimeMS)).append("\n");
    sb.append("    serverUsed: ").append(toIndentedString(serverUsed)).append("\n");
    sb.append("    userData: ").append(toIndentedString(userData)).append("\n");
    sb.append("    hits: ").append(toIndentedString(hits)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    params: ").append(toIndentedString(params)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
