/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.querysuggestions.BaseResponse;
import com.algolia.model.querysuggestions.GetConfigStatus200Response;
import com.algolia.model.querysuggestions.GetLogFile200Response;
import com.algolia.model.querysuggestions.QuerySuggestionsConfiguration;
import com.algolia.model.querysuggestions.QuerySuggestionsConfigurationResponse;
import com.algolia.model.querysuggestions.QuerySuggestionsConfigurationWithIndex;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class QuerySuggestionsClient
extends ApiClient {
    private static final String[] allowedRegions = new String[]{"eu", "us"};

    public QuerySuggestionsClient(String appId, String apiKey, String region) {
        this(appId, apiKey, region, null);
    }

    public QuerySuggestionsClient(String appId, String apiKey, String region, ClientOptions options) {
        super(appId, apiKey, "QuerySuggestions", options, QuerySuggestionsClient.getDefaultHosts(region));
    }

    private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
        ArrayList<Host> hosts = new ArrayList<Host>();
        boolean found = false;
        if (region != null) {
            for (String allowed : allowedRegions) {
                if (!allowed.equals(region)) continue;
                found = true;
                break;
            }
        }
        if (region == null || !found) {
            throw new AlgoliaRuntimeException("`region` is required and must be one of the following: eu, us");
        }
        String url = "query-suggestions.{region}.algolia.com".replace("{region}", region);
        hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
        return hosts;
    }

    public BaseResponse createConfig(@Nonnull QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.createConfigAsync(querySuggestionsConfigurationWithIndex, requestOptions));
    }

    public BaseResponse createConfig(@Nonnull QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex) throws AlgoliaRuntimeException {
        return this.createConfig(querySuggestionsConfigurationWithIndex, null);
    }

    public CompletableFuture<BaseResponse> createConfigAsync(@Nonnull QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(querySuggestionsConfigurationWithIndex, "Parameter `querySuggestionsConfigurationWithIndex` is required when calling `createConfig`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/configs").setMethod("POST").setBody(querySuggestionsConfigurationWithIndex).build();
        return this.executeAsync(request, requestOptions, new TypeReference<BaseResponse>(){});
    }

    public CompletableFuture<BaseResponse> createConfigAsync(@Nonnull QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex) throws AlgoliaRuntimeException {
        return this.createConfigAsync(querySuggestionsConfigurationWithIndex, null);
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customDeleteAsync(path, parameters, requestOptions));
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDelete(path, parameters, null);
    }

    public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, requestOptions);
    }

    public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, null);
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customGetAsync(path, parameters, requestOptions));
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGet(path, parameters, null);
    }

    public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGet(path, null, requestOptions);
    }

    public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGet(path, null, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, null);
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPostAsync(path, parameters, body, requestOptions));
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPost(path, parameters, body, null);
    }

    public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, requestOptions);
    }

    public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, null);
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPutAsync(path, parameters, body, requestOptions));
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPut(path, parameters, body, null);
    }

    public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, requestOptions);
    }

    public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, null);
    }

    public BaseResponse deleteConfig(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteConfigAsync(indexName, requestOptions));
    }

    public BaseResponse deleteConfig(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.deleteConfig(indexName, null);
    }

    public CompletableFuture<BaseResponse> deleteConfigAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteConfig`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}", indexName).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<BaseResponse>(){});
    }

    public CompletableFuture<BaseResponse> deleteConfigAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.deleteConfigAsync(indexName, null);
    }

    public List<QuerySuggestionsConfigurationResponse> getAllConfigs(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAllConfigsAsync(requestOptions));
    }

    public List<QuerySuggestionsConfigurationResponse> getAllConfigs() throws AlgoliaRuntimeException {
        return this.getAllConfigs(null);
    }

    public CompletableFuture<List<QuerySuggestionsConfigurationResponse>> getAllConfigsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/configs").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<List<QuerySuggestionsConfigurationResponse>>(){});
    }

    public CompletableFuture<List<QuerySuggestionsConfigurationResponse>> getAllConfigsAsync() throws AlgoliaRuntimeException {
        return this.getAllConfigsAsync(null);
    }

    public QuerySuggestionsConfigurationResponse getConfig(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getConfigAsync(indexName, requestOptions));
    }

    public QuerySuggestionsConfigurationResponse getConfig(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getConfig(indexName, null);
    }

    public CompletableFuture<QuerySuggestionsConfigurationResponse> getConfigAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getConfig`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}", indexName).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<QuerySuggestionsConfigurationResponse>(){});
    }

    public CompletableFuture<QuerySuggestionsConfigurationResponse> getConfigAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getConfigAsync(indexName, null);
    }

    public GetConfigStatus200Response getConfigStatus(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getConfigStatusAsync(indexName, requestOptions));
    }

    public GetConfigStatus200Response getConfigStatus(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getConfigStatus(indexName, null);
    }

    public CompletableFuture<GetConfigStatus200Response> getConfigStatusAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getConfigStatus`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}/status", indexName).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetConfigStatus200Response>(){});
    }

    public CompletableFuture<GetConfigStatus200Response> getConfigStatusAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getConfigStatusAsync(indexName, null);
    }

    public GetLogFile200Response getLogFile(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getLogFileAsync(indexName, requestOptions));
    }

    public GetLogFile200Response getLogFile(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getLogFile(indexName, null);
    }

    public CompletableFuture<GetLogFile200Response> getLogFileAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getLogFile`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/logs/{indexName}", indexName).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetLogFile200Response>(){});
    }

    public CompletableFuture<GetLogFile200Response> getLogFileAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getLogFileAsync(indexName, null);
    }

    public BaseResponse updateConfig(@Nonnull String indexName, @Nonnull QuerySuggestionsConfiguration querySuggestionsConfiguration, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.updateConfigAsync(indexName, querySuggestionsConfiguration, requestOptions));
    }

    public BaseResponse updateConfig(@Nonnull String indexName, @Nonnull QuerySuggestionsConfiguration querySuggestionsConfiguration) throws AlgoliaRuntimeException {
        return this.updateConfig(indexName, querySuggestionsConfiguration, null);
    }

    public CompletableFuture<BaseResponse> updateConfigAsync(@Nonnull String indexName, @Nonnull QuerySuggestionsConfiguration querySuggestionsConfiguration, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `updateConfig`.");
        Parameters.requireNonNull(querySuggestionsConfiguration, "Parameter `querySuggestionsConfiguration` is required when calling `updateConfig`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}", indexName).setMethod("PUT").setBody(querySuggestionsConfiguration).build();
        return this.executeAsync(request, requestOptions, new TypeReference<BaseResponse>(){});
    }

    public CompletableFuture<BaseResponse> updateConfigAsync(@Nonnull String indexName, @Nonnull QuerySuggestionsConfiguration querySuggestionsConfiguration) throws AlgoliaRuntimeException {
        return this.updateConfigAsync(indexName, querySuggestionsConfiguration, null);
    }
}

