/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.config;

import com.algolia.config.CallType;
import java.util.Set;
import javax.annotation.Nonnull;

public final class Host {
    private final String url;
    private final Set<CallType> callTypes;
    private final String scheme;

    public Host(@Nonnull String url, @Nonnull Set<CallType> callType) {
        this(url, callType, "https");
    }

    public Host(String url, Set<CallType> callType, String scheme) {
        this.url = url;
        this.callTypes = callType;
        this.scheme = scheme;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public Set<CallType> getCallTypes() {
        return this.callTypes;
    }

    @Nonnull
    public String getScheme() {
        return this.scheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Host host = (Host)o;
        if (!this.url.equals(host.url)) {
            return false;
        }
        if (!this.callTypes.equals(host.callTypes)) {
            return false;
        }
        return this.scheme.equals(host.scheme);
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + this.callTypes.hashCode();
        result = 31 * result + this.scheme.hashCode();
        return result;
    }
}

