/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.config;

import com.algolia.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HttpRequest {
    private final String method;
    private final String path;
    private final boolean read;
    private final Map<String, String> headers;
    private final Map<String, String> queryParameters;
    private final Object body;

    public static Builder builder() {
        return new Builder();
    }

    public HttpRequest(String method, String path, boolean isRead, Map<String, String> headers, Map<String, String> queryParameters, Object body) {
        this.method = method;
        this.path = path;
        this.read = isRead;
        this.headers = headers;
        this.queryParameters = queryParameters;
        this.body = body;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isRead() {
        return this.read;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public Object getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        return this.read == that.read && Objects.equals(this.method, that.method) && Objects.equals(this.path, that.path) && Objects.equals(this.headers, that.headers) && Objects.equals(this.queryParameters, that.queryParameters) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.path, this.read, this.headers, this.queryParameters, this.body);
    }

    public String toString() {
        return "HttpRequest{method='" + this.method + '\'' + ", path=" + this.path + ", isRead=" + this.read + ", headers=" + this.headers + ", queryParameters=" + this.queryParameters + ", body=" + this.body + '}';
    }

    public static class Builder {
        private String method;
        private String path;
        private boolean read;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, String> queryParameters = new HashMap<String, String>();
        private Object body;

        public Builder() {
        }

        public Builder(HttpRequest request) {
            this.method = request.method;
            this.path = request.path;
            this.read = request.read;
            this.body = request.body;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder addQueryParameter(String key, Object value) {
            if (value == null) {
                return this;
            }
            this.queryParameters.put(key, StringUtils.paramToString(value));
            return this;
        }

        public Builder addQueryParameters(Map<String, Object> queryParameters) {
            if (queryParameters == null) {
                return this;
            }
            queryParameters.forEach(this::addQueryParameter);
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setPath(String template, Object ... values) {
            this.path = StringUtils.pathFormat(template, true, values);
            return this;
        }

        public Builder setPathEncoded(String template, Object ... values) {
            this.path = StringUtils.pathFormat(template, false, values);
            return this;
        }

        public Builder setRead(boolean read) {
            this.read = read;
            return this;
        }

        public Builder setBody(Object body) {
            this.body = body;
            return this;
        }

        public Builder addHeader(String key, Object value) {
            if (value == null) {
                return this;
            }
            this.headers.put(key.toLowerCase(), StringUtils.paramToString(value));
            return this;
        }

        public Builder addHeaders(Map<String, Object> headers) {
            if (headers == null) {
                return this;
            }
            headers.forEach(this::addHeader);
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this.method, this.path, this.read, this.headers, this.queryParameters, this.body);
        }
    }
}

