/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.internal.interceptors;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class HeaderInterceptor
implements Interceptor {
    private final Map<String, String> headers;

    public HeaderInterceptor(Map<String, String> headers) {
        this.headers = Collections.unmodifiableMap(headers);
    }

    @Nonnull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        Headers requestHeaders = request.headers();
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            String key = header.getKey();
            if (requestHeaders.get(key) == null) continue;
            builder.header(key, header.getValue());
        }
        Request newRequest = builder.build();
        return chain.proceed(newRequest);
    }
}

