// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.recommend;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** RecommendedForYouQueryParameters */
public class RecommendedForYouQueryParameters {

  @JsonProperty("query")
  private String query;

  @JsonProperty("similarQuery")
  private String similarQuery;

  @JsonProperty("filters")
  private String filters;

  @JsonProperty("facetFilters")
  private FacetFilters facetFilters;

  @JsonProperty("optionalFilters")
  private OptionalFilters optionalFilters;

  @JsonProperty("numericFilters")
  private NumericFilters numericFilters;

  @JsonProperty("tagFilters")
  private TagFilters tagFilters;

  @JsonProperty("sumOrFiltersScores")
  private Boolean sumOrFiltersScores;

  @JsonProperty("restrictSearchableAttributes")
  private List<String> restrictSearchableAttributes;

  @JsonProperty("facets")
  private List<String> facets;

  @JsonProperty("facetingAfterDistinct")
  private Boolean facetingAfterDistinct;

  @JsonProperty("page")
  private Integer page;

  @JsonProperty("offset")
  private Integer offset;

  @JsonProperty("length")
  private Integer length;

  @JsonProperty("aroundLatLng")
  private String aroundLatLng;

  @JsonProperty("aroundLatLngViaIP")
  private Boolean aroundLatLngViaIP;

  @JsonProperty("aroundRadius")
  private AroundRadius aroundRadius;

  @JsonProperty("aroundPrecision")
  private AroundPrecision aroundPrecision;

  @JsonProperty("minimumAroundRadius")
  private Integer minimumAroundRadius;

  @JsonProperty("insideBoundingBox")
  private List<List<Double>> insideBoundingBox;

  @JsonProperty("insidePolygon")
  private List<List<Double>> insidePolygon;

  @JsonProperty("naturalLanguages")
  private List<String> naturalLanguages;

  @JsonProperty("ruleContexts")
  private List<String> ruleContexts;

  @JsonProperty("personalizationImpact")
  private Integer personalizationImpact;

  @JsonProperty("userToken")
  private String userToken;

  @JsonProperty("getRankingInfo")
  private Boolean getRankingInfo;

  @JsonProperty("explain")
  private List<String> explain;

  @JsonProperty("synonyms")
  private Boolean synonyms;

  @JsonProperty("clickAnalytics")
  private Boolean clickAnalytics;

  @JsonProperty("analytics")
  private Boolean analytics;

  @JsonProperty("analyticsTags")
  private List<String> analyticsTags;

  @JsonProperty("percentileComputation")
  private Boolean percentileComputation;

  @JsonProperty("enableABTest")
  private Boolean enableABTest;

  @JsonProperty("attributesForFaceting")
  private List<String> attributesForFaceting;

  @JsonProperty("attributesToRetrieve")
  private List<String> attributesToRetrieve;

  @JsonProperty("ranking")
  private List<String> ranking;

  @JsonProperty("customRanking")
  private List<String> customRanking;

  @JsonProperty("relevancyStrictness")
  private Integer relevancyStrictness;

  @JsonProperty("attributesToHighlight")
  private List<String> attributesToHighlight;

  @JsonProperty("attributesToSnippet")
  private List<String> attributesToSnippet;

  @JsonProperty("highlightPreTag")
  private String highlightPreTag;

  @JsonProperty("highlightPostTag")
  private String highlightPostTag;

  @JsonProperty("snippetEllipsisText")
  private String snippetEllipsisText;

  @JsonProperty("restrictHighlightAndSnippetArrays")
  private Boolean restrictHighlightAndSnippetArrays;

  @JsonProperty("hitsPerPage")
  private Integer hitsPerPage;

  @JsonProperty("minWordSizefor1Typo")
  private Integer minWordSizefor1Typo;

  @JsonProperty("minWordSizefor2Typos")
  private Integer minWordSizefor2Typos;

  @JsonProperty("typoTolerance")
  private TypoTolerance typoTolerance;

  @JsonProperty("allowTyposOnNumericTokens")
  private Boolean allowTyposOnNumericTokens;

  @JsonProperty("disableTypoToleranceOnAttributes")
  private List<String> disableTypoToleranceOnAttributes;

  @JsonProperty("ignorePlurals")
  private IgnorePlurals ignorePlurals;

  @JsonProperty("removeStopWords")
  private RemoveStopWords removeStopWords;

  @JsonProperty("keepDiacriticsOnCharacters")
  private String keepDiacriticsOnCharacters;

  @JsonProperty("queryLanguages")
  private List<String> queryLanguages;

  @JsonProperty("decompoundQuery")
  private Boolean decompoundQuery;

  @JsonProperty("enableRules")
  private Boolean enableRules;

  @JsonProperty("enablePersonalization")
  private Boolean enablePersonalization;

  @JsonProperty("queryType")
  private QueryType queryType;

  @JsonProperty("removeWordsIfNoResults")
  private RemoveWordsIfNoResults removeWordsIfNoResults;

  @JsonProperty("mode")
  private Mode mode;

  @JsonProperty("semanticSearch")
  private SemanticSearch semanticSearch;

  @JsonProperty("advancedSyntax")
  private Boolean advancedSyntax;

  @JsonProperty("optionalWords")
  private List<String> optionalWords;

  @JsonProperty("disableExactOnAttributes")
  private List<String> disableExactOnAttributes;

  @JsonProperty("exactOnSingleWordQuery")
  private ExactOnSingleWordQuery exactOnSingleWordQuery;

  @JsonProperty("alternativesAsExact")
  private List<AlternativesAsExact> alternativesAsExact;

  @JsonProperty("advancedSyntaxFeatures")
  private List<AdvancedSyntaxFeatures> advancedSyntaxFeatures;

  @JsonProperty("distinct")
  private Distinct distinct;

  @JsonProperty("replaceSynonymsInHighlight")
  private Boolean replaceSynonymsInHighlight;

  @JsonProperty("minProximity")
  private Integer minProximity;

  @JsonProperty("responseFields")
  private List<String> responseFields;

  @JsonProperty("maxFacetHits")
  private Integer maxFacetHits;

  @JsonProperty("maxValuesPerFacet")
  private Integer maxValuesPerFacet;

  @JsonProperty("sortFacetValuesBy")
  private String sortFacetValuesBy;

  @JsonProperty("attributeCriteriaComputedByMinProximity")
  private Boolean attributeCriteriaComputedByMinProximity;

  @JsonProperty("renderingContent")
  private RenderingContent renderingContent;

  @JsonProperty("enableReRanking")
  private Boolean enableReRanking;

  @JsonProperty("reRankingApplyFilter")
  private ReRankingApplyFilter reRankingApplyFilter;

  public RecommendedForYouQueryParameters setQuery(String query) {
    this.query = query;
    return this;
  }

  /** Text to search for in an index. */
  @javax.annotation.Nullable
  public String getQuery() {
    return query;
  }

  public RecommendedForYouQueryParameters setSimilarQuery(String similarQuery) {
    this.similarQuery = similarQuery;
    return this;
  }

  /** Overrides the query parameter and performs a more generic search. */
  @javax.annotation.Nullable
  public String getSimilarQuery() {
    return similarQuery;
  }

  public RecommendedForYouQueryParameters setFilters(String filters) {
    this.filters = filters;
    return this;
  }

  /**
   * [Filter](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/) the
   * query with numeric, facet, or tag filters.
   */
  @javax.annotation.Nullable
  public String getFilters() {
    return filters;
  }

  public RecommendedForYouQueryParameters setFacetFilters(FacetFilters facetFilters) {
    this.facetFilters = facetFilters;
    return this;
  }

  /** Get facetFilters */
  @javax.annotation.Nullable
  public FacetFilters getFacetFilters() {
    return facetFilters;
  }

  public RecommendedForYouQueryParameters setOptionalFilters(OptionalFilters optionalFilters) {
    this.optionalFilters = optionalFilters;
    return this;
  }

  /** Get optionalFilters */
  @javax.annotation.Nullable
  public OptionalFilters getOptionalFilters() {
    return optionalFilters;
  }

  public RecommendedForYouQueryParameters setNumericFilters(NumericFilters numericFilters) {
    this.numericFilters = numericFilters;
    return this;
  }

  /** Get numericFilters */
  @javax.annotation.Nullable
  public NumericFilters getNumericFilters() {
    return numericFilters;
  }

  public RecommendedForYouQueryParameters setTagFilters(TagFilters tagFilters) {
    this.tagFilters = tagFilters;
    return this;
  }

  /** Get tagFilters */
  @javax.annotation.Nullable
  public TagFilters getTagFilters() {
    return tagFilters;
  }

  public RecommendedForYouQueryParameters setSumOrFiltersScores(Boolean sumOrFiltersScores) {
    this.sumOrFiltersScores = sumOrFiltersScores;
    return this;
  }

  /**
   * Determines how to calculate [filter
   * scores](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/in-depth/filter-scoring/#accumulating-scores-with-sumorfiltersscores).
   * If `false`, maximum score is kept. If `true`, score is summed.
   */
  @javax.annotation.Nullable
  public Boolean getSumOrFiltersScores() {
    return sumOrFiltersScores;
  }

  public RecommendedForYouQueryParameters setRestrictSearchableAttributes(List<String> restrictSearchableAttributes) {
    this.restrictSearchableAttributes = restrictSearchableAttributes;
    return this;
  }

  public RecommendedForYouQueryParameters addRestrictSearchableAttributes(String restrictSearchableAttributesItem) {
    if (this.restrictSearchableAttributes == null) {
      this.restrictSearchableAttributes = new ArrayList<>();
    }
    this.restrictSearchableAttributes.add(restrictSearchableAttributesItem);
    return this;
  }

  /**
   * Restricts a query to only look at a subset of your [searchable
   * attributes](https://www.algolia.com/doc/guides/managing-results/must-do/searchable-attributes/).
   */
  @javax.annotation.Nullable
  public List<String> getRestrictSearchableAttributes() {
    return restrictSearchableAttributes;
  }

  public RecommendedForYouQueryParameters setFacets(List<String> facets) {
    this.facets = facets;
    return this;
  }

  public RecommendedForYouQueryParameters addFacets(String facetsItem) {
    if (this.facets == null) {
      this.facets = new ArrayList<>();
    }
    this.facets.add(facetsItem);
    return this;
  }

  /**
   * Returns
   * [facets](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#contextual-facet-values-and-counts),
   * their facet values, and the number of matching facet values.
   */
  @javax.annotation.Nullable
  public List<String> getFacets() {
    return facets;
  }

  public RecommendedForYouQueryParameters setFacetingAfterDistinct(Boolean facetingAfterDistinct) {
    this.facetingAfterDistinct = facetingAfterDistinct;
    return this;
  }

  /**
   * Forces faceting to be applied after
   * [de-duplication](https://www.algolia.com/doc/guides/managing-results/refine-results/grouping/)
   * (with the distinct feature). Alternatively, the `afterDistinct`
   * [modifier](https://www.algolia.com/doc/api-reference/api-parameters/attributesForFaceting/#modifiers)
   * of `attributesForFaceting` allows for more granular control.
   */
  @javax.annotation.Nullable
  public Boolean getFacetingAfterDistinct() {
    return facetingAfterDistinct;
  }

  public RecommendedForYouQueryParameters setPage(Integer page) {
    this.page = page;
    return this;
  }

  /** Page to retrieve (the first page is `0`, not `1`). */
  @javax.annotation.Nullable
  public Integer getPage() {
    return page;
  }

  public RecommendedForYouQueryParameters setOffset(Integer offset) {
    this.offset = offset;
    return this;
  }

  /**
   * Specifies the offset of the first hit to return. > **Note**: Using `page` and `hitsPerPage` is
   * the recommended method for [paging
   * results](https://www.algolia.com/doc/guides/building-search-ui/ui-and-ux-patterns/pagination/js/).
   * However, you can use `offset` and `length` to implement [an alternative approach to
   * paging](https://www.algolia.com/doc/guides/building-search-ui/ui-and-ux-patterns/pagination/js/#retrieving-a-subset-of-records-with-offset-and-length).
   */
  @javax.annotation.Nullable
  public Integer getOffset() {
    return offset;
  }

  public RecommendedForYouQueryParameters setLength(Integer length) {
    this.length = length;
    return this;
  }

  /**
   * Sets the number of hits to retrieve (for use with `offset`). > **Note**: Using `page` and
   * `hitsPerPage` is the recommended method for [paging
   * results](https://www.algolia.com/doc/guides/building-search-ui/ui-and-ux-patterns/pagination/js/).
   * However, you can use `offset` and `length` to implement [an alternative approach to
   * paging](https://www.algolia.com/doc/guides/building-search-ui/ui-and-ux-patterns/pagination/js/#retrieving-a-subset-of-records-with-offset-and-length).
   * minimum: 1 maximum: 1000
   */
  @javax.annotation.Nullable
  public Integer getLength() {
    return length;
  }

  public RecommendedForYouQueryParameters setAroundLatLng(String aroundLatLng) {
    this.aroundLatLng = aroundLatLng;
    return this;
  }

  /**
   * Search for entries [around a central
   * location](https://www.algolia.com/doc/guides/managing-results/refine-results/geolocation/#filter-around-a-central-point),
   * enabling a geographical search within a circular area.
   */
  @javax.annotation.Nullable
  public String getAroundLatLng() {
    return aroundLatLng;
  }

  public RecommendedForYouQueryParameters setAroundLatLngViaIP(Boolean aroundLatLngViaIP) {
    this.aroundLatLngViaIP = aroundLatLngViaIP;
    return this;
  }

  /**
   * Search for entries around a location. The location is automatically computed from the
   * requester's IP address.
   */
  @javax.annotation.Nullable
  public Boolean getAroundLatLngViaIP() {
    return aroundLatLngViaIP;
  }

  public RecommendedForYouQueryParameters setAroundRadius(AroundRadius aroundRadius) {
    this.aroundRadius = aroundRadius;
    return this;
  }

  /** Get aroundRadius */
  @javax.annotation.Nullable
  public AroundRadius getAroundRadius() {
    return aroundRadius;
  }

  public RecommendedForYouQueryParameters setAroundPrecision(AroundPrecision aroundPrecision) {
    this.aroundPrecision = aroundPrecision;
    return this;
  }

  /** Get aroundPrecision */
  @javax.annotation.Nullable
  public AroundPrecision getAroundPrecision() {
    return aroundPrecision;
  }

  public RecommendedForYouQueryParameters setMinimumAroundRadius(Integer minimumAroundRadius) {
    this.minimumAroundRadius = minimumAroundRadius;
    return this;
  }

  /**
   * Minimum radius (in meters) used for a geographical search when `aroundRadius` isn't set.
   * minimum: 1
   */
  @javax.annotation.Nullable
  public Integer getMinimumAroundRadius() {
    return minimumAroundRadius;
  }

  public RecommendedForYouQueryParameters setInsideBoundingBox(List<List<Double>> insideBoundingBox) {
    this.insideBoundingBox = insideBoundingBox;
    return this;
  }

  public RecommendedForYouQueryParameters addInsideBoundingBox(List<Double> insideBoundingBoxItem) {
    if (this.insideBoundingBox == null) {
      this.insideBoundingBox = new ArrayList<>();
    }
    this.insideBoundingBox.add(insideBoundingBoxItem);
    return this;
  }

  /**
   * Search inside a [rectangular
   * area](https://www.algolia.com/doc/guides/managing-results/refine-results/geolocation/#filtering-inside-rectangular-or-polygonal-areas)
   * (in geographical coordinates).
   */
  @javax.annotation.Nullable
  public List<List<Double>> getInsideBoundingBox() {
    return insideBoundingBox;
  }

  public RecommendedForYouQueryParameters setInsidePolygon(List<List<Double>> insidePolygon) {
    this.insidePolygon = insidePolygon;
    return this;
  }

  public RecommendedForYouQueryParameters addInsidePolygon(List<Double> insidePolygonItem) {
    if (this.insidePolygon == null) {
      this.insidePolygon = new ArrayList<>();
    }
    this.insidePolygon.add(insidePolygonItem);
    return this;
  }

  /**
   * Search inside a
   * [polygon](https://www.algolia.com/doc/guides/managing-results/refine-results/geolocation/#filtering-inside-rectangular-or-polygonal-areas)
   * (in geographical coordinates).
   */
  @javax.annotation.Nullable
  public List<List<Double>> getInsidePolygon() {
    return insidePolygon;
  }

  public RecommendedForYouQueryParameters setNaturalLanguages(List<String> naturalLanguages) {
    this.naturalLanguages = naturalLanguages;
    return this;
  }

  public RecommendedForYouQueryParameters addNaturalLanguages(String naturalLanguagesItem) {
    if (this.naturalLanguages == null) {
      this.naturalLanguages = new ArrayList<>();
    }
    this.naturalLanguages.add(naturalLanguagesItem);
    return this;
  }

  /**
   * Changes the default values of parameters that work best for a natural language query, such as
   * `ignorePlurals`, `removeStopWords`, `removeWordsIfNoResults`, `analyticsTags`, and
   * `ruleContexts`. These parameters work well together when the query consists of fuller natural
   * language strings instead of keywords, for example when processing voice search queries.
   */
  @javax.annotation.Nullable
  public List<String> getNaturalLanguages() {
    return naturalLanguages;
  }

  public RecommendedForYouQueryParameters setRuleContexts(List<String> ruleContexts) {
    this.ruleContexts = ruleContexts;
    return this;
  }

  public RecommendedForYouQueryParameters addRuleContexts(String ruleContextsItem) {
    if (this.ruleContexts == null) {
      this.ruleContexts = new ArrayList<>();
    }
    this.ruleContexts.add(ruleContextsItem);
    return this;
  }

  /**
   * Assigns [rule
   * contexts](https://www.algolia.com/doc/guides/managing-results/rules/rules-overview/how-to/customize-search-results-by-platform/#whats-a-context)
   * to search queries.
   */
  @javax.annotation.Nullable
  public List<String> getRuleContexts() {
    return ruleContexts;
  }

  public RecommendedForYouQueryParameters setPersonalizationImpact(Integer personalizationImpact) {
    this.personalizationImpact = personalizationImpact;
    return this;
  }

  /**
   * Defines how much [Personalization affects
   * results](https://www.algolia.com/doc/guides/personalization/personalizing-results/in-depth/configuring-personalization/#understanding-personalization-impact).
   */
  @javax.annotation.Nullable
  public Integer getPersonalizationImpact() {
    return personalizationImpact;
  }

  public RecommendedForYouQueryParameters setUserToken(String userToken) {
    this.userToken = userToken;
    return this;
  }

  /**
   * Associates a [user
   * token](https://www.algolia.com/doc/guides/sending-events/concepts/usertoken/) with the current
   * search.
   */
  @javax.annotation.Nonnull
  public String getUserToken() {
    return userToken;
  }

  public RecommendedForYouQueryParameters setGetRankingInfo(Boolean getRankingInfo) {
    this.getRankingInfo = getRankingInfo;
    return this;
  }

  /**
   * Incidates whether the search response includes [detailed ranking
   * information](https://www.algolia.com/doc/guides/building-search-ui/going-further/backend-search/in-depth/understanding-the-api-response/#ranking-information).
   */
  @javax.annotation.Nullable
  public Boolean getGetRankingInfo() {
    return getRankingInfo;
  }

  public RecommendedForYouQueryParameters setExplain(List<String> explain) {
    this.explain = explain;
    return this;
  }

  public RecommendedForYouQueryParameters addExplain(String explainItem) {
    if (this.explain == null) {
      this.explain = new ArrayList<>();
    }
    this.explain.add(explainItem);
    return this;
  }

  /** Enriches the API's response with information about how the query was processed. */
  @javax.annotation.Nullable
  public List<String> getExplain() {
    return explain;
  }

  public RecommendedForYouQueryParameters setSynonyms(Boolean synonyms) {
    this.synonyms = synonyms;
    return this;
  }

  /** Whether to take into account an index's synonyms for a particular search. */
  @javax.annotation.Nullable
  public Boolean getSynonyms() {
    return synonyms;
  }

  public RecommendedForYouQueryParameters setClickAnalytics(Boolean clickAnalytics) {
    this.clickAnalytics = clickAnalytics;
    return this;
  }

  /**
   * Indicates whether a query ID parameter is included in the search response. This is required for
   * [tracking click and conversion
   * events](https://www.algolia.com/doc/guides/sending-events/concepts/event-types/#events-related-to-algolia-requests).
   */
  @javax.annotation.Nullable
  public Boolean getClickAnalytics() {
    return clickAnalytics;
  }

  public RecommendedForYouQueryParameters setAnalytics(Boolean analytics) {
    this.analytics = analytics;
    return this;
  }

  /**
   * Indicates whether this query will be included in
   * [analytics](https://www.algolia.com/doc/guides/search-analytics/guides/exclude-queries/).
   */
  @javax.annotation.Nullable
  public Boolean getAnalytics() {
    return analytics;
  }

  public RecommendedForYouQueryParameters setAnalyticsTags(List<String> analyticsTags) {
    this.analyticsTags = analyticsTags;
    return this;
  }

  public RecommendedForYouQueryParameters addAnalyticsTags(String analyticsTagsItem) {
    if (this.analyticsTags == null) {
      this.analyticsTags = new ArrayList<>();
    }
    this.analyticsTags.add(analyticsTagsItem);
    return this;
  }

  /**
   * Tags to apply to the query for [segmenting analytics
   * data](https://www.algolia.com/doc/guides/search-analytics/guides/segments/).
   */
  @javax.annotation.Nullable
  public List<String> getAnalyticsTags() {
    return analyticsTags;
  }

  public RecommendedForYouQueryParameters setPercentileComputation(Boolean percentileComputation) {
    this.percentileComputation = percentileComputation;
    return this;
  }

  /** Whether to include or exclude a query from the processing-time percentile computation. */
  @javax.annotation.Nullable
  public Boolean getPercentileComputation() {
    return percentileComputation;
  }

  public RecommendedForYouQueryParameters setEnableABTest(Boolean enableABTest) {
    this.enableABTest = enableABTest;
    return this;
  }

  /** Incidates whether this search will be considered in A/B testing. */
  @javax.annotation.Nullable
  public Boolean getEnableABTest() {
    return enableABTest;
  }

  public RecommendedForYouQueryParameters setAttributesForFaceting(List<String> attributesForFaceting) {
    this.attributesForFaceting = attributesForFaceting;
    return this;
  }

  public RecommendedForYouQueryParameters addAttributesForFaceting(String attributesForFacetingItem) {
    if (this.attributesForFaceting == null) {
      this.attributesForFaceting = new ArrayList<>();
    }
    this.attributesForFaceting.add(attributesForFacetingItem);
    return this;
  }

  /**
   * Attributes used for
   * [faceting](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/) and
   * the
   * [modifiers](https://www.algolia.com/doc/api-reference/api-parameters/attributesForFaceting/#modifiers)
   * that can be applied: `filterOnly`, `searchable`, and `afterDistinct`.
   */
  @javax.annotation.Nullable
  public List<String> getAttributesForFaceting() {
    return attributesForFaceting;
  }

  public RecommendedForYouQueryParameters setAttributesToRetrieve(List<String> attributesToRetrieve) {
    this.attributesToRetrieve = attributesToRetrieve;
    return this;
  }

  public RecommendedForYouQueryParameters addAttributesToRetrieve(String attributesToRetrieveItem) {
    if (this.attributesToRetrieve == null) {
      this.attributesToRetrieve = new ArrayList<>();
    }
    this.attributesToRetrieve.add(attributesToRetrieveItem);
    return this;
  }

  /**
   * Attributes to include in the API response. To reduce the size of your response, you can
   * retrieve only some of the attributes. By default, the response includes all attributes.
   */
  @javax.annotation.Nullable
  public List<String> getAttributesToRetrieve() {
    return attributesToRetrieve;
  }

  public RecommendedForYouQueryParameters setRanking(List<String> ranking) {
    this.ranking = ranking;
    return this;
  }

  public RecommendedForYouQueryParameters addRanking(String rankingItem) {
    if (this.ranking == null) {
      this.ranking = new ArrayList<>();
    }
    this.ranking.add(rankingItem);
    return this;
  }

  /**
   * Determines the order in which Algolia [returns your
   * results](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/).
   */
  @javax.annotation.Nullable
  public List<String> getRanking() {
    return ranking;
  }

  public RecommendedForYouQueryParameters setCustomRanking(List<String> customRanking) {
    this.customRanking = customRanking;
    return this;
  }

  public RecommendedForYouQueryParameters addCustomRanking(String customRankingItem) {
    if (this.customRanking == null) {
      this.customRanking = new ArrayList<>();
    }
    this.customRanking.add(customRankingItem);
    return this;
  }

  /**
   * Specifies the [Custom ranking
   * criterion](https://www.algolia.com/doc/guides/managing-results/must-do/custom-ranking/). Use
   * the `asc` and `desc` modifiers to specify the ranking order: ascending or descending.
   */
  @javax.annotation.Nullable
  public List<String> getCustomRanking() {
    return customRanking;
  }

  public RecommendedForYouQueryParameters setRelevancyStrictness(Integer relevancyStrictness) {
    this.relevancyStrictness = relevancyStrictness;
    return this;
  }

  /** Relevancy threshold below which less relevant results aren't included in the results. */
  @javax.annotation.Nullable
  public Integer getRelevancyStrictness() {
    return relevancyStrictness;
  }

  public RecommendedForYouQueryParameters setAttributesToHighlight(List<String> attributesToHighlight) {
    this.attributesToHighlight = attributesToHighlight;
    return this;
  }

  public RecommendedForYouQueryParameters addAttributesToHighlight(String attributesToHighlightItem) {
    if (this.attributesToHighlight == null) {
      this.attributesToHighlight = new ArrayList<>();
    }
    this.attributesToHighlight.add(attributesToHighlightItem);
    return this;
  }

  /**
   * Attributes to highlight. Strings that match the search query in the attributes are highlighted
   * by surrounding them with HTML tags (`highlightPreTag` and `highlightPostTag`).
   */
  @javax.annotation.Nullable
  public List<String> getAttributesToHighlight() {
    return attributesToHighlight;
  }

  public RecommendedForYouQueryParameters setAttributesToSnippet(List<String> attributesToSnippet) {
    this.attributesToSnippet = attributesToSnippet;
    return this;
  }

  public RecommendedForYouQueryParameters addAttributesToSnippet(String attributesToSnippetItem) {
    if (this.attributesToSnippet == null) {
      this.attributesToSnippet = new ArrayList<>();
    }
    this.attributesToSnippet.add(attributesToSnippetItem);
    return this;
  }

  /**
   * Attributes to _snippet_. 'Snippeting' is shortening the attribute to a certain number of words.
   * If not specified, the attribute is shortened to the 10 words around the matching string but you
   * can specify the number. For example: `body:20`.
   */
  @javax.annotation.Nullable
  public List<String> getAttributesToSnippet() {
    return attributesToSnippet;
  }

  public RecommendedForYouQueryParameters setHighlightPreTag(String highlightPreTag) {
    this.highlightPreTag = highlightPreTag;
    return this;
  }

  /** HTML string to insert before the highlighted parts in all highlight and snippet results. */
  @javax.annotation.Nullable
  public String getHighlightPreTag() {
    return highlightPreTag;
  }

  public RecommendedForYouQueryParameters setHighlightPostTag(String highlightPostTag) {
    this.highlightPostTag = highlightPostTag;
    return this;
  }

  /** HTML string to insert after the highlighted parts in all highlight and snippet results. */
  @javax.annotation.Nullable
  public String getHighlightPostTag() {
    return highlightPostTag;
  }

  public RecommendedForYouQueryParameters setSnippetEllipsisText(String snippetEllipsisText) {
    this.snippetEllipsisText = snippetEllipsisText;
    return this;
  }

  /** String used as an ellipsis indicator when a snippet is truncated. */
  @javax.annotation.Nullable
  public String getSnippetEllipsisText() {
    return snippetEllipsisText;
  }

  public RecommendedForYouQueryParameters setRestrictHighlightAndSnippetArrays(Boolean restrictHighlightAndSnippetArrays) {
    this.restrictHighlightAndSnippetArrays = restrictHighlightAndSnippetArrays;
    return this;
  }

  /** Restrict highlighting and snippeting to items that matched the query. */
  @javax.annotation.Nullable
  public Boolean getRestrictHighlightAndSnippetArrays() {
    return restrictHighlightAndSnippetArrays;
  }

  public RecommendedForYouQueryParameters setHitsPerPage(Integer hitsPerPage) {
    this.hitsPerPage = hitsPerPage;
    return this;
  }

  /** Number of hits per page. minimum: 1 maximum: 1000 */
  @javax.annotation.Nullable
  public Integer getHitsPerPage() {
    return hitsPerPage;
  }

  public RecommendedForYouQueryParameters setMinWordSizefor1Typo(Integer minWordSizefor1Typo) {
    this.minWordSizefor1Typo = minWordSizefor1Typo;
    return this;
  }

  /**
   * Minimum number of characters a word in the query string must contain to accept matches with
   * [one
   * typo](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/in-depth/configuring-typo-tolerance/#configuring-word-length-for-typos).
   */
  @javax.annotation.Nullable
  public Integer getMinWordSizefor1Typo() {
    return minWordSizefor1Typo;
  }

  public RecommendedForYouQueryParameters setMinWordSizefor2Typos(Integer minWordSizefor2Typos) {
    this.minWordSizefor2Typos = minWordSizefor2Typos;
    return this;
  }

  /**
   * Minimum number of characters a word in the query string must contain to accept matches with
   * [two
   * typos](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/in-depth/configuring-typo-tolerance/#configuring-word-length-for-typos).
   */
  @javax.annotation.Nullable
  public Integer getMinWordSizefor2Typos() {
    return minWordSizefor2Typos;
  }

  public RecommendedForYouQueryParameters setTypoTolerance(TypoTolerance typoTolerance) {
    this.typoTolerance = typoTolerance;
    return this;
  }

  /** Get typoTolerance */
  @javax.annotation.Nullable
  public TypoTolerance getTypoTolerance() {
    return typoTolerance;
  }

  public RecommendedForYouQueryParameters setAllowTyposOnNumericTokens(Boolean allowTyposOnNumericTokens) {
    this.allowTyposOnNumericTokens = allowTyposOnNumericTokens;
    return this;
  }

  /** Whether to allow typos on numbers (\"numeric tokens\") in the query string. */
  @javax.annotation.Nullable
  public Boolean getAllowTyposOnNumericTokens() {
    return allowTyposOnNumericTokens;
  }

  public RecommendedForYouQueryParameters setDisableTypoToleranceOnAttributes(List<String> disableTypoToleranceOnAttributes) {
    this.disableTypoToleranceOnAttributes = disableTypoToleranceOnAttributes;
    return this;
  }

  public RecommendedForYouQueryParameters addDisableTypoToleranceOnAttributes(String disableTypoToleranceOnAttributesItem) {
    if (this.disableTypoToleranceOnAttributes == null) {
      this.disableTypoToleranceOnAttributes = new ArrayList<>();
    }
    this.disableTypoToleranceOnAttributes.add(disableTypoToleranceOnAttributesItem);
    return this;
  }

  /**
   * Attributes for which you want to turn off [typo
   * tolerance](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/).
   */
  @javax.annotation.Nullable
  public List<String> getDisableTypoToleranceOnAttributes() {
    return disableTypoToleranceOnAttributes;
  }

  public RecommendedForYouQueryParameters setIgnorePlurals(IgnorePlurals ignorePlurals) {
    this.ignorePlurals = ignorePlurals;
    return this;
  }

  /** Get ignorePlurals */
  @javax.annotation.Nullable
  public IgnorePlurals getIgnorePlurals() {
    return ignorePlurals;
  }

  public RecommendedForYouQueryParameters setRemoveStopWords(RemoveStopWords removeStopWords) {
    this.removeStopWords = removeStopWords;
    return this;
  }

  /** Get removeStopWords */
  @javax.annotation.Nullable
  public RemoveStopWords getRemoveStopWords() {
    return removeStopWords;
  }

  public RecommendedForYouQueryParameters setKeepDiacriticsOnCharacters(String keepDiacriticsOnCharacters) {
    this.keepDiacriticsOnCharacters = keepDiacriticsOnCharacters;
    return this;
  }

  /**
   * Characters that the engine shouldn't automatically
   * [normalize](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/normalization/).
   */
  @javax.annotation.Nullable
  public String getKeepDiacriticsOnCharacters() {
    return keepDiacriticsOnCharacters;
  }

  public RecommendedForYouQueryParameters setQueryLanguages(List<String> queryLanguages) {
    this.queryLanguages = queryLanguages;
    return this;
  }

  public RecommendedForYouQueryParameters addQueryLanguages(String queryLanguagesItem) {
    if (this.queryLanguages == null) {
      this.queryLanguages = new ArrayList<>();
    }
    this.queryLanguages.add(queryLanguagesItem);
    return this;
  }

  /**
   * Sets your user's search language. This adjusts language-specific settings and features such as
   * `ignorePlurals`, `removeStopWords`, and
   * [CJK](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/normalization/#normalization-for-logogram-based-languages-cjk)
   * word detection.
   */
  @javax.annotation.Nullable
  public List<String> getQueryLanguages() {
    return queryLanguages;
  }

  public RecommendedForYouQueryParameters setDecompoundQuery(Boolean decompoundQuery) {
    this.decompoundQuery = decompoundQuery;
    return this;
  }

  /**
   * [Splits compound
   * words](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/#splitting-compound-words)
   * into their component word parts in the query.
   */
  @javax.annotation.Nullable
  public Boolean getDecompoundQuery() {
    return decompoundQuery;
  }

  public RecommendedForYouQueryParameters setEnableRules(Boolean enableRules) {
    this.enableRules = enableRules;
    return this;
  }

  /**
   * Incidates whether
   * [Rules](https://www.algolia.com/doc/guides/managing-results/rules/rules-overview/) are enabled.
   */
  @javax.annotation.Nullable
  public Boolean getEnableRules() {
    return enableRules;
  }

  public RecommendedForYouQueryParameters setEnablePersonalization(Boolean enablePersonalization) {
    this.enablePersonalization = enablePersonalization;
    return this;
  }

  /**
   * Incidates whether
   * [Personalization](https://www.algolia.com/doc/guides/personalization/what-is-personalization/)
   * is enabled.
   */
  @javax.annotation.Nullable
  public Boolean getEnablePersonalization() {
    return enablePersonalization;
  }

  public RecommendedForYouQueryParameters setQueryType(QueryType queryType) {
    this.queryType = queryType;
    return this;
  }

  /** Get queryType */
  @javax.annotation.Nullable
  public QueryType getQueryType() {
    return queryType;
  }

  public RecommendedForYouQueryParameters setRemoveWordsIfNoResults(RemoveWordsIfNoResults removeWordsIfNoResults) {
    this.removeWordsIfNoResults = removeWordsIfNoResults;
    return this;
  }

  /** Get removeWordsIfNoResults */
  @javax.annotation.Nullable
  public RemoveWordsIfNoResults getRemoveWordsIfNoResults() {
    return removeWordsIfNoResults;
  }

  public RecommendedForYouQueryParameters setMode(Mode mode) {
    this.mode = mode;
    return this;
  }

  /** Get mode */
  @javax.annotation.Nullable
  public Mode getMode() {
    return mode;
  }

  public RecommendedForYouQueryParameters setSemanticSearch(SemanticSearch semanticSearch) {
    this.semanticSearch = semanticSearch;
    return this;
  }

  /** Get semanticSearch */
  @javax.annotation.Nullable
  public SemanticSearch getSemanticSearch() {
    return semanticSearch;
  }

  public RecommendedForYouQueryParameters setAdvancedSyntax(Boolean advancedSyntax) {
    this.advancedSyntax = advancedSyntax;
    return this;
  }

  /**
   * Enables the [advanced query
   * syntax](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/override-search-engine-defaults/#advanced-syntax).
   */
  @javax.annotation.Nullable
  public Boolean getAdvancedSyntax() {
    return advancedSyntax;
  }

  public RecommendedForYouQueryParameters setOptionalWords(List<String> optionalWords) {
    this.optionalWords = optionalWords;
    return this;
  }

  public RecommendedForYouQueryParameters addOptionalWords(String optionalWordsItem) {
    if (this.optionalWords == null) {
      this.optionalWords = new ArrayList<>();
    }
    this.optionalWords.add(optionalWordsItem);
    return this;
  }

  /**
   * Words which should be considered
   * [optional](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/empty-or-insufficient-results/#creating-a-list-of-optional-words)
   * when found in a query.
   */
  @javax.annotation.Nullable
  public List<String> getOptionalWords() {
    return optionalWords;
  }

  public RecommendedForYouQueryParameters setDisableExactOnAttributes(List<String> disableExactOnAttributes) {
    this.disableExactOnAttributes = disableExactOnAttributes;
    return this;
  }

  public RecommendedForYouQueryParameters addDisableExactOnAttributes(String disableExactOnAttributesItem) {
    if (this.disableExactOnAttributes == null) {
      this.disableExactOnAttributes = new ArrayList<>();
    }
    this.disableExactOnAttributes.add(disableExactOnAttributesItem);
    return this;
  }

  /**
   * Attributes for which you want to [turn off the exact ranking
   * criterion](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/override-search-engine-defaults/in-depth/adjust-exact-settings/#turn-off-exact-for-some-attributes).
   */
  @javax.annotation.Nullable
  public List<String> getDisableExactOnAttributes() {
    return disableExactOnAttributes;
  }

  public RecommendedForYouQueryParameters setExactOnSingleWordQuery(ExactOnSingleWordQuery exactOnSingleWordQuery) {
    this.exactOnSingleWordQuery = exactOnSingleWordQuery;
    return this;
  }

  /** Get exactOnSingleWordQuery */
  @javax.annotation.Nullable
  public ExactOnSingleWordQuery getExactOnSingleWordQuery() {
    return exactOnSingleWordQuery;
  }

  public RecommendedForYouQueryParameters setAlternativesAsExact(List<AlternativesAsExact> alternativesAsExact) {
    this.alternativesAsExact = alternativesAsExact;
    return this;
  }

  public RecommendedForYouQueryParameters addAlternativesAsExact(AlternativesAsExact alternativesAsExactItem) {
    if (this.alternativesAsExact == null) {
      this.alternativesAsExact = new ArrayList<>();
    }
    this.alternativesAsExact.add(alternativesAsExactItem);
    return this;
  }

  /**
   * Alternatives that should be considered an exact match by [the exact ranking
   * criterion](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/override-search-engine-defaults/in-depth/adjust-exact-settings/#turn-off-exact-for-some-attributes).
   */
  @javax.annotation.Nullable
  public List<AlternativesAsExact> getAlternativesAsExact() {
    return alternativesAsExact;
  }

  public RecommendedForYouQueryParameters setAdvancedSyntaxFeatures(List<AdvancedSyntaxFeatures> advancedSyntaxFeatures) {
    this.advancedSyntaxFeatures = advancedSyntaxFeatures;
    return this;
  }

  public RecommendedForYouQueryParameters addAdvancedSyntaxFeatures(AdvancedSyntaxFeatures advancedSyntaxFeaturesItem) {
    if (this.advancedSyntaxFeatures == null) {
      this.advancedSyntaxFeatures = new ArrayList<>();
    }
    this.advancedSyntaxFeatures.add(advancedSyntaxFeaturesItem);
    return this;
  }

  /**
   * Allows you to specify which advanced syntax features are active when `advancedSyntax` is
   * enabled.
   */
  @javax.annotation.Nullable
  public List<AdvancedSyntaxFeatures> getAdvancedSyntaxFeatures() {
    return advancedSyntaxFeatures;
  }

  public RecommendedForYouQueryParameters setDistinct(Distinct distinct) {
    this.distinct = distinct;
    return this;
  }

  /** Get distinct */
  @javax.annotation.Nullable
  public Distinct getDistinct() {
    return distinct;
  }

  public RecommendedForYouQueryParameters setReplaceSynonymsInHighlight(Boolean replaceSynonymsInHighlight) {
    this.replaceSynonymsInHighlight = replaceSynonymsInHighlight;
    return this;
  }

  /**
   * Whether to highlight and snippet the original word that matches the synonym or the synonym
   * itself.
   */
  @javax.annotation.Nullable
  public Boolean getReplaceSynonymsInHighlight() {
    return replaceSynonymsInHighlight;
  }

  public RecommendedForYouQueryParameters setMinProximity(Integer minProximity) {
    this.minProximity = minProximity;
    return this;
  }

  /**
   * Precision of the [proximity ranking
   * criterion](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/#proximity).
   * minimum: 1 maximum: 7
   */
  @javax.annotation.Nullable
  public Integer getMinProximity() {
    return minProximity;
  }

  public RecommendedForYouQueryParameters setResponseFields(List<String> responseFields) {
    this.responseFields = responseFields;
    return this;
  }

  public RecommendedForYouQueryParameters addResponseFields(String responseFieldsItem) {
    if (this.responseFields == null) {
      this.responseFields = new ArrayList<>();
    }
    this.responseFields.add(responseFieldsItem);
    return this;
  }

  /** Attributes to include in the API response for search and browse queries. */
  @javax.annotation.Nullable
  public List<String> getResponseFields() {
    return responseFields;
  }

  public RecommendedForYouQueryParameters setMaxFacetHits(Integer maxFacetHits) {
    this.maxFacetHits = maxFacetHits;
    return this;
  }

  /**
   * Maximum number of facet hits to return when [searching for facet
   * values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values).
   * maximum: 100
   */
  @javax.annotation.Nullable
  public Integer getMaxFacetHits() {
    return maxFacetHits;
  }

  public RecommendedForYouQueryParameters setMaxValuesPerFacet(Integer maxValuesPerFacet) {
    this.maxValuesPerFacet = maxValuesPerFacet;
    return this;
  }

  /** Maximum number of facet values to return for each facet. */
  @javax.annotation.Nullable
  public Integer getMaxValuesPerFacet() {
    return maxValuesPerFacet;
  }

  public RecommendedForYouQueryParameters setSortFacetValuesBy(String sortFacetValuesBy) {
    this.sortFacetValuesBy = sortFacetValuesBy;
    return this;
  }

  /** Controls how facet values are fetched. */
  @javax.annotation.Nullable
  public String getSortFacetValuesBy() {
    return sortFacetValuesBy;
  }

  public RecommendedForYouQueryParameters setAttributeCriteriaComputedByMinProximity(Boolean attributeCriteriaComputedByMinProximity) {
    this.attributeCriteriaComputedByMinProximity = attributeCriteriaComputedByMinProximity;
    return this;
  }

  /**
   * When the [Attribute criterion is ranked above
   * Proximity](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/#attribute-and-proximity-combinations)
   * in your ranking formula, Proximity is used to select which searchable attribute is matched in
   * the Attribute ranking stage.
   */
  @javax.annotation.Nullable
  public Boolean getAttributeCriteriaComputedByMinProximity() {
    return attributeCriteriaComputedByMinProximity;
  }

  public RecommendedForYouQueryParameters setRenderingContent(RenderingContent renderingContent) {
    this.renderingContent = renderingContent;
    return this;
  }

  /** Get renderingContent */
  @javax.annotation.Nullable
  public RenderingContent getRenderingContent() {
    return renderingContent;
  }

  public RecommendedForYouQueryParameters setEnableReRanking(Boolean enableReRanking) {
    this.enableReRanking = enableReRanking;
    return this;
  }

  /**
   * Indicates whether this search will use [Dynamic
   * Re-Ranking](https://www.algolia.com/doc/guides/algolia-ai/re-ranking/).
   */
  @javax.annotation.Nullable
  public Boolean getEnableReRanking() {
    return enableReRanking;
  }

  public RecommendedForYouQueryParameters setReRankingApplyFilter(ReRankingApplyFilter reRankingApplyFilter) {
    this.reRankingApplyFilter = reRankingApplyFilter;
    return this;
  }

  /** Get reRankingApplyFilter */
  @javax.annotation.Nullable
  public ReRankingApplyFilter getReRankingApplyFilter() {
    return reRankingApplyFilter;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RecommendedForYouQueryParameters recommendedForYouQueryParameters = (RecommendedForYouQueryParameters) o;
    return (
      Objects.equals(this.query, recommendedForYouQueryParameters.query) &&
      Objects.equals(this.similarQuery, recommendedForYouQueryParameters.similarQuery) &&
      Objects.equals(this.filters, recommendedForYouQueryParameters.filters) &&
      Objects.equals(this.facetFilters, recommendedForYouQueryParameters.facetFilters) &&
      Objects.equals(this.optionalFilters, recommendedForYouQueryParameters.optionalFilters) &&
      Objects.equals(this.numericFilters, recommendedForYouQueryParameters.numericFilters) &&
      Objects.equals(this.tagFilters, recommendedForYouQueryParameters.tagFilters) &&
      Objects.equals(this.sumOrFiltersScores, recommendedForYouQueryParameters.sumOrFiltersScores) &&
      Objects.equals(this.restrictSearchableAttributes, recommendedForYouQueryParameters.restrictSearchableAttributes) &&
      Objects.equals(this.facets, recommendedForYouQueryParameters.facets) &&
      Objects.equals(this.facetingAfterDistinct, recommendedForYouQueryParameters.facetingAfterDistinct) &&
      Objects.equals(this.page, recommendedForYouQueryParameters.page) &&
      Objects.equals(this.offset, recommendedForYouQueryParameters.offset) &&
      Objects.equals(this.length, recommendedForYouQueryParameters.length) &&
      Objects.equals(this.aroundLatLng, recommendedForYouQueryParameters.aroundLatLng) &&
      Objects.equals(this.aroundLatLngViaIP, recommendedForYouQueryParameters.aroundLatLngViaIP) &&
      Objects.equals(this.aroundRadius, recommendedForYouQueryParameters.aroundRadius) &&
      Objects.equals(this.aroundPrecision, recommendedForYouQueryParameters.aroundPrecision) &&
      Objects.equals(this.minimumAroundRadius, recommendedForYouQueryParameters.minimumAroundRadius) &&
      Objects.equals(this.insideBoundingBox, recommendedForYouQueryParameters.insideBoundingBox) &&
      Objects.equals(this.insidePolygon, recommendedForYouQueryParameters.insidePolygon) &&
      Objects.equals(this.naturalLanguages, recommendedForYouQueryParameters.naturalLanguages) &&
      Objects.equals(this.ruleContexts, recommendedForYouQueryParameters.ruleContexts) &&
      Objects.equals(this.personalizationImpact, recommendedForYouQueryParameters.personalizationImpact) &&
      Objects.equals(this.userToken, recommendedForYouQueryParameters.userToken) &&
      Objects.equals(this.getRankingInfo, recommendedForYouQueryParameters.getRankingInfo) &&
      Objects.equals(this.explain, recommendedForYouQueryParameters.explain) &&
      Objects.equals(this.synonyms, recommendedForYouQueryParameters.synonyms) &&
      Objects.equals(this.clickAnalytics, recommendedForYouQueryParameters.clickAnalytics) &&
      Objects.equals(this.analytics, recommendedForYouQueryParameters.analytics) &&
      Objects.equals(this.analyticsTags, recommendedForYouQueryParameters.analyticsTags) &&
      Objects.equals(this.percentileComputation, recommendedForYouQueryParameters.percentileComputation) &&
      Objects.equals(this.enableABTest, recommendedForYouQueryParameters.enableABTest) &&
      Objects.equals(this.attributesForFaceting, recommendedForYouQueryParameters.attributesForFaceting) &&
      Objects.equals(this.attributesToRetrieve, recommendedForYouQueryParameters.attributesToRetrieve) &&
      Objects.equals(this.ranking, recommendedForYouQueryParameters.ranking) &&
      Objects.equals(this.customRanking, recommendedForYouQueryParameters.customRanking) &&
      Objects.equals(this.relevancyStrictness, recommendedForYouQueryParameters.relevancyStrictness) &&
      Objects.equals(this.attributesToHighlight, recommendedForYouQueryParameters.attributesToHighlight) &&
      Objects.equals(this.attributesToSnippet, recommendedForYouQueryParameters.attributesToSnippet) &&
      Objects.equals(this.highlightPreTag, recommendedForYouQueryParameters.highlightPreTag) &&
      Objects.equals(this.highlightPostTag, recommendedForYouQueryParameters.highlightPostTag) &&
      Objects.equals(this.snippetEllipsisText, recommendedForYouQueryParameters.snippetEllipsisText) &&
      Objects.equals(this.restrictHighlightAndSnippetArrays, recommendedForYouQueryParameters.restrictHighlightAndSnippetArrays) &&
      Objects.equals(this.hitsPerPage, recommendedForYouQueryParameters.hitsPerPage) &&
      Objects.equals(this.minWordSizefor1Typo, recommendedForYouQueryParameters.minWordSizefor1Typo) &&
      Objects.equals(this.minWordSizefor2Typos, recommendedForYouQueryParameters.minWordSizefor2Typos) &&
      Objects.equals(this.typoTolerance, recommendedForYouQueryParameters.typoTolerance) &&
      Objects.equals(this.allowTyposOnNumericTokens, recommendedForYouQueryParameters.allowTyposOnNumericTokens) &&
      Objects.equals(this.disableTypoToleranceOnAttributes, recommendedForYouQueryParameters.disableTypoToleranceOnAttributes) &&
      Objects.equals(this.ignorePlurals, recommendedForYouQueryParameters.ignorePlurals) &&
      Objects.equals(this.removeStopWords, recommendedForYouQueryParameters.removeStopWords) &&
      Objects.equals(this.keepDiacriticsOnCharacters, recommendedForYouQueryParameters.keepDiacriticsOnCharacters) &&
      Objects.equals(this.queryLanguages, recommendedForYouQueryParameters.queryLanguages) &&
      Objects.equals(this.decompoundQuery, recommendedForYouQueryParameters.decompoundQuery) &&
      Objects.equals(this.enableRules, recommendedForYouQueryParameters.enableRules) &&
      Objects.equals(this.enablePersonalization, recommendedForYouQueryParameters.enablePersonalization) &&
      Objects.equals(this.queryType, recommendedForYouQueryParameters.queryType) &&
      Objects.equals(this.removeWordsIfNoResults, recommendedForYouQueryParameters.removeWordsIfNoResults) &&
      Objects.equals(this.mode, recommendedForYouQueryParameters.mode) &&
      Objects.equals(this.semanticSearch, recommendedForYouQueryParameters.semanticSearch) &&
      Objects.equals(this.advancedSyntax, recommendedForYouQueryParameters.advancedSyntax) &&
      Objects.equals(this.optionalWords, recommendedForYouQueryParameters.optionalWords) &&
      Objects.equals(this.disableExactOnAttributes, recommendedForYouQueryParameters.disableExactOnAttributes) &&
      Objects.equals(this.exactOnSingleWordQuery, recommendedForYouQueryParameters.exactOnSingleWordQuery) &&
      Objects.equals(this.alternativesAsExact, recommendedForYouQueryParameters.alternativesAsExact) &&
      Objects.equals(this.advancedSyntaxFeatures, recommendedForYouQueryParameters.advancedSyntaxFeatures) &&
      Objects.equals(this.distinct, recommendedForYouQueryParameters.distinct) &&
      Objects.equals(this.replaceSynonymsInHighlight, recommendedForYouQueryParameters.replaceSynonymsInHighlight) &&
      Objects.equals(this.minProximity, recommendedForYouQueryParameters.minProximity) &&
      Objects.equals(this.responseFields, recommendedForYouQueryParameters.responseFields) &&
      Objects.equals(this.maxFacetHits, recommendedForYouQueryParameters.maxFacetHits) &&
      Objects.equals(this.maxValuesPerFacet, recommendedForYouQueryParameters.maxValuesPerFacet) &&
      Objects.equals(this.sortFacetValuesBy, recommendedForYouQueryParameters.sortFacetValuesBy) &&
      Objects.equals(
        this.attributeCriteriaComputedByMinProximity,
        recommendedForYouQueryParameters.attributeCriteriaComputedByMinProximity
      ) &&
      Objects.equals(this.renderingContent, recommendedForYouQueryParameters.renderingContent) &&
      Objects.equals(this.enableReRanking, recommendedForYouQueryParameters.enableReRanking) &&
      Objects.equals(this.reRankingApplyFilter, recommendedForYouQueryParameters.reRankingApplyFilter)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(
      query,
      similarQuery,
      filters,
      facetFilters,
      optionalFilters,
      numericFilters,
      tagFilters,
      sumOrFiltersScores,
      restrictSearchableAttributes,
      facets,
      facetingAfterDistinct,
      page,
      offset,
      length,
      aroundLatLng,
      aroundLatLngViaIP,
      aroundRadius,
      aroundPrecision,
      minimumAroundRadius,
      insideBoundingBox,
      insidePolygon,
      naturalLanguages,
      ruleContexts,
      personalizationImpact,
      userToken,
      getRankingInfo,
      explain,
      synonyms,
      clickAnalytics,
      analytics,
      analyticsTags,
      percentileComputation,
      enableABTest,
      attributesForFaceting,
      attributesToRetrieve,
      ranking,
      customRanking,
      relevancyStrictness,
      attributesToHighlight,
      attributesToSnippet,
      highlightPreTag,
      highlightPostTag,
      snippetEllipsisText,
      restrictHighlightAndSnippetArrays,
      hitsPerPage,
      minWordSizefor1Typo,
      minWordSizefor2Typos,
      typoTolerance,
      allowTyposOnNumericTokens,
      disableTypoToleranceOnAttributes,
      ignorePlurals,
      removeStopWords,
      keepDiacriticsOnCharacters,
      queryLanguages,
      decompoundQuery,
      enableRules,
      enablePersonalization,
      queryType,
      removeWordsIfNoResults,
      mode,
      semanticSearch,
      advancedSyntax,
      optionalWords,
      disableExactOnAttributes,
      exactOnSingleWordQuery,
      alternativesAsExact,
      advancedSyntaxFeatures,
      distinct,
      replaceSynonymsInHighlight,
      minProximity,
      responseFields,
      maxFacetHits,
      maxValuesPerFacet,
      sortFacetValuesBy,
      attributeCriteriaComputedByMinProximity,
      renderingContent,
      enableReRanking,
      reRankingApplyFilter
    );
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RecommendedForYouQueryParameters {\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    similarQuery: ").append(toIndentedString(similarQuery)).append("\n");
    sb.append("    filters: ").append(toIndentedString(filters)).append("\n");
    sb.append("    facetFilters: ").append(toIndentedString(facetFilters)).append("\n");
    sb.append("    optionalFilters: ").append(toIndentedString(optionalFilters)).append("\n");
    sb.append("    numericFilters: ").append(toIndentedString(numericFilters)).append("\n");
    sb.append("    tagFilters: ").append(toIndentedString(tagFilters)).append("\n");
    sb.append("    sumOrFiltersScores: ").append(toIndentedString(sumOrFiltersScores)).append("\n");
    sb.append("    restrictSearchableAttributes: ").append(toIndentedString(restrictSearchableAttributes)).append("\n");
    sb.append("    facets: ").append(toIndentedString(facets)).append("\n");
    sb.append("    facetingAfterDistinct: ").append(toIndentedString(facetingAfterDistinct)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    length: ").append(toIndentedString(length)).append("\n");
    sb.append("    aroundLatLng: ").append(toIndentedString(aroundLatLng)).append("\n");
    sb.append("    aroundLatLngViaIP: ").append(toIndentedString(aroundLatLngViaIP)).append("\n");
    sb.append("    aroundRadius: ").append(toIndentedString(aroundRadius)).append("\n");
    sb.append("    aroundPrecision: ").append(toIndentedString(aroundPrecision)).append("\n");
    sb.append("    minimumAroundRadius: ").append(toIndentedString(minimumAroundRadius)).append("\n");
    sb.append("    insideBoundingBox: ").append(toIndentedString(insideBoundingBox)).append("\n");
    sb.append("    insidePolygon: ").append(toIndentedString(insidePolygon)).append("\n");
    sb.append("    naturalLanguages: ").append(toIndentedString(naturalLanguages)).append("\n");
    sb.append("    ruleContexts: ").append(toIndentedString(ruleContexts)).append("\n");
    sb.append("    personalizationImpact: ").append(toIndentedString(personalizationImpact)).append("\n");
    sb.append("    userToken: ").append(toIndentedString(userToken)).append("\n");
    sb.append("    getRankingInfo: ").append(toIndentedString(getRankingInfo)).append("\n");
    sb.append("    explain: ").append(toIndentedString(explain)).append("\n");
    sb.append("    synonyms: ").append(toIndentedString(synonyms)).append("\n");
    sb.append("    clickAnalytics: ").append(toIndentedString(clickAnalytics)).append("\n");
    sb.append("    analytics: ").append(toIndentedString(analytics)).append("\n");
    sb.append("    analyticsTags: ").append(toIndentedString(analyticsTags)).append("\n");
    sb.append("    percentileComputation: ").append(toIndentedString(percentileComputation)).append("\n");
    sb.append("    enableABTest: ").append(toIndentedString(enableABTest)).append("\n");
    sb.append("    attributesForFaceting: ").append(toIndentedString(attributesForFaceting)).append("\n");
    sb.append("    attributesToRetrieve: ").append(toIndentedString(attributesToRetrieve)).append("\n");
    sb.append("    ranking: ").append(toIndentedString(ranking)).append("\n");
    sb.append("    customRanking: ").append(toIndentedString(customRanking)).append("\n");
    sb.append("    relevancyStrictness: ").append(toIndentedString(relevancyStrictness)).append("\n");
    sb.append("    attributesToHighlight: ").append(toIndentedString(attributesToHighlight)).append("\n");
    sb.append("    attributesToSnippet: ").append(toIndentedString(attributesToSnippet)).append("\n");
    sb.append("    highlightPreTag: ").append(toIndentedString(highlightPreTag)).append("\n");
    sb.append("    highlightPostTag: ").append(toIndentedString(highlightPostTag)).append("\n");
    sb.append("    snippetEllipsisText: ").append(toIndentedString(snippetEllipsisText)).append("\n");
    sb.append("    restrictHighlightAndSnippetArrays: ").append(toIndentedString(restrictHighlightAndSnippetArrays)).append("\n");
    sb.append("    hitsPerPage: ").append(toIndentedString(hitsPerPage)).append("\n");
    sb.append("    minWordSizefor1Typo: ").append(toIndentedString(minWordSizefor1Typo)).append("\n");
    sb.append("    minWordSizefor2Typos: ").append(toIndentedString(minWordSizefor2Typos)).append("\n");
    sb.append("    typoTolerance: ").append(toIndentedString(typoTolerance)).append("\n");
    sb.append("    allowTyposOnNumericTokens: ").append(toIndentedString(allowTyposOnNumericTokens)).append("\n");
    sb.append("    disableTypoToleranceOnAttributes: ").append(toIndentedString(disableTypoToleranceOnAttributes)).append("\n");
    sb.append("    ignorePlurals: ").append(toIndentedString(ignorePlurals)).append("\n");
    sb.append("    removeStopWords: ").append(toIndentedString(removeStopWords)).append("\n");
    sb.append("    keepDiacriticsOnCharacters: ").append(toIndentedString(keepDiacriticsOnCharacters)).append("\n");
    sb.append("    queryLanguages: ").append(toIndentedString(queryLanguages)).append("\n");
    sb.append("    decompoundQuery: ").append(toIndentedString(decompoundQuery)).append("\n");
    sb.append("    enableRules: ").append(toIndentedString(enableRules)).append("\n");
    sb.append("    enablePersonalization: ").append(toIndentedString(enablePersonalization)).append("\n");
    sb.append("    queryType: ").append(toIndentedString(queryType)).append("\n");
    sb.append("    removeWordsIfNoResults: ").append(toIndentedString(removeWordsIfNoResults)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    semanticSearch: ").append(toIndentedString(semanticSearch)).append("\n");
    sb.append("    advancedSyntax: ").append(toIndentedString(advancedSyntax)).append("\n");
    sb.append("    optionalWords: ").append(toIndentedString(optionalWords)).append("\n");
    sb.append("    disableExactOnAttributes: ").append(toIndentedString(disableExactOnAttributes)).append("\n");
    sb.append("    exactOnSingleWordQuery: ").append(toIndentedString(exactOnSingleWordQuery)).append("\n");
    sb.append("    alternativesAsExact: ").append(toIndentedString(alternativesAsExact)).append("\n");
    sb.append("    advancedSyntaxFeatures: ").append(toIndentedString(advancedSyntaxFeatures)).append("\n");
    sb.append("    distinct: ").append(toIndentedString(distinct)).append("\n");
    sb.append("    replaceSynonymsInHighlight: ").append(toIndentedString(replaceSynonymsInHighlight)).append("\n");
    sb.append("    minProximity: ").append(toIndentedString(minProximity)).append("\n");
    sb.append("    responseFields: ").append(toIndentedString(responseFields)).append("\n");
    sb.append("    maxFacetHits: ").append(toIndentedString(maxFacetHits)).append("\n");
    sb.append("    maxValuesPerFacet: ").append(toIndentedString(maxValuesPerFacet)).append("\n");
    sb.append("    sortFacetValuesBy: ").append(toIndentedString(sortFacetValuesBy)).append("\n");
    sb
      .append("    attributeCriteriaComputedByMinProximity: ")
      .append(toIndentedString(attributeCriteriaComputedByMinProximity))
      .append("\n");
    sb.append("    renderingContent: ").append(toIndentedString(renderingContent)).append("\n");
    sb.append("    enableReRanking: ").append(toIndentedString(enableReRanking)).append("\n");
    sb.append("    reRankingApplyFilter: ").append(toIndentedString(reRankingApplyFilter)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
