/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.ingestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SourceType {
    BIGCOMMERCE("bigcommerce"),
    COMMERCETOOLS("commercetools"),
    JSON("json"),
    CSV("csv"),
    BIGQUERY("bigquery"),
    DOCKER("docker");

    private final String value;

    private SourceType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static SourceType fromValue(String value) {
        for (SourceType b : SourceType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

